/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer.tools.handlers;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.scene.Cursor;
import javafx.scene.input.MouseEvent;
import javafx.util.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.awt.common.AwtTools;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.gui.viewer.tools.handlers.AbstractPathToolEventHandler;
import qupath.lib.gui.viewer.tools.handlers.ToolUtils;
import qupath.lib.objects.PathAnnotationObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathROIObject;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.roi.RoiEditor;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;

public class MoveToolEventHandler
extends AbstractPathToolEventHandler {
    private static final Logger logger = LoggerFactory.getLogger(MoveToolEventHandler.class);
    private static boolean requestDynamicDragging = true;
    private Point2D pDragging;
    private double dx;
    private double dy;
    private long lastDragTimestamp;
    private ViewerMover mover;

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.mover != null) {
            this.mover.stopMoving();
        }
        super.mousePressed(e);
        if (!e.isPrimaryButtonDown() || e.isConsumed()) {
            return;
        }
        QuPathViewer viewer = this.getViewer();
        boolean snapping = false;
        Point2D p = this.mouseLocationToImage(e, false, snapping);
        double xx = p.getX();
        double yy = p.getY();
        if (e.getClickCount() > 1 || e.isAltDown() || e.isShortcutDown()) {
            boolean selected = false;
            selected = e.isAltDown() || e.isShortcutDown() ? ToolUtils.tryToSelect(viewer, xx, yy, e.getClickCount() - 1, true, true) : ToolUtils.tryToSelect(viewer, xx, yy, e.getClickCount() - 2, false);
            e.consume();
            this.pDragging = null;
            if (!selected && PathPrefs.doubleClickToZoomProperty().get()) {
                double downsample = viewer.getDownsampleFactor();
                downsample = e.isAltDown() || e.isShortcutDown() ? (downsample *= 2.0) : (downsample /= 2.0);
                viewer.setDownsampleFactor(downsample, e.getX(), e.getY());
            }
            return;
        }
        if (!viewer.isSpaceDown() && viewer.getHierarchy() != null) {
            PathObject currentObject = viewer.getSelectedObject();
            this.updatingConstrainingObjects(viewer, xx, yy, Collections.singleton(currentObject));
            ROI currentROI = viewer.getCurrentROI();
            RoiEditor editor = viewer.getROIEditor();
            if (currentROI != null) {
                double search;
                if (editor.getROI() == currentROI && editor.grabHandle(xx, yy, search = viewer.getMaxROIHandleSize() * 0.75, e.isShiftDown())) {
                    e.consume();
                }
                if (!e.isConsumed() && MoveToolEventHandler.canAdjust(currentObject) && (RoiTools.areaContains((ROI)currentROI, (double)xx, (double)yy) || ToolUtils.getSelectableObjectList(viewer, xx, yy).contains(currentObject)) && !editor.getROI().isPoint() && editor.startTranslation(xx, yy, PathPrefs.usePixelSnappingProperty().get() && currentROI.isArea())) {
                    e.consume();
                }
                if (e.isConsumed()) {
                    this.pDragging = null;
                    return;
                }
            }
        }
        this.pDragging = p;
    }

    private static boolean canAdjust(PathObject pathObject) {
        return pathObject != null && pathObject.isEditable();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.mover != null) {
            this.mover.stopMoving();
        }
        super.mouseDragged(e);
        if (!e.isPrimaryButtonDown() || e.isConsumed()) {
            return;
        }
        QuPathViewer viewer = this.getViewer();
        if (!viewer.isSpaceDown()) {
            RoiEditor editor = viewer.getROIEditor();
            Point2D p = this.mouseLocationToImage(e, true, false);
            if (editor != null && editor.hasActiveHandle()) {
                ROI updatedROI;
                double x = p.getX();
                double y = p.getY();
                if (PathPrefs.usePixelSnappingProperty().get() && editor.getROI() != null && editor.getROI().isArea()) {
                    x = (int)x;
                    y = (int)y;
                }
                if ((updatedROI = editor.setActiveHandlePosition(x, y, viewer.getDownsampleFactor() / 2.0, e.isShiftDown())) == null) {
                    logger.warn("Updated ROI is null! Will be skipped...");
                } else {
                    PathObject selectedObject = viewer.getSelectedObject();
                    if (selectedObject.getROI() != updatedROI && selectedObject instanceof PathROIObject) {
                        ((PathROIObject)selectedObject).setROI(updatedROI);
                    }
                    viewer.getHierarchy().fireObjectsChangedEvent((Object)this, Collections.singleton(selectedObject), true);
                    e.consume();
                    return;
                }
            }
            ROI currentROI = viewer.getCurrentROI();
            if (editor != null && editor.isTranslating()) {
                Rectangle2D boundsBefore = AwtTools.getBounds2D((ROI)currentROI);
                ROI translatedROI = editor.updateTranslation(p.getX(), p.getY(), viewer.getServerBounds());
                if (translatedROI != null) {
                    Rectangle2D boundsAfter = AwtTools.getBounds2D((ROI)currentROI);
                    Rectangle2D.Double boundsIntersection = new Rectangle2D.Double();
                    Rectangle2D.union(boundsBefore, boundsAfter, boundsIntersection);
                    ((PathROIObject)viewer.getSelectedObject()).setROI(translatedROI);
                    viewer.getHierarchy().fireObjectsChangedEvent((Object)this, Collections.singleton(viewer.getSelectedObject()), true);
                }
                this.pDragging = null;
                return;
            }
            if (e.isAltDown()) {
                ToolUtils.tryToSelect(viewer, p.getX(), p.getY(), e.getClickCount() - 1, true, false);
                e.consume();
                return;
            }
        }
        if (this.pDragging == null) {
            return;
        }
        double xPrevious = this.pDragging.getX();
        double yPrevious = this.pDragging.getY();
        this.pDragging = this.mouseLocationToImage(e, false, false);
        this.dx = this.pDragging.getX() - xPrevious;
        this.dy = this.pDragging.getY() - yPrevious;
        viewer.setDoFasterRepaint(true);
        viewer.setCenterPixelLocation(viewer.getCenterPixelX() - this.dx, viewer.getCenterPixelY() - this.dy);
        this.pDragging = this.mouseLocationToImage(e, false, false);
        this.lastDragTimestamp = System.currentTimeMillis();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        if (e.isConsumed()) {
            return;
        }
        QuPathViewer viewer = this.getViewer();
        RoiEditor editor = viewer.getROIEditor();
        if (editor != null && (editor.hasActiveHandle() || editor.isTranslating())) {
            boolean roiChanged = editor.isTranslating() && editor.finishTranslation() || editor.hasActiveHandle();
            editor.resetActiveHandle();
            e.consume();
            PathObject pathObject = viewer.getSelectedObject();
            if (this.requestParentClipping(e) && pathObject instanceof PathAnnotationObject) {
                ROI roiNew = this.refineROIByParent(pathObject.getROI());
                ((PathAnnotationObject)pathObject).setROI(roiNew);
            }
            if (pathObject != null && pathObject.hasROI() && pathObject.getROI().isEmpty()) {
                if (pathObject.getParent() != null) {
                    viewer.getHierarchy().removeObject(pathObject, true);
                }
                viewer.setSelectedObject(null);
            } else {
                PathObjectHierarchy hierarchy = viewer.getHierarchy();
                if (pathObject instanceof TMACoreObject) {
                    hierarchy.fireHierarchyChangedEvent((Object)pathObject);
                } else if (pathObject != null && roiChanged) {
                    ROI updatedROI = editor.getROI();
                    if (pathObject.getROI() != updatedROI && pathObject instanceof PathROIObject) {
                        ((PathROIObject)pathObject).setROI(updatedROI);
                    }
                    hierarchy.removeObjectWithoutUpdate(pathObject, true);
                    if (this.getCurrentParent() == null || !PathPrefs.clipROIsForHierarchyProperty().get() || e.isShiftDown()) {
                        hierarchy.addObject(pathObject);
                    } else {
                        hierarchy.addObjectBelowParent(this.getCurrentParent(), pathObject, true);
                    }
                }
                viewer.setSelectedObject(pathObject);
            }
        }
        if (this.pDragging != null && requestDynamicDragging && System.currentTimeMillis() - this.lastDragTimestamp < 100L && this.dx * this.dx + this.dy * this.dy > viewer.getDownsampleFactor()) {
            this.mover = new ViewerMover(viewer);
            this.mover.startMoving(this.dx, this.dy, false);
        } else {
            viewer.setDoFasterRepaint(false);
        }
        this.pDragging = null;
        this.resetConstrainingObjects();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        double yy;
        Point2D p2;
        double xx;
        super.mouseMoved(e);
        QuPathViewer viewer = this.getViewer();
        Cursor cursorType = viewer.getCursor();
        if (cursorType == Cursor.WAIT) {
            return;
        }
        if (viewer.getROIEditor().isTranslating()) {
            if (cursorType != Cursor.MOVE) {
                viewer.setCursor(Cursor.MOVE);
            }
            return;
        }
        ROI currentROI = viewer.getCurrentROI();
        if (currentROI != null && MoveToolEventHandler.canAdjust(viewer.getSelectedObject()) && RoiTools.areaContains((ROI)currentROI, (double)(xx = (p2 = this.mouseLocationToImage(e, true, false)).getX()), (double)(yy = p2.getY()))) {
            this.ensureCursorType(Cursor.MOVE);
            return;
        }
        this.ensureCursorType(Cursor.HAND);
    }

    public static class ViewerMover {
        private QuPathViewer viewer;
        private Timeline timer;
        private long timestamp = -1L;
        private int heartbeat = 10;
        private double dx;
        private double dy;
        private boolean constantVelocity = false;

        public ViewerMover(QuPathViewer viewer) {
            this.viewer = viewer;
        }

        void handleUpdate() {
            double scale;
            if (this.timestamp < 0L || this.viewer == null) {
                this.stopMoving();
                return;
            }
            long newTimestamp = System.currentTimeMillis();
            double d = scale = this.constantVelocity ? 1.0 : 1.0 - (double)(newTimestamp - this.timestamp) * 0.005;
            if (scale <= 0.0) {
                return;
            }
            this.timestamp = newTimestamp;
            this.dx *= scale;
            this.dy *= scale;
            double downsample = this.viewer.getDownsampleFactor();
            if (this.dx * this.dx + this.dy * this.dy < downsample * downsample * 4.0) {
                this.stopMoving();
                return;
            }
            this.viewer.setCenterPixelLocation(this.viewer.getCenterPixelX() - this.dx, this.viewer.getCenterPixelY() - this.dy);
        }

        public void startMoving(double dx, double dy, boolean constantVelocity) {
            this.dx = dx;
            this.dy = dy;
            this.constantVelocity = constantVelocity;
            if (this.timer == null) {
                this.timer = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, actionEvent -> this.handleUpdate(), new KeyValue[0]), new KeyFrame(Duration.millis((double)this.heartbeat), new KeyValue[0])});
                this.timer.setCycleCount(-1);
            }
            this.timestamp = System.currentTimeMillis();
            this.timer.playFromStart();
        }

        public void cancelDirection(boolean xAxis) {
            if (xAxis) {
                this.dx = 0.0;
            } else {
                this.dy = 0.0;
            }
        }

        public void decelerate() {
            this.constantVelocity = false;
        }

        public void stopMoving() {
            if (this.timer != null && this.timer.getStatus() == Animation.Status.RUNNING) {
                this.timestamp = -1L;
                this.timer.stop();
                if (this.viewer != null) {
                    this.viewer.setDoFasterRepaint(false);
                }
            }
        }
    }
}

