/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer.tools.handlers;

import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javafx.scene.Cursor;
import javafx.scene.input.MouseEvent;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.simplify.VWSimplifier;
import org.locationtech.jts.util.GeometricShapeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.gui.viewer.tools.QuPathPenManager;
import qupath.lib.gui.viewer.tools.handlers.AbstractPathROIToolEventHandler;
import qupath.lib.gui.viewer.tools.handlers.ToolUtils;
import qupath.lib.objects.PathAnnotationObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjects;
import qupath.lib.objects.PathTileObject;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.regions.ImagePlane;
import qupath.lib.roi.GeometryTools;
import qupath.lib.roi.ROIs;
import qupath.lib.roi.RectangleROI;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;

public class BrushToolEventHandler
extends AbstractPathROIToolEventHandler {
    private static final Logger logger = LoggerFactory.getLogger(BrushToolEventHandler.class);
    static Set<PathClass> reservedPathClasses = Collections.singleton(PathClass.StandardPathClasses.REGION);
    double lastRequestedCursorDiameter = Double.NaN;
    Cursor requestedCursor;
    private PathObject currentObject;
    Point2D lastPoint;
    private boolean creatingTiledROI = false;

    @Override
    protected boolean preferReturnToMove() {
        return false;
    }

    protected Cursor getRequestedCursor() {
        return Cursor.CROSSHAIR;
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.ensureCursorType(this.getRequestedCursor());
    }

    @Override
    public void mousePressed(MouseEvent e) {
        ROI shapeROI;
        boolean multipleClicks;
        boolean createNew;
        if (!e.isPrimaryButtonDown() || e.isConsumed()) {
            return;
        }
        this.ensureCursorType(this.getRequestedCursor());
        QuPathViewer viewer = this.getViewer();
        PathObjectHierarchy hierarchy = viewer.getHierarchy();
        if (hierarchy == null) {
            return;
        }
        PathObject currentObject = viewer.getSelectedObject();
        if (currentObject == null || PathPrefs.selectionModeStatus().get() || !(currentObject instanceof PathAnnotationObject) || !currentObject.isEditable() || currentObject.getROI().getZ() != viewer.getZPosition() || currentObject.getROI().getT() != viewer.getTPosition()) {
            currentObject = null;
        }
        Point2D p = this.mouseLocationToImage(e, false, this.requestPixelSnapping());
        double xx = p.getX();
        double yy = p.getY();
        if (xx < 0.0 || yy < 0.0 || xx >= (double)viewer.getServerWidth() || yy >= (double)viewer.getServerHeight()) {
            if (currentObject != null) {
                this.currentObject = currentObject;
                this.lastPoint = p;
                viewer.getROIEditor().setROI(null);
            } else {
                this.currentObject = null;
            }
            return;
        }
        boolean bl = createNew = currentObject == null || !e.isShiftDown() && PathPrefs.brushCreateNewObjectsProperty().get() && !RoiTools.areaContains((ROI)currentObject.getROI(), (double)p.getX(), (double)p.getY()) && !this.isSubtractMode(e);
        if (this.isSubtractMode(e)) {
            createNew = false;
        }
        boolean bl2 = multipleClicks = e.getClickCount() > 1;
        if (!PathPrefs.selectionModeStatus().get() && (multipleClicks || createNew && !e.isShiftDown())) {
            if (multipleClicks) {
                PathObject objectSelectable = ToolUtils.getSelectableObject(viewer, p.getX(), p.getY(), e.getClickCount() - 1);
                if (objectSelectable != null && objectSelectable.isEditable() && objectSelectable.hasROI() && objectSelectable.getROI().isArea()) {
                    createNew = false;
                    viewer.setSelectedObject(objectSelectable);
                    currentObject = objectSelectable;
                } else if (createNew) {
                    viewer.setSelectedObject(null);
                    currentObject = null;
                }
            } else if (!PathPrefs.selectionModeStatus().get()) {
                List<PathObject> listSelectable = ToolUtils.getSelectableObjectList(viewer, p.getX(), p.getY());
                PathObject objectSelectable = null;
                for (PathObject temp : listSelectable) {
                    if (!temp.isEditable() || !(temp instanceof PathAnnotationObject) || !temp.hasROI() || !temp.getROI().isArea()) continue;
                    objectSelectable = temp;
                    break;
                }
                if (objectSelectable != null) {
                    createNew = false;
                    viewer.setSelectedObject(objectSelectable);
                    currentObject = objectSelectable;
                } else if (createNew) {
                    viewer.setSelectedObject(null);
                    currentObject = null;
                }
            }
        }
        if (!(createNew || currentObject != null && currentObject.isAnnotation() && currentObject.isEditable() && RoiTools.isShapeROI((ROI)currentObject.getROI()))) {
            return;
        }
        this.updatingConstrainingObjects(viewer, xx, yy, Collections.singleton(currentObject));
        if (!createNew && currentObject != null) {
            hierarchy.removeObjectWithoutUpdate(currentObject, true);
        }
        ROI rOI = shapeROI = createNew ? null : currentObject.getROI();
        if (createNew) {
            this.creatingTiledROI = false;
            this.currentObject = this.createNewAnnotation(e, p.getX(), p.getY());
            viewer.getROIEditor().setROI(null);
        } else {
            this.currentObject = this.getUpdatedObject(e, shapeROI, currentObject, -1.0);
            viewer.setSelectedObject(this.currentObject);
            viewer.getROIEditor().setROI(null);
        }
        this.lastPoint = p;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        super.mouseDragged(e);
        this.ensureCursorType(this.getRequestedCursor());
        if (!e.isPrimaryButtonDown()) {
            return;
        }
        QuPathViewer viewer = this.getViewer();
        PathObject pathObject = viewer.getSelectedObject();
        if (pathObject == null || !pathObject.isAnnotation() || !pathObject.isEditable()) {
            return;
        }
        if (pathObject != this.currentObject) {
            logger.debug("Selected object has changed from {} to {}", (Object)this.currentObject, (Object)pathObject);
            return;
        }
        ROI currentROI = pathObject.getROI();
        if (currentROI == null) {
            return;
        }
        PathObject pathObjectUpdated = this.getUpdatedObject(e, currentROI, pathObject, -1.0);
        if (pathObject != pathObjectUpdated) {
            viewer.setSelectedObject(pathObjectUpdated, PathPrefs.selectionModeStatus().get());
        } else {
            viewer.repaint();
        }
    }

    protected boolean isSubtractMode(MouseEvent e) {
        QuPathPenManager.PenInputManager manager = QuPathPenManager.getPenManager();
        if (manager.isEraser()) {
            return true;
        }
        return e != null && e.isAltDown() && !PathPrefs.selectionModeStatus().get();
    }

    private PathObject getUpdatedObject(MouseEvent e, ROI shapeROI, PathObject currentObject, double flatness) {
        Point2D p = this.mouseLocationToImage(e, false, this.requestPixelSnapping());
        if (p.getX() < 0.0 || p.getY() < 0.0 || p.getX() >= (double)this.getViewer().getServerWidth() || p.getY() >= (double)this.getViewer().getServerHeight()) {
            return currentObject;
        }
        QuPathViewer viewer = this.getViewer();
        ImagePlane plane = shapeROI == null ? ImagePlane.getPlane((int)viewer.getZPosition(), (int)viewer.getTPosition()) : shapeROI.getImagePlane();
        boolean subtractMode = this.isSubtractMode(e);
        Geometry shapeCurrent = shapeROI == null ? null : shapeROI.getGeometry();
        Geometry shapeDrawn = this.createShape(e, p.getX(), p.getY(), PathPrefs.useTileBrushProperty().get() && !e.isShiftDown(), subtractMode ? null : shapeCurrent);
        if (shapeDrawn == null) {
            return currentObject;
        }
        if (this.requestPixelSnapping()) {
            shapeDrawn = GeometryTools.roundCoordinates((Geometry)shapeDrawn);
        }
        shapeDrawn = GeometryTools.ensurePolygonal((Geometry)shapeDrawn);
        this.lastPoint = p;
        try {
            Geometry shapeNew;
            if (shapeROI != null) {
                if (shapeDrawn == null || subtractMode && !shapeCurrent.intersects(shapeDrawn) || !subtractMode && shapeCurrent.covers(shapeDrawn)) {
                    return currentObject;
                }
                boolean avoidOtherAnnotations = this.requestParentClipping(e);
                if (subtractMode) {
                    shapeNew = shapeROI.getGeometry().difference(shapeDrawn);
                } else if (avoidOtherAnnotations) {
                    shapeNew = shapeCurrent.union(shapeDrawn);
                    shapeNew = this.refineGeometryByParent(shapeNew);
                } else {
                    Geometry temp = shapeROI.getGeometry();
                    try {
                        shapeNew = temp.union(shapeDrawn);
                    }
                    catch (Exception e2) {
                        shapeNew = shapeROI.getGeometry();
                    }
                }
            } else {
                shapeNew = shapeDrawn;
            }
            if (!this.requestPixelSnapping()) {
                try {
                    shapeNew = VWSimplifier.simplify((Geometry)shapeNew, (double)0.1);
                }
                catch (Exception e2) {
                    logger.error("Error simplifying ROI: {}", (Object)e2.getMessage(), (Object)e2);
                }
            }
            if ((shapeNew = GeometryTools.constrainToBounds((Geometry)shapeNew, (double)0.0, (double)0.0, (double)viewer.getServerWidth(), (double)viewer.getServerHeight())) instanceof GeometryCollection) {
                shapeNew = GeometryTools.ensurePolygonal((Geometry)shapeNew);
            }
            ROI roiNew = GeometryTools.geometryToROI((Geometry)shapeNew, (ImagePlane)plane);
            if (currentObject instanceof PathAnnotationObject) {
                ((PathAnnotationObject)currentObject).setROI(roiNew);
                return currentObject;
            }
            PathObject pathObjectNew = PathObjects.createAnnotationObject((ROI)roiNew, (PathClass)((PathClass)PathPrefs.autoSetAnnotationClassProperty().get()));
            if (currentObject != null) {
                pathObjectNew.setName(currentObject.getName());
                pathObjectNew.setColor(currentObject.getColor());
                pathObjectNew.setPathClass(currentObject.getPathClass());
            }
            return pathObjectNew;
        }
        catch (Exception ex) {
            logger.error("Error updating ROI", (Throwable)ex);
            return currentObject;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        this.ensureCursorType(Cursor.DEFAULT);
        if (e.isConsumed()) {
            return;
        }
        if (this.currentObject != null) {
            this.commitObjectToHierarchy(e, this.currentObject);
        }
        this.lastPoint = null;
        this.currentObject = null;
        this.resetConstrainingObjects();
    }

    protected double getBrushDiameter() {
        QuPathPenManager.PenInputManager manager = QuPathPenManager.getPenManager();
        double scale = manager.getPressure();
        QuPathViewer viewer = this.getViewer();
        double brushDiameter = (double)PathPrefs.brushDiameterProperty().get() * scale;
        if (PathPrefs.brushScaleByMagProperty().get()) {
            return brushDiameter * viewer.getDownsampleFactor();
        }
        return brushDiameter;
    }

    protected Geometry createShape(MouseEvent e, double x, double y, boolean useTiles, Geometry addToShape) {
        Polygon geometry;
        if (useTiles) {
            List<PathObject> listSelectable = ToolUtils.getSelectableObjectList(this.getViewer(), x, y);
            for (PathObject temp : listSelectable) {
                if (!(temp instanceof PathTileObject) || !temp.hasROI() || !temp.getROI().isArea() || temp.getROI() instanceof RectangleROI) continue;
                this.creatingTiledROI = true;
                return temp.getROI().getGeometry();
            }
            if (this.creatingTiledROI) {
                return null;
            }
        }
        double diameter = Math.max(1.0, this.getBrushDiameter());
        if (this.lastPoint == null) {
            GeometricShapeFactory shapeFactory = new GeometricShapeFactory(this.getGeometryFactory());
            shapeFactory.setCentre(new Coordinate(x, y));
            shapeFactory.setSize(diameter);
            geometry = shapeFactory.createEllipse();
        } else {
            if (this.lastPoint.distanceSq(x, y) == 0.0) {
                return null;
            }
            GeometryFactory factory = this.getGeometryFactory();
            geometry = factory.createLineString(new Coordinate[]{new Coordinate(this.lastPoint.getX(), this.lastPoint.getY()), new Coordinate(x, y)}).buffer(diameter / 2.0);
        }
        return geometry;
    }

    protected GeometryFactory getGeometryFactory() {
        return GeometryTools.getDefaultFactory();
    }

    @Override
    protected ROI createNewROI(MouseEvent e, double x, double y, ImagePlane plane) {
        this.creatingTiledROI = false;
        this.lastPoint = null;
        Geometry geom = this.createShape(e, x, y, PathPrefs.useTileBrushProperty().get(), null);
        if (geom == null || geom.isEmpty()) {
            return ROIs.createEmptyROI();
        }
        QuPathViewer viewer = this.getViewer();
        geom = GeometryTools.roundCoordinates((Geometry)geom);
        geom = GeometryTools.constrainToBounds((Geometry)geom, (double)0.0, (double)0.0, (double)viewer.getServerWidth(), (double)viewer.getServerHeight());
        return GeometryTools.geometryToROI((Geometry)geom, (ImagePlane)plane);
    }
}

