/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer.tools.handlers;

import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.HashSet;
import javafx.scene.input.MouseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.gui.viewer.tools.handlers.AbstractPathROIToolEventHandler;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathROIObject;
import qupath.lib.roi.PolygonROI;
import qupath.lib.roi.PolylineROI;
import qupath.lib.roi.RoiEditor;
import qupath.lib.roi.interfaces.ROI;

abstract class AbstractPolyROIToolEventHandler
extends AbstractPathROIToolEventHandler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPolyROIToolEventHandler.class);
    boolean isFreehandPolyROI = false;

    AbstractPolyROIToolEventHandler() {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        ROI currentROI;
        PathObject currentObject;
        super.mousePressed(e);
        QuPathViewer viewer = this.getViewer();
        PathObject pathObject = currentObject = viewer == null ? null : viewer.getSelectedObject();
        if (currentObject != null && e.getClickCount() == 1) {
            RoiEditor editor = viewer.getROIEditor();
            logger.trace("Adjusting polygon {}", (Object)e);
            Point2D p2 = this.mouseLocationToImage(e, true, this.requestPixelSnapping());
            ROI roiUpdated = editor.requestNewHandle(p2.getX(), p2.getY());
            if (currentObject != null && currentObject.getROI() != roiUpdated && currentObject instanceof PathROIObject) {
                ((PathROIObject)currentObject).setROI(roiUpdated);
            }
            this.isFreehandPolyROI = false;
            viewer.repaint();
        } else {
            this.commitObjectToHierarchy(e, currentObject);
        }
        ROI rOI = currentROI = currentObject == null ? null : currentObject.getROI();
        if (this.isPolyROI(currentROI) && currentROI.isEmpty() && (currentROI.getNumPoints() == 1 || new HashSet(currentROI.getAllPoints()).size() == 1)) {
            this.isFreehandPolyROI = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        if (this.isFreehandPolyROI) {
            ROI currentROI;
            QuPathViewer viewer = this.getViewer();
            PathObject currentObject = viewer.getSelectedObject();
            ROI rOI = currentROI = currentObject == null ? null : currentObject.getROI();
            if (this.isPolyROI(currentROI) && currentROI.isEmpty()) {
                this.isFreehandPolyROI = false;
            } else if (PathPrefs.enableFreehandToolsProperty().get()) {
                RoiEditor editor = viewer.getROIEditor();
                Point2D p2 = this.mouseLocationToImage(e, true, this.requestPixelSnapping());
                ROI roiUpdated = editor.setActiveHandlePosition(p2.getX(), p2.getY(), viewer.getDownsampleFactor(), e.isShiftDown());
                if (currentObject != null && currentObject.getROI() != roiUpdated && currentObject instanceof PathROIObject) {
                    ((PathROIObject)currentObject).setROI(roiUpdated);
                }
                this.commitObjectToHierarchy(e, currentObject);
                this.resetConstrainingObjects();
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
        QuPathViewer viewer = this.getViewer();
        ROI currentROI = viewer.getCurrentROI();
        RoiEditor editor = viewer.getROIEditor();
        if (this.isPolyROI(currentROI) && editor.getROI() == currentROI) {
            Point2D p = this.mouseLocationToImage(e, true, this.requestPixelSnapping());
            ROI roiUpdated = editor.setActiveHandlePosition(p.getX(), p.getY(), viewer.getDownsampleFactor(), e.isShiftDown());
            PathObject pathObject = viewer.getSelectedObject();
            if (roiUpdated != currentROI && pathObject instanceof PathROIObject) {
                ((PathROIObject)pathObject).setROI(roiUpdated);
                viewer.getHierarchy().fireObjectsChangedEvent((Object)this, Collections.singleton(pathObject), true);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        super.mouseDragged(e);
        if (!e.isPrimaryButtonDown()) {
            return;
        }
        QuPathViewer viewer = this.getViewer();
        ROI currentROI = viewer.getCurrentROI();
        RoiEditor editor = viewer.getROIEditor();
        if (this.isPolyROI(currentROI) && editor.getROI() == currentROI) {
            Point2D p = this.mouseLocationToImage(e, true, this.requestPixelSnapping());
            ROI roiUpdated = editor.requestNewHandle(p.getX(), p.getY());
            PathObject pathObject = viewer.getSelectedObject();
            if (roiUpdated != currentROI && pathObject instanceof PathROIObject) {
                ((PathROIObject)pathObject).setROI(roiUpdated);
                viewer.getHierarchy().fireObjectsChangedEvent((Object)this, Collections.singleton(pathObject), true);
            }
        }
    }

    boolean isPolyROI(ROI roi) {
        return roi instanceof PolygonROI || roi instanceof PolylineROI;
    }
}

