/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer.tools.handlers;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.geom.Point2;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.gui.viewer.tools.handlers.ToolUtils;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.regions.ImagePlane;
import qupath.lib.regions.ImageRegion;
import qupath.lib.roi.GeometryTools;
import qupath.lib.roi.ROIs;
import qupath.lib.roi.interfaces.ROI;

abstract class AbstractPathToolEventHandler
implements EventHandler<MouseEvent> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPathToolEventHandler.class);
    private ConstrainingObjects constrainingObjects = new ConstrainingObjects();

    AbstractPathToolEventHandler() {
    }

    protected void ensureCursorType(Cursor cursor) {
        QuPathViewer viewer = this.getViewer();
        Cursor currentCursor = viewer.getCursor();
        if (currentCursor == null || currentCursor == Cursor.WAIT) {
            return;
        }
        viewer.setCursor(cursor);
    }

    protected boolean requestPixelSnapping() {
        return PathPrefs.usePixelSnappingProperty().get();
    }

    protected QuPathViewer getViewer() {
        return QuPathGUI.getInstance().getViewer();
    }

    protected Point2D mouseLocationToImage(MouseEvent e, boolean constrainToBounds, boolean snapToPixel) {
        QuPathViewer viewer = this.getViewer();
        Point2D p = viewer.componentPointToImagePoint(e.getX(), e.getY(), null, constrainToBounds);
        if (snapToPixel) {
            p.setLocation(Math.floor(p.getX()), Math.floor(p.getY()));
        }
        return p;
    }

    protected boolean requestParentClipping(MouseEvent e) {
        return PathPrefs.clipROIsForHierarchyProperty().get() != (e.isShiftDown() && e.isShortcutDown());
    }

    protected ROI refineROIByParent(ROI currentROI) {
        if (currentROI.isLine()) {
            return currentROI;
        }
        Geometry geometry = currentROI.getGeometry();
        if ((geometry = this.refineGeometryByParent(geometry)).isEmpty()) {
            return ROIs.createEmptyROI();
        }
        return GeometryTools.geometryToROI((Geometry)geometry, (ImagePlane)currentROI.getImagePlane());
    }

    protected Geometry refineGeometryByParent(Geometry geometry) {
        return this.constrainingObjects.refineGeometryByParent(geometry, true);
    }

    protected void updatingConstrainingObjects(QuPathViewer viewer, double xx, double yy, Collection<PathObject> exclusions) {
        PathObjectHierarchy hierarchy;
        if (!Platform.isFxApplicationThread()) {
            throw new IllegalStateException("Not on the FxApplication thread!");
        }
        this.constrainingObjects.reset();
        PathObjectHierarchy pathObjectHierarchy = hierarchy = viewer == null ? null : viewer.getHierarchy();
        if (hierarchy == null) {
            return;
        }
        PathObject constrainedParentObject = ToolUtils.getSelectableObjectList(viewer, xx, yy).stream().filter(p -> !p.isDetection() && p.hasROI() && p.getROI().isArea() && !exclusions.contains(p)).min(Comparator.comparing(p -> p.getROI().getArea())).orElse(null);
        if (constrainedParentObject == null || !constrainedParentObject.hasROI() || !constrainedParentObject.getROI().isArea()) {
            constrainedParentObject = hierarchy.getRootObject();
        }
        this.constrainingObjects.update(viewer, constrainedParentObject, xx, yy);
    }

    protected synchronized void resetConstrainingObjects() {
        this.constrainingObjects.reset();
    }

    protected synchronized PathObject getCurrentParent() {
        return this.constrainingObjects.getConstrainedParentObject();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        Node node;
        if (e.isPopupTrigger()) {
            e.consume();
            return;
        }
        Object source = e.getSource();
        if (source instanceof Node && (node = (Node)source).isFocusTraversable() && !node.isFocused()) {
            node.requestFocus();
            e.consume();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            e.consume();
        }
    }

    public void handle(MouseEvent event) {
        EventType type = event.getEventType();
        if (type == MouseEvent.DRAG_DETECTED || type == MouseEvent.MOUSE_DRAGGED) {
            this.mouseDragged(event);
        } else if (type == MouseEvent.MOUSE_CLICKED) {
            this.mouseClicked(event);
        } else if (type == MouseEvent.MOUSE_MOVED) {
            this.mouseMoved(event);
        } else if (type == MouseEvent.MOUSE_PRESSED) {
            this.mousePressed(event);
        } else if (type == MouseEvent.MOUSE_RELEASED) {
            this.mouseReleased(event);
        } else if (type == MouseEvent.MOUSE_ENTERED) {
            this.mouseEntered(event);
        } else if (type == MouseEvent.MOUSE_EXITED) {
            this.mouseExited(event);
        }
    }

    private static class ConstrainingObjects {
        private QuPathViewer viewer;
        private PathObject constrainedParentObject;
        private Geometry constrainedParentGeometry;
        private Collection<Geometry> constrainedRemoveGeometries;
        private Point2 constrainedStartPoint;

        private ConstrainingObjects() {
        }

        public void reset() {
            this.constrainedParentObject = null;
            this.constrainedParentGeometry = null;
            this.constrainedRemoveGeometries = null;
            this.constrainedStartPoint = null;
        }

        public void update(QuPathViewer viewer, PathObject parent, double xStart, double yStart) {
            this.viewer = viewer;
            this.constrainedParentObject = parent;
            this.constrainedParentGeometry = parent != null && parent.hasROI() && parent.getROI().isArea() ? parent.getROI().getGeometry() : null;
            this.constrainedRemoveGeometries = null;
            this.constrainedStartPoint = new Point2(xStart, yStart);
        }

        public PathObject getConstrainedParentObject() {
            return this.constrainedParentObject;
        }

        public Geometry getConstrainedParentGeometry() {
            return this.constrainedParentGeometry;
        }

        public Collection<Geometry> getConstrainedRemoveGeometries() {
            if (!Platform.isFxApplicationThread()) {
                throw new IllegalStateException("Not on the FxApplication thread!");
            }
            if (this.constrainedRemoveGeometries == null) {
                PathObjectHierarchy hierarchy;
                PathObjectHierarchy pathObjectHierarchy = hierarchy = this.viewer == null ? null : this.viewer.getHierarchy();
                if (hierarchy == null || this.constrainedParentObject == null) {
                    return Collections.emptyList();
                }
                PathObject selected = hierarchy.getSelectionModel().getSelectedObject();
                boolean fullImage = hierarchy.getRootObject() == this.constrainedParentObject;
                Collection toRemove = fullImage ? hierarchy.getAnnotationObjects() : hierarchy.getAnnotationsForRegion(ImageRegion.createInstance((ROI)this.constrainedParentObject.getROI()), null);
                logger.debug("Constrained ROI drawing: identifying objects to remove");
                Envelope boundsEnvelope = this.constrainedParentGeometry == null ? null : this.constrainedParentGeometry.getEnvelopeInternal();
                this.constrainedRemoveGeometries = new ArrayList<Geometry>();
                for (PathObject child : toRemove) {
                    if (child.isDetection() || child == this.constrainedParentObject || !child.hasROI() || !child.getROI().isArea() || child.getROI().getZ() != this.viewer.getZPosition() || child.getROI().getT() != this.viewer.getTPosition() || child == selected || this.constrainedStartPoint != null && child.getROI().contains(this.constrainedStartPoint.getX(), this.constrainedStartPoint.getY())) continue;
                    Geometry childArea = child.getROI().getGeometry();
                    Envelope childEnvelope = childArea.getEnvelopeInternal();
                    if (this.constrainedParentGeometry != null && (!boundsEnvelope.intersects(childEnvelope) || childEnvelope.covers(boundsEnvelope) && childArea.covers(this.constrainedParentGeometry))) continue;
                    this.constrainedRemoveGeometries.add(childArea);
                }
            }
            return this.constrainedRemoveGeometries;
        }

        public Point2 getConstrainedStartPoint() {
            return this.constrainedStartPoint;
        }

        private Geometry refineGeometryByParent(Geometry geometry, boolean tryAgain) {
            try {
                if (this.constrainedParentGeometry != null) {
                    geometry = geometry.intersection(this.constrainedParentGeometry);
                }
                int count = 0;
                Collection<Geometry> constrainedRemoveGeometries = this.getConstrainedRemoveGeometries();
                if (!constrainedRemoveGeometries.isEmpty()) {
                    Envelope envelope = geometry.getEnvelopeInternal();
                    for (Geometry temp : constrainedRemoveGeometries) {
                        if (!envelope.intersects(temp.getEnvelopeInternal()) || !geometry.relate(temp, "T********")) continue;
                        geometry = geometry.difference(temp);
                        envelope = geometry.getEnvelopeInternal();
                        ++count;
                    }
                }
                logger.debug("Clipped ROI with {} geometries", (Object)count);
            }
            catch (Exception e) {
                if (tryAgain) {
                    logger.warn("First Error refining ROI, will retry after buffer(0): {}", (Object)e.getLocalizedMessage());
                    return this.refineGeometryByParent(geometry.buffer(0.0), false);
                }
                logger.warn("Error refining ROI: {}", (Object)e.getLocalizedMessage());
                logger.debug("", (Throwable)e);
            }
            return geometry;
        }
    }
}

