/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer.tools.handlers;

import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javafx.scene.Cursor;
import javafx.scene.input.MouseEvent;
import org.locationtech.jts.geom.Geometry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.geom.Point2;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.gui.viewer.tools.PathTools;
import qupath.lib.gui.viewer.tools.handlers.AbstractPathToolEventHandler;
import qupath.lib.gui.viewer.tools.handlers.ToolUtils;
import qupath.lib.objects.PathAnnotationObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.PathObjects;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.classes.PathClassTools;
import qupath.lib.objects.classes.Reclassifier;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.objects.hierarchy.events.PathObjectSelectionModel;
import qupath.lib.regions.ImagePlane;
import qupath.lib.regions.ImageRegion;
import qupath.lib.roi.PolygonROI;
import qupath.lib.roi.PolylineROI;
import qupath.lib.roi.RoiEditor;
import qupath.lib.roi.interfaces.ROI;

abstract class AbstractPathROIToolEventHandler
extends AbstractPathToolEventHandler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPathROIToolEventHandler.class);

    AbstractPathROIToolEventHandler() {
    }

    protected abstract ROI createNewROI(MouseEvent var1, double var2, double var4, ImagePlane var6);

    protected PathObject createNewAnnotation(MouseEvent e, double x, double y) {
        QuPathViewer viewer = this.getViewer();
        PathObject currentObject = viewer.getSelectedObject();
        RoiEditor editor = viewer.getROIEditor();
        if (currentObject != null && currentObject.getParent() == null && currentObject.getROI() == editor.getROI() && (editor.isTranslating() || editor.hasActiveHandle())) {
            logger.warn("Creating a new annotation before a previous one was complete - {} will be discarded!", (Object)currentObject);
        }
        logger.trace("Creating new annotation at ({}, {}", (Object)x, (Object)y);
        PathObjectHierarchy hierarchy = viewer.getHierarchy();
        if (hierarchy == null) {
            logger.warn("Cannot create new annotation - no hierarchy available!");
            return null;
        }
        ROI roi = this.createNewROI(e, x, y, viewer.getImagePlane());
        if (roi == null) {
            return null;
        }
        PathObject pathObject = PathObjects.createAnnotationObject((ROI)roi, (PathClass)((PathClass)PathPrefs.autoSetAnnotationClassProperty().get()));
        PathObjectSelectionModel selectionModel = hierarchy.getSelectionModel();
        if (PathPrefs.selectionModeStatus().get() && !selectionModel.noSelection()) {
            viewer.setSelectedObject(pathObject, true);
        } else {
            viewer.setSelectedObject(pathObject);
        }
        return pathObject;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        boolean adjustingPolygon;
        super.mousePressed(e);
        if (!e.isPrimaryButtonDown() || e.isConsumed()) {
            return;
        }
        QuPathViewer viewer = this.getViewer();
        PathObjectHierarchy hierarchy = viewer.getHierarchy();
        if (hierarchy == null) {
            return;
        }
        PathObject currentObject = viewer.getSelectedObject();
        ROI currentROI = currentObject == null ? null : currentObject.getROI();
        RoiEditor editor = viewer.getROIEditor();
        boolean bl = adjustingPolygon = !(!(currentROI instanceof PolygonROI) && !(currentROI instanceof PolylineROI) || editor.getROI() != currentROI || !editor.isTranslating() && !editor.hasActiveHandle());
        if (adjustingPolygon) {
            if (viewer.getActiveTool() == PathTools.POLYGON || viewer.getActiveTool() == PathTools.POLYLINE) {
                return;
            }
            viewer.getHierarchy().getSelectionModel().clearSelection();
            viewer.getHierarchy().fireHierarchyChangedEvent((Object)currentObject);
        }
        Point2D p2 = this.mouseLocationToImage(e, false, this.requestPixelSnapping());
        double xx = p2.getX();
        double yy = p2.getY();
        if (xx < 0.0 || yy < 0.0 || xx >= (double)viewer.getServerWidth() || yy >= (double)viewer.getServerHeight()) {
            return;
        }
        if (!PathPrefs.selectionModeStatus().get() && e.getClickCount() > 1) {
            this.resetConstrainingObjects();
            ToolUtils.tryToSelect(viewer, xx, yy, e.getClickCount() - 2, false);
            e.consume();
            return;
        }
        this.updatingConstrainingObjects(viewer, xx, yy, Collections.emptyList());
        PathObject pathObject = this.createNewAnnotation(e, xx, yy);
        if (pathObject == null) {
            return;
        }
        editor.setROI(pathObject.getROI());
        editor.grabHandle(xx, yy, viewer.getMaxROIHandleSize() * 1.5, e.isShiftDown());
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
        this.ensureCursorType(Cursor.CROSSHAIR);
    }

    protected boolean preferReturnToMove() {
        return PathPrefs.returnToMoveModeProperty().get();
    }

    void commitObjectToHierarchy(MouseEvent e, PathObject pathObject) {
        QuPathGUI qupath;
        if (pathObject == null) {
            return;
        }
        QuPathViewer viewer = this.getViewer();
        PathObjectHierarchy hierarchy = viewer.getHierarchy();
        ROI currentROI = pathObject.getROI();
        if (PathPrefs.selectionModeStatus().get()) {
            Collection<Object> toSelect;
            PathClass pathClass;
            PathClass pathClass2 = pathClass = e.isAltDown() ? null : (PathClass)PathPrefs.autoSetAnnotationClassProperty().get();
            if (currentROI.isArea()) {
                toSelect = hierarchy.getAllObjectsForROI(currentROI);
            } else if (currentROI.isPoint()) {
                toSelect = new HashSet();
                for (Point2 p2 : currentROI.getAllPoints()) {
                    toSelect.addAll(PathObjectTools.getObjectsForLocation((PathObjectHierarchy)hierarchy, (double)p2.getX(), (double)p2.getY(), (int)currentROI.getZ(), (int)currentROI.getT(), (double)0.0));
                }
            } else {
                Geometry geom = currentROI.getGeometry();
                toSelect = hierarchy.getAllDetectionsForRegion(ImageRegion.createInstance((ROI)currentROI)).parallelStream().filter(p -> geom.intersects(p.getROI().getGeometry())).toList();
            }
            if (!toSelect.isEmpty() && pathClass != null) {
                boolean retainIntensityClass = !PathClassTools.isPositiveOrGradedIntensityClass((PathClass)pathClass) && !PathClassTools.isNegativeClass((PathClass)pathClass);
                List<PathObject> reclassified = toSelect.stream().filter(p -> p.getPathClass() != pathClass).map(p -> new Reclassifier(p, pathClass, retainIntensityClass)).filter(Reclassifier::apply).map(Reclassifier::getPathObject).toList();
                if (!reclassified.isEmpty()) {
                    hierarchy.fireObjectClassificationsChangedEvent((Object)this, reclassified);
                }
            }
            if (pathObject.getParent() != null) {
                hierarchy.removeObject(pathObject, true);
            }
            if (toSelect.isEmpty()) {
                viewer.setSelectedObject(null);
            } else if (e.isAltDown()) {
                hierarchy.getSelectionModel().deselectObject(pathObject);
                hierarchy.getSelectionModel().deselectObjects(toSelect);
            } else if (e.isShiftDown()) {
                hierarchy.getSelectionModel().deselectObject(pathObject);
                hierarchy.getSelectionModel().selectObjects(toSelect);
            } else {
                hierarchy.getSelectionModel().setSelectedObjects(toSelect, null);
            }
        } else {
            if (!this.requestParentClipping(e)) {
                if (currentROI.isEmpty()) {
                    if (pathObject != null) {
                        if (pathObject.getParent() == null) {
                            hierarchy.fireHierarchyChangedEvent((Object)this);
                        } else {
                            hierarchy.removeObject(pathObject, true);
                        }
                    }
                    pathObject = null;
                } else {
                    hierarchy.addObject(pathObject);
                }
            } else {
                ROI roiNew = this.refineROIByParent(pathObject.getROI());
                if (roiNew.isEmpty()) {
                    hierarchy.removeObject(pathObject, true);
                    pathObject = null;
                } else {
                    ((PathAnnotationObject)pathObject).setROI(roiNew);
                    hierarchy.addObjectBelowParent(this.getCurrentParent(), pathObject, true);
                }
            }
            if (pathObject != null) {
                viewer.setSelectedObject(pathObject);
            } else {
                viewer.getHierarchy().getSelectionModel().clearSelection();
            }
        }
        RoiEditor editor = viewer.getROIEditor();
        editor.ensureHandlesUpdated();
        editor.resetActiveHandle();
        if (this.preferReturnToMove() && (qupath = QuPathGUI.getInstance()) != null) {
            qupath.getToolManager().setSelectedTool(PathTools.MOVE);
        }
    }
}

