/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer.tools.handlers;

import java.awt.geom.Point2D;
import java.util.Collections;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.gui.viewer.tools.handlers.AbstractPathROIToolEventHandler;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathROIObject;
import qupath.lib.roi.RoiEditor;
import qupath.lib.roi.interfaces.ROI;

abstract class AbstractPathDraggingROIToolEventHandler
extends AbstractPathROIToolEventHandler {
    AbstractPathDraggingROIToolEventHandler() {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        super.mouseDragged(e);
        if (!e.isPrimaryButtonDown()) {
            return;
        }
        QuPathViewer viewer = this.getViewer();
        ROI currentROI = viewer.getCurrentROI() instanceof ROI ? viewer.getCurrentROI() : null;
        RoiEditor editor = viewer.getROIEditor();
        if (currentROI != null && editor.getROI() == currentROI && editor.hasActiveHandle()) {
            PathObject pathObject = viewer.getSelectedObject();
            Point2D p = this.mouseLocationToImage(e, true, this.requestPixelSnapping());
            ROI roiUpdated = editor.setActiveHandlePosition(p.getX(), p.getY(), 0.25, e.isShiftDown());
            if (roiUpdated != currentROI) {
                ((PathROIObject)pathObject).setROI(roiUpdated);
                viewer.repaint();
            }
            viewer.getHierarchy().fireObjectsChangedEvent((Object)this, Collections.singleton(pathObject), true);
            viewer.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() != MouseButton.PRIMARY) {
            return;
        }
        QuPathViewer viewer = this.getViewer();
        PathObject selectedObject = viewer.getSelectedObject();
        if (selectedObject == null) {
            this.resetConstrainingObjects();
            return;
        }
        RoiEditor editor = viewer.getROIEditor();
        ROI currentROI = selectedObject.getROI();
        if (currentROI != null && editor.getROI() == currentROI && editor.hasActiveHandle()) {
            editor.setROI(null);
            if (currentROI.isEmpty()) {
                if (selectedObject.getParent() != null) {
                    viewer.getHierarchy().removeObject(selectedObject, true);
                }
                viewer.setSelectedObject(null);
            } else {
                this.commitObjectToHierarchy(e, selectedObject);
            }
        }
        this.resetConstrainingObjects();
    }
}

