/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer.tools;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuPathPenManager {
    private static Logger logger = LoggerFactory.getLogger(QuPathPenManager.class);
    private static PenInputManager defaultPenManager;
    private static PenInputManager penManager;

    public static PenInputManager getPenManager() {
        return penManager;
    }

    public static void setPenManager(PenInputManager manager) {
        if (manager == null) {
            logger.debug("Cannot set PenInputManager to null - will set it to default instead");
            penManager = defaultPenManager;
        }
        penManager = manager;
    }

    static {
        penManager = defaultPenManager = new DefaultPenManager();
    }

    public static interface PenInputManager {
        public boolean isEraser();

        public double getPressure();
    }

    private static class DefaultPenManager
    implements PenInputManager {
        private DefaultPenManager() {
        }

        @Override
        public boolean isEraser() {
            return false;
        }

        @Override
        public double getPressure() {
            return 1.0;
        }
    }
}

