/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer.tools;

import java.util.Arrays;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.gui.localization.QuPathResources;
import qupath.lib.gui.tools.IconFactory;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.gui.viewer.tools.ExtendedPathTool;
import qupath.lib.gui.viewer.tools.PathTool;
import qupath.lib.gui.viewer.tools.handlers.PathToolEventHandlers;

public class PathTools {
    public static final PathTool MOVE = PathTools.createTool(PathToolEventHandlers.createMoveEventHandler(), QuPathResources.getString("Tools.move"), PathTools.createIcon(IconFactory.PathIcons.MOVE_TOOL));
    public static final PathTool RECTANGLE = PathTools.createTool(PathToolEventHandlers.createRectangleEventHandler(), QuPathResources.getString("Tools.rectangle"), PathTools.createIcon(IconFactory.PathIcons.RECTANGLE_TOOL));
    public static final PathTool ELLIPSE = PathTools.createTool(PathToolEventHandlers.createEllipseEventHandler(), QuPathResources.getString("Tools.ellipse"), PathTools.createIcon(IconFactory.PathIcons.ELLIPSE_TOOL));
    public static final PathTool LINE = PathTools.createTool(PathToolEventHandlers.createLineEventHandler(), QuPathResources.getString("Tools.line"), PathTools.createIcon(IconFactory.PathIcons.LINE_TOOL));
    public static final PathTool ARROW_START = PathTools.createTool(PathToolEventHandlers.createArrowStartEventHandler(), QuPathResources.getString("Tools.arrowStart"), PathTools.createIcon(IconFactory.PathIcons.ARROW_START_TOOL));
    public static final PathTool ARROW_END = PathTools.createTool(PathToolEventHandlers.createArrowEndEventHandler(), QuPathResources.getString("Tools.arrowEnd"), PathTools.createIcon(IconFactory.PathIcons.ARROW_END_TOOL));
    public static final PathTool ARROW_DOUBLE = PathTools.createTool(PathToolEventHandlers.createDoubleArrowEventHandler(), QuPathResources.getString("Tools.arrowDouble"), PathTools.createIcon(IconFactory.PathIcons.ARROW_DOUBLE_TOOL));
    public static final PathTool LINE_OR_ARROW = PathTools.createExtendedTool(LINE, ARROW_START, ARROW_END, ARROW_DOUBLE);
    public static final PathTool POLYGON = PathTools.createTool(PathToolEventHandlers.createPolygonEventHandler(), QuPathResources.getString("Tools.polygon"), PathTools.createIcon(IconFactory.PathIcons.POLYGON_TOOL));
    public static final PathTool POLYLINE = PathTools.createTool(PathToolEventHandlers.createPolylineEventHandler(), QuPathResources.getString("Tools.polyline"), PathTools.createIcon(IconFactory.PathIcons.POLYLINE_TOOL));
    public static final PathTool BRUSH = PathTools.createTool(PathToolEventHandlers.createBrushEventHandler(), QuPathResources.getString("Tools.brush"), PathTools.createIcon(IconFactory.PathIcons.BRUSH_TOOL));
    public static final PathTool POINTS = PathTools.createTool(PathToolEventHandlers.createPointsEventHandler(), QuPathResources.getString("Tools.points"), PathTools.createIcon(IconFactory.PathIcons.POINTS_TOOL));
    private static List<PathTool> ALL_TOOLS = Arrays.asList(MOVE, RECTANGLE, ELLIPSE, LINE, POLYGON, POLYLINE, BRUSH, POINTS);

    private static Node createIcon(IconFactory.PathIcons icon) {
        return IconFactory.createNode(16, 16, icon);
    }

    public static PathTool createTool(EventHandler<MouseEvent> handler, String name, Node icon) {
        return PathTools.createTool(MouseEvent.ANY, handler, name, icon);
    }

    public static PathTool createExtendedTool(PathTool ... tools) {
        if (tools.length == 0) {
            throw new IllegalArgumentException("An extended tool should have at least 1 available mode!");
        }
        return new ExtendedPathTool(Arrays.asList(tools));
    }

    public static <T extends Event> PathTool createTool(EventType<T> type, EventHandler<T> handler, String name, Node icon) {
        return new DefaultPathTool<T>(type, handler, name, icon);
    }

    public static PathTool getTool(String pathToolString) {
        for (PathTool t : ALL_TOOLS) {
            if (!t.getName().toLowerCase().equals(pathToolString)) continue;
            return t;
        }
        return null;
    }

    static class DefaultPathTool<T extends Event>
    implements PathTool {
        private static final Logger logger = LoggerFactory.getLogger(DefaultPathTool.class);
        private QuPathViewer viewer;
        private StringProperty name;
        private ObjectProperty<Node> icon;
        private EventType<T> type;
        private EventHandler<T> handler;

        DefaultPathTool(EventType<T> type, EventHandler<T> handler, String name, Node icon) {
            this.name = new SimpleStringProperty(name);
            this.icon = new SimpleObjectProperty((Object)icon);
            this.type = type;
            this.handler = handler;
        }

        @Override
        public void registerTool(QuPathViewer viewer) {
            if (this.viewer != null) {
                this.deregisterTool(this.viewer);
            }
            this.viewer = viewer;
            if (viewer != null) {
                logger.trace("Registering {} to viewer {}", (Object)this.getName(), (Object)viewer);
                Pane canvas = viewer.getView();
                canvas.addEventHandler(this.type, this.handler);
            }
        }

        @Override
        public void deregisterTool(QuPathViewer viewer) {
            if (this.viewer == viewer) {
                logger.trace("Deregistering {} from viewer {}", (Object)this.getName(), (Object)viewer);
                this.viewer = null;
                Pane canvas = viewer.getView();
                canvas.removeEventHandler(this.type, this.handler);
            }
        }

        public StringProperty nameProperty() {
            return this.name;
        }

        public ObjectProperty<Node> iconProperty() {
            return this.icon;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + String.valueOf(this.name);
        }
    }
}

