/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer.tools;

import java.util.Collection;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.gui.viewer.tools.PathTool;

public class ExtendedPathTool
implements PathTool {
    private ObservableList<PathTool> tools;
    private ObjectProperty<PathTool> selectedTool;
    private StringProperty nameProperty = new SimpleStringProperty();
    private ObjectProperty<Node> iconProperty = new SimpleObjectProperty();
    private QuPathViewer viewer;

    ExtendedPathTool(Collection<? extends PathTool> tools) {
        this(tools, tools.iterator().next());
    }

    ExtendedPathTool(Collection<? extends PathTool> tools, PathTool defaultSelectedTool) {
        this.tools = FXCollections.observableArrayList(tools);
        this.selectedTool = new SimpleObjectProperty((Object)defaultSelectedTool);
        this.nameProperty.bind((ObservableValue)Bindings.createStringBinding(() -> ((PathTool)this.selectedTool.getValue()).getName(), (Observable[])new Observable[]{this.selectedTool}));
        this.iconProperty.bind((ObservableValue)Bindings.createObjectBinding(() -> ((PathTool)this.selectedTool.getValue()).getIcon(), (Observable[])new Observable[]{this.selectedTool}));
        this.selectedTool.addListener(this::handleToolChange);
    }

    private void handleToolChange(ObservableValue<? extends PathTool> selectedTool, PathTool previousTool, PathTool newTool) {
        if (this.viewer == null) {
            return;
        }
        if (previousTool != null && this.viewer != null) {
            previousTool.deregisterTool(this.viewer);
        }
        if (newTool != null && this.viewer != null) {
            newTool.registerTool(this.viewer);
        }
    }

    public ObservableList<PathTool> getAvailableTools() {
        return this.tools;
    }

    public ObjectProperty<PathTool> selectedTool() {
        return this.selectedTool;
    }

    @Override
    public void registerTool(QuPathViewer viewer) {
        PathTool tool = (PathTool)this.selectedTool.getValue();
        if (tool == null || viewer == null) {
            return;
        }
        tool.registerTool(viewer);
        this.viewer = viewer;
    }

    @Override
    public void deregisterTool(QuPathViewer viewer) {
        PathTool tool = (PathTool)this.selectedTool.getValue();
        if (tool == null || viewer == null) {
            return;
        }
        tool.deregisterTool(viewer);
        if (this.viewer == viewer) {
            this.viewer = null;
        }
    }

    @Override
    public ReadOnlyStringProperty nameProperty() {
        return this.nameProperty;
    }

    @Override
    public ReadOnlyObjectProperty<Node> iconProperty() {
        return this.iconProperty;
    }
}

