/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer.recording;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import javafx.stage.FileChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.dialogs.FileChoosers;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.gui.viewer.recording.ViewRecordingFrame;
import qupath.lib.gui.viewer.recording.ViewTracker;
import qupath.lib.gui.viewer.tools.PathTool;
import qupath.lib.gui.viewer.tools.PathTools;

final class ViewTrackerTools {
    private static final Logger logger = LoggerFactory.getLogger(ViewTrackerTools.class);

    private ViewTrackerTools() {
        throw new AssertionError();
    }

    static String getSummaryHeadings(String delimiter, boolean includeCursor, boolean includeActiveTool, boolean includeEyeTracking, boolean isZAndTIncluded) {
        StringBuffer sb = new StringBuffer();
        sb.append("Timestamp");
        sb.append(delimiter);
        sb.append("X");
        sb.append(delimiter);
        sb.append("Y");
        sb.append(delimiter);
        sb.append("Width");
        sb.append(delimiter);
        sb.append("Height");
        sb.append(delimiter);
        sb.append("Canvas width");
        sb.append(delimiter);
        sb.append("Canvas height");
        sb.append(delimiter);
        sb.append("Downsample factor");
        sb.append(delimiter);
        sb.append("Rotation");
        if (includeCursor) {
            sb.append(delimiter);
            sb.append("Cursor X");
            sb.append(delimiter);
            sb.append("Cursor Y");
        }
        if (includeActiveTool) {
            sb.append(delimiter);
            sb.append("Active tool");
        }
        if (includeEyeTracking) {
            sb.append(delimiter);
            sb.append("Eye X");
            sb.append(delimiter);
            sb.append("Eye Y");
            sb.append(delimiter);
            sb.append("Eye fixated");
        }
        if (isZAndTIncluded) {
            sb.append(delimiter);
            sb.append("Z");
            sb.append(delimiter);
            sb.append("T");
        }
        return sb.toString();
    }

    static ViewTracker parseSummaryString(String str, String delimiter, ViewTracker tracker) throws Exception {
        ViewTracker trackerOrDefault = tracker == null ? new ViewTracker(null) : tracker;
        String delimiterOrDefault = delimiter == null ? ViewTrackerTools.estimateDelimiter(str) : delimiter;
        boolean includesCursorTracking = false;
        boolean includesActiveToolTracking = false;
        boolean includesEyeTracking = false;
        boolean includeZAndT = false;
        boolean firstLine = true;
        for (String s : GeneralTools.splitLines((String)str)) {
            if (firstLine) {
                includesCursorTracking = s.toLowerCase().contains("cursor");
                includesActiveToolTracking = s.toLowerCase().contains("tool");
                includesEyeTracking = s.toLowerCase().contains("eye");
                includeZAndT = s.toLowerCase().contains("z") && s.toLowerCase().contains("t");
                firstLine = false;
                continue;
            }
            ViewRecordingFrame frame = ViewTrackerTools.parseLogString(s, delimiterOrDefault, includesCursorTracking, includesActiveToolTracking, includesEyeTracking, includeZAndT);
            if (frame == null) continue;
            trackerOrDefault.appendFrame(frame);
        }
        trackerOrDefault.setOptionalParameters(includeZAndT, includesCursorTracking, includesActiveToolTracking, includesEyeTracking);
        return trackerOrDefault;
    }

    static String getSummary(ViewRecordingFrame frame, String delimiter, boolean includeCursor, boolean includeActiveTool, boolean includeEyeTracking, boolean includeZAndT) {
        StringBuffer sb = new StringBuffer();
        sb.append(frame.getTimestamp());
        sb.append(delimiter);
        Rectangle bounds = frame.getImageBounds();
        sb.append(bounds.x);
        sb.append(delimiter);
        sb.append(bounds.y);
        sb.append(delimiter);
        sb.append(bounds.width);
        sb.append(delimiter);
        sb.append(bounds.height);
        sb.append(delimiter);
        Dimension canvasSize = frame.getSize();
        sb.append(canvasSize.width);
        sb.append(delimiter);
        sb.append(canvasSize.height);
        sb.append(delimiter);
        sb.append(frame.getDownsampleFactor());
        sb.append(delimiter);
        sb.append(frame.getRotation());
        if (includeCursor) {
            if (frame.hasCursorPosition()) {
                Point2D cursorPosition = frame.getCursorPosition();
                sb.append(delimiter);
                sb.append(ViewTracker.df.format(cursorPosition.getX()));
                sb.append(delimiter);
                sb.append(ViewTracker.df.format(cursorPosition.getY()));
            } else {
                sb.append(delimiter);
                sb.append(delimiter);
            }
        }
        if (includeActiveTool) {
            sb.append(delimiter);
            sb.append(frame.getActiveTool().getName());
        }
        if (includeEyeTracking) {
            if (frame.hasEyePosition()) {
                Point2D eyePosition = frame.getEyePosition();
                sb.append(delimiter);
                sb.append(ViewTracker.df.format(eyePosition.getX()));
                sb.append(delimiter);
                sb.append(ViewTracker.df.format(eyePosition.getY()));
                sb.append(delimiter);
                if (frame.isEyeFixated() == null) {
                    sb.append(delimiter);
                } else {
                    sb.append(frame.isEyeFixated().toString());
                }
            } else {
                sb.append(delimiter);
                sb.append(delimiter);
                sb.append(delimiter);
            }
        }
        if (includeZAndT) {
            if (frame.getZ() != -1) {
                sb.append(delimiter);
                sb.append(ViewTracker.df.format(frame.getZ()));
            }
            if (frame.getT() != -1) {
                sb.append(delimiter);
                sb.append(ViewTracker.df.format(frame.getT()));
            }
        }
        return sb.toString();
    }

    static void handleExport(ViewTracker tracker) {
        if (tracker.isEmpty()) {
            Dialogs.showErrorMessage((String)"Tracking export", (String)"Tracker is empty - nothing to export!");
            return;
        }
        File fileExport = FileChoosers.promptToSaveFile((FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)"QuPath tracking data (tsv)", (String[])new String[]{"tsv"})});
        if (fileExport == null) {
            return;
        }
        try (PrintWriter out = new PrintWriter(fileExport);){
            out.print(ViewTrackerTools.getSummaryHeadings("\t", tracker.hasCursorTrackingData(), tracker.hasActiveToolTrackingData(), tracker.hasEyeTrackingData(), tracker.hasZAndT()));
            for (ViewRecordingFrame frame : tracker.getAllFrames()) {
                out.print(ViewTrackerTools.getSummary(frame, "\t", tracker.hasCursorTrackingData(), tracker.hasActiveToolTrackingData(), tracker.hasEyeTrackingData(), tracker.hasZAndT()));
            }
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    static ViewTracker handleImport(Path in) {
        String content = null;
        try (Scanner scanner = new Scanner(in);){
            content = scanner.useDelimiter("\\Z").next();
        }
        catch (IOException ex) {
            Dialogs.showErrorMessage((String)"View tracking import", (String)("Unable to read " + String.valueOf(in) + "." + System.lineSeparator() + ex.getLocalizedMessage()));
            return null;
        }
        if (content == null) {
            Dialogs.showErrorMessage((String)"View tracking import", (String)("Unable to read " + String.valueOf(in)));
            return null;
        }
        try {
            ViewTracker tracker = ViewTrackerTools.parseSummaryString(content, null, null);
            tracker.setFile(in.toFile());
            tracker.setName(GeneralTools.getNameWithoutExtension((File)in.toFile()));
            return tracker;
        }
        catch (Exception ex) {
            Dialogs.showErrorNotification((String)"View tracking import", (String)("Unable to read tracking data from " + String.valueOf(in) + ": " + ex.getLocalizedMessage()));
            return null;
        }
    }

    static String getPrettyTimestamp(long startTime, long endTime) {
        return ViewTrackerTools.getPrettyTimestamp(endTime - startTime);
    }

    static String getPrettyTimestamp(long date) {
        long hour = TimeUnit.MILLISECONDS.toHours(date);
        long min = TimeUnit.MILLISECONDS.toMinutes(date) % 60L;
        long sec = TimeUnit.MILLISECONDS.toSeconds(date) % 60L;
        return String.format("%02d:%02d:%02d", hour, min, sec);
    }

    static long getTimestampFromPrettyString(String prettyString) {
        return TimeUnit.HOURS.toMillis(Integer.parseInt(prettyString.substring(0, 2))) + TimeUnit.MINUTES.toMillis(Integer.parseInt(prettyString.substring(3, 5))) + TimeUnit.SECONDS.toMillis(Integer.parseInt(prettyString.substring(6, 8)));
    }

    static Dimension getSize(QuPathViewer viewer) {
        return new Dimension((int)Math.round(viewer.getView().getWidth()), (int)Math.round(viewer.getView().getHeight()));
    }

    private static int countOccurrences(String s, CharSequence sequence) {
        return s.length() - s.replace(sequence, "").length();
    }

    private static String estimateDelimiter(String s) {
        String[] possibleDelimiters;
        int nLines = ViewTrackerTools.countOccurrences(s, "\n");
        for (String delim : possibleDelimiters = new String[]{"\t", "\t", ",", ":"}) {
            int nOccurrences = ViewTrackerTools.countOccurrences(s, delim);
            double occurrencesPerLine = (double)nOccurrences / (double)nLines;
            if (!(occurrencesPerLine > 0.0) || occurrencesPerLine != Math.floor(occurrencesPerLine)) continue;
            return delim;
        }
        return "\t";
    }

    private static ViewRecordingFrame parseLogString(String logString, String delimiter, boolean includesCursorTracking, boolean includesActiveToolTracking, boolean includesEyeTracking, boolean includeZAndT) {
        String s;
        String string = s = logString != null ? logString.trim().toLowerCase() : null;
        if (s == null || s.isEmpty()) {
            return null;
        }
        String[] columns = s.split(delimiter);
        int col = 0;
        long timestamp = Long.parseLong(columns[col++]);
        double x = Double.parseDouble(columns[col++]);
        double y = Double.parseDouble(columns[col++]);
        double width = Double.parseDouble(columns[col++]);
        double height = Double.parseDouble(columns[col++]);
        int canvasWidth = Integer.parseInt(columns[col++]);
        int canvasHeight = Integer.parseInt(columns[col++]);
        double downFactor = Double.parseDouble(columns[col++]);
        double rotation = Double.parseDouble(columns[col++]);
        Point2D.Double pCursor = null;
        if (includesCursorTracking && columns.length > col && !columns[col].isEmpty() && !columns[col + 1].isEmpty()) {
            double cursorX = Double.parseDouble(columns[col++]);
            double cursorY = Double.parseDouble(columns[col++]);
            pCursor = new Point2D.Double(cursorX, cursorY);
        }
        PathTool activeTool = null;
        if (includesActiveToolTracking && columns.length > col && !columns[col].isEmpty()) {
            activeTool = PathTools.getTool(columns[col++]);
        }
        Point2D.Double pEye = null;
        Boolean isFixated = null;
        if (includesEyeTracking) {
            if (columns.length > col && columns[col].length() > 0 && !columns[col + 1].isEmpty()) {
                double eyeX = Double.parseDouble(columns[col++]);
                double eyeY = Double.parseDouble(columns[col++]);
                pEye = new Point2D.Double(eyeX, eyeY);
            }
            if (columns.length > col && columns[col].length() > 0) {
                isFixated = Boolean.parseBoolean(columns[col++]);
            }
        }
        int z = 0;
        int t = 0;
        if (includeZAndT && columns.length > col && columns[col].length() > 0 && !columns[col + 1].isEmpty()) {
            z = Integer.parseInt(columns[col++]);
            t = Integer.parseInt(columns[col++]);
        }
        return new ViewRecordingFrame(timestamp, new Rectangle2D.Double(x, y, width, height), new Dimension(canvasWidth, canvasHeight), downFactor, rotation, pCursor, activeTool, pEye, isFixated, z, t);
    }
}

