/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer.recording;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.FileChooser;
import javafx.util.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.FileChoosers;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.gui.viewer.overlays.BufferedImageOverlay;
import qupath.lib.gui.viewer.recording.ViewRecordingFrame;
import qupath.lib.gui.viewer.recording.ViewTracker;
import qupath.lib.gui.viewer.recording.ViewTrackerAnalysisCommand;
import qupath.lib.images.writers.ImageWriterTools;
import qupath.lib.regions.ImageRegion;

final class ViewTrackerSlideOverview {
    private static final Logger logger = LoggerFactory.getLogger(ViewTrackerSlideOverview.class);
    private QuPathViewer viewer;
    private BufferedImage img;
    private BufferedImageOverlay overlay;
    private WritableImage scaledImg;
    private WritableImage scaledMap;
    private Canvas canvas;
    private final int preferredWidth = 250;
    private int preferredHeight = -1;
    private final Color color = Color.rgb((int)200, (int)0, (int)0, (double)0.8);
    private Shape shapeVisible = null;
    private AffineTransform transform = new AffineTransform();
    private DoubleProperty mouseXLocation = new SimpleDoubleProperty();
    private DoubleProperty mouseYLocation = new SimpleDoubleProperty();
    private ViewTrackerAnalysisCommand.DataMapsLocationString locationString;

    ViewTrackerSlideOverview(QuPathViewer viewer) {
        this.viewer = viewer;
        this.canvas = new Canvas();
        this.img = viewer.getRGBThumbnail();
        if (this.img == null) {
            return;
        }
        this.preferredHeight = (int)((double)this.img.getHeight() * (250.0 / (double)this.img.getWidth()));
        WritableImage imgPreview = GuiTools.getScaledRGBInstance(this.img, 250, this.preferredHeight);
        this.canvas.setWidth(imgPreview.getWidth());
        this.canvas.setHeight(imgPreview.getHeight());
        this.paintCanvas();
        Tooltip tooltip = new Tooltip();
        tooltip.setShowDelay(Duration.ZERO);
        tooltip.setHideDelay(Duration.ZERO);
        tooltip.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            double canvasDownsample = (double)viewer.getServerWidth() / this.canvas.getWidth();
            double x = this.mouseXLocation.get() * canvasDownsample;
            double y = this.mouseYLocation.get() * canvasDownsample;
            if (x < 0.0 || y < 0.0) {
                return "";
            }
            String legend = "X: " + ViewTracker.df.format(x) + System.lineSeparator() + "Y: " + ViewTracker.df.format(y);
            if (this.overlay != null && this.locationString != null) {
                legend = legend + System.lineSeparator() + this.locationString.getLocationString(viewer.getImageData(), x, y, viewer.getZPosition(), viewer.getTPosition());
            }
            return legend;
        }, (Observable[])new Observable[]{this.mouseXLocation, this.mouseYLocation}));
        Tooltip.install((Node)this.canvas, (Tooltip)tooltip);
        this.canvas.setOnMouseMoved(e -> {
            if (e.getX() < 0.0 || e.getY() < 0.0) {
                return;
            }
            this.mouseXLocation.set(e.getX());
            this.mouseYLocation.set(e.getY());
            tooltip.setX(e.getScreenX() + 10.0);
            tooltip.setY(e.getScreenY());
        });
        this.canvas.setOnMouseExited(e -> {
            this.mouseXLocation.set(-1.0);
            this.mouseYLocation.set(-1.0);
        });
        this.canvas.setOnContextMenuRequested(e -> {
            MenuItem tifExportItem = new MenuItem("Export data as TIF");
            MenuItem copyItem = new MenuItem("Copy image to clipboard");
            ContextMenu contextMenu = new ContextMenu(new MenuItem[]{tifExportItem, copyItem});
            tifExportItem.setOnAction(event -> {
                File path = FileChoosers.promptToSaveFile((String)"Save data map", (File)new File("data map"), (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)"TIFF image", (String[])new String[]{".tif"})});
                if (path == null) {
                    return;
                }
                try {
                    BufferedImage imgToExport = this.overlay.getRegionMap().get(ImageRegion.createInstance((int)0, (int)0, (int)viewer.getServerWidth(), (int)viewer.getServerHeight(), (int)viewer.getZPosition(), (int)viewer.getTPosition()));
                    ImageWriterTools.writeImage((BufferedImage)imgToExport, (String)path.toString());
                }
                catch (IOException ex) {
                    logger.error("Could not export data", (Throwable)ex);
                }
            });
            copyItem.setOnAction(event -> {
                if (this.overlay == null) {
                    return;
                }
                ClipboardContent content = new ClipboardContent();
                BufferedImage imgToExport = this.overlay.getRegionMap().get(ImageRegion.createInstance((int)0, (int)0, (int)viewer.getServerWidth(), (int)viewer.getServerHeight(), (int)viewer.getZPosition(), (int)viewer.getTPosition()));
                content.putImage((Image)SwingFXUtils.toFXImage((BufferedImage)imgToExport, null));
                Clipboard.getSystemClipboard().setContent((Map)content);
            });
            tifExportItem.setDisable(this.overlay == null);
            copyItem.setDisable(this.overlay == null);
            contextMenu.show(this.canvas.getParent().getScene().getWindow(), e.getScreenX(), e.getScreenY());
            contextMenu.setAutoHide(true);
        });
    }

    Canvas getCanvas() {
        return this.canvas;
    }

    void paintCanvas() {
        this.paintCanvas(true, true);
    }

    void paintCanvas(boolean resetMainImage, boolean resetScaledMap) {
        GraphicsContext g = this.canvas.getGraphicsContext2D();
        double w = this.canvas.getWidth();
        double h = this.canvas.getHeight();
        g.clearRect(0.0, 0.0, w, h);
        if (this.viewer == null || !this.viewer.hasServer()) {
            return;
        }
        if (resetMainImage) {
            this.img = this.viewer.getRGBThumbnail();
            this.scaledImg = GuiTools.getScaledRGBInstance(this.img, 250, this.preferredHeight);
        }
        ViewTrackerSlideOverview.drawImage(g, this.scaledImg);
        if (this.overlay != null && resetScaledMap) {
            BufferedImage tempImg = this.overlay.getRegionMap().get(ImageRegion.createInstance((int)0, (int)0, (int)this.viewer.getServerWidth(), (int)this.viewer.getServerHeight(), (int)this.viewer.getZPosition(), (int)this.viewer.getTPosition()));
            this.scaledMap = GuiTools.getScaledRGBInstance(tempImg, 250, this.preferredHeight);
        }
        ViewTrackerSlideOverview.drawImage(g, this.scaledMap);
        if (this.shapeVisible != null) {
            g.setStroke((Paint)this.color);
            g.setLineWidth(1.0);
            PathIterator iterator = this.shapeVisible.getPathIterator(null);
            double[] coords = new double[6];
            g.beginPath();
            while (!iterator.isDone()) {
                int type = iterator.currentSegment(coords);
                if (type == 0) {
                    g.moveTo(coords[0], coords[1]);
                } else if (type == 1) {
                    g.lineTo(coords[0], coords[1]);
                } else if (type == 4) {
                    g.closePath();
                    g.stroke();
                } else {
                    logger.debug("Unknown PathIterator type: {}", (Object)type);
                }
                iterator.next();
            }
        }
        g.setLineWidth(2.0);
        g.setStroke((Paint)Color.rgb((int)64, (int)64, (int)64));
        g.strokeRect(0.0, 0.0, w, h);
    }

    private static void drawImage(GraphicsContext g, WritableImage imgPreview) {
        if (imgPreview == null) {
            return;
        }
        g.drawImage((Image)imgPreview, 0.0, 0.0);
    }

    void setOverlay(BufferedImageOverlay overlay) {
        this.overlay = overlay;
        if (overlay == null) {
            this.scaledMap = null;
        }
        this.paintCanvas();
    }

    void setVisibleShape(ViewRecordingFrame frame) {
        double scale = 250.0 / (double)this.viewer.getServer().getWidth();
        double theta = frame.getRotation();
        Shape shape = frame.getShape();
        this.transform.setToIdentity();
        this.transform.setToScale(scale, scale);
        if (shape instanceof Rectangle2D && theta != 0.0) {
            Point2D center = frame.getFrameCentre();
            this.transform.rotate(-theta, center.getX(), center.getY());
        }
        this.shapeVisible = this.transform.createTransformedShape(shape);
    }

    void setLocationStringFunction(ViewTrackerAnalysisCommand.DataMapsLocationString locationString) {
        this.locationString = locationString;
    }
}

