/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer.recording;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyLongProperty;
import javafx.beans.property.ReadOnlyLongWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.stage.Window;
import javafx.util.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.gui.viewer.recording.ViewRecordingFrame;
import qupath.lib.gui.viewer.recording.ViewTracker;
import qupath.lib.gui.viewer.recording.ViewTrackerTools;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjects;
import qupath.lib.regions.ImagePlane;
import qupath.lib.roi.ROIs;
import qupath.lib.roi.interfaces.ROI;

class ViewTrackerPlayback {
    private static final Logger logger = LoggerFactory.getLogger(ViewTrackerPlayback.class);
    private QuPathViewer viewer;
    private ViewTracker tracker;
    private BooleanProperty playing;
    private ReadOnlyLongWrapper playbackTimeProperty = new ReadOnlyLongWrapper();
    private Timeline timeline;
    private long startTimestamp;
    private ViewRecordingFrame firstFrame;
    private ObjectProperty<ViewRecordingFrame> currentFrame = new SimpleObjectProperty();

    ViewTrackerPlayback(QuPathViewer viewer) {
        this.viewer = viewer;
        this.playing = new SimpleBooleanProperty(false);
        this.timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                ViewTrackerPlayback.this.handleUpdate();
            }
        }, new KeyValue[0]), new KeyFrame(Duration.millis((double)50.0), new KeyValue[0])});
        this.timeline.setCycleCount(-1);
        this.playing.addListener((v, o, n) -> {
            if (n.booleanValue()) {
                this.doStartPlayback();
            } else {
                this.doStopPlayback();
            }
        });
    }

    boolean isPlaying() {
        return this.timeline.getStatus() == Animation.Status.RUNNING;
    }

    boolean doStartPlayback() {
        if (this.tracker == null || this.tracker.isEmpty()) {
            return false;
        }
        this.startTimestamp = System.currentTimeMillis();
        if (this.timeline.getStatus() == Animation.Status.RUNNING) {
            this.timeline.playFromStart();
        } else {
            this.timeline.play();
        }
        this.playing.set(true);
        return true;
    }

    void doStopPlayback() {
        if (!this.isPlaying()) {
            return;
        }
        this.timeline.stop();
        this.playing.set(false);
    }

    static void resizeViewer(QuPathViewer viewer, Dimension newSize) {
        if (ViewTrackerTools.getSize(viewer).equals(newSize)) {
            return;
        }
        double dw = (double)newSize.width - viewer.getView().getWidth();
        double dh = (double)newSize.height - viewer.getView().getHeight();
        Window window = viewer.getView().getScene().getWindow();
        window.setWidth(window.getWidth() + dw);
        window.setHeight(window.getHeight() + dh);
    }

    void handleUpdate() {
        boolean requestStop;
        if (this.tracker.isEmpty()) {
            this.playbackTimeProperty.set(0L);
            return;
        }
        long timestamp = System.currentTimeMillis();
        ViewRecordingFrame frame = this.tracker.getFrameForTime(timestamp - this.startTimestamp + this.firstFrame.getTimestamp());
        if (this.timeline != null) {
            this.playbackTimeProperty.set(timestamp - this.startTimestamp);
        }
        if (frame == null) {
            requestStop = true;
        } else {
            this.currentFrame.set((Object)frame);
            ViewTrackerPlayback.setViewerForFrame(this.viewer, frame);
            requestStop = this.tracker.isLastFrame(frame);
        }
        if (requestStop) {
            this.timeline.stop();
            this.playbackTimeProperty.set(0L);
            this.playing.set(false);
        }
    }

    ReadOnlyLongProperty playbackTimeProperty() {
        return this.playbackTimeProperty.getReadOnlyProperty();
    }

    static void setViewerForFrame(QuPathViewer viewer, ViewRecordingFrame frame) {
        ViewTrackerPlayback.resizeViewer(viewer, frame.getSize());
        viewer.setDownsampleFactor(frame.getDownsampleFactor());
        Rectangle imageBounds = frame.getImageBounds();
        viewer.setCenterPixelLocation((double)imageBounds.x + (double)imageBounds.width * 0.5, (double)imageBounds.y + (double)imageBounds.height * 0.5);
        viewer.setRotation(frame.getRotation());
        if (frame.hasEyePosition()) {
            Point2D p2d = frame.getEyePosition();
            ROI point = ROIs.createPointsROI((double)p2d.getX(), (double)p2d.getY(), (ImagePlane)ImagePlane.getDefaultPlane());
            PathObject pathObject = PathObjects.createAnnotationObject((ROI)point);
            pathObject.setName("Eye tracking position");
            viewer.setSelectedObject(pathObject);
            logger.debug("Eye position: " + String.valueOf(p2d));
        }
        if (frame.hasZOrT()) {
            viewer.setZPosition(frame.getZ());
            viewer.setTPosition(frame.getT());
        }
    }

    BooleanProperty playingProperty() {
        return this.playing;
    }

    void setViewTracker(ViewTracker tracker) {
        this.tracker = tracker;
        if (!tracker.isEmpty()) {
            this.firstFrame = tracker.getFrame(0);
            this.currentFrame.set((Object)this.firstFrame);
        }
    }

    void setFirstFrame(ViewRecordingFrame frame) {
        this.firstFrame = frame;
        this.currentFrame.set((Object)frame);
    }

    ObjectProperty<ViewRecordingFrame> getCurrentFrame() {
        return this.currentFrame;
    }
}

