/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer.recording;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.color.ColorMaps;
import qupath.lib.gui.viewer.recording.ViewRecordingFrame;
import qupath.lib.gui.viewer.recording.ViewTracker;
import qupath.lib.gui.viewer.recording.ViewTrackerDataMap;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.regions.ImageRegion;

final class ViewTrackerDataMaps {
    private static final Logger logger = LoggerFactory.getLogger(ViewTrackerDataMaps.class);
    private final ViewTracker tracker;
    private final int nZSlices;
    private final int nTimepoints;
    private final int fullWidth;
    private final int fullHeight;
    private final double downsample;
    private int dataMapWidth;
    private int dataMapHeight;
    private final Map<ImageRegion, ViewTrackerDataMap> regionMapsOriginal;
    private final Map<ImageRegion, BufferedImage> regionMaps;
    private BooleanProperty generatingOverlayProperty = new SimpleBooleanProperty(false);

    ViewTrackerDataMaps(ViewTracker tracker, int fullWidth, int fullHeight, int nZSlices, int nTimepoints, double[] downsamples) {
        this.tracker = tracker;
        this.fullWidth = fullWidth;
        this.fullHeight = fullHeight;
        this.dataMapWidth = fullWidth;
        this.dataMapHeight = fullHeight;
        this.nZSlices = nZSlices;
        this.nTimepoints = nTimepoints;
        this.regionMapsOriginal = new HashMap<ImageRegion, ViewTrackerDataMap>();
        this.regionMaps = new HashMap<ImageRegion, BufferedImage>();
        int index = 0;
        double divider = downsamples[0];
        while ((long)this.dataMapWidth * (long)this.dataMapHeight > 4000000L) {
            divider = ++index >= downsamples.length ? downsamples[downsamples.length - 1] * 2.0 : downsamples[index];
            this.dataMapWidth = (int)Math.round((double)fullWidth / divider);
            this.dataMapHeight = (int)Math.round((double)fullHeight / divider);
        }
        this.downsample = divider;
    }

    ViewTrackerDataMaps(ImageServer<?> server, ViewTracker tracker) {
        this(tracker, server.getWidth(), server.getHeight(), server.nZSlices(), server.nTimepoints(), server.getPreferredDownsamples());
    }

    Map<ImageRegion, BufferedImage> getRegionMaps() {
        return this.regionMaps;
    }

    BooleanProperty generatingOverlayProperty() {
        return this.generatingOverlayProperty;
    }

    Map<ImageRegion, BufferedImage> updateDataMaps(long timeStart, long timeStop, double downsampleMin, double downsampleMax, Feature feature, ColorMaps.ColorMap colorMap) {
        if (timeStart == -1L || timeStop == -1L || downsampleMin == -1.0 || downsampleMax == -1.0 || colorMap == null) {
            return null;
        }
        long startTime = System.currentTimeMillis();
        this.regionMaps.clear();
        this.regionMapsOriginal.clear();
        for (int z = 0; z < this.nZSlices; ++z) {
            for (int t = 0; t < this.nTimepoints; ++t) {
                ViewRecordingFrame[] relevantFrames = this.getRelevantFrames(timeStart, timeStop, downsampleMin, downsampleMax, z, t);
                ImageRegion region = ImageRegion.createInstance((int)0, (int)0, (int)this.fullWidth, (int)this.fullHeight, (int)z, (int)t);
                ViewTrackerDataMap dataMap = new ViewTrackerDataMap(region, feature, relevantFrames, this.downsample, this.dataMapWidth, this.dataMapHeight);
                this.regionMapsOriginal.put(region, dataMap);
                this.regionMaps.put(region, dataMap.getBufferedImage(colorMap));
            }
        }
        logger.info("Processing time for populateRegionMap(): " + (System.currentTimeMillis() - startTime));
        return this.regionMaps;
    }

    Number getMaxValue(double z, double t) {
        for (ImageRegion map : this.regionMapsOriginal.keySet()) {
            if ((double)map.getZ() != z || (double)map.getT() != t) continue;
            return this.regionMapsOriginal.get(map).getMaxValue();
        }
        return null;
    }

    private ViewRecordingFrame[] getRelevantFrames(long timeStart, long timeStop, double downsampleMin, double downsampleMax, int z, int t) {
        int frameStartIndex = this.tracker.getFrameIndexForTime(timeStart);
        int frameStopIndex = this.tracker.getFrameIndexForTime(timeStop);
        ArrayList<ViewRecordingFrame> relevantFrames = new ArrayList<ViewRecordingFrame>();
        ViewRecordingFrame previousFrame = null;
        for (int nFrame = frameStopIndex; nFrame >= frameStartIndex; --nFrame) {
            ViewRecordingFrame frame = this.tracker.getFrame(nFrame);
            if (frame.getZ() != z || frame.getT() != t || frame.getDownsampleFactor() < downsampleMin || frame.getDownsampleFactor() > downsampleMax || frame.sameImageBounds(previousFrame) && nFrame != frameStartIndex) continue;
            relevantFrames.add(frame);
            previousFrame = frame;
        }
        return (ViewRecordingFrame[])relevantFrames.toArray(ViewRecordingFrame[]::new);
    }

    Number getValueFromOriginalLocation(int x, int y, int z, int t) {
        Optional<ImageRegion> imageRegion = this.regionMaps.keySet().stream().filter(region -> region.contains(x, y, z, t)).findFirst();
        if (imageRegion.isPresent()) {
            return this.regionMapsOriginal.get(imageRegion.get()).getCalculatedValue(x, y);
        }
        return null;
    }

    static enum Feature {
        TIMESTAMP,
        DOWNSAMPLE;

    }
}

