/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer.recording;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferFloat;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.stream.DoubleStream;
import java.util.stream.LongStream;
import qupath.lib.color.ColorMaps;
import qupath.lib.color.ColorModels;
import qupath.lib.gui.viewer.recording.ViewRecordingFrame;
import qupath.lib.gui.viewer.recording.ViewTrackerDataMaps;
import qupath.lib.regions.ImageRegion;

public class ViewTrackerDataMap {
    long[] longArray;
    double[] doubleArray;
    final ImageRegion region;
    final ViewTrackerDataMaps.Feature feature;
    final ViewRecordingFrame[] relevantFrames;
    final int targetWidth;
    final int targetHeight;
    final double downsample;

    ViewTrackerDataMap(ImageRegion region, ViewTrackerDataMaps.Feature feature, ViewRecordingFrame[] relevantFrames, double downsample, int targetWidth, int targetHeight) {
        this.region = region;
        this.feature = feature;
        this.relevantFrames = relevantFrames;
        this.targetWidth = targetWidth;
        this.targetHeight = targetHeight;
        this.downsample = downsample;
        this.calculateMapValues();
    }

    private void calculateMapValues() {
        int arrayLength = this.targetHeight * this.targetWidth;
        if (this.feature == ViewTrackerDataMaps.Feature.TIMESTAMP) {
            this.longArray = new long[arrayLength];
            Arrays.fill(this.longArray, 0L);
        } else {
            this.doubleArray = new double[arrayLength];
            Arrays.fill(this.doubleArray, 0.0);
        }
        if (this.relevantFrames.length <= 1) {
            return;
        }
        for (int nFrame = this.relevantFrames.length - 1; nFrame >= 0; --nFrame) {
            ViewRecordingFrame frame = this.relevantFrames[nFrame];
            Rectangle downsampledBounds = ViewTrackerDataMap.getDownsampledBounds(frame.getImageBounds(), this.downsample);
            if (nFrame == 0 || frame.getTimestamp() == 0L) continue;
            long timestampValue = this.relevantFrames[nFrame - 1].getTimestamp() - frame.getTimestamp();
            double downsampleValue = frame.getDownsampleFactor();
            downsampledBounds = ViewTrackerDataMap.getCroppedBounds(downsampledBounds, this.targetWidth, this.targetHeight);
            Shape rotated = null;
            if (frame.getRotation() != 0.0) {
                AffineTransform transform = new AffineTransform();
                Point2D center = frame.getFrameCentre();
                transform.rotate(-frame.getRotation(), center.getX() / this.downsample, center.getY() / this.downsample);
                rotated = transform.createTransformedShape(downsampledBounds);
                downsampledBounds = rotated.getBounds();
            }
            int y = (int)downsampledBounds.getY();
            while ((double)y < downsampledBounds.getY() + downsampledBounds.getHeight()) {
                int x = (int)downsampledBounds.getX();
                while ((double)x < downsampledBounds.getX() + downsampledBounds.getWidth()) {
                    int index = y * this.targetWidth + x;
                    if (rotated == null || rotated.contains(new Point2D.Double(x, y)) && index > 0 && index < arrayLength) {
                        if (this.feature == ViewTrackerDataMaps.Feature.TIMESTAMP) {
                            this.longArray[index] = this.longArray[index] + timestampValue;
                        } else if (this.doubleArray[index] > downsampleValue || this.doubleArray[index] == 0.0) {
                            this.doubleArray[index] = downsampleValue;
                        }
                    }
                    ++x;
                }
                ++y;
            }
        }
    }

    private static Rectangle getDownsampledBounds(Rectangle bounds, double downsample) {
        int x = (int)Math.round(bounds.getX() / downsample);
        int y = (int)Math.round(bounds.getY() / downsample);
        int width = (int)Math.round(bounds.getWidth() / downsample);
        int height = (int)Math.round(bounds.getHeight() / downsample);
        return new Rectangle(x, y, width, height);
    }

    private static Rectangle getCroppedBounds(Rectangle bounds, int width, int height) {
        int newWidth;
        int y;
        int x;
        int n = bounds.x < 0 ? 0 : (x = bounds.x < width ? bounds.x : width);
        int n2 = bounds.y < 0 ? 0 : (y = bounds.y < height ? bounds.y : height);
        int n3 = bounds.width < 0 ? 0 : (newWidth = bounds.width + x > width ? width - x : bounds.width);
        int newHeight = bounds.height < 0 ? 0 : (bounds.height + y > height ? height - y : bounds.height);
        return new Rectangle(x, y, newWidth, newHeight);
    }

    Number getMaxValue() {
        if (this.feature == ViewTrackerDataMaps.Feature.TIMESTAMP) {
            return LongStream.of(this.longArray).max().getAsLong();
        }
        return DoubleStream.of(this.doubleArray).max().getAsDouble();
    }

    Number getCalculatedValue(int x, int y) {
        if (this.feature == ViewTrackerDataMaps.Feature.TIMESTAMP) {
            return this.longArray[(int)Math.floor((double)x / this.downsample) + this.targetWidth * (int)Math.floor((double)y / this.downsample)];
        }
        return this.doubleArray[(int)Math.floor((double)x / this.downsample) + this.targetWidth * (int)Math.floor((double)y / this.downsample)];
    }

    BufferedImage getBufferedImage(ColorMaps.ColorMap colorMap) {
        DataBufferFloat dataBuffer = new DataBufferFloat(this.feature == ViewTrackerDataMaps.Feature.TIMESTAMP ? this.longArray.length : this.doubleArray.length);
        for (int i = 0; i < dataBuffer.getSize(); ++i) {
            dataBuffer.setElemDouble(i, this.feature == ViewTrackerDataMaps.Feature.TIMESTAMP ? (double)this.longArray[i] : this.doubleArray[i]);
        }
        String colorMapName = colorMap.getName();
        Number maxValue = this.getMaxValue();
        ColorModels.ColorModelBuilder colorModelBuilder = ColorModels.createColorModelBuilder((ColorModels.DisplayBand)ColorModels.createBand((String)colorMapName, (int)0, (double)0.0, (double)(this.feature == ViewTrackerDataMaps.Feature.TIMESTAMP ? (double)maxValue.longValue() : maxValue.doubleValue())), (ColorModels.DisplayBand)ColorModels.createBand((String)colorMapName, (int)0, (double)0.0, (double)(this.feature == ViewTrackerDataMaps.Feature.TIMESTAMP ? (double)maxValue.longValue() : maxValue.doubleValue()), (double)0.8));
        ColorModel cm = colorModelBuilder.build();
        BandedSampleModel sampleModel = new BandedSampleModel(dataBuffer.getDataType(), this.targetWidth, this.targetHeight, 1);
        WritableRaster raster = Raster.createWritableRaster(sampleModel, dataBuffer, null);
        BufferedImage img = new BufferedImage(cm, raster, false, null);
        return img;
    }
}

