/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer.recording;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javafx.animation.Animation;
import javafx.animation.AnimationTimer;
import javafx.animation.FadeTransition;
import javafx.animation.SequentialTransition;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Separator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.utils.FXUtils;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.actions.ActionTools;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.tools.IconFactory;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.gui.viewer.recording.ViewTracker;
import qupath.lib.gui.viewer.recording.ViewTrackerAnalysisCommand;
import qupath.lib.gui.viewer.recording.ViewTrackerPlayback;
import qupath.lib.gui.viewer.recording.ViewTrackerTools;
import qupath.lib.images.ImageData;
import qupath.lib.projects.ProjectImageEntry;

public class ViewTrackerControlPane
implements Runnable {
    private static final BooleanProperty cursorTrackingProperty = PathPrefs.createPersistentPreference("trackCursorPosition", true);
    private static final BooleanProperty activeToolTrackingProperty = PathPrefs.createPersistentPreference("trackActiveTool", true);
    private static final String[] columnNames = new String[]{"Name", "Duration"};
    private static final Node iconRecord = IconFactory.createNode(16, 16, IconFactory.PathIcons.TRACKING_RECORD);
    private static final Node iconRecordStop = IconFactory.createNode(16, 16, IconFactory.PathIcons.TRACKING_STOP);
    private static final Node iconPlay = IconFactory.createNode(16, 16, IconFactory.PathIcons.PLAYBACK_PLAY);
    private static final Node iconPlayStop = IconFactory.createNode(16, 16, IconFactory.PathIcons.TRACKING_STOP);
    private static final Node iconRecording = IconFactory.createNode(16, 16, IconFactory.PathIcons.TRACKING_RECORD);
    private static final Logger logger = LoggerFactory.getLogger(ViewTrackerControlPane.class);
    private static Stage dialog = null;
    private QuPathGUI qupath;
    private QuPathViewer viewer;
    private final BooleanProperty recordingMode = new SimpleBooleanProperty(false);
    private ObservableList<ViewTracker> trackersList;
    private ViewTracker tracker;
    private final BooleanProperty isAnalysisOpened = new SimpleBooleanProperty(false);
    private final ChangeListener<ImageData<?>> imageDataListener;
    private final ChangeListener<QuPathViewer> viewerListener;
    private AnimationTimer recordingTime;
    private TableView<ViewTracker> table;
    private BorderPane mainPane;
    private TitledPane titledPane;
    private GridPane contentPane;
    private Label duration;
    private ViewTrackerPlayback playback;

    public ViewTrackerControlPane(QuPathGUI qupath) {
        this.qupath = qupath;
        this.viewer = qupath.getViewer();
        this.trackersList = FXCollections.observableArrayList(ViewTrackerControlPane.getExistingRecordings(qupath, this.viewer.getImageData()));
        this.imageDataListener = (v, o, n) -> {
            if (this.recordingMode.get()) {
                this.recordingMode.set(false);
            }
            this.trackersList.clear();
            if (n != null) {
                this.trackersList.setAll(ViewTrackerControlPane.getExistingRecordings(qupath, this.viewer.getImageData()));
            }
            this.table.setItems(this.trackersList);
            this.titledPane.disableProperty().bind((ObservableValue)this.viewer.imageDataProperty().isNull().or((ObservableBooleanValue)this.isAnalysisOpened));
        };
        this.viewerListener = (v, o, n) -> {
            if (this.recordingMode.get()) {
                this.recordingMode.set(false);
            }
            this.trackersList.clear();
            this.viewer.imageDataProperty().removeListener(this.imageDataListener);
            this.viewer = n;
            this.viewer.imageDataProperty().addListener(this.imageDataListener);
            if (n.getImageData() != null) {
                this.trackersList.setAll(ViewTrackerControlPane.getExistingRecordings(qupath, this.viewer.getImageData()));
            }
            this.table.setItems(this.trackersList);
            this.titledPane.disableProperty().bind((ObservableValue)Bindings.or((ObservableBooleanValue)this.viewer.imageDataProperty().isNull(), (ObservableBooleanValue)this.isAnalysisOpened));
        };
        this.viewer.imageDataProperty().addListener(this.imageDataListener);
        qupath.viewerProperty().addListener(this.viewerListener);
        this.prepareNewViewTracker(qupath);
        this.playback = new ViewTrackerPlayback(this.viewer);
        Action actionRecord = ActionTools.createSelectableAction((ObservableValue<Boolean>)this.recordingMode, "Start a new recording of the viewer", iconRecord, null);
        Action actionPlayback = ActionTools.createSelectableAction((ObservableValue<Boolean>)this.playback.playingProperty(), "Play the selected recording", iconPlay, null);
        this.recordingMode.addListener((v, o, n) -> {
            this.titledPane.setExpanded(n == false);
            if (n.booleanValue()) {
                actionRecord.setGraphic(iconRecordStop);
                actionRecord.setText("Stop recording");
                String newName = GeneralTools.generateDistinctName((String)"Recording", this.trackersList.stream().map(t -> t.getName()).toList());
                this.tracker.setName(newName);
                this.tracker.setRecording(true);
                this.startRecordingTimer();
            } else {
                actionRecord.setGraphic(iconRecord);
                actionRecord.setText("Start recording the viewer");
                this.tracker.setRecording(false);
                this.stopRecordingTimer();
                if (!this.tracker.isEmpty()) {
                    this.trackersList.add((Object)this.tracker);
                }
                this.table.getSelectionModel().clearSelection();
                this.table.scrollTo(this.table.getItems().size() - 1);
                this.table.getSelectionModel().selectLast();
                this.prepareNewViewTracker(qupath);
            }
        });
        BooleanProperty playing = this.playback.playingProperty();
        iconPlay.setStyle("-fx-text-fill: -fx-text-background-color;");
        actionPlayback.graphicProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> playing.get() ? iconPlayStop : iconPlay, (Observable[])new Observable[]{playing}));
        actionPlayback.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> playing.get() ? "Stop the playback" : "Play the selected recording", (Observable[])new Observable[]{playing}));
        this.mainPane = new BorderPane();
        this.mainPane.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.titledPane = new TitledPane();
        this.titledPane.managedProperty().bind((ObservableValue)this.titledPane.visibleProperty());
        this.titledPane.setAnimated(true);
        this.table = new TableView();
        this.table.setMaxHeight(200.0);
        this.table.setItems(this.trackersList);
        this.table.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.contentPane = new GridPane();
        this.contentPane.setVgap(5.0);
        Button exportBtn = new Button("Export");
        exportBtn.setOnAction(ev -> ViewTrackerTools.handleExport((ViewTracker)this.table.getSelectionModel().getSelectedItem()));
        exportBtn.setTooltip(new Tooltip("Export the selected recording as a tab-separated file (TSV)"));
        Button deleteBtn = new Button("Delete");
        deleteBtn.setTooltip(new Tooltip("Delete the selected recording from the project directory"));
        deleteBtn.setOnAction(e -> {
            ObservableList trackersToDelete = this.table.getSelectionModel().getSelectedItems();
            String deleteRecording = "Delete recording" + (trackersToDelete.size() > 1 ? "s" : "");
            boolean response = Dialogs.showConfirmDialog((String)deleteRecording, (String)(deleteRecording + "? The data will be lost."));
            if (!response) {
                return;
            }
            for (ViewTracker tracker : trackersToDelete) {
                try {
                    Files.delete(tracker.getFile().toPath());
                }
                catch (IOException ex) {
                    Dialogs.showErrorNotification((String)"Could not delete recording", (Throwable)ex);
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
            this.trackersList.removeAll((Collection)trackersToDelete);
        });
        Button btnMore = new Button("More");
        btnMore.setOnAction(e -> this.openViewTrackingAnalysisCommand());
        btnMore.setTooltip(new Tooltip("Open the recording analysis window for the selected recording"));
        GridPane btnPane = GridPaneUtils.createColumnGrid((int)3);
        exportBtn.setMaxWidth(Double.MAX_VALUE);
        deleteBtn.setMaxWidth(Double.MAX_VALUE);
        btnMore.setMaxWidth(Double.MAX_VALUE);
        btnPane.addRow(0, new Node[]{exportBtn, deleteBtn, btnMore});
        exportBtn.disableProperty().bind((ObservableValue)playing.or((ObservableBooleanValue)Bindings.or((ObservableBooleanValue)Bindings.equal((ObservableNumberValue)Bindings.size((ObservableList)this.table.getSelectionModel().getSelectedItems()), (int)1).not(), (ObservableBooleanValue)this.isAnalysisOpened)));
        deleteBtn.disableProperty().bind((ObservableValue)playing.or((ObservableBooleanValue)Bindings.or((ObservableBooleanValue)this.table.getSelectionModel().selectedItemProperty().isNull(), (ObservableBooleanValue)this.isAnalysisOpened)));
        btnMore.disableProperty().bind((ObservableValue)playing.or((ObservableBooleanValue)Bindings.or((ObservableBooleanValue)Bindings.equal((ObservableNumberValue)Bindings.size((ObservableList)this.table.getSelectionModel().getSelectedItems()), (int)1).not(), (ObservableBooleanValue)this.isAnalysisOpened)));
        actionPlayback.disabledProperty().bind((ObservableValue)Bindings.size((ObservableList)this.table.getSelectionModel().getSelectedItems()).isNotEqualTo(1).or((ObservableBooleanValue)this.recordingMode).or((ObservableBooleanValue)this.isAnalysisOpened));
        actionRecord.disabledProperty().bind((ObservableValue)playing.or((ObservableBooleanValue)this.isAnalysisOpened));
        int row = 0;
        GridPaneUtils.addGridRow((GridPane)this.contentPane, (int)row++, (int)0, null, (Node[])new Node[]{this.table});
        GridPaneUtils.addGridRow((GridPane)this.contentPane, (int)row++, (int)0, null, (Node[])new Node[]{btnPane});
        this.table.getSelectionModel().selectedItemProperty().addListener((v, o, tracker) -> {
            if (tracker != null) {
                this.playback.setViewTracker((ViewTracker)tracker);
            }
        });
        this.table.setOnDragOver(e -> {
            e.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
            e.consume();
        });
        this.table.setOnDragDropped(e -> {
            Dragboard dragboard = e.getDragboard();
            if (dragboard.hasFiles()) {
                logger.trace("Files dragged onto view tracking control dialog");
                try {
                    List<File> files = dragboard.getFiles().stream().filter(f -> f.isFile() && !f.isHidden()).toList();
                    files.removeIf(t -> {
                        for (ViewTracker element : this.table.getItems()) {
                            if (!element.getFile().getAbsolutePath().equals(t.getAbsolutePath())) continue;
                            return true;
                        }
                        return false;
                    });
                    for (File file : files) {
                        if (!((String)GeneralTools.getExtension((File)file).get()).equals(".tsv")) continue;
                        ViewTracker tracker = ViewTrackerTools.handleImport(file.toPath());
                        if (tracker == null) {
                            logger.warn("Unable to read view tracker: {}", (Object)file);
                            continue;
                        }
                        this.trackersList.add((Object)tracker);
                    }
                }
                catch (Exception ex) {
                    Dialogs.showErrorMessage((String)"Drag & Drop", (Throwable)ex);
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
            e.setDropCompleted(true);
            e.consume();
        });
        this.table.setRowFactory(e -> {
            TableRow recordingRow = new TableRow();
            ContextMenu menu = new ContextMenu();
            MenuItem renameItem = new MenuItem("Rename");
            MenuItem openDirectoryItem = new MenuItem("Open directory");
            menu.getItems().addAll((Object[])new MenuItem[]{renameItem, openDirectoryItem});
            renameItem.setOnAction(ev -> {
                String newName = Dialogs.showInputDialog((String)"Rename", (String)"New name", (String)(((ViewTracker)recordingRow.getItem()).getFile() == null ? "" : ((ViewTracker)recordingRow.getItem()).getFile().getName()));
                if ((newName = GeneralTools.generateDistinctName((String)newName, this.trackersList.stream().map(tracker -> tracker.getName()).toList())) == null || newName.isEmpty() || newName.equals(((ViewTracker)recordingRow.getItem()).getFile().getName())) {
                    return;
                }
                ((ViewTracker)recordingRow.getItem()).setName(newName);
            });
            openDirectoryItem.setOnAction(ev -> {
                File file = ((ViewTracker)recordingRow.getItem()).getFile();
                if (file != null) {
                    GuiTools.browseDirectory(file);
                } else {
                    Dialogs.showErrorMessage((String)"Cannot open directory", (String)"Recording was not locally saved!");
                }
            });
            recordingRow.contextMenuProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)recordingRow.emptyProperty()).then((Object)null).otherwise((Object)menu));
            recordingRow.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !recordingRow.isEmpty()) {
                    this.openViewTrackingAnalysisCommand();
                }
            });
            return recordingRow;
        });
        for (String columnName : columnNames) {
            TableColumn column = new TableColumn(columnName);
            column.prefWidthProperty().bind((ObservableValue)this.table.widthProperty().subtract(17).divide(columnNames.length));
            column.setCellValueFactory(item -> {
                ViewTracker currentTracker = (ViewTracker)item.getValue();
                if (currentTracker == null) {
                    return null;
                }
                if (columnName.equals("Name")) {
                    File file = currentTracker.getFile();
                    if (file != null) {
                        return currentTracker.nameProperty();
                    }
                    return new SimpleObjectProperty((Object)("*" + String.valueOf(currentTracker.nameProperty())));
                }
                if (columnName.equals("Duration")) {
                    return new SimpleObjectProperty((Object)ViewTrackerTools.getPrettyTimestamp(currentTracker.getStartTime(), currentTracker.getLastTime()));
                }
                return null;
            });
            this.table.getColumns().add((Object)column);
        }
        CheckMenuItem miTrackCursor = new CheckMenuItem("Track cursor");
        CheckMenuItem miTrackActiveTool = new CheckMenuItem("Track active tool");
        miTrackCursor.selectedProperty().addListener((v, o, n) -> cursorTrackingProperty.set(n.booleanValue()));
        miTrackActiveTool.selectedProperty().addListener((v, o, n) -> activeToolTrackingProperty.set(n.booleanValue()));
        miTrackCursor.setSelected(cursorTrackingProperty.get());
        miTrackActiveTool.setSelected(activeToolTrackingProperty.get());
        ContextMenu menu = new ContextMenu(new MenuItem[]{miTrackCursor, miTrackActiveTool});
        Button optionBtn = GuiTools.createMoreButton(menu, Side.RIGHT);
        ToggleButton toggleRecord = ActionUtils.createToggleButton((Action)actionRecord, (ActionUtils.ActionTextBehavior)ActionUtils.ActionTextBehavior.HIDE);
        ToggleButton togglePlayback = ActionUtils.createToggleButton((Action)actionPlayback, (ActionUtils.ActionTextBehavior)ActionUtils.ActionTextBehavior.HIDE);
        this.duration = new Label("");
        this.duration.setVisible(false);
        this.duration.setMinWidth(50.0);
        Separator separator = new Separator(Orientation.VERTICAL);
        this.duration.visibleProperty().bind((ObservableValue)this.recordingMode);
        separator.visibleProperty().bind((ObservableValue)this.recordingMode);
        iconRecording.visibleProperty().bind((ObservableValue)this.recordingMode);
        Tooltip.install((Node)iconRecording, (Tooltip)new Tooltip("Recording"));
        FadeTransition fadeOut = new FadeTransition(Duration.seconds((double)1.0), iconRecording);
        fadeOut.setFromValue(1.0);
        fadeOut.setToValue(0.5);
        FadeTransition fadeIn = new FadeTransition(Duration.seconds((double)1.0), iconRecording);
        fadeIn.setFromValue(0.5);
        fadeIn.setToValue(1.0);
        SequentialTransition pulse = new SequentialTransition(iconRecording, new Animation[]{fadeOut, fadeIn});
        pulse.setCycleCount(-1);
        this.recordingMode.addListener((v, o, n) -> {
            if (n.booleanValue()) {
                pulse.playFromStart();
            } else {
                pulse.stop();
            }
        });
        optionBtn.disableProperty().bind((ObservableValue)Bindings.or((ObservableBooleanValue)this.recordingMode, (ObservableBooleanValue)this.isAnalysisOpened));
        this.table.disableProperty().bind((ObservableValue)this.isAnalysisOpened);
        GridPane topButtonGrid = new GridPane();
        topButtonGrid.setHgap(10.0);
        topButtonGrid.addRow(0, new Node[]{toggleRecord, togglePlayback, separator, iconRecording, this.duration, optionBtn});
        this.titledPane.setContent((Node)this.contentPane);
        this.titledPane.setGraphic((Node)topButtonGrid);
        this.titledPane.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.titledPane.setOnMouseClicked(mouseEvent -> this.titledPane.setExpanded(this.recordingMode.getValue() == false));
        this.titledPane.setPrefWidth(250.0);
        this.mainPane.setTop((Node)this.titledPane);
        this.mainPane.setMaxSize(250.0, 300.0);
    }

    @Override
    public void run() {
        if (dialog != null) {
            dialog.requestFocus();
        } else {
            dialog = new Stage();
            FXUtils.addCloseWindowShortcuts((Stage)dialog);
            dialog.sizeToScene();
            dialog.initOwner((Window)this.qupath.getStage());
            dialog.setTitle("Tracking");
            BorderPane pane = new BorderPane((Node)this.mainPane);
            dialog.setScene(new Scene((Parent)pane));
            this.titledPane.heightProperty().addListener((v, o, n) -> dialog.sizeToScene());
            dialog.setResizable(false);
            dialog.setOnCloseRequest(e -> {
                boolean response;
                boolean response2;
                if (this.recordingMode.get() && !(response2 = Dialogs.showYesNoDialog((String)"Shut down recording", (String)("The current recording will be stopped." + System.lineSeparator() + "Continue?")))) {
                    e.consume();
                    return;
                }
                List<ViewTracker> unsaved = this.trackersList.stream().filter(tracker -> tracker.getFile() == null).toList();
                if (!unsaved.isEmpty() && !(response = Dialogs.showYesNoDialog((String)"Save recordings", (String)("You will lose your unsaved recordings." + System.lineSeparator() + "Continue?")))) {
                    e.consume();
                    return;
                }
                dialog = null;
            });
            dialog.setOnHidden(e -> {
                this.forceStopRecording();
                this.removeListeners();
            });
            dialog.show();
            this.titledPane.lookup(".arrow").setVisible(false);
        }
    }

    private void prepareNewViewTracker(QuPathGUI qupath) {
        if (this.tracker != null) {
            this.tracker.cursorTrackingProperty().unbind();
            this.tracker.activeToolProperty().unbind();
        }
        this.tracker = new ViewTracker(qupath);
        this.tracker.cursorTrackingProperty().bind((ObservableValue)cursorTrackingProperty);
        this.tracker.activeToolProperty().bind((ObservableValue)activeToolTrackingProperty);
    }

    private void startRecordingTimer() {
        this.recordingTime = new AnimationTimer(){

            public void handle(long now) {
                String timeElapsed = ViewTrackerTools.getPrettyTimestamp(ViewTrackerControlPane.this.tracker.getStartTime(), System.currentTimeMillis());
                ViewTrackerControlPane.this.duration.setText(timeElapsed);
            }
        };
        this.recordingTime.start();
    }

    private void stopRecordingTimer() {
        this.recordingTime.stop();
    }

    private void openViewTrackingAnalysisCommand() {
        ViewTrackerAnalysisCommand activeTracker = new ViewTrackerAnalysisCommand(this.qupath, (ViewTracker)this.table.getSelectionModel().getSelectedItem());
        this.isAnalysisOpened.bind((ObservableValue)activeTracker.isOpenedProperty());
        activeTracker.run();
    }

    private static List<ViewTracker> getExistingRecordings(QuPathGUI qupath, ImageData<BufferedImage> imageData) {
        ArrayList<ViewTracker> out = new ArrayList<ViewTracker>();
        ProjectImageEntry entry = qupath.getProject().getEntry(imageData);
        if (entry == null) {
            return out;
        }
        File entryDirectory = entry.getEntryPath().toFile();
        if (entryDirectory != null && entryDirectory.exists()) {
            return ViewTrackerControlPane.getRecordingsFromDirectory(entryDirectory);
        }
        return out;
    }

    private static List<ViewTracker> getRecordingsFromDirectory(File entryDirectory) {
        File recordingDirectory = new File(entryDirectory, "recordings");
        ArrayList<ViewTracker> trackers = new ArrayList<ViewTracker>();
        if (recordingDirectory.exists()) {
            try (Stream<Path> walk = Files.walk(recordingDirectory.toPath(), new FileVisitOption[0]);){
                trackers.addAll(walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> GeneralTools.getExtension((File)path.toFile()).orElse("").equals(".tsv")).map(path -> ViewTrackerTools.handleImport(path)).filter(t -> t != null).toList());
            }
            catch (IOException ex) {
                logger.error("Could not fetch existing recordings: " + ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
        return trackers;
    }

    void forceStopRecording() {
        this.recordingMode.set(false);
    }

    Node getNode() {
        return this.mainPane;
    }

    void removeListeners() {
        this.viewer.imageDataProperty().removeListener(this.imageDataListener);
        this.qupath.viewerProperty().removeListener(this.viewerListener);
    }
}

