/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer.recording;

import java.awt.image.BufferedImage;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Separator;
import javafx.scene.control.Slider;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javafx.util.converter.DateTimeStringConverter;
import org.controlsfx.control.RangeSlider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.utils.FXUtils;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.color.ColorMaps;
import qupath.lib.common.GeneralTools;
import qupath.lib.common.ThreadTools;
import qupath.lib.gui.ColorMapCanvas;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.tools.IconFactory;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.gui.viewer.overlays.AbstractOverlay;
import qupath.lib.gui.viewer.overlays.BufferedImageOverlay;
import qupath.lib.gui.viewer.overlays.PathOverlay;
import qupath.lib.gui.viewer.recording.ViewRecordingFrame;
import qupath.lib.gui.viewer.recording.ViewTracker;
import qupath.lib.gui.viewer.recording.ViewTrackerDataMaps;
import qupath.lib.gui.viewer.recording.ViewTrackerPlayback;
import qupath.lib.gui.viewer.recording.ViewTrackerSlideOverview;
import qupath.lib.gui.viewer.recording.ViewTrackerTools;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.plugins.parameters.ParameterList;

final class ViewTrackerAnalysisCommand
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ViewTrackerAnalysisCommand.class);
    private final QuPathGUI qupath;
    private final QuPathViewer viewer;
    private final ViewTracker tracker;
    private final ImageServer<?> server;
    private ObjectProperty<ViewRecordingFrame> currentFrame = new SimpleObjectProperty();
    private BooleanProperty isOpenedProperty = new SimpleBooleanProperty(true);
    private Stage dialog;
    private SplitPane mainPane;
    private TableView<ViewRecordingFrame> table = new TableView();
    private ViewTrackerPlayback playback;
    private Slider zSlider;
    private Slider tSlider;
    private Slider timeSlider;
    private ProgressIndicator progressIndicator;
    private ObservableList<ColorMaps.ColorMap> colorMaps;
    private ColorMapCanvas colorMapCanvas;
    private CheckBox visualizationCheckBox;
    private RangeSlider downsampleSlider;
    private RangeSlider timeDisplayedSlider;
    private static final Node iconPlay = IconFactory.createNode(16, 16, IconFactory.PathIcons.PLAYBACK_PLAY);
    private static final Node iconStop = IconFactory.createNode(16, 16, IconFactory.PathIcons.TRACKING_STOP);
    private static final Node iconRewind = IconFactory.createNode(16, 16, IconFactory.PathIcons.TRACKING_REWIND);
    private ViewTrackerSlideOverview slideOverview;
    private ViewTrackerDataMaps dataMaps;
    private double initialWidth = -1.0;
    private double initialHeight = -1.0;
    private final ExecutorService executor = Executors.newSingleThreadExecutor(ThreadTools.createThreadFactory((String)"data-overlay", (boolean)true));

    ViewTrackerAnalysisCommand(QuPathGUI qupath, ViewTracker tracker) {
        this.qupath = qupath;
        this.tracker = tracker;
        this.viewer = qupath.getViewer();
        this.server = this.viewer.getServer();
        this.slideOverview = new ViewTrackerSlideOverview(this.viewer);
        this.playback = new ViewTrackerPlayback(this.viewer);
        this.playback.setViewTracker(tracker);
    }

    @Override
    public void run() {
        if (this.dialog == null) {
            this.dialog = new Stage();
            FXUtils.addCloseWindowShortcuts((Stage)this.dialog);
            this.dialog.sizeToScene();
            this.dialog.initOwner((Window)this.qupath.getStage());
            this.dialog.setTitle("Recording analysis");
            this.currentFrame.set((Object)this.tracker.getFrame(0));
            int nCols = ViewTrackerAnalysisCommand.nCols(this.tracker);
            int i = 0;
            while (i < nCols) {
                int col = i++;
                final String columnName = ViewTrackerAnalysisCommand.getColumnName(this.tracker, col);
                TableColumn column = new TableColumn(columnName);
                column.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ViewRecordingFrame, Object>, ObservableValue<Object>>(this){

                    public ObservableValue<Object> call(TableColumn.CellDataFeatures<ViewRecordingFrame, Object> frame) {
                        return new SimpleObjectProperty(ViewTrackerAnalysisCommand.getColumnValue((ViewRecordingFrame)frame.getValue(), columnName));
                    }
                });
                this.table.getColumns().add((Object)column);
            }
            this.table.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
            this.table.getSelectionModel().selectedItemProperty().addListener((v, o, frame) -> {
                if (frame != null) {
                    this.currentFrame.set(frame);
                }
            });
            this.refreshTracker();
            this.playback.getCurrentFrame().addListener((v, o, frame) -> this.currentFrame.set(frame));
            this.currentFrame.addListener((v, o, frame) -> {
                if (frame == null) {
                    return;
                }
                ViewTrackerPlayback.setViewerForFrame(this.viewer, frame);
                this.slideOverview.setVisibleShape((ViewRecordingFrame)frame);
                this.zSlider.setValue((double)frame.getZ());
                this.tSlider.setValue((double)frame.getT());
                this.slideOverview.paintCanvas(o.getZ() != frame.getZ() || o.getT() != frame.getT(), false);
            });
            this.mainPane = new SplitPane();
            this.mainPane.setDividerPositions(new double[]{1.0});
            BorderPane tablePane = new BorderPane();
            tablePane.setCenter(this.table);
            int z = this.server.getMetadata().getSizeZ();
            int t = this.server.getMetadata().getSizeT();
            this.tSlider = new Slider(0.0, (double)(t - 1), 0.0);
            this.tSlider.setBlockIncrement(1.0);
            this.tSlider.setValue((double)this.viewer.getTPosition());
            this.tSlider.valueProperty().addListener((v, o, n) -> {
                this.tSlider.setValue((double)n.intValue());
                this.viewer.setTPosition(n.intValue());
                this.slideOverview.paintCanvas();
            });
            this.zSlider = new Slider(0.0, (double)(z - 1), 0.0);
            this.zSlider.setBlockIncrement(1.0);
            this.zSlider.setMinorTickCount(0);
            this.zSlider.setMajorTickUnit(1.0);
            this.zSlider.setShowTickMarks(true);
            this.zSlider.setValue((double)this.viewer.getZPosition());
            this.zSlider.valueProperty().addListener((v, o, n) -> {
                this.zSlider.setValue((double)n.intValue());
                this.viewer.setZPosition(n.intValue());
                this.slideOverview.paintCanvas();
            });
            this.zSlider.setOrientation(Orientation.VERTICAL);
            long timeSliderLength = this.tracker.getLastTime() - this.tracker.getStartTime();
            this.timeSlider = new Slider(0.0, (double)timeSliderLength, 0.0);
            this.timeSlider.setMinWidth(250.0);
            if (timeSliderLength > 0L) {
                this.timeSlider.setMajorTickUnit((double)(timeSliderLength / 4L));
                this.timeSlider.setMinorTickCount(0);
                this.timeSlider.setShowTickMarks(true);
            }
            this.timeSlider.valueProperty().addListener((v, o, n) -> {
                ViewRecordingFrame frame = this.tracker.getFrameForTime(n.longValue());
                this.currentFrame.set((Object)frame);
                if (this.table.getSelectionModel().getSelectedItem() != frame) {
                    this.table.getSelectionModel().select((Object)frame);
                }
            });
            this.timeSlider.setOnMouseClicked(e -> this.playback.doStopPlayback());
            long startTime = this.tracker.getStartTime();
            long endTime = this.tracker.getLastTime();
            Label timepointLabel = new Label();
            timepointLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> "t=" + GeneralTools.formatNumber((double)this.tSlider.getValue(), (int)2), (Observable[])new Observable[]{this.tSlider.valueProperty()}));
            Label zSliceLabel = new Label();
            zSliceLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> "z=" + GeneralTools.formatNumber((double)this.zSlider.getValue(), (int)2), (Observable[])new Observable[]{this.zSlider.valueProperty()}));
            Label timeLabelLeft = new Label();
            timeLabelLeft.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> ViewTrackerTools.getPrettyTimestamp(startTime, (long)this.timeSlider.getValue() + startTime), (Observable[])new Observable[]{this.timeSlider.valueProperty()}));
            Label timeLabelRight = new Label();
            timeLabelRight.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> "-" + ViewTrackerTools.getPrettyTimestamp((long)this.timeSlider.getValue() + startTime, endTime), (Observable[])new Observable[]{this.timeSlider.valueProperty()}));
            if (t == 1) {
                this.tSlider.setVisible(false);
                timepointLabel.setVisible(false);
            }
            if (z == 1) {
                this.zSlider.setVisible(false);
                zSliceLabel.setVisible(false);
            }
            Button btnPlay = new Button();
            btnPlay.setGraphic(iconPlay);
            btnPlay.setOnAction(e -> {
                if (!this.playback.isPlaying()) {
                    this.playback.setFirstFrame((ViewRecordingFrame)this.currentFrame.get());
                    this.slideOverview.paintCanvas();
                    this.playback.doStartPlayback();
                    this.timeSlider.valueProperty().bind((ObservableValue)this.playback.playbackTimeProperty());
                } else {
                    this.timeSlider.valueProperty().unbind();
                    this.playback.doStopPlayback();
                }
            });
            Button btnRewind = new Button();
            btnRewind.setGraphic(iconRewind);
            btnRewind.setOnAction(e -> {
                boolean isPlaying = this.playback.isPlaying();
                this.playback.doStopPlayback();
                this.timeSlider.valueProperty().unbind();
                this.timeSlider.setValue((double)this.tracker.getFrame(0).getTimestamp());
                if (isPlaying) {
                    this.playback.doStartPlayback();
                    this.timeSlider.valueProperty().bind((ObservableValue)this.playback.playbackTimeProperty());
                }
            });
            btnPlay.disableProperty().bind((ObservableValue)new SimpleBooleanProperty(this.tracker.nFrames() <= 1));
            btnRewind.disableProperty().bind((ObservableValue)new SimpleBooleanProperty(this.tracker.nFrames() <= 1));
            this.playback.playingProperty().addListener((v, o, n) -> {
                if (n.booleanValue()) {
                    btnPlay.setGraphic(iconStop);
                    this.zSlider.setDisable(true);
                    this.tSlider.setDisable(true);
                } else {
                    btnPlay.setGraphic(iconPlay);
                    this.zSlider.setDisable(false);
                    this.tSlider.setDisable(false);
                }
            });
            this.visualizationCheckBox = new CheckBox("Enable data overlay");
            this.progressIndicator = new ProgressIndicator();
            this.progressIndicator.setPrefSize(15.0, 15.0);
            this.colorMaps = FXCollections.observableArrayList(ColorMaps.getColorMaps().values());
            ComboBox colorMapCombo = new ComboBox(this.colorMaps);
            colorMapCombo.setMinWidth(350.0);
            this.colorMapCanvas = new ColorMapCanvas(10.0, (ColorMaps.ColorMap)this.colorMaps.get(0));
            colorMapCombo.getSelectionModel().selectedItemProperty().addListener((v, o, n) -> this.colorMapCanvas.setColorMap((ColorMaps.ColorMap)n));
            if (colorMapCombo.getSelectionModel().isEmpty() && !colorMapCombo.getItems().isEmpty()) {
                colorMapCombo.getSelectionModel().selectFirst();
            }
            colorMapCombo.setTooltip(new Tooltip("Select color map"));
            Label timeDisplayedLeftLabel = new Label();
            Label timeDisplayedRightLabel = new Label();
            this.timeDisplayedSlider = new RangeSlider(0.0, (double)timeSliderLength, 0.0, (double)timeSliderLength);
            this.timeDisplayedSlider.setMinWidth(250.0);
            timeDisplayedLeftLabel.setOnMouseClicked(e -> {
                if (e.getButton().equals((Object)MouseButton.PRIMARY) && e.getClickCount() == 2) {
                    GridPane gp = new GridPane();
                    TextField tf = new TextField();
                    SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
                    try {
                        tf.setTextFormatter(new TextFormatter((StringConverter)new DateTimeStringConverter((DateFormat)format), (Object)format.parse("00:00:00")));
                    }
                    catch (ParseException ex) {
                        logger.error("Error parsing the input time", (Throwable)ex);
                    }
                    gp.addRow(0, new Node[]{new Label("Enter time"), tf});
                    boolean response = Dialogs.showConfirmDialog((String)"Set min time", (Node)gp);
                    if (response) {
                        long time = TimeUnit.HOURS.toMillis(Integer.parseInt(tf.getText(0, 2))) + TimeUnit.MINUTES.toMillis(Integer.parseInt(tf.getText(3, 5))) + TimeUnit.SECONDS.toMillis(Integer.parseInt(tf.getText(6, 8)));
                        this.timeDisplayedSlider.setLowValue((double)time);
                        this.updateOverlays();
                    }
                }
            });
            timeDisplayedRightLabel.setOnMouseClicked(e -> {
                if (e.getButton().equals((Object)MouseButton.PRIMARY) && e.getClickCount() == 2) {
                    GridPane gp = new GridPane();
                    TextField tf = new TextField();
                    SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
                    try {
                        tf.setTextFormatter(new TextFormatter((StringConverter)new DateTimeStringConverter((DateFormat)format), (Object)format.parse(ViewTrackerTools.getPrettyTimestamp((long)this.timeDisplayedSlider.getHighValue()))));
                    }
                    catch (ParseException ex) {
                        logger.error("Error parsing the input time", (Throwable)ex);
                    }
                    gp.addRow(0, new Node[]{new Label("Enter time"), tf});
                    boolean response = Dialogs.showConfirmDialog((String)"Set max time", (Node)gp);
                    if (response) {
                        long time = ViewTrackerTools.getTimestampFromPrettyString(tf.getText());
                        this.timeDisplayedSlider.setHighValue((double)time);
                        this.updateOverlays();
                    }
                }
            });
            timeDisplayedLeftLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> ViewTrackerTools.getPrettyTimestamp(startTime, (long)this.timeDisplayedSlider.getLowValue() + startTime), (Observable[])new Observable[]{this.timeDisplayedSlider.lowValueProperty()}));
            timeDisplayedRightLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> ViewTrackerTools.getPrettyTimestamp(startTime, (long)this.timeDisplayedSlider.getHighValue() + startTime), (Observable[])new Observable[]{this.timeDisplayedSlider.highValueProperty()}));
            List<Double> allFramesDownsamples = this.tracker.getAllFrames().stream().map(e -> e.getDownsampleFactor()).toList();
            Double minDownsample = (Double)allFramesDownsamples.stream().min(Comparator.naturalOrder()).get();
            Double maxDownsample = (Double)allFramesDownsamples.stream().max(Comparator.naturalOrder()).get();
            this.downsampleSlider = new RangeSlider(minDownsample.doubleValue(), maxDownsample.doubleValue(), minDownsample.doubleValue(), maxDownsample.doubleValue());
            Label downsampleLeftLabel = new Label();
            Label downsampleRightLabel = new Label();
            downsampleLeftLabel.setOnMouseClicked(e -> {
                if (e.getButton().equals((Object)MouseButton.PRIMARY) && e.getClickCount() == 2) {
                    ParameterList params = new ParameterList();
                    params.addDoubleParameter("downsampleFilterLow", "Enter downsample", this.downsampleSlider.getLowValue());
                    if (!GuiTools.showParameterDialog("Set min downsample", params)) {
                        return;
                    }
                    double downFactor = params.getDoubleParameterValue("downsampleFilterLow");
                    this.downsampleSlider.setLowValue(downFactor);
                    this.updateOverlays();
                }
            });
            downsampleRightLabel.setOnMouseClicked(e -> {
                if (e.getButton().equals((Object)MouseButton.PRIMARY) && e.getClickCount() == 2) {
                    ParameterList params = new ParameterList();
                    params.addDoubleParameter("downsampleFilterHigh", "Enter downsample", this.downsampleSlider.getHighValue());
                    if (!GuiTools.showParameterDialog("Set max downsample", params)) {
                        return;
                    }
                    double downFactor = params.getDoubleParameterValue("downsampleFilterHigh");
                    this.downsampleSlider.setHighValue(downFactor);
                    this.updateOverlays();
                }
            });
            downsampleLeftLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> GeneralTools.formatNumber((double)this.downsampleSlider.getLowValue(), (int)2), (Observable[])new Observable[]{this.downsampleSlider.lowValueProperty()}));
            downsampleRightLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> GeneralTools.formatNumber((double)this.downsampleSlider.getHighValue(), (int)2), (Observable[])new Observable[]{this.downsampleSlider.highValueProperty()}));
            this.dataMaps = new ViewTrackerDataMaps(this.server, this.tracker);
            this.timeDisplayedSlider.setOnMouseReleased(v -> this.updateOverlays());
            this.downsampleSlider.setOnMouseReleased(v -> this.updateOverlays());
            this.colorMapCanvas.colorMapProperty().addListener((v, o, n) -> this.updateOverlays());
            this.progressIndicator.visibleProperty().bind((ObservableValue)this.dataMaps.generatingOverlayProperty());
            this.visualizationCheckBox.selectedProperty().addListener((v, o, n) -> {
                if (n.booleanValue()) {
                    this.updateOverlays();
                } else {
                    this.viewer.getCustomOverlayLayers().clear();
                    this.slideOverview.setOverlay(null);
                }
            });
            GridPane mainLeftPane = new GridPane();
            GridPane slideOverviewPane = new GridPane();
            GridPane dataVisualizationPane = new GridPane();
            mainLeftPane.setPadding(new Insets(5.0, 5.0, 5.0, 15.0));
            slideOverviewPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
            dataVisualizationPane.setPadding(new Insets(5.0, 5.0, 15.0, 5.0));
            mainLeftPane.addRow(0, new Node[]{slideOverviewPane});
            mainLeftPane.addRow(1, new Node[]{dataVisualizationPane});
            GridPane canvasPane = new GridPane();
            GridPane timelinePane = new GridPane();
            GridPane playbackPane = new GridPane();
            GridPane rangeSlidersPane = new GridPane();
            GridPane downsamplePane = new GridPane();
            Separator sep = new Separator();
            slideOverviewPane.setHgap(10.0);
            slideOverviewPane.setVgap(10.0);
            dataVisualizationPane.setHgap(10.0);
            dataVisualizationPane.setVgap(10.0);
            playbackPane.setHgap(10.0);
            rangeSlidersPane.setHgap(10.0);
            rangeSlidersPane.setVgap(10.0);
            downsamplePane.setHgap(10.0);
            if (this.zSlider.isVisible()) {
                canvasPane.addRow(0, new Node[]{new HBox(), timepointLabel, this.tSlider});
                canvasPane.addRow(1, new Node[]{zSliceLabel, this.zSlider, this.slideOverview.getCanvas()});
                this.zSlider.setTooltip(new Tooltip("Slide to change the visible z-slice"));
            } else {
                canvasPane.addRow(0, new Node[]{timepointLabel, this.tSlider, new HBox()});
                canvasPane.addRow(1, new Node[]{new HBox(), this.slideOverview.getCanvas()});
            }
            if (this.tSlider.isVisible()) {
                this.tSlider.setTooltip(new Tooltip("Slide to change the visible timepoint"));
            }
            timelinePane.addRow(0, new Node[]{timeLabelLeft, this.timeSlider, timeLabelRight});
            playbackPane.addRow(0, new Node[]{btnPlay, btnRewind});
            timelinePane.setAlignment(Pos.CENTER);
            playbackPane.setAlignment(Pos.CENTER);
            canvasPane.setAlignment(Pos.CENTER);
            btnPlay.setTooltip(new Tooltip("Play the recording"));
            btnRewind.setTooltip(new Tooltip("Rewind the recording"));
            int row = 0;
            GridPaneUtils.addGridRow((GridPane)slideOverviewPane, (int)row++, (int)0, null, (Node[])new Node[]{new HBox(), canvasPane});
            GridPaneUtils.addGridRow((GridPane)slideOverviewPane, (int)row++, (int)0, null, (Node[])new Node[]{timeLabelLeft, this.timeSlider, timeLabelRight});
            GridPaneUtils.addGridRow((GridPane)slideOverviewPane, (int)row++, (int)0, (String)"Playback options", (Node[])new Node[]{new HBox(), playbackPane});
            GridPaneUtils.addGridRow((GridPane)slideOverviewPane, (int)row++, (int)0, null, (Node[])new Node[]{sep, sep, sep, sep});
            row = 0;
            GridPaneUtils.addGridRow((GridPane)dataVisualizationPane, (int)row++, (int)0, (String)"Show the amount of time spent in each region of the image", (Node[])new Node[]{this.visualizationCheckBox, this.progressIndicator});
            GridPaneUtils.addGridRow((GridPane)dataVisualizationPane, (int)row++, (int)0, (String)"The data will only take into account the values recorded in-between this range", (Node[])new Node[]{new Label("Time range"), timeDisplayedLeftLabel, this.timeDisplayedSlider, timeDisplayedRightLabel});
            GridPaneUtils.addGridRow((GridPane)dataVisualizationPane, (int)row++, (int)0, (String)"The data will only take into account the values recorded in-between this range", (Node[])new Node[]{new Label("Downsample range"), downsampleLeftLabel, this.downsampleSlider, downsampleRightLabel});
            GridPaneUtils.addGridRow((GridPane)dataVisualizationPane, (int)row++, (int)0, (String)"Color map", (Node[])new Node[]{new Label("Color map"), colorMapCombo, colorMapCombo, colorMapCombo});
            GridPaneUtils.addGridRow((GridPane)dataVisualizationPane, (int)row++, (int)0, null, (Node[])new Node[]{this.colorMapCanvas, this.colorMapCanvas, this.colorMapCanvas, this.colorMapCanvas});
            for (Node child : dataVisualizationPane.getChildren()) {
                if (child == this.visualizationCheckBox) continue;
                if (child == this.downsampleSlider) {
                    child.disableProperty().bind((ObservableValue)this.visualizationCheckBox.selectedProperty().not().or((ObservableBooleanValue)new SimpleBooleanProperty(minDownsample == maxDownsample)));
                    continue;
                }
                child.disableProperty().bind((ObservableValue)this.visualizationCheckBox.selectedProperty().not());
            }
            ColumnConstraints col1 = new ColumnConstraints();
            ColumnConstraints col2 = new ColumnConstraints();
            ColumnConstraints col3 = new ColumnConstraints();
            ColumnConstraints col4 = new ColumnConstraints();
            col2.setHgrow(Priority.ALWAYS);
            slideOverviewPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{col1, col2, col3, col4});
            Button btnExpand = new Button("Show frames");
            Button btnOpen = new Button("Open directory");
            btnOpen.setDisable(this.tracker.getFile() == null);
            ArrayList<Button> buttons = new ArrayList<Button>();
            btnOpen.setOnAction(e -> GuiTools.browseDirectory(this.tracker.getFile()));
            btnExpand.setOnAction(e -> {
                if (btnExpand.getText().equals("Show frames")) {
                    this.dialog.setWidth(this.initialWidth + 700.0);
                    this.dialog.setResizable(true);
                    this.dialog.setMinWidth(this.initialWidth + 50.0);
                    this.dialog.setMinHeight(this.initialHeight);
                    mainLeftPane.setMinWidth(this.initialWidth);
                    mainLeftPane.setMaxWidth(this.initialWidth);
                    this.mainPane.getItems().add((Object)tablePane);
                    this.mainPane.setDividerPositions(new double[]{0.0});
                    btnExpand.setText("Hide frames");
                } else {
                    this.mainPane.getItems().remove((Object)tablePane);
                    btnExpand.setText("Show frames");
                    this.dialog.setWidth(this.initialWidth + 30.0);
                    this.dialog.setHeight(this.initialHeight);
                    this.dialog.setResizable(false);
                }
            });
            buttons.add(btnOpen);
            buttons.add(btnExpand);
            GridPane panelButtons = GridPaneUtils.createColumnGridControls((Node[])((Node[])buttons.toArray(new ButtonBase[0])));
            GridPaneUtils.addGridRow((GridPane)mainLeftPane, (int)row++, (int)0, null, (Node[])new Node[]{panelButtons, panelButtons, panelButtons});
            this.mainPane.getItems().add((Object)mainLeftPane);
            this.dialog.setScene(new Scene((Parent)this.mainPane));
        }
        this.viewer.imageDataProperty().addListener((v, o, n) -> this.dialog.hide());
        this.dialog.setOnHiding(e -> {
            this.viewer.getCustomOverlayLayers().clear();
            this.playback.doStopPlayback();
            this.isOpenedProperty.set(false);
        });
        this.dialog.setResizable(false);
        this.dialog.show();
        this.initialWidth = this.dialog.getWidth();
        this.initialHeight = this.dialog.getHeight();
    }

    private static Object getColumnValue(ViewRecordingFrame frame, String columnName) {
        switch (columnName) {
            case "Timestamp (ms)": {
                return frame.getTimestamp();
            }
            case "X": {
                return frame.getImageBounds().x;
            }
            case "Y": {
                return frame.getImageBounds().y;
            }
            case "Width": {
                return frame.getImageBounds().width;
            }
            case "Height": {
                return frame.getImageBounds().height;
            }
            case "Canvas width": {
                return frame.getSize().width;
            }
            case "Canvas height": {
                return frame.getSize().height;
            }
            case "Downsample factor": {
                return frame.getDownsampleFactor();
            }
            case "Rotation": {
                return frame.getRotation();
            }
            case "Cursor X": {
                return frame.getCursorPosition() == null ? "" : Double.valueOf(frame.getCursorPosition().getX());
            }
            case "Cursor Y": {
                return frame.getCursorPosition() == null ? "" : Double.valueOf(frame.getCursorPosition().getY());
            }
            case "Active Tool": {
                return frame.getActiveTool() == null ? "Other" : frame.getActiveTool().getName();
            }
            case "Eye X": {
                return frame.getEyePosition().getX();
            }
            case "Eye Y": {
                return frame.getEyePosition().getY();
            }
            case "Fixated": {
                return frame.isEyeFixated();
            }
            case "Z": {
                return frame.getZ();
            }
            case "T": {
                return frame.getT();
            }
        }
        return null;
    }

    private static String getColumnName(ViewTracker tracker, int col) {
        switch (col) {
            case 0: {
                return "Timestamp (ms)";
            }
            case 1: {
                return "X";
            }
            case 2: {
                return "Y";
            }
            case 3: {
                return "Width";
            }
            case 4: {
                return "Height";
            }
            case 5: {
                return "Canvas width";
            }
            case 6: {
                return "Canvas height";
            }
            case 7: {
                return "Downsample factor";
            }
            case 8: {
                return "Rotation";
            }
            case 9: {
                if (tracker.hasCursorTrackingData()) {
                    return "Cursor X";
                }
                if (tracker.hasActiveToolTrackingData()) {
                    return "Active Tool";
                }
                if (tracker.hasEyeTrackingData()) {
                    return "Eye X";
                }
                return "Z";
            }
            case 10: {
                if (tracker.hasCursorTrackingData()) {
                    return "Cursor Y";
                }
                if (tracker.hasEyeTrackingData()) {
                    return "Eye Y";
                }
                return "T";
            }
            case 11: {
                if (tracker.hasActiveToolTrackingData()) {
                    return "Active Tool";
                }
                if (tracker.hasEyeTrackingData()) {
                    return "Eye X";
                }
            }
            case 12: {
                if (tracker.hasEyeTrackingData()) {
                    if (tracker.hasActiveToolTrackingData()) {
                        return "Eye X";
                    }
                    return "Eye Y";
                }
                return "Z";
            }
            case 13: {
                return tracker.hasEyeTrackingData() ? "Eye Y" : "T";
            }
            case 14: {
                return "Fixated";
            }
            case 15: {
                return "Z";
            }
            case 16: {
                return "T";
            }
        }
        return null;
    }

    private static int nCols(ViewTracker tracker) {
        if (tracker == null) {
            return 0;
        }
        int nCol = 9;
        nCol += tracker.hasCursorTrackingData() ? 2 : 0;
        nCol += tracker.hasActiveToolTrackingData() ? 1 : 0;
        nCol += tracker.hasEyeTrackingData() ? 3 : 0;
        return nCol += tracker.hasZAndT() ? 2 : 0;
    }

    private void refreshTracker() {
        ArrayList<ViewRecordingFrame> frames = new ArrayList<ViewRecordingFrame>();
        if (this.tracker == null) {
            return;
        }
        for (int i = 0; i < this.tracker.nFrames(); ++i) {
            frames.add(this.tracker.getFrame(i));
        }
        this.table.getItems().setAll(frames);
    }

    private void updateOverlays() {
        this.executor.execute(() -> {
            this.dataMaps.generatingOverlayProperty().set(true);
            this.dataMaps.updateDataMaps(this.timeDisplayedSlider.lowValueProperty().longValue(), this.timeDisplayedSlider.highValueProperty().longValue(), this.downsampleSlider.lowValueProperty().doubleValue(), this.downsampleSlider.highValueProperty().doubleValue(), ViewTrackerDataMaps.Feature.TIMESTAMP, this.colorMapCanvas.getColorMap());
            this.viewer.repaint();
            Number maxValue = this.dataMaps.getMaxValue(this.zSlider.getValue(), this.tSlider.getValue());
            Function<Double, String> fun = d -> "View time: " + ViewTracker.df.format((Object)(d / 255.0 * (double)maxValue.longValue() / 1000.0)) + "s";
            this.colorMapCanvas.setTooltipFunction(fun);
            if (this.isOpenedProperty.get() && this.visualizationCheckBox.isSelected()) {
                BufferedImageOverlay overlay = new BufferedImageOverlay(this.viewer, this.dataMaps.getRegionMaps());
                DataMapsLocationString locationString = new DataMapsLocationString(this, this.dataMaps);
                overlay.setLocationStringFunction(locationString);
                this.viewer.getCustomOverlayLayers().setAll((Object[])new PathOverlay[]{overlay});
                this.slideOverview.setOverlay(overlay);
                this.slideOverview.setLocationStringFunction(locationString);
            }
            this.dataMaps.generatingOverlayProperty().set(false);
        });
    }

    BooleanProperty isOpenedProperty() {
        return this.isOpenedProperty;
    }

    public class DataMapsLocationString
    implements AbstractOverlay.LocationStringFunction {
        ViewTrackerDataMaps data;

        DataMapsLocationString(ViewTrackerAnalysisCommand this$0, ViewTrackerDataMaps data) {
            this.data = data;
        }

        @Override
        public String getLocationString(ImageData<BufferedImage> imageData, double x, double y, int z, int t) {
            Number value = this.data.getValueFromOriginalLocation((int)x, (int)y, z, t);
            if (value == null) {
                return "";
            }
            return "View time: " + ViewTracker.df.format((Object)((double)value.longValue() / 1000.0)) + " s";
        }
    }
}

