/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer.recording;

import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.gui.viewer.QuPathViewerListener;
import qupath.lib.gui.viewer.recording.ViewRecordingFrame;
import qupath.lib.gui.viewer.recording.ViewTrackerTools;
import qupath.lib.gui.viewer.tools.PathTool;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.objects.PathObject;

public class ViewTracker
implements QuPathViewerListener {
    private static final Logger logger = LoggerFactory.getLogger(ViewTracker.class);
    protected static final DecimalFormat df = new DecimalFormat("#.##");
    protected static final String LOG_DELIMITER = "\t";
    private transient QuPathGUI qupath;
    private transient QuPathViewer viewer;
    private boolean hasZAndT;
    private BooleanProperty doCursorTracking = new SimpleBooleanProperty(true);
    private BooleanProperty doActiveToolTracking = new SimpleBooleanProperty();
    private BooleanProperty doEyeTracking = new SimpleBooleanProperty();
    private BooleanProperty recording = new SimpleBooleanProperty(false);
    private File recordingDirectory;
    private File recordingFile = null;
    private OutputStreamWriter fw = null;
    private StringProperty nameProperty = new SimpleStringProperty(null);
    private long startTime = -1L;
    private List<ViewRecordingFrame> frames = new ArrayList<ViewRecordingFrame>();
    private transient ViewRecordingFrame lastFrame = null;
    private double rotation = 0.0;
    private boolean initialized = false;
    private MouseMovementHandler mouseHandler = new MouseMovementHandler();

    ViewTracker(QuPathGUI qupath) {
        this.qupath = qupath;
        this.viewer = qupath != null ? qupath.getViewer() : null;
        this.nameProperty.addListener((v, o, n) -> this.renameFile((String)n));
        this.recording.addListener((v, o, n) -> {
            if (n.booleanValue()) {
                this.doStartRecording();
            } else {
                this.doStopRecording();
            }
        });
    }

    private void renameFile(String newName) {
        if (this.recording.get() || this.recordingFile == null || GeneralTools.getNameWithoutExtension((File)this.recordingFile).equals(newName)) {
            return;
        }
        try {
            Files.move(this.recordingFile.toPath(), this.recordingFile.toPath().resolveSibling(newName + GeneralTools.getExtension((File)new File(newName)).orElse(".tsv")), new CopyOption[0]);
            this.recordingFile = this.recordingFile.toPath().resolveSibling(newName + GeneralTools.getExtension((File)new File(newName)).orElse(".tsv")).toFile();
        }
        catch (IOException ex) {
            Dialogs.showErrorMessage((String)"Error", (String)("Could not rename recording  '" + newName + "': " + ex.getLocalizedMessage()));
        }
    }

    public int nFrames() {
        return this.frames.size();
    }

    public ViewRecordingFrame getFrame(int index) {
        return this.frames.get(index);
    }

    public void setRecording(boolean recording) {
        if (this.isRecording() == recording) {
            return;
        }
        this.recording.set(recording);
    }

    private void doStartRecording() {
        if (this.viewer == null || this.viewer.getServer() == null || this.initialized) {
            return;
        }
        ImageServer<BufferedImage> server = this.viewer.getServer();
        this.initializeRecording();
        this.viewer.addViewerListener(this);
        if (this.doCursorTracking.get()) {
            this.viewer.getView().addEventHandler(MouseEvent.MOUSE_MOVED, (EventHandler)this.mouseHandler);
            this.viewer.getView().addEventHandler(MouseEvent.MOUSE_DRAGGED, (EventHandler)this.mouseHandler);
        }
        this.visibleRegionChanged(this.viewer, this.viewer.getDisplayedRegionShape());
        logger.debug("--------------------------------------\nView tracking for image: " + server.getPath() + "\n" + ViewTrackerTools.getSummaryHeadings(LOG_DELIMITER, this.doCursorTracking.get(), this.doActiveToolTracking.get(), this.doEyeTracking.get(), this.hasZAndT()));
    }

    private void doStopRecording() {
        ViewRecordingFrame frame = new ViewRecordingFrame(System.currentTimeMillis() - this.startTime, this.viewer.getDisplayedRegionShape(), ViewTrackerTools.getSize(this.viewer), this.viewer.getDownsampleFactor(), this.viewer.getRotation(), new Point2D.Double(-1.0, -1.0), this.getActiveToolIfRequired(), this.getEyePointIfRequired(), this.getEyeFixatedIfRequired(), this.getCurrentZ(), this.getCurrentT());
        this.appendFrame(frame);
        logger.debug("--------------------------------------");
        this.viewer.removeViewerListener(this);
        if (this.doCursorTracking.get()) {
            this.viewer.getView().removeEventHandler(MouseEvent.MOUSE_MOVED, (EventHandler)this.mouseHandler);
            this.viewer.getView().removeEventHandler(MouseEvent.MOUSE_DRAGGED, (EventHandler)this.mouseHandler);
        }
        if (this.fw != null) {
            try {
                this.fw.flush();
                this.fw.close();
                this.fw = null;
            }
            catch (IOException e) {
                logger.error("Error while closing back-up file: ", (Throwable)e);
            }
        }
    }

    private boolean setRecordingDirectory() {
        File recordingDirectory;
        Path entryPath = this.qupath.getProject().getEntry(this.viewer.getImageData()).getEntryPath();
        if (entryPath != null && entryPath.toFile().exists() && (recordingDirectory = new File(entryPath.toFile(), "recordings")).exists()) {
            this.recordingDirectory = recordingDirectory;
            return true;
        }
        return false;
    }

    private void createRecordingDir(Path entryPath) {
        if (entryPath == null) {
            logger.warn("Could not set recording directory.");
            return;
        }
        File directory = new File(entryPath.toFile(), "recordings");
        directory.mkdir();
        this.recordingDirectory = directory;
    }

    public boolean isRecording() {
        return this.recording.get();
    }

    private void initializeRecording() {
        ImageData<BufferedImage> imageData = this.viewer.getImageData();
        this.hasZAndT = imageData.getServerMetadata().getSizeZ() != 1 || imageData.getServerMetadata().getSizeT() != 1;
        this.frames.clear();
        this.startTime = System.currentTimeMillis();
        this.lastFrame = null;
        if (!this.setRecordingDirectory()) {
            this.createRecordingDir(this.qupath.getProject().getEntry(imageData).getEntryPath());
        }
        this.recordingFile = this.recordingFile != null ? this.recordingFile : new File(this.recordingDirectory, (String)this.nameProperty.get() + ".tsv");
        try {
            this.fw = new OutputStreamWriter((OutputStream)new FileOutputStream(this.recordingFile), StandardCharsets.UTF_8);
            this.fw.write(ViewTrackerTools.getSummaryHeadings(LOG_DELIMITER, this.doCursorTracking.get(), this.doActiveToolTracking.get(), this.doEyeTracking.get(), this.hasZAndT()));
            this.fw.write(System.lineSeparator());
        }
        catch (IOException e) {
            logger.error("Could not create back-up file - recording will not be saved", (Throwable)e);
        }
        this.initialized = true;
    }

    public boolean isEmpty() {
        return this.frames.isEmpty();
    }

    private synchronized ViewRecordingFrame addFrame(long timestamp, Shape imageBounds, Dimension canvasSize, double downFactor, Point2D cursorPoint, PathTool activeTool, Point2D eyePoint, Boolean isFixated, double rotation, int z, int t) {
        if (!this.isRecording()) {
            logger.error("Recording has not started! Frame request will be ignored.");
            return null;
        }
        if (this.lastFrame != null && this.lastFrame.getTimestamp() > timestamp) {
            logger.warn("View tracking frame disregarded with timestamp " + df.format((timestamp - this.startTime) / 1000L) + " seconds");
            return null;
        }
        ViewRecordingFrame frame = new ViewRecordingFrame(timestamp - this.startTime, imageBounds, canvasSize, downFactor, rotation, cursorPoint, activeTool, eyePoint, isFixated, z, t);
        this.appendFrame(frame);
        logger.debug(ViewTrackerTools.getSummary(this.lastFrame, LOG_DELIMITER, this.doCursorTracking.get(), this.doActiveToolTracking.get(), this.doEyeTracking.get(), this.hasZAndT));
        return frame;
    }

    public synchronized void appendFrame(ViewRecordingFrame frame) {
        if (this.lastFrame != null && this.lastFrame.getTimestamp() > frame.getTimestamp()) {
            throw new RuntimeException("Unable to append frame - frame timestamp is earlier than the current timestamp");
        }
        this.frames.add(frame);
        this.lastFrame = frame;
        if (this.fw != null) {
            try {
                this.fw.write(ViewTrackerTools.getSummary(frame, LOG_DELIMITER, this.doCursorTracking.get(), this.doActiveToolTracking.get(), this.doEyeTracking.get(), this.hasZAndT));
                this.fw.write(System.lineSeparator());
            }
            catch (IOException e) {
                logger.error("Could not write frame to file. Frame will be ignored: ", (Throwable)e);
            }
        }
    }

    private int getCurrentZ() {
        return this.viewer.getZPosition();
    }

    private int getCurrentT() {
        return this.viewer.getTPosition();
    }

    protected List<ViewRecordingFrame> getFrames() {
        return Collections.unmodifiableList(this.frames);
    }

    public boolean isLastFrame(ViewRecordingFrame frame) {
        return frame == this.lastFrame;
    }

    public int getFrameIndexForTime(long timestamp) {
        ArrayList timestampList = this.frames.stream().map(e -> e.getTimestamp()).collect(Collectors.toCollection(ArrayList::new));
        int index = Collections.binarySearch(timestampList, timestamp);
        if (index < 0) {
            index = ~index - 1;
        }
        return index >= 0 ? index : 0;
    }

    public ViewRecordingFrame getFrameForTime(long timestamp) {
        int index = this.getFrameIndexForTime(timestamp);
        return this.frames.get(index);
    }

    @Override
    public void visibleRegionChanged(QuPathViewer viewer, Shape shape) {
        if (this.lastFrame != null && this.lastFrame.getImageShape().equals(shape) && this.lastFrame.getSize().equals(ViewTrackerTools.getSize(viewer))) {
            return;
        }
        this.rotation = viewer.getRotation() != this.rotation ? viewer.getRotation() : this.rotation;
        this.addFrame(System.currentTimeMillis(), shape, ViewTrackerTools.getSize(viewer), viewer.getDownsampleFactor(), this.getMousePointIfRequired(), this.getActiveToolIfRequired(), null, null, this.rotation, this.getCurrentZ(), this.getCurrentT());
    }

    protected Point2D getMousePointIfRequired() {
        Point2D p = null;
        if (this.doCursorTracking.get() && (p = this.viewer.getMousePosition()) != null) {
            return this.viewer.componentPointToImagePoint(p, p, false);
        }
        return new Point2D.Double(-1.0, -1.0);
    }

    protected PathTool getActiveToolIfRequired() {
        return this.doActiveToolTracking.get() ? this.viewer.getActiveTool() : null;
    }

    protected Point2D getEyePointIfRequired() {
        return null;
    }

    protected Boolean getEyeFixatedIfRequired() {
        return null;
    }

    @Override
    public void selectedObjectChanged(QuPathViewer viewer, PathObject pathObjectSelected) {
    }

    @Override
    public void viewerClosed(QuPathViewer viewer) {
        if (this.viewer == viewer) {
            this.setRecording(false);
        }
    }

    public BooleanProperty recordingProperty() {
        return this.recording;
    }

    @Override
    public void imageDataChanged(QuPathViewer viewer, ImageData<BufferedImage> imageDataOld, ImageData<BufferedImage> imageDataNew) {
    }

    public File getFile() {
        return this.recordingFile;
    }

    public void setFile(File file) {
        this.recordingFile = file;
    }

    public String getName() {
        return (String)this.nameProperty.get();
    }

    public void setName(String name) {
        this.nameProperty.set((Object)name);
    }

    public StringProperty nameProperty() {
        return this.nameProperty;
    }

    public long getStartTime() {
        if (this.startTime == -1L && this.frames.size() > 0) {
            return this.frames.get(0).getTimestamp();
        }
        return this.startTime;
    }

    public long getLastTime() {
        return this.lastFrame.getTimestamp() + this.getStartTime();
    }

    public boolean hasZAndT() {
        return this.hasZAndT;
    }

    public boolean hasCursorTrackingData() {
        return this.doCursorTracking.get();
    }

    public boolean hasActiveToolTrackingData() {
        return this.doActiveToolTracking.get();
    }

    public boolean hasEyeTrackingData() {
        return this.doEyeTracking.get();
    }

    public BooleanProperty cursorTrackingProperty() {
        return this.doCursorTracking;
    }

    public BooleanProperty activeToolProperty() {
        return this.doActiveToolTracking;
    }

    public BooleanProperty eyeTrackingProperty() {
        return this.doEyeTracking;
    }

    public List<ViewRecordingFrame> getAllFrames() {
        return this.frames;
    }

    public void setOptionalParameters(boolean ZandT, boolean cursorTracking, boolean activeToolTracking, boolean eyeTracking) {
        this.hasZAndT = ZandT;
        this.doCursorTracking.set(cursorTracking);
        this.doActiveToolTracking.set(activeToolTracking);
        this.doEyeTracking.set(eyeTracking);
    }

    class MouseMovementHandler
    implements EventHandler<MouseEvent> {
        MouseMovementHandler() {
        }

        public void handle(MouseEvent event) {
            Point2D p = ViewTracker.this.viewer.componentPointToImagePoint(event.getX(), event.getY(), null, false);
            ViewTracker.this.addFrame(System.currentTimeMillis(), ViewTracker.this.viewer.getDisplayedRegionShape(), ViewTrackerTools.getSize(ViewTracker.this.viewer), ViewTracker.this.viewer.getDownsampleFactor(), p, ViewTracker.this.getActiveToolIfRequired(), ViewTracker.this.getEyePointIfRequired(), ViewTracker.this.getEyeFixatedIfRequired(), ViewTracker.this.viewer.getRotation(), ViewTracker.this.getCurrentZ(), ViewTracker.this.getCurrentT());
        }
    }
}

