/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer.recording;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import qupath.lib.gui.viewer.tools.PathTool;

class ViewRecordingFrame {
    private static final DecimalFormat df = new DecimalFormat("#.##");
    private long timestamp;
    private Shape region;
    private Dimension canvasSize;
    private double downFactor;
    private PathTool activeTool;
    private Point2D cursorPosition;
    private Point2D eyePosition;
    private Boolean isFixated;
    private double rotation;
    private Integer z;
    private Integer t;

    ViewRecordingFrame(long timestamp, Shape region, Dimension canvasSize) {
        this(timestamp, region, canvasSize, 1.0, null);
    }

    ViewRecordingFrame(long timestamp, Shape region, Dimension canvasSize, double downFactor, double rotation, int z, int t) {
        this(timestamp, region, canvasSize, downFactor, rotation, null, null, null, false, z, t);
    }

    ViewRecordingFrame(long timestamp, Shape region, Dimension canvasSize, double downFactor, Point2D cursorPosition) {
        this(timestamp, region, canvasSize, 0.0, downFactor, cursorPosition, null, null, false, -1, -1);
    }

    ViewRecordingFrame(long timestamp, Shape region, Dimension canvasSize, double downFactor, double rotation, Point2D cursorPosition, PathTool activeTool, Point2D eyePosition, Boolean isFixated, Integer z, Integer t) {
        this.timestamp = timestamp;
        this.region = region;
        this.canvasSize = canvasSize;
        this.downFactor = downFactor;
        this.rotation = rotation;
        this.cursorPosition = cursorPosition;
        this.activeTool = activeTool;
        this.eyePosition = eyePosition;
        this.isFixated = isFixated;
        this.z = z;
        this.t = t;
    }

    public String toString() {
        Object s = String.format("Timestamp: %d, Shape: %s, Canvas size: %d, %d, Rotation: %f", this.timestamp, this.region.toString(), this.canvasSize.width, this.canvasSize.height, this.rotation);
        if (this.cursorPosition != null) {
            s = (String)s + ", Cursor position: " + df.format(this.cursorPosition.getX()) + ", " + df.format(this.cursorPosition.getY());
        }
        if (this.eyePosition != null) {
            s = (String)s + ", Eye position: " + df.format(this.eyePosition.getX()) + ", " + df.format(this.eyePosition.getY()) + ", Is fixated: " + this.isFixated;
        }
        if (this.z != null || this.t != null) {
            s = (String)s + ", Z-Slice: " + df.format(this.z) + ", , Timepoint: " + df.format(this.t);
        }
        return s;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Shape getShape() {
        return this.region;
    }

    public Rectangle getImageBounds() {
        Point2D center = this.getFrameCentre();
        AffineTransform at = new AffineTransform();
        at.rotate(this.rotation, center.getX(), center.getY());
        Shape rec = at.createTransformedShape(this.region);
        return rec.getBounds();
    }

    public Point2D getFrameCentre() {
        PathIterator it = this.region.getPathIterator(null);
        double[] segment = new double[6];
        Point2D[] coords = new Point2D[4];
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = 0.0;
        double maxY = 0.0;
        for (int i = 0; i < coords.length; ++i) {
            if (it.isDone()) {
                return null;
            }
            it.currentSegment(segment);
            coords[i] = new Point2D.Double(segment[0], segment[1]);
            minX = segment[0] < minX ? (minX = segment[0]) : minX;
            maxX = segment[0] > maxX ? (maxX = segment[0]) : maxX;
            minY = segment[1] < minY ? (minY = segment[1]) : minY;
            maxY = segment[1] > maxY ? (maxY = segment[1]) : maxY;
            it.next();
        }
        return new Point2D.Double(minX + 0.5 * (maxX - minX), minY + 0.5 * (maxY - minY));
    }

    public Point2D getCursorPosition() {
        return this.cursorPosition == null ? null : new Point2D.Double(this.cursorPosition.getX(), this.cursorPosition.getY());
    }

    public boolean hasCursorPosition() {
        return this.cursorPosition != null;
    }

    public Point2D getEyePosition() {
        return this.eyePosition == null ? null : new Point2D.Double(this.eyePosition.getX(), this.eyePosition.getY());
    }

    public Boolean isEyeFixated() {
        return this.isFixated;
    }

    public boolean hasEyePosition() {
        return this.eyePosition != null;
    }

    public Shape getImageShape() {
        if (this.region instanceof Rectangle2D) {
            return (Shape)((Rectangle2D)this.region).clone();
        }
        return new Path2D.Double(this.region);
    }

    public Dimension getSize() {
        return this.canvasSize;
    }

    public int getZ() {
        return this.z;
    }

    public int getT() {
        return this.t;
    }

    public boolean hasZOrT() {
        return this.z != null || this.t != null;
    }

    public double getRotation() {
        return this.rotation;
    }

    public double getDownsampleFactor() {
        return this.downFactor;
    }

    public PathTool getActiveTool() {
        return this.activeTool;
    }

    public boolean hasActiveTool() {
        return this.activeTool != null;
    }

    boolean sameImageBounds(ViewRecordingFrame frame) {
        if (frame == null) {
            return false;
        }
        Rectangle b1 = this.getImageBounds();
        Rectangle b2 = frame.getImageBounds();
        if (b1.getX() != b2.getX() || b1.getY() != b2.getY() || b1.getWidth() != b2.getWidth() || b1.getHeight() != b2.getHeight()) {
            return false;
        }
        return this.getRotation() == frame.getRotation();
    }
}

