/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer.overlays;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import qupath.lib.gui.images.stores.DefaultImageRegionStore;
import qupath.lib.gui.images.stores.ImageRegionStoreFactory;
import qupath.lib.gui.images.stores.ImageRenderer;
import qupath.lib.gui.viewer.OverlayOptions;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.gui.viewer.overlays.AbstractImageOverlay;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.TransformedServerBuilder;
import qupath.lib.images.servers.ZProjectedImageServer;
import qupath.lib.regions.ImageRegion;

public class ZProjectOverlay
extends AbstractImageOverlay {
    private final ObjectProperty<ImageRenderer> renderer = new SimpleObjectProperty();
    private final ObjectProperty<ZProjectedImageServer.Projection> projection = new SimpleObjectProperty((Object)ZProjectedImageServer.Projection.MAX);
    private DefaultImageRegionStore store;
    private long paintCompletelyTimeout = 250L;
    private final Map<ImageServer<BufferedImage>, ImageServer<BufferedImage>> map = new WeakHashMap<ImageServer<BufferedImage>, ImageServer<BufferedImage>>();

    protected ZProjectOverlay(OverlayOptions options) {
        super(options);
        this.projection.addListener((v, o, n) -> this.map.clear());
    }

    private ZProjectOverlay(QuPathViewer viewer) {
        this(viewer.getOverlayOptions());
        this.store = viewer.getImageRegionStore();
        this.renderer.set((Object)viewer.getImageDisplay());
    }

    public static ZProjectOverlay create(QuPathViewer viewer) {
        return new ZProjectOverlay(viewer);
    }

    public ZProjectedImageServer.Projection getProjection() {
        return (ZProjectedImageServer.Projection)this.projection.get();
    }

    public ObjectProperty<ZProjectedImageServer.Projection> projectionProperty() {
        return this.projection;
    }

    public void setProjection(ZProjectedImageServer.Projection projection) {
        this.projection.set((Object)projection);
    }

    public ObjectProperty<ImageRenderer> rendererProperty() {
        return this.renderer;
    }

    public void setRenderer(ImageRenderer renderer) {
        this.renderer.set((Object)renderer);
    }

    public ImageRenderer getRenderer() {
        return (ImageRenderer)this.renderer.get();
    }

    private DefaultImageRegionStore getStore() {
        if (this.store == null) {
            this.store = ImageRegionStoreFactory.createImageRegionStore();
        }
        return this.store;
    }

    private ImageServer<BufferedImage> getProjection(ImageServer<BufferedImage> server) {
        return this.map.computeIfAbsent(server, this::createProjection);
    }

    private ImageServer<BufferedImage> createProjection(ImageServer<BufferedImage> server) {
        return new TransformedServerBuilder(server).zProject((ZProjectedImageServer.Projection)this.projection.get()).build();
    }

    @Override
    public void paintOverlay(Graphics2D g2d, ImageRegion imageRegion, double downsampleFactor, ImageData<BufferedImage> imageData, boolean paintCompletely) {
        super.paintOverlay(g2d, imageRegion, downsampleFactor, imageData, paintCompletely);
        ZProjectedImageServer.Projection proj = (ZProjectedImageServer.Projection)this.projection.get();
        if (this.getOpacity() == 0.0 || imageData == null || imageData.getServer().nZSlices() == 1 || proj == null) {
            return;
        }
        ImageServer<BufferedImage> zProjServer = this.getProjection((ImageServer<BufferedImage>)imageData.getServer());
        int z = 0;
        if (zProjServer.nZSlices() > 1) {
            z = imageRegion.getZ();
        }
        DefaultImageRegionStore store = this.getStore();
        if (this.paintCompletelyTimeout > 0L) {
            store.paintRegionCompletely(zProjServer, g2d, g2d.getClip(), z, imageRegion.getT(), downsampleFactor, null, (ImageRenderer)this.renderer.get(), this.paintCompletelyTimeout);
        } else {
            store.paintRegion(zProjServer, g2d, g2d.getClip(), z, imageRegion.getT(), downsampleFactor, null, null, (ImageRenderer)this.renderer.get());
        }
    }
}

