/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer.overlays;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import qupath.lib.gui.viewer.OverlayOptions;
import qupath.lib.gui.viewer.PathObjectPainter;
import qupath.lib.gui.viewer.overlays.AbstractOverlay;
import qupath.lib.images.ImageData;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.objects.hierarchy.TMAGrid;
import qupath.lib.regions.ImageRegion;

public class TMAGridOverlay
extends AbstractOverlay {
    public TMAGridOverlay(OverlayOptions overlayOptions) {
        super(overlayOptions);
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.getOverlayOptions().getShowTMAGrid();
    }

    @Override
    public void paintOverlay(Graphics2D g, ImageRegion imageRegion, double downsampleFactor, ImageData<BufferedImage> imageData, boolean paintCompletely) {
        PathObjectHierarchy hierarchy;
        if (!this.isVisible()) {
            return;
        }
        PathObjectHierarchy pathObjectHierarchy = hierarchy = imageData == null ? null : imageData.getHierarchy();
        if (hierarchy == null) {
            return;
        }
        TMAGrid tmaGrid = hierarchy.getTMAGrid();
        if (tmaGrid == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        this.setAlphaComposite(g2d);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        PathObjectPainter.paintTMAGrid(g2d, tmaGrid, this.getOverlayOptions(), hierarchy.getSelectionModel(), downsampleFactor);
        g2d.dispose();
    }
}

