/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer.overlays;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.analysis.DelaunayTools;
import qupath.lib.awt.common.AwtTools;
import qupath.lib.color.ColorToolsAwt;
import qupath.lib.common.ColorTools;
import qupath.lib.common.GeneralTools;
import qupath.lib.geom.Point;
import qupath.lib.geom.Point2;
import qupath.lib.gui.images.servers.PathHierarchyImageServer;
import qupath.lib.gui.images.stores.DefaultImageRegionStore;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tools.ColorToolsFX;
import qupath.lib.gui.viewer.OverlayOptions;
import qupath.lib.gui.viewer.PathObjectPainter;
import qupath.lib.gui.viewer.overlays.AbstractOverlay;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.objects.DefaultPathObjectComparator;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectConnections;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.regions.ImagePlane;
import qupath.lib.regions.ImageRegion;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.EllipseROI;
import qupath.lib.roi.LineROI;
import qupath.lib.roi.ROIs;
import qupath.lib.roi.RectangleROI;
import qupath.lib.roi.interfaces.ROI;

public class HierarchyOverlay
extends AbstractOverlay {
    private static final Logger logger = LoggerFactory.getLogger(HierarchyOverlay.class);
    private ImageData<BufferedImage> imageData;
    private PathHierarchyImageServer overlayServer = null;
    private DefaultImageRegionStore regionStore = null;
    private long overlayOptionsTimestamp;
    private int lastPointRadius = PathPrefs.pointRadiusProperty().get();
    private Font font = new Font("SansSerif", 1, 10);
    private final Map<ROI, Point2> nameConnectionPointMap = Collections.synchronizedMap(new WeakHashMap());
    private final Map<Integer, Color> nameColorMap = new ConcurrentHashMap<Integer, Color>();
    private final transient DetectionComparator comparator = new DetectionComparator();

    public HierarchyOverlay(DefaultImageRegionStore regionStore, OverlayOptions overlayOptions, ImageData<BufferedImage> imageData) {
        super(overlayOptions);
        this.regionStore = regionStore;
        this.imageData = imageData;
        this.updateOverlayServer();
    }

    private void updateOverlayServer() {
        this.clearCachedOverlay();
        this.overlayServer = this.imageData == null ? null : new PathHierarchyImageServer(this.imageData, this.getOverlayOptions());
    }

    public void resetImageData() {
        this.imageData = null;
        this.updateOverlayServer();
    }

    @Override
    public void paintOverlay(Graphics2D g2d, ImageRegion imageRegion, double downsampleFactor, ImageData<BufferedImage> imageData, boolean paintCompletely) {
        long endTime;
        List paintableAnnotations;
        PathObjectHierarchy hierarchy;
        if (this.imageData != imageData) {
            this.imageData = imageData;
            this.updateOverlayServer();
        }
        PathObjectHierarchy pathObjectHierarchy = hierarchy = imageData == null ? null : imageData.getHierarchy();
        if (hierarchy == null) {
            return;
        }
        if (!this.isVisible() && hierarchy.getSelectionModel().noSelection()) {
            return;
        }
        Object defaultAntiAlias = RenderingHints.VALUE_ANTIALIAS_ON;
        Object defaultStroke = RenderingHints.VALUE_STROKE_PURE;
        OverlayOptions overlayOptions = this.getOverlayOptions();
        long timestamp = overlayOptions.lastChangeTimestamp().get();
        int pointRadius = PathPrefs.pointRadiusProperty().get();
        if (this.overlayOptionsTimestamp != timestamp || pointRadius != this.lastPointRadius) {
            this.lastPointRadius = pointRadius;
            this.overlayOptionsTimestamp = timestamp;
        }
        int t = imageRegion.getT();
        int z = imageRegion.getZ();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, defaultAntiAlias);
        Shape shapeRegion = g2d.getClip();
        if (shapeRegion == null) {
            shapeRegion = AwtTools.getBounds((ImageRegion)imageRegion);
            g2d.setClip(shapeRegion);
        }
        Rectangle boundsDisplayed = shapeRegion.getBounds();
        if (boundsDisplayed.width <= 0 || boundsDisplayed.height <= 0) {
            return;
        }
        ImageRegion region = AwtTools.getImageRegion((Rectangle)boundsDisplayed, (int)z, (int)t);
        LinkedHashSet<PathObject> paintableSelectedObjects = new LinkedHashSet<PathObject>(hierarchy.getSelectionModel().getSelectedObjects());
        paintableSelectedObjects.removeIf(p -> p == null || !HierarchyOverlay.roiBoundsIntersectsRegion(p.getROI(), region));
        boolean showAnnotations = overlayOptions.getShowAnnotations();
        boolean showDetections = overlayOptions.getShowDetections();
        List paintableDetections = showDetections && downsampleFactor <= 1.0 ? hierarchy.getAllDetectionsForRegion(region) : Collections.emptyList();
        Collection<Object> collection = paintableAnnotations = showAnnotations ? hierarchy.getAnnotationsForRegion(region) : Collections.emptyList();
        if (!showDetections && paintableSelectedObjects.isEmpty() && paintableDetections.isEmpty() && paintableAnnotations.isEmpty()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        if (overlayOptions.getShowDetections()) {
            if (this.overlayServer == null || this.regionStore == null || !paintableDetections.isEmpty()) {
                SequencedCollection<Object> detectionsToPaint;
                try {
                    detectionsToPaint = new TreeSet<PathObject>(this.comparator);
                    detectionsToPaint.addAll(paintableDetections);
                }
                catch (IllegalArgumentException e) {
                    logger.debug("Exception requesting detections to paint: " + e.getLocalizedMessage(), (Throwable)e);
                    detectionsToPaint = paintableDetections;
                }
                detectionsToPaint.removeIf(paintableSelectedObjects::contains);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                PathObjectPainter.paintSpecifiedObjects(g2d, detectionsToPaint, overlayOptions, hierarchy.getSelectionModel(), downsampleFactor);
                if (overlayOptions.getShowConnections()) {
                    Object connections = imageData.getProperty("OBJECT_CONNECTIONS");
                    if (connections instanceof PathObjectConnections) {
                        PathObjectConnections conn = (PathObjectConnections)connections;
                        PathObjectPainter.paintConnections(conn, hierarchy, g2d, imageData.isFluorescence() ? ColorToolsAwt.TRANSLUCENT_WHITE : ColorToolsAwt.TRANSLUCENT_BLACK, downsampleFactor, imageRegion.getImagePlane());
                    } else {
                        DelaunayTools.Subdivision subdiv = hierarchy.getCellSubdivision(imageRegion.getImagePlane());
                        if (subdiv.isEmpty()) {
                            subdiv = hierarchy.getDetectionSubdivision(imageRegion.getImagePlane());
                        }
                        PathObjectPainter.paintConnections(subdiv, hierarchy, g2d, imageData.isFluorescence() ? ColorToolsAwt.TRANSLUCENT_WHITE : ColorToolsAwt.TRANSLUCENT_BLACK, downsampleFactor, imageRegion.getImagePlane());
                    }
                }
            } else if (paintCompletely) {
                this.regionStore.paintRegionCompletely((ImageServer<BufferedImage>)this.overlayServer, g2d, shapeRegion, z, t, downsampleFactor, null, null, 5000L);
            } else {
                this.regionStore.paintRegion((ImageServer<BufferedImage>)this.overlayServer, g2d, shapeRegion, z, t, downsampleFactor, null, null, null);
            }
        }
        if ((endTime = System.currentTimeMillis()) - startTime > 500L) {
            logger.debug("Painting time: {} seconds", (Object)GeneralTools.formatNumber((double)((double)(endTime - startTime) / 1000.0), (int)4));
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, defaultAntiAlias);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, defaultStroke);
        List<PathObject> annotationsToPaint = paintableAnnotations.stream().filter(p -> !paintableSelectedObjects.contains(p)).sorted(Comparator.comparingInt(PathObject::getLevel).reversed().thenComparing(p -> -p.getROI().getArea())).toList();
        PathObjectPainter.paintSpecifiedObjects(g2d, annotationsToPaint, overlayOptions, null, downsampleFactor);
        if (!paintableSelectedObjects.isEmpty()) {
            Composite previousComposite = g2d.getComposite();
            float opacity = overlayOptions.getOpacity();
            if (opacity < 1.0f) {
                g2d.setComposite(AlphaComposite.getInstance(3));
                PathObjectPainter.paintSpecifiedObjects(g2d, paintableSelectedObjects, overlayOptions, hierarchy.getSelectionModel(), downsampleFactor);
                g2d.setComposite(previousComposite);
            } else {
                PathObjectPainter.paintSpecifiedObjects(g2d, paintableSelectedObjects, overlayOptions, hierarchy.getSelectionModel(), downsampleFactor);
            }
        }
        if (overlayOptions.getShowNames()) {
            LinkedHashSet objectsWithNames = new LinkedHashSet();
            paintableDetections.stream().filter(p -> p.getName() != null).forEach(objectsWithNames::add);
            paintableAnnotations.stream().filter(p -> p.getName() != null).forEach(objectsWithNames::add);
            paintableSelectedObjects.stream().filter(p -> p.getName() != null).forEach(objectsWithNames::add);
            OverlayOptions.DetectionDisplayMode detectionDisplayMode = overlayOptions.getDetectionDisplayMode();
            double requestedFontSize = overlayOptions.getFontSize();
            if (requestedFontSize <= 0.0 || !Double.isFinite(requestedFontSize)) {
                switch ((PathPrefs.FontSize)((Object)PathPrefs.locationFontSizeProperty().get())) {
                    case HUGE: {
                        requestedFontSize = 24.0;
                        break;
                    }
                    case LARGE: {
                        requestedFontSize = 18.0;
                        break;
                    }
                    case SMALL: {
                        requestedFontSize = 10.0;
                        break;
                    }
                    case TINY: {
                        requestedFontSize = 8.0;
                        break;
                    }
                    default: {
                        requestedFontSize = 14.0;
                    }
                }
            }
            double fontDownsample = Math.min(downsampleFactor, 16.0);
            float fontSize = (float)(requestedFontSize * fontDownsample);
            if (!GeneralTools.almostTheSame((double)this.font.getSize2D(), (double)fontSize, (double)0.001)) {
                this.font = this.font.deriveFont(fontSize);
            }
            g2d.setFont(this.font);
            FontMetrics metrics = g2d.getFontMetrics(this.font);
            Rectangle2D.Double rect = new Rectangle2D.Double();
            Line2D.Double connector = new Line2D.Double();
            g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            for (PathObject namedObject : objectsWithNames) {
                String name = namedObject.getName();
                ROI roi = namedObject.getROI();
                if (namedObject.isCell()) {
                    if (detectionDisplayMode == OverlayOptions.DetectionDisplayMode.NUCLEI_ONLY) {
                        roi = PathObjectTools.getNucleusOrMainROI((PathObject)namedObject);
                    } else if (detectionDisplayMode == OverlayOptions.DetectionDisplayMode.CENTROIDS) {
                        roi = PathObjectTools.getNucleusOrMainROI((PathObject)namedObject);
                        roi = ROIs.createPointsROI((double)roi.getCentroidX(), (double)roi.getCentroidY(), (ImagePlane)roi.getImagePlane());
                    }
                }
                if (name == null || name.isBlank() || roi == null || overlayOptions.isHidden(namedObject)) continue;
                Rectangle2D bounds = metrics.getStringBounds(name, g2d);
                Point2 point = this.nameConnectionPointMap.computeIfAbsent(roi, this::findNamePointForROI);
                if (point == null) {
                    logger.trace("No suitable point found for roi {}", (Object)roi);
                    continue;
                }
                double pad = 5.0 * fontDownsample;
                double x = point.getX() - bounds.getWidth() / 2.0;
                double y = point.getY() - (bounds.getY() + (double)metrics.getAscent() + pad * 4.0);
                rect.setFrame(x + bounds.getX() - pad, y + bounds.getY() - pad, bounds.getWidth() + pad * 2.0, bounds.getHeight() + pad * 2.0);
                int objectColorInt = hierarchy.getSelectionModel().isSelected(namedObject) && PathPrefs.useSelectedColorProperty().get() ? PathPrefs.colorSelectedObjectProperty().get() : ColorToolsFX.getDisplayedColorARGB(namedObject).intValue();
                Color objectColor = ColorToolsAwt.getCachedColor((Integer)objectColorInt);
                float thickness = (float)(PathPrefs.annotationStrokeThicknessProperty().get() * fontDownsample);
                g2d.setColor(objectColor);
                g2d.setStroke(PathObjectPainter.getCachedStroke(thickness));
                connector.setLine(rect.getCenterX(), rect.getMaxY(), point.getX(), point.getY());
                g2d.draw(connector);
                g2d.draw(rect);
                Color colorTranslucent = this.nameColorMap.computeIfAbsent(objectColorInt, this::getNameRectangleColor);
                g2d.setColor(colorTranslucent);
                g2d.fill(rect);
                g2d.setColor(Color.WHITE);
                g2d.drawString(name, (float)x, (float)y);
            }
        }
    }

    private static boolean roiBoundsIntersectsRegion(ROI roi, ImageRegion region) {
        return roi != null && roi.getZ() == region.getZ() && roi.getT() == region.getT() && region.intersects(roi.getBoundsX(), roi.getBoundsY(), Math.max(roi.getBoundsWidth(), 0.001), Math.max(roi.getBoundsHeight(), 0.001));
    }

    private Color getNameRectangleColor(Integer objectColorInt) {
        float darken = 0.6f;
        return ColorToolsAwt.getCachedColor((int)Math.round((float)ColorTools.red((int)objectColorInt) * darken), (int)Math.round((float)ColorTools.green((int)objectColorInt) * darken), (int)Math.round((float)ColorTools.blue((int)objectColorInt) * darken), (int)128);
    }

    private Point2 findNamePointForROI(ROI roi) {
        double x = HierarchyOverlay.getTargetNamePointX(roi);
        double y = HierarchyOverlay.getTargetNamePointY(roi);
        if (Double.isNaN(x) || Double.isNaN(y) || roi.isEmpty()) {
            return null;
        }
        if (roi instanceof RectangleROI || roi instanceof EllipseROI) {
            return new Point2(x, y);
        }
        if (roi instanceof LineROI) {
            return new Point2(roi.getCentroidX(), roi.getCentroidY());
        }
        Point2 target = new Point2(x, y);
        return roi.getAllPoints().stream().filter(p -> Math.abs(p.getY() - target.getY()) < 0.001).min(Comparator.comparingDouble(p -> p.distanceSq((Point)target))).orElse(null);
    }

    private static double getTargetNamePointX(ROI roi) {
        double x = roi.getCentroidX();
        if (Double.isFinite(x)) {
            return x;
        }
        return roi.getBoundsX() + roi.getBoundsWidth() / 2.0;
    }

    private static double getTargetNamePointY(ROI roi) {
        return roi.getBoundsY();
    }

    public void clearCachedOverlay() {
        if (this.regionStore != null && this.overlayServer != null) {
            this.regionStore.clearCacheForServer((ImageServer)this.overlayServer);
        }
    }

    public void clearCachedOverlayForRegion(ImageRegion region) {
        if (this.regionStore != null && this.overlayServer != null) {
            this.regionStore.clearCacheForRequestOverlap(RegionRequest.createInstance((String)this.overlayServer.getPath(), (double)1.0, (ImageRegion)region));
        }
    }

    private static class DetectionComparator
    implements Comparator<PathObject> {
        private Comparator<PathObject> baseComparator = DefaultPathObjectComparator.getInstance();

        private DetectionComparator() {
        }

        @Override
        public int compare(PathObject o1, PathObject o2) {
            int level = Integer.compare(o1.getLevel(), o2.getLevel());
            if (level == 0) {
                return this.baseComparator.compare(o1, o2);
            }
            return level;
        }
    }
}

