/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer.overlays;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import qupath.lib.gui.viewer.GridLines;
import qupath.lib.gui.viewer.OverlayOptions;
import qupath.lib.gui.viewer.overlays.AbstractOverlay;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.regions.ImageRegion;

public class GridOverlay
extends AbstractOverlay {
    public GridOverlay(OverlayOptions overlayOptions) {
        super(overlayOptions);
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.getOverlayOptions().getShowGrid();
    }

    @Override
    public void paintOverlay(Graphics2D g, ImageRegion imageRegion, double downsampleFactor, ImageData<BufferedImage> imageData, boolean paintCompletely) {
        if (!this.isVisible() || imageData == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        this.setAlphaComposite(g2d);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setStroke(new BasicStroke((float)(downsampleFactor * 1.5)));
        GridOverlay.drawGrid(this.getOverlayOptions().getGridLines(), g2d, imageData.getServer(), downsampleFactor, imageRegion, this.getPreferredOverlayColor());
        g2d.dispose();
    }

    private static void drawGrid(GridLines gridLines, Graphics g, ImageServer<?> server, double downsample, ImageRegion imageRegion, Color color) {
        if (server == null || gridLines.useMicrons() && !server.getPixelCalibration().hasPixelSizeMicrons()) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        double startXpx = gridLines.getStartX();
        double startYpx = gridLines.getStartY();
        double spaceXpx = gridLines.getSpaceX();
        double spaceYpx = gridLines.getSpaceY();
        if (gridLines.useMicrons()) {
            PixelCalibration cal = server.getPixelCalibration();
            startXpx /= cal.getPixelWidthMicrons();
            startYpx /= cal.getPixelHeightMicrons();
            spaceXpx /= cal.getPixelWidthMicrons();
            spaceYpx /= cal.getPixelHeightMicrons();
        }
        if (color != null) {
            g2d.setColor(color);
        }
        int minImageX = imageRegion.getX();
        int maxImageX = imageRegion.getX() + imageRegion.getWidth();
        int minImageY = imageRegion.getY();
        int maxImageY = imageRegion.getY() + imageRegion.getHeight();
        if (spaceXpx > 0.0) {
            if (spaceXpx > downsample) {
                for (double x = startXpx; x < (double)server.getWidth(); x += spaceXpx) {
                    if (x < (double)minImageX || x > (double)maxImageX) continue;
                    g2d.drawLine((int)(x + 0.5), minImageY, (int)(x + 0.5), maxImageY);
                }
            } else {
                g2d.fillRect(imageRegion.getX(), imageRegion.getY(), imageRegion.getWidth(), imageRegion.getHeight());
            }
        }
        if (spaceYpx > 0.0 && spaceYpx >= downsample) {
            if (spaceYpx > downsample) {
                for (double y = startYpx; y < (double)server.getHeight(); y += spaceYpx) {
                    if (y < (double)minImageY || y > (double)maxImageY) continue;
                    g2d.drawLine(minImageX, (int)(y + 0.5), maxImageX, (int)(y + 0.5));
                }
            } else {
                g2d.fillRect(imageRegion.getX(), imageRegion.getY(), imageRegion.getWidth(), imageRegion.getHeight());
            }
        }
        g2d.dispose();
    }
}

