/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer.overlays;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.gui.viewer.OverlayOptions;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.gui.viewer.overlays.AbstractImageOverlay;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.TileRequest;
import qupath.lib.regions.ImageRegion;
import qupath.lib.regions.RegionRequest;

public class BufferedImageOverlay
extends AbstractImageOverlay
implements ChangeListener<ImageData<BufferedImage>> {
    private static Logger logger = LoggerFactory.getLogger(BufferedImageOverlay.class);
    private Map<ImageRegion, BufferedImage> regions = new LinkedHashMap<ImageRegion, BufferedImage>();
    private QuPathViewer viewer;
    private ColorModel colorModel;
    private Map<BufferedImage, BufferedImage> cacheRGB = Collections.synchronizedMap(new HashMap());

    public BufferedImageOverlay(QuPathViewer viewer, BufferedImage img) {
        this(viewer, viewer.getOverlayOptions(), Map.of(ImageRegion.createInstance((int)0, (int)0, (int)viewer.getServerWidth(), (int)viewer.getServerHeight(), (int)viewer.getZPosition(), (int)viewer.getTPosition()), img));
    }

    public BufferedImageOverlay(QuPathViewer viewer, Map<ImageRegion, BufferedImage> map) {
        this(viewer, viewer.getOverlayOptions(), map);
    }

    public BufferedImageOverlay(OverlayOptions options) {
        this(options, Collections.emptyMap());
    }

    public BufferedImageOverlay(OverlayOptions options, ImageRegion region, BufferedImage img) {
        this(options, img == null ? Collections.emptyMap() : Collections.singletonMap(region, img));
    }

    public BufferedImageOverlay(OverlayOptions options, Map<? extends ImageRegion, BufferedImage> regions) {
        this(null, options, regions);
    }

    public BufferedImageOverlay(QuPathViewer viewer, OverlayOptions options, Map<? extends ImageRegion, BufferedImage> regions) {
        super(options);
        if (regions != null) {
            this.regions.putAll(regions);
        }
        if (viewer != null) {
            this.addViewerListener(viewer);
        }
    }

    public void addAllRegions(ImageServer<BufferedImage> server, int level) throws IOException {
        Collection tiles = server.getTileRequestManager().getTileRequestsForLevel(0);
        for (TileRequest tile : tiles) {
            BufferedImage img;
            RegionRequest region = tile.getRegionRequest();
            if (server.isEmptyRegion(region) || (img = (BufferedImage)server.readRegion(region)) == null) continue;
            this.regions.put((ImageRegion)region, img);
        }
    }

    public synchronized void setColorModel(ColorModel colorModel) {
        if (this.colorModel == colorModel) {
            return;
        }
        this.colorModel = colorModel;
        this.cacheRGB.clear();
        if (this.viewer != null) {
            this.viewer.repaint();
        }
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    private void addViewerListener(QuPathViewer viewer) {
        this.viewer = viewer;
        viewer.imageDataProperty().addListener((ChangeListener)this);
    }

    public void changed(ObservableValue<? extends ImageData<BufferedImage>> observable, ImageData<BufferedImage> oldValue, ImageData<BufferedImage> newValue) {
        if (this.viewer != null) {
            this.viewer.imageDataProperty().removeListener((ChangeListener)this);
            this.viewer.getCustomOverlayLayers().remove((Object)this);
            if (this == this.viewer.getCustomPixelLayerOverlay()) {
                this.viewer.resetCustomPixelLayerOverlay();
            }
            this.viewer = null;
        }
    }

    public Map<ImageRegion, BufferedImage> getRegionMap() {
        return Collections.unmodifiableMap(this.regions);
    }

    @Override
    public void paintOverlay(Graphics2D g2d, ImageRegion imageRegion, double downsampleFactor, ImageData<BufferedImage> imageData, boolean paintCompletely) {
        if (!this.isVisible() || !this.getOverlayOptions().getShowPixelClassification()) {
            return;
        }
        super.paintOverlay(g2d, imageRegion, downsampleFactor, imageData, paintCompletely);
        for (Map.Entry<ImageRegion, BufferedImage> entry : this.regions.entrySet()) {
            ImageRegion region = entry.getKey();
            if (!imageRegion.intersects(region)) continue;
            BufferedImage img = entry.getValue();
            if (this.colorModel != null && this.colorModel != img.getColorModel()) {
                BufferedImage imgRGB = this.cacheRGB.get(img);
                if (imgRGB == null) {
                    BufferedImage img22 = new BufferedImage(this.colorModel, img.getRaster(), img.getColorModel().isAlphaPremultiplied(), null);
                    imgRGB = this.convertToDrawable(img22);
                    this.cacheRGB.put(img, imgRGB);
                }
                img = imgRGB;
            } else {
                img = this.cacheRGB.computeIfAbsent(img, img2 -> this.convertToDrawable((BufferedImage)img2));
            }
            g2d.drawImage(img, region.getX(), region.getY(), region.getWidth(), region.getHeight(), null);
        }
    }

    private BufferedImage convertToDrawable(BufferedImage img) {
        if (img.getColorModel() == ColorModel.getRGBdefault()) {
            return img;
        }
        if (img.getRaster().getNumBands() == 1 && img.getColorModel() instanceof IndexColorModel) {
            return img;
        }
        BufferedImage imgRGB = new BufferedImage(img.getWidth(), img.getHeight(), 2);
        Graphics2D g2d = imgRGB.createGraphics();
        g2d.drawImage((Image)img, 0, 0, null);
        g2d.dispose();
        return imgRGB;
    }
}

