/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer.overlays;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import qupath.lib.color.ColorToolsAwt;
import qupath.lib.gui.viewer.OverlayOptions;
import qupath.lib.gui.viewer.overlays.PathOverlay;
import qupath.lib.images.ImageData;

public abstract class AbstractOverlay
implements PathOverlay {
    private OverlayOptions overlayOptions = null;
    private Color overlayColor = ColorToolsAwt.TRANSLUCENT_BLACK;
    private double opacity = 1.0;
    private AlphaComposite composite = null;
    private LocationStringFunction locationFun;

    protected AbstractOverlay(OverlayOptions options) {
        this.overlayOptions = options;
    }

    public OverlayOptions getOverlayOptions() {
        return this.overlayOptions;
    }

    protected AlphaComposite getAlphaComposite() {
        return this.composite;
    }

    protected void setAlphaComposite(Graphics2D g2d) {
        if (this.composite != null) {
            g2d.setComposite(this.composite);
        }
    }

    public boolean isVisible() {
        return this.opacity > 0.0;
    }

    public void setPreferredOverlayColor(Color color) {
        this.overlayColor = color;
    }

    public Color getPreferredOverlayColor() {
        return this.overlayColor;
    }

    public double getOpacity() {
        return this.opacity;
    }

    public void setOpacity(double opacity) {
        if (this.opacity == (opacity = Math.max(0.0, Math.min(opacity, 1.0)))) {
            return;
        }
        this.opacity = opacity;
        this.composite = opacity == 1.0 ? null : AlphaComposite.getInstance(3, (float)opacity);
    }

    public void setLocationStringFunction(LocationStringFunction fun) {
        this.locationFun = fun;
    }

    protected LocationStringFunction getLocationStringFunction() {
        return this.locationFun;
    }

    @Override
    public String getLocationString(ImageData<BufferedImage> imageData, double x, double y, int z, int t) {
        if (this.locationFun != null) {
            return this.locationFun.getLocationString(imageData, x, y, z, t);
        }
        return null;
    }

    @FunctionalInterface
    public static interface LocationStringFunction {
        public String getLocationString(ImageData<BufferedImage> var1, double var2, double var4, int var6, int var7);
    }
}

