/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer.overlays;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.gui.viewer.ImageInterpolation;
import qupath.lib.gui.viewer.OverlayOptions;
import qupath.lib.gui.viewer.overlays.AbstractOverlay;
import qupath.lib.images.ImageData;
import qupath.lib.regions.ImageRegion;

public abstract class AbstractImageOverlay
extends AbstractOverlay {
    private static final Logger logger = LoggerFactory.getLogger(AbstractImageOverlay.class);
    private final ObjectProperty<ImageInterpolation> interpolation = new SimpleObjectProperty((Object)ImageInterpolation.NEAREST);

    protected AbstractImageOverlay(OverlayOptions options) {
        super(options);
    }

    public void setInterpolation(ImageInterpolation interpolation) {
        this.interpolation.set((Object)interpolation);
    }

    public ImageInterpolation getInterpolation() {
        return (ImageInterpolation)((Object)this.interpolation.get());
    }

    public ObjectProperty<ImageInterpolation> interpolationProperty() {
        return this.interpolation;
    }

    protected void setInterpolation(Graphics2D g2d) {
        ImageInterpolation interp = this.getInterpolation();
        switch (interp) {
            case BILINEAR: {
                g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                break;
            }
            case NEAREST: {
                g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                break;
            }
            default: {
                logger.debug("Unknown interpolation value {}", (Object)interp);
            }
        }
    }

    @Override
    public void paintOverlay(Graphics2D g2d, ImageRegion imageRegion, double downsampleFactor, ImageData<BufferedImage> imageData, boolean paintCompletely) {
        this.setInterpolation(g2d);
    }
}

