/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer;

import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.TilePane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.gui.viewer.overlays.PathOverlay;
import qupath.lib.gui.viewer.overlays.ZProjectOverlay;
import qupath.lib.images.servers.ZProjectedImageServer;

class ZProjectOverlayControls {
    private static final Logger logger = LoggerFactory.getLogger(ZProjectOverlayControls.class);
    private final QuPathViewer viewer;
    private final ZProjectOverlay overlay;
    private final Node node;
    private final BooleanProperty showControls = new SimpleBooleanProperty(false);

    ZProjectOverlayControls(QuPathViewer viewer, BooleanProperty showControls) {
        this.viewer = viewer;
        this.overlay = ZProjectOverlay.create(viewer);
        this.overlay.setProjection(null);
        this.node = this.createNode();
        this.showControls.bind((ObservableValue)Bindings.createBooleanBinding(() -> showControls.get() && viewer.getServer() != null && viewer.getServer().nZSlices() > 1, (Observable[])new Observable[]{viewer.imageDataProperty(), showControls}));
        this.showControls.addListener(this::handleShowControlsChange);
        this.handleShowControlsChange((ObservableValue<? extends Boolean>)this.showControls, false, this.showControls.get());
    }

    private void handleShowControlsChange(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
        if (newValue.booleanValue()) {
            this.showControls();
        } else {
            this.hideControls();
        }
    }

    private Node createNode() {
        TilePane tilePane = new TilePane();
        ToggleGroup toggles = new ToggleGroup();
        ToggleButton selected = null;
        for (ZProjectedImageServer.Projection projection : List.of(ZProjectedImageServer.Projection.MEAN, ZProjectedImageServer.Projection.MEDIAN, ZProjectedImageServer.Projection.MAX, ZProjectedImageServer.Projection.MIN, ZProjectedImageServer.Projection.STANDARD_DEVIATION)) {
            ToggleButton btn = ZProjectOverlayControls.createButton(projection);
            tilePane.getChildren().add((Object)btn);
            toggles.getToggles().add((Object)btn);
            if (this.overlay.getProjection() != projection) continue;
            selected = btn;
        }
        toggles.selectedToggleProperty().addListener((v, o, n) -> {
            Object proj;
            Object object = proj = n == null ? null : n.getUserData();
            if (proj instanceof ZProjectedImageServer.Projection) {
                ZProjectedImageServer.Projection zp = (ZProjectedImageServer.Projection)proj;
                logger.debug("Setting projection to {}", proj);
                this.overlay.setProjection(zp);
            } else {
                logger.debug("Resetting z-projection {}", proj);
                this.overlay.setProjection(null);
            }
            this.viewer.repaint();
        });
        if (selected != null) {
            selected.setSelected(true);
        }
        Group pane = new Group(new Node[]{tilePane});
        pane.getProperties().put((Object)"z-project-overlay", (Object)Boolean.TRUE);
        StackPane.setAlignment((Node)pane, (Pos)Pos.TOP_CENTER);
        StackPane.setMargin((Node)pane, (Insets)new Insets(10.0));
        return pane;
    }

    private void showControls() {
        logger.debug("Showing z-projection overlay control");
        this.viewer.getView().getChildren().add((Object)this.node);
        this.viewer.getCustomOverlayLayers().setAll((Object[])new PathOverlay[]{this.overlay});
    }

    private void hideControls() {
        logger.debug("Hiding z-projection overlay control");
        this.viewer.getView().getChildren().remove((Object)this.node);
        this.viewer.getCustomOverlayLayers().remove((Object)this.overlay);
    }

    private static ToggleButton createButton(ZProjectedImageServer.Projection projection) {
        ToggleButton btn = new ToggleButton(ZProjectOverlayControls.getName(projection));
        btn.setUserData((Object)projection);
        btn.setMaxWidth(Double.MAX_VALUE);
        btn.selectedProperty().addListener((v, o, n) -> {
            if (n.booleanValue()) {
                btn.setStyle("-fx-font-weight: bold;");
            } else {
                btn.setStyle(null);
            }
        });
        return btn;
    }

    private static String getName(ZProjectedImageServer.Projection projection) {
        return switch (projection) {
            default -> throw new MatchException(null, null);
            case ZProjectedImageServer.Projection.MAX -> "Max";
            case ZProjectedImageServer.Projection.MIN -> "Min";
            case ZProjectedImageServer.Projection.MEAN -> "Mean";
            case ZProjectedImageServer.Projection.STANDARD_DEVIATION -> "Std.Dev";
            case ZProjectedImageServer.Projection.SUM -> "Sum";
            case ZProjectedImageServer.Projection.MEDIAN -> "Median";
        };
    }
}

