/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer;

import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import qupath.lib.gui.prefs.PathPrefs;

public class ViewerPlusDisplayOptions {
    private final BooleanProperty showOverview = new SimpleBooleanProperty(null, "showOverview", true);
    private final BooleanProperty showLocation = new SimpleBooleanProperty(null, "showLocation", true);
    private final BooleanProperty showScalebar = new SimpleBooleanProperty(null, "showScalebar", true);
    private final BooleanProperty showZProjectControls = new SimpleBooleanProperty(null, "showZProjectControls", false);
    private static final ViewerPlusDisplayOptions SHARED_INSTANCE = ViewerPlusDisplayOptions.createSharedInstance();

    private static ViewerPlusDisplayOptions createSharedInstance() {
        ViewerPlusDisplayOptions options = new ViewerPlusDisplayOptions();
        for (BooleanProperty prop : List.of(options.showOverview, options.showLocation, options.showScalebar, options.showZProjectControls)) {
            prop.bindBidirectional((Property)PathPrefs.createPersistentPreference("viewerOptions_" + prop.getName(), prop.get()));
        }
        return options;
    }

    public static ViewerPlusDisplayOptions getSharedInstance() {
        return SHARED_INSTANCE;
    }

    public BooleanProperty showOverviewProperty() {
        return this.showOverview;
    }

    public BooleanProperty showLocationProperty() {
        return this.showLocation;
    }

    public BooleanProperty showScalebarProperty() {
        return this.showScalebar;
    }

    public BooleanProperty showZProjectControlsProperty() {
        return this.showZProjectControls;
    }

    public boolean getShowOverview() {
        return this.showOverview.get();
    }

    public boolean getShowLocation() {
        return this.showLocation.get();
    }

    public boolean getShowScalebar() {
        return this.showScalebar.get();
    }

    public boolean getShowZProjectControls() {
        return this.showZProjectControls.get();
    }

    public void setShowOverview(boolean show) {
        this.showOverview.set(show);
    }

    public void setShowLocation(boolean show) {
        this.showLocation.set(show);
    }

    public void setShowScalebar(boolean show) {
        this.showScalebar.set(show);
    }

    public void setShowZProjectControls(boolean show) {
        this.showZProjectControls.set(show);
    }
}

