/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.control.ToggleGroup;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.RotateEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.ZoomEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Ellipse;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Duration;
import jfxtras.scene.menu.CirclePopupMenu;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.utils.FXUtils;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.ToolManager;
import qupath.lib.gui.actions.ActionTools;
import qupath.lib.gui.actions.CommonActions;
import qupath.lib.gui.actions.OverlayActions;
import qupath.lib.gui.actions.ViewerActions;
import qupath.lib.gui.commands.Commands;
import qupath.lib.gui.commands.TMACommands;
import qupath.lib.gui.localization.QuPathResources;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tools.ColorToolsFX;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.tools.MenuTools;
import qupath.lib.gui.viewer.OverlayOptions;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.gui.viewer.QuPathViewerListener;
import qupath.lib.gui.viewer.QuPathViewerPlus;
import qupath.lib.gui.viewer.ScrollEventPanningFilter;
import qupath.lib.gui.viewer.ViewerPlusDisplayOptions;
import qupath.lib.gui.viewer.tools.PathTool;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.objects.PathAnnotationObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.PathObjects;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.objects.hierarchy.TMAGrid;
import qupath.lib.regions.ImagePlane;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;

public class ViewerManager
implements QuPathViewerListener {
    private static final Logger logger = LoggerFactory.getLogger(ViewerManager.class);
    private QuPathGUI qupath;
    private ObjectProperty<ImageData<BufferedImage>> imageDataProperty = new SimpleObjectProperty();
    private ObservableList<QuPathViewer> viewers = FXCollections.observableArrayList();
    private ObservableList<QuPathViewer> viewersUnmodifiable = FXCollections.unmodifiableObservableList(this.viewers);
    private SimpleObjectProperty<QuPathViewer> activeViewerProperty = new SimpleObjectProperty();
    private SplitPaneGrid splitPaneGrid;
    private ViewerPlusDisplayOptions viewerDisplayOptions = ViewerPlusDisplayOptions.getSharedInstance();
    private OverlayOptions overlayOptions = OverlayOptions.getSharedInstance();
    private Reference<PathObject> lastAnnotationObject = null;
    private final Color colorBorder = Color.rgb((int)180, (int)0, (int)0, (double)0.8);
    private BooleanProperty synchronizeViewers = PathPrefs.createPersistentPreference("synchronizeViewers", false);
    private Map<QuPathViewer, ViewerPosition> lastViewerPosition = new WeakHashMap<QuPathViewer, ViewerPosition>();
    private BooleanProperty refreshTitleProperty = new SimpleBooleanProperty();

    private ViewerManager(QuPathGUI qupath) {
        this.qupath = qupath;
    }

    public static ViewerManager create(QuPathGUI qupath) {
        return new ViewerManager(qupath);
    }

    public void refreshTitles() {
        this.refreshTitleProperty.set(!this.refreshTitleProperty.get());
    }

    public ObservableList<QuPathViewer> getAllViewers() {
        return this.viewersUnmodifiable;
    }

    public OverlayOptions getOverlayOptions() {
        return this.overlayOptions;
    }

    public BooleanProperty showOverviewProperty() {
        return this.viewerDisplayOptions.showOverviewProperty();
    }

    public BooleanProperty showLocationProperty() {
        return this.viewerDisplayOptions.showLocationProperty();
    }

    public BooleanProperty showScalebarProperty() {
        return this.viewerDisplayOptions.showScalebarProperty();
    }

    public BooleanProperty showZProjectControlsProperty() {
        return this.viewerDisplayOptions.showZProjectControlsProperty();
    }

    public void matchResolutions() {
        QuPathViewer viewer = this.getActiveViewer();
        List<QuPathViewer> activeViewers = this.getAllViewers().stream().filter(v -> v.hasServer()).toList();
        if (activeViewers.size() <= 1 || !viewer.hasServer()) {
            return;
        }
        PixelCalibration cal = viewer.getServer().getPixelCalibration();
        double pixelSize = cal.getAveragedPixelSize().doubleValue();
        double downsample = viewer.getDownsampleFactor();
        for (QuPathViewer temp : activeViewers) {
            if (temp == viewer) continue;
            PixelCalibration cal2 = temp.getServer().getPixelCalibration();
            double tempPixelSize = cal2.getAveragedPixelSize().doubleValue();
            double newDownsample = Double.isFinite(tempPixelSize) && Double.isFinite(pixelSize) && cal2.getPixelWidthUnit().equals(cal.getPixelWidthUnit()) && cal2.getPixelHeightUnit().equals(cal.getPixelHeightUnit()) ? pixelSize / tempPixelSize * downsample : downsample;
            temp.setDownsampleFactor(newDownsample);
        }
    }

    public void setActiveViewer(QuPathViewer viewer) {
        QuPathViewer previousActiveViewer = this.getActiveViewer();
        if (previousActiveViewer == viewer) {
            return;
        }
        ImageData<BufferedImage> imageDataNew = viewer == null ? null : viewer.getImageData();
        boolean spaceDown = false;
        if (previousActiveViewer != null) {
            spaceDown = previousActiveViewer.isSpaceDown();
            previousActiveViewer.setSpaceDown(false);
            previousActiveViewer.setBorderColor(null);
            this.deactivateTools(previousActiveViewer);
            PathObject pathObjectSelected = previousActiveViewer.getSelectedObject();
            if (pathObjectSelected instanceof PathAnnotationObject) {
                PathAnnotationObject annotation = (PathAnnotationObject)pathObjectSelected;
                this.updateLastAnnotation(annotation);
            }
        }
        this.activeViewerProperty.set((Object)viewer);
        this.getLastViewerPosition(viewer).reset();
        if (viewer != null) {
            if (this.viewers.size() > 1) {
                viewer.setBorderColor(this.colorBorder);
            }
            if (viewer.getServer() != null) {
                this.getLastViewerPosition(viewer).update(viewer);
                if (spaceDown) {
                    viewer.setSpaceDown(true);
                }
            }
        }
        logger.debug("Active viewer set to {}", (Object)viewer);
        this.imageDataProperty.set(imageDataNew);
    }

    private void updateLastAnnotation(PathAnnotationObject pathObject) {
        PathObject temp = PathObjects.createAnnotationObject((ROI)pathObject.getROI(), (PathClass)pathObject.getPathClass());
        temp.setID(pathObject.getID());
        TMACoreObject core = PathObjectTools.getAncestorTMACore((PathObject)pathObject);
        if (core != null) {
            TMACoreObject coreTemp = PathObjects.createTMACoreObject((double)core.getROI().getBoundsX(), (double)core.getROI().getBoundsY(), (double)core.getROI().getBoundsWidth(), (double)core.getROI().getBoundsHeight(), (boolean)core.isMissing(), (ImagePlane)core.getROI().getImagePlane());
            coreTemp.setID(core.getID());
            coreTemp.setName(core.getName());
            coreTemp.addChildObject(temp);
            assert (temp.getParent() == coreTemp);
        }
        this.lastAnnotationObject = new SoftReference<PathObject>(temp);
    }

    public ReadOnlyObjectProperty<ImageData<BufferedImage>> imageDataProperty() {
        return this.imageDataProperty;
    }

    private void deactivateTools(QuPathViewer viewer) {
        viewer.setActiveTool(null);
    }

    public QuPathViewer getActiveViewer() {
        return (QuPathViewer)this.activeViewerProperty.get();
    }

    public ReadOnlyObjectProperty<QuPathViewer> activeViewerProperty() {
        return this.activeViewerProperty;
    }

    public Region getRegion() {
        if (this.splitPaneGrid == null) {
            QuPathViewerPlus defaultViewer = this.createViewer();
            if (defaultViewer != null) {
                defaultViewer.addViewerListener(this);
            }
            this.setActiveViewer(defaultViewer);
            this.splitPaneGrid = new SplitPaneGrid((Node)defaultViewer.getView());
        }
        return this.splitPaneGrid.getMainSplitPane();
    }

    public void repaintAllViewers() {
        for (QuPathViewer v : this.getAllViewers()) {
            v.repaint();
        }
    }

    protected QuPathViewerPlus createViewer() {
        QuPathViewerPlus viewerNew = new QuPathViewerPlus(this.qupath.getImageRegionStore(), this.overlayOptions, this.viewerDisplayOptions);
        this.setupViewer(viewerNew);
        viewerNew.addViewerListener(this);
        this.viewers.add((Object)viewerNew);
        return viewerNew;
    }

    public boolean removeRow(QuPathViewer viewer) {
        int row = this.splitPaneGrid.getRow(viewer);
        if (row < 0) {
            Dialogs.showErrorMessage((String)"Multiview", (String)("Cannot find " + String.valueOf(viewer) + " in the grid!"));
            return false;
        }
        if (this.splitPaneGrid.nRows() == 1) {
            Dialogs.showWarningNotification((String)"Close row", (String)"The last row can't be removed!");
            return false;
        }
        int nOpen = this.splitPaneGrid.countOpenViewersForRow(row);
        if (nOpen > 0) {
            Dialogs.showWarningNotification((String)"Close row", (String)"Please close all open viewers in the selected row, then try again");
            return false;
        }
        this.splitPaneGrid.removeRow(row);
        this.splitPaneGrid.resetGridSize();
        this.refreshViewerList();
        return true;
    }

    private void refreshViewerList() {
        Iterator iter = this.viewers.iterator();
        while (iter.hasNext()) {
            Pane view = ((QuPathViewer)iter.next()).getView();
            if (view.getScene() != null) continue;
            iter.remove();
        }
    }

    public boolean removeColumn(QuPathViewer viewer) {
        int col = this.splitPaneGrid.getColumn((Node)viewer.getView());
        if (col < 0) {
            Dialogs.showErrorMessage((String)"Multiview error", (String)("Cannot find " + String.valueOf(viewer) + " in the grid!"));
            return false;
        }
        if (this.splitPaneGrid.nCols() == 1) {
            Dialogs.showWarningNotification((String)"Close column", (String)"The last columns can't be removed!");
            return false;
        }
        int nOpen = this.splitPaneGrid.countOpenViewersForColumn(col);
        if (nOpen > 0) {
            Dialogs.showWarningNotification((String)"Close column", (String)"Please close all open viewers in selected column, then try again");
            return false;
        }
        this.splitPaneGrid.removeColumn(col);
        this.splitPaneGrid.resetGridSize();
        this.refreshViewerList();
        return true;
    }

    public boolean setGridSize(int nRows, int nCols) {
        if (nRows < 1 || nCols < 1) {
            Dialogs.showErrorMessage((String)"Multiview grid", (String)"There must be at least one viewer in the grid!");
            return false;
        }
        if (nRows == this.splitPaneGrid.nRows() && nCols == this.splitPaneGrid.nCols()) {
            logger.warn("Viewer grid is already {} x {} - nothing to change!", (Object)nRows, (Object)nCols);
            return true;
        }
        this.refreshViewerList();
        List<QuPathViewer> openViewers = this.getAllViewers().stream().filter(v -> !this.splitPaneGrid.isDetached((QuPathViewer)v) && v.hasServer()).toList();
        if (openViewers.size() > nRows * nCols) {
            Dialogs.showWarningNotification((String)"Multiview grid", (String)"There are too many viewers open! Please close some, then set the grid size.");
            return false;
        }
        while (this.splitPaneGrid.nRows() < nRows) {
            this.splitPaneGrid.addRow(this.splitPaneGrid.nRows());
        }
        while (this.splitPaneGrid.nCols() < nCols) {
            this.splitPaneGrid.addColumn(this.splitPaneGrid.nCols());
        }
        if (nRows == this.splitPaneGrid.nRows() && nCols == this.splitPaneGrid.nCols()) {
            return true;
        }
        QuPathViewer activeViewer = this.getActiveViewer();
        ObservableList<QuPathViewer> allViewers = this.getAllViewers();
        ArrayList closedViewers = allViewers.stream().filter(v -> !this.splitPaneGrid.isDetached((QuPathViewer)v) && !v.hasServer() && this.splitPaneGrid.getRow((QuPathViewer)v) < nRows && this.splitPaneGrid.getColumn((QuPathViewer)v) < nCols).collect(Collectors.toCollection(ArrayList::new));
        for (QuPathViewer viewer : openViewers) {
            Pane view = viewer.getView();
            int r = this.splitPaneGrid.getRow((Node)view);
            int c = this.splitPaneGrid.getColumn((Node)view);
            if (r < nRows && c < nCols) continue;
            QuPathViewer nextClosedViewer = (QuPathViewer)closedViewers.remove(0);
            int rClosed = this.splitPaneGrid.getRow(nextClosedViewer);
            int cClosed = this.splitPaneGrid.getColumn(nextClosedViewer);
            this.splitPaneGrid.splitPaneRows.get(r).getItems().set(c, (Object)new BorderPane());
            this.splitPaneGrid.splitPaneRows.get(rClosed).getItems().set(cClosed, (Object)view);
            this.viewers.remove((Object)nextClosedViewer);
        }
        while (this.splitPaneGrid.nRows() > nRows) {
            this.splitPaneGrid.removeRow(this.splitPaneGrid.nRows() - 1);
        }
        while (this.splitPaneGrid.nCols() > nCols) {
            this.splitPaneGrid.removeColumn(this.splitPaneGrid.nCols() - 1);
        }
        this.refreshViewerList();
        if (activeViewer != null && this.viewers.contains((Object)activeViewer)) {
            this.setActiveViewer(activeViewer);
        } else if (!this.viewers.isEmpty()) {
            this.setActiveViewer((QuPathViewer)this.viewers.get(0));
        } else {
            logger.warn("No viewers remaining, cannot set active viewer");
        }
        this.resetGridSize();
        return true;
    }

    public void addRow(QuPathViewer viewer) {
        this.splitViewer(viewer, false);
        this.splitPaneGrid.resetGridSize();
    }

    public void addColumn(QuPathViewer viewer) {
        this.splitViewer(viewer, true);
        this.splitPaneGrid.resetGridSize();
    }

    public void splitViewer(QuPathViewer viewer, boolean splitVertical) {
        if (!this.viewers.contains((Object)viewer)) {
            return;
        }
        if (splitVertical) {
            this.splitPaneGrid.addColumn(this.splitPaneGrid.getColumn((Node)viewer.getView()) + 1);
        } else {
            this.splitPaneGrid.addRow(this.splitPaneGrid.getRow((Node)viewer.getView()) + 1);
        }
    }

    public void resetGridSize() {
        this.splitPaneGrid.resetGridSize();
    }

    @Override
    public void imageDataChanged(QuPathViewer viewer, ImageData<BufferedImage> imageDataOld, ImageData<BufferedImage> imageDataNew) {
        if (viewer != null && viewer == this.getActiveViewer()) {
            if (viewer.getServer() != null) {
                this.getLastViewerPosition(viewer).reset();
            }
            this.imageDataProperty.set(viewer.getImageData());
        }
    }

    private ViewerPosition getLastViewerPosition(QuPathViewer viewer) {
        return this.lastViewerPosition.computeIfAbsent(viewer, v -> new ViewerPosition());
    }

    @Override
    public void visibleRegionChanged(QuPathViewer viewer, Shape shape) {
        if (viewer == null) {
            return;
        }
        if (viewer != this.getActiveViewer() || viewer.isImageDataChanging()) {
            return;
        }
        QuPathViewer activeViewer = this.getActiveViewer();
        double x = activeViewer.getCenterPixelX();
        double y = activeViewer.getCenterPixelY();
        double rotation = activeViewer.getRotation();
        double dx = Double.NaN;
        double dy = Double.NaN;
        double dr = Double.NaN;
        int dt = 0;
        int dz = 0;
        double downsample = viewer.getDownsampleFactor();
        ViewerPosition position = this.getLastViewerPosition(activeViewer);
        double relativeDownsample = viewer.getDownsampleFactor() / position.downsample;
        if (this.synchronizeViewers.get()) {
            if (!Double.isNaN(position.x + position.y)) {
                dx = x - position.x;
                dy = y - position.y;
                dr = rotation - position.rotation;
                dt = activeViewer.getTPosition() - position.t;
                dz = activeViewer.getZPosition() - position.z;
            }
            for (QuPathViewer v : this.viewers) {
                if (v == viewer) continue;
                if (!Double.isNaN(relativeDownsample)) {
                    v.setDownsampleFactor(v.getDownsampleFactor() * relativeDownsample, -1.0, -1.0, false);
                }
                if (!Double.isNaN(dr) && dr != 0.0) {
                    v.setRotation(v.getRotation() + dr);
                }
                double downsampleRatio = v.getDownsampleFactor() / downsample;
                if (Double.isNaN(dx) || Double.isNaN(downsampleRatio)) continue;
                double rot = rotation - v.getRotation();
                double sin = Math.sin(rot);
                double cos = Math.cos(rot);
                double dx2 = dx * downsampleRatio;
                double dy2 = dy * downsampleRatio;
                double dx3 = cos * dx2 - sin * dy2;
                double dy3 = sin * dx2 + cos * dy2;
                v.setCenterPixelLocation(v.getCenterPixelX() + dx3, v.getCenterPixelY() + dy3);
                if (dz != 0) {
                    v.setZPosition(GeneralTools.clipValue((int)(v.getZPosition() + dz), (int)0, (int)(v.getServer().nZSlices() - 1)));
                }
                if (dt == 0) continue;
                v.setTPosition(GeneralTools.clipValue((int)(v.getTPosition() + dt), (int)0, (int)(v.getServer().nTimepoints() - 1)));
            }
        }
        position.update(activeViewer);
    }

    public boolean getSynchronizeViewers() {
        return this.synchronizeViewers.get();
    }

    public void setSynchronizeViewers(boolean synchronizeViewers) {
        this.synchronizeViewers.set(synchronizeViewers);
    }

    public ReadOnlyBooleanProperty synchronizeViewersProperty() {
        return this.synchronizeViewers;
    }

    @Override
    public void selectedObjectChanged(QuPathViewer viewer, PathObject pathObjectSelected) {
        if (pathObjectSelected instanceof PathAnnotationObject) {
            PathAnnotationObject annotation = (PathAnnotationObject)pathObjectSelected;
            this.updateLastAnnotation(annotation);
            return;
        }
        if (viewer != this.getActiveViewer()) {
            return;
        }
        if (!(pathObjectSelected instanceof TMACoreObject)) {
            return;
        }
        this.getLastViewerPosition(this.getActiveViewer()).reset();
        String coreName = ((TMACoreObject)pathObjectSelected).getName();
        for (QuPathViewer v : this.viewers) {
            TMAGrid tmaGrid;
            TMACoreObject core;
            PathObjectHierarchy hierarchy;
            if (v == viewer || (hierarchy = v.getHierarchy()) == null || hierarchy.getTMAGrid() == null || (core = (tmaGrid = hierarchy.getTMAGrid()).getTMACore(coreName)) == null) continue;
            v.setSelectedObject((PathObject)core);
            double cx = core.getROI().getCentroidX();
            double cy = core.getROI().getCentroidY();
            v.setCenterPixelLocation(cx, cy);
        }
    }

    public boolean applyLastAnnotationToActiveViewer() {
        TMACoreObject coreParent;
        PathObject lastAnnotation = this.lastAnnotationObject.get();
        if (lastAnnotation == null) {
            logger.info("No annotation object to copy");
            return false;
        }
        QuPathViewer activeViewer = this.getActiveViewer();
        if (activeViewer == null || activeViewer.getHierarchy() == null) {
            logger.info("No active viewer available");
            return false;
        }
        PathObjectHierarchy hierarchy = activeViewer.getHierarchy();
        if (PathObjectTools.hierarchyContainsObject((PathObjectHierarchy)hierarchy, (PathObject)lastAnnotation) || hierarchy.getAnnotationObjects().stream().anyMatch(a -> a.getID().equals(lastAnnotation.getID()))) {
            logger.info("Hierarchy already contains the annotation object!");
            return false;
        }
        ROI roi = lastAnnotation.getROI().duplicate();
        TMACoreObject coreNewParent = null;
        if (hierarchy.getTMAGrid() != null && (coreParent = PathObjectTools.getAncestorTMACore((PathObject)lastAnnotation)) != null && (coreNewParent = hierarchy.getTMAGrid().getTMACore(coreParent.getName())) != null) {
            double rotation = activeViewer.getRotation();
            double dx = coreNewParent.getROI().getCentroidX() - coreParent.getROI().getCentroidX();
            double dy = coreNewParent.getROI().getCentroidY() - coreParent.getROI().getCentroidY();
            roi = roi.translate(dx, dy);
            if (rotation != 0.0) {
                AffineTransform transform = new AffineTransform();
                transform.rotate(-rotation, coreNewParent.getROI().getCentroidX(), coreNewParent.getROI().getCentroidY());
                logger.info("ROTATING: " + String.valueOf(transform));
                Area area = RoiTools.getArea((ROI)roi);
                area.transform(transform);
                roi = RoiTools.getShapeROI((Area)area, (ImagePlane)roi.getImagePlane());
            }
        }
        PathObject annotation = PathObjects.createAnnotationObject((ROI)roi, (PathClass)lastAnnotation.getPathClass());
        hierarchy.addObjectBelowParent(coreNewParent, annotation, true);
        activeViewer.setSelectedObject(annotation);
        return true;
    }

    @Override
    public void viewerClosed(QuPathViewer viewer) {
    }

    private void setupViewer(QuPathViewerPlus viewer) {
        viewer.getView().setFocusTraversable(true);
        StringBinding placeholder = Bindings.createStringBinding(() -> {
            if (!PathPrefs.showViewerPlaceholderTextProperty().get() || viewer != this.activeViewerProperty().get() || viewer.getImageData() != null) {
                return null;
            }
            if (this.qupath.getProject() == null) {
                return "Drag & drop an image file or project folder";
            }
            return "Drag & drop image files to add them to the project\nor open an image by double-clicking it under the 'Project' tab";
        }, (Observable[])new Observable[]{viewer.imageDataProperty(), this.qupath.projectProperty(), this.activeViewerProperty(), PathPrefs.showViewerPlaceholderTextProperty()});
        viewer.placeholderTextProperty().bind((ObservableValue)placeholder);
        viewer.getView().focusedProperty().addListener((e, f, nowFocussed) -> {
            if (nowFocussed.booleanValue()) {
                this.setActiveViewer(viewer);
            }
        });
        viewer.getView().addEventFilter(MouseEvent.MOUSE_PRESSED, e -> viewer.getView().requestFocus());
        this.setViewerPopupMenu(viewer);
        this.qupath.getDefaultDragDropListener().setupTarget((Node)viewer.getView());
        viewer.getView().setOnScroll(e -> {
            if (viewer == this.getActiveViewer() || !this.getSynchronizeViewers()) {
                if (!viewer.hasServer()) {
                    return;
                }
                double scrollUnits = e.getDeltaY() * PathPrefs.getScaledScrollSpeed();
                if (e.isShortcutDown()) {
                    OverlayOptions options = viewer.getOverlayOptions();
                    options.setOpacity((float)((double)options.getOpacity() + scrollUnits * 0.001));
                    return;
                }
                if (e.isInertia()) {
                    return;
                }
                if (PathPrefs.invertScrollingProperty().get()) {
                    scrollUnits = -scrollUnits;
                }
                double newDownsampleFactor = viewer.getDownsampleFactor() * Math.pow(viewer.getDefaultZoomFactor(), scrollUnits);
                newDownsampleFactor = Math.min(viewer.getMaxDownsample(), Math.max(newDownsampleFactor, viewer.getMinDownsample()));
                viewer.setDownsampleFactor(newDownsampleFactor, e.getX(), e.getY());
            }
        });
        viewer.getView().addEventFilter(RotateEvent.ANY, e -> {
            if (!PathPrefs.useRotateGesturesProperty().get()) {
                return;
            }
            viewer.setRotation(viewer.getRotation() + Math.toRadians(e.getAngle()));
            e.consume();
        });
        viewer.getView().addEventFilter(ZoomEvent.ANY, e -> {
            if (!PathPrefs.useZoomGesturesProperty().get()) {
                return;
            }
            double zoomFactor = e.getZoomFactor();
            if (Double.isNaN(zoomFactor)) {
                return;
            }
            logger.debug("Zooming: " + e.getZoomFactor() + " (" + e.getTotalZoomFactor() + ")");
            viewer.setDownsampleFactor(viewer.getDownsampleFactor() / zoomFactor, e.getX(), e.getY());
            e.consume();
        });
        viewer.getView().addEventFilter(ScrollEvent.ANY, (EventHandler)new ScrollEventPanningFilter(viewer));
        viewer.getView().addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            if (e.isConsumed()) {
                return;
            }
            PathObject pathObject = viewer.getSelectedObject();
            if (pathObject != null) {
                if (pathObject.isTMACore()) {
                    TMACoreObject core = (TMACoreObject)pathObject;
                    if (e.getCode() == KeyCode.ENTER) {
                        this.qupath.getCommonActions().TMA_ADD_NOTE.handle(new ActionEvent(e.getSource(), e.getTarget()));
                        e.consume();
                    } else if (e.getCode() == KeyCode.BACK_SPACE) {
                        core.setMissing(!core.isMissing());
                        viewer.getHierarchy().fireObjectsChangedEvent((Object)this, Collections.singleton(core));
                        e.consume();
                    }
                } else if (pathObject.isAnnotation() && e.getCode() == KeyCode.ENTER) {
                    GuiTools.promptToSetActiveAnnotationProperties(viewer.getHierarchy());
                    e.consume();
                }
            }
            if (e.getCode() == KeyCode.S && e.getEventType() == KeyEvent.KEY_PRESSED) {
                PathPrefs.tempSelectionModeProperty().set(true);
            }
        });
        viewer.getView().addEventHandler(KeyEvent.KEY_RELEASED, e -> PathPrefs.tempSelectionModeProperty().set(false));
    }

    public void detachActiveViewerFromGrid() {
        this.detachViewerFromGrid(this.getActiveViewer());
    }

    public void attachActiveViewerToGrid() {
        this.attachViewerToGrid(this.getActiveViewer());
    }

    public void detachViewerFromGrid(QuPathViewer viewer) {
        if (viewer == null) {
            Dialogs.showWarningNotification((String)"Attach viewer", (String)"Viewer is null - cannot detach from the viewer grid");
        } else if (this.splitPaneGrid.isDetached(viewer)) {
            Dialogs.showWarningNotification((String)"Attach viewer", (String)"Viewer is already detached from the viewer grid");
        } else {
            this.splitPaneGrid.detachViewer(viewer);
        }
    }

    public void attachViewerToGrid(QuPathViewer viewer) {
        if (viewer == null) {
            Dialogs.showWarningNotification((String)"Attach viewer", (String)"Viewer is null - cannot attach to the viewer grid");
        } else if (this.splitPaneGrid.isDetached(viewer)) {
            this.splitPaneGrid.attachViewer(viewer);
        } else {
            Dialogs.showWarningNotification((String)"Attach viewer", (String)"Viewer can't be added to the viewer grid");
        }
    }

    private void setViewerPopupMenu(QuPathViewerPlus viewer) {
        ContextMenu popup = new ContextMenu();
        CommonActions commonActions = this.qupath.getCommonActions();
        ViewerActions viewerManagerActions = this.qupath.getViewerActions();
        MenuItem miAddRow = new MenuItem(QuPathResources.getString("Action.View.Multiview.addRow"));
        miAddRow.setOnAction(e -> this.addRow(viewer));
        MenuItem miAddColumn = new MenuItem(QuPathResources.getString("Action.View.Multiview.addColumn"));
        miAddColumn.setOnAction(e -> this.addColumn(viewer));
        MenuItem miRemoveRow = new MenuItem(QuPathResources.getString("Action.View.Multiview.removeRow"));
        miRemoveRow.setOnAction(e -> this.removeRow(viewer));
        MenuItem miRemoveColumn = new MenuItem(QuPathResources.getString("Action.View.Multiview.removeColumn"));
        miRemoveColumn.setOnAction(e -> this.removeColumn(viewer));
        MenuItem miCloseViewer = new MenuItem(QuPathResources.getString("Action.View.Multiview.closeViewer"));
        miCloseViewer.setOnAction(e -> this.qupath.closeViewer(viewer));
        MenuItem miResizeGrid = new MenuItem(QuPathResources.getString("Action.View.Multiview.resetGridSize"));
        miResizeGrid.setOnAction(e -> this.resetGridSize());
        Menu menuGrid = MenuTools.createMenu("Action.View.Multiview.gridMenu", viewerManagerActions.VIEWER_GRID_1x1, viewerManagerActions.VIEWER_GRID_1x2, viewerManagerActions.VIEWER_GRID_2x1, viewerManagerActions.VIEWER_GRID_2x2, viewerManagerActions.VIEWER_GRID_3x3, null, miAddRow, miAddColumn, null, miRemoveRow, miRemoveColumn, null, miResizeGrid);
        MenuItem miDetachViewer = ActionTools.createMenuItem(viewerManagerActions.DETACH_VIEWER);
        MenuItem miAttachViewer = ActionTools.createMenuItem(viewerManagerActions.ATTACH_VIEWER);
        MenuItem miToggleSync = ActionTools.createCheckMenuItem(viewerManagerActions.TOGGLE_SYNCHRONIZE_VIEWERS, null);
        MenuItem miMatchResolutions = ActionTools.createMenuItem(viewerManagerActions.MATCH_VIEWER_RESOLUTIONS);
        Menu menuMultiview = MenuTools.createMenu("Menu.View.Multiview", menuGrid, null, miToggleSync, miMatchResolutions, null, miCloseViewer, null, miDetachViewer, miAttachViewer);
        Menu menuView = MenuTools.createMenu("Display", ActionTools.createCheckMenuItem(commonActions.SHOW_ANALYSIS_PANE, null), commonActions.BRIGHTNESS_CONTRAST, null, ActionTools.createAction(() -> Commands.setViewerDownsample(viewer, 0.25), "400%"), ActionTools.createAction(() -> Commands.setViewerDownsample(viewer, 1.0), "100%"), ActionTools.createAction(() -> Commands.setViewerDownsample(viewer, 2.0), "50%"), ActionTools.createAction(() -> Commands.setViewerDownsample(viewer, 10.0), "10%"), ActionTools.createAction(() -> Commands.setViewerDownsample(viewer, 100.0), "1%"));
        Menu menuTools = MenuTools.createMenu("Set tool", new Object[0]);
        CheckMenuItem miTMAValid = new CheckMenuItem("Set core valid");
        miTMAValid.setOnAction(e -> this.setTMACoreMissing(viewer.getHierarchy(), false));
        CheckMenuItem miTMAMissing = new CheckMenuItem("Set core missing");
        miTMAMissing.setOnAction(e -> this.setTMACoreMissing(viewer.getHierarchy(), true));
        Menu menuTMA = MenuTools.createMenu("Menu.TMA", miTMAValid, miTMAMissing, null, commonActions.TMA_ADD_NOTE, null, MenuTools.createMenu("General.add", this.qupath.createImageDataAction(imageData -> TMACommands.promptToAddRowBeforeSelected(imageData), "Add TMA row before"), this.qupath.createImageDataAction(imageData -> TMACommands.promptToAddRowAfterSelected(imageData), "Add TMA row after"), this.qupath.createImageDataAction(imageData -> TMACommands.promptToAddColumnBeforeSelected(imageData), "Add TMA column before"), this.qupath.createImageDataAction(imageData -> TMACommands.promptToAddColumnAfterSelected(imageData), "Add TMA column after")), MenuTools.createMenu("General.remove", this.qupath.createImageDataAction(imageData -> TMACommands.promptToDeleteTMAGridRow(imageData), "Remove TMA row"), this.qupath.createImageDataAction(imageData -> TMACommands.promptToDeleteTMAGridColumn(imageData), "column")));
        Menu menuSetClass = MenuTools.createMenu("Set classification", new Object[0]);
        OverlayActions overlayActions = this.qupath.getOverlayActions();
        Menu menuCells = MenuTools.createMenu("General.objects.cells", ActionTools.createCheckMenuItem(overlayActions.SHOW_CELL_BOUNDARIES_AND_NUCLEI), ActionTools.createCheckMenuItem(overlayActions.SHOW_CELL_NUCLEI), ActionTools.createCheckMenuItem(overlayActions.SHOW_CELL_BOUNDARIES), ActionTools.createCheckMenuItem(overlayActions.SHOW_CELL_CENTROIDS));
        MenuItem miRemoveSelectedObjects = new MenuItem(QuPathResources.getString("General.deleteObjects"));
        miRemoveSelectedObjects.setOnAction(e -> {
            PathObjectHierarchy hierarchy = viewer.getHierarchy();
            if (hierarchy == null) {
                return;
            }
            if (hierarchy.getSelectionModel().singleSelection()) {
                GuiTools.promptToRemoveSelectedObject(hierarchy.getSelectionModel().getSelectedObject(), hierarchy);
            } else {
                GuiTools.promptToClearAllSelectedObjects(viewer.getImageData());
            }
        });
        Menu menuAnnotations = GuiTools.populateAnnotationsMenu(this.qupath, MenuTools.createMenu("General.objects.annotations", new Object[0]));
        SeparatorMenuItem topSeparator = new SeparatorMenuItem();
        popup.setOnShowing(e -> {
            ImageData<BufferedImage> imageData = viewer.getImageData();
            if (imageData == null) {
                menuCells.setVisible(false);
            } else {
                menuCells.setVisible(!imageData.getHierarchy().getDetectionObjects().isEmpty());
            }
            Collection<PathObject> selectedObjects = viewer.getAllSelectedObjects();
            PathObject pathObject = viewer.getSelectedObject();
            menuTMA.setVisible(false);
            if (pathObject instanceof TMACoreObject) {
                TMACoreObject core = (TMACoreObject)pathObject;
                boolean isMissing = core.isMissing();
                miTMAValid.setSelected(!isMissing);
                miTMAMissing.setSelected(isMissing);
                menuTMA.setVisible(true);
            }
            if (imageData == null || imageData.getHierarchy().getSelectionModel().noSelection() || imageData.getHierarchy().getSelectionModel().getSelectedObject() instanceof TMACoreObject) {
                miRemoveSelectedObjects.setVisible(false);
            } else if (imageData.getHierarchy().getSelectionModel().singleSelection()) {
                miRemoveSelectedObjects.setText(QuPathResources.getString("General.deleteObject"));
                miRemoveSelectedObjects.setVisible(true);
            } else {
                miRemoveSelectedObjects.setText(QuPathResources.getString("General.deleteObjects"));
                miRemoveSelectedObjects.setVisible(true);
            }
            if (menuTools.getItems().isEmpty()) {
                menuTools.getItems().addAll(ViewerManager.createToolMenu(this.qupath.getToolManager()));
            }
            boolean hasAnnotations = pathObject instanceof PathAnnotationObject || !selectedObjects.isEmpty() && selectedObjects.stream().allMatch(PathObject::isAnnotation);
            this.updateSetAnnotationPathClassMenu(menuSetClass, (QuPathViewer)viewer);
            menuAnnotations.setVisible(hasAnnotations);
            topSeparator.setVisible(hasAnnotations || pathObject instanceof TMACoreObject);
            popup.setWidth(popup.getPrefWidth());
            if (viewer == null || this.splitPaneGrid == null) {
                miDetachViewer.setVisible(false);
                miAttachViewer.setVisible(false);
            } else if (this.splitPaneGrid.isDetached(viewer)) {
                miDetachViewer.setVisible(false);
                miAttachViewer.setVisible(true);
            } else {
                miDetachViewer.setVisible(true);
                miAttachViewer.setVisible(false);
            }
        });
        popup.getItems().addAll((Object[])new MenuItem[]{miRemoveSelectedObjects, menuTMA, menuSetClass, menuAnnotations, topSeparator, menuMultiview, menuCells, menuView, menuTools});
        popup.setAutoHide(true);
        CirclePopupMenu circlePopup = new CirclePopupMenu((Node)viewer.getView(), null);
        viewer.getView().addEventHandler(MouseEvent.MOUSE_PRESSED, e -> {
            if ((e.isPopupTrigger() || e.isSecondaryButtonDown()) && e.isShiftDown() && !this.qupath.getAvailablePathClasses().isEmpty()) {
                circlePopup.setAnimationDuration(Duration.millis((double)200.0));
                this.updateSetAnnotationPathClassMenu(circlePopup, (QuPathViewer)viewer);
                circlePopup.show(e.getScreenX(), e.getScreenY());
                e.consume();
                return;
            }
            if (circlePopup.isShown()) {
                circlePopup.hide();
            }
            if (e.isPopupTrigger() || e.isSecondaryButtonDown()) {
                popup.show(viewer.getView().getScene().getWindow(), e.getScreenX(), e.getScreenY());
                e.consume();
            }
        });
    }

    static List<MenuItem> createToolMenu(ToolManager toolManager) {
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        for (PathTool tool : toolManager.getTools()) {
            Action action = toolManager.getToolAction(tool);
            MenuItem mi = ActionTools.createCheckMenuItem(action);
            items.add(mi);
        }
        if (!items.isEmpty()) {
            items.add((MenuItem)new SeparatorMenuItem());
        }
        items.add(ActionTools.createCheckMenuItem(toolManager.getSelectionModeAction()));
        return items;
    }

    private void setTMACoreMissing(PathObjectHierarchy hierarchy, boolean setToMissing) {
        if (hierarchy == null) {
            return;
        }
        PathObject pathObject = hierarchy.getSelectionModel().getSelectedObject();
        ArrayList<TMACoreObject> changed = new ArrayList<TMACoreObject>();
        if (pathObject instanceof TMACoreObject) {
            TMACoreObject core = (TMACoreObject)pathObject;
            core.setMissing(setToMissing);
            changed.add(core);
            for (PathObject pathObject2 : hierarchy.getSelectionModel().getSelectedObjects()) {
                if (!(pathObject2 instanceof TMACoreObject) || (core = (TMACoreObject)pathObject2).isMissing() == setToMissing) continue;
                core.setMissing(setToMissing);
                changed.add(core);
            }
        }
        if (!changed.isEmpty()) {
            hierarchy.fireObjectsChangedEvent((Object)this.qupath, changed);
        }
    }

    private void updateSetAnnotationPathClassMenu(Menu menuSetClass, QuPathViewer viewer) {
        this.updateSetAnnotationPathClassMenu((ObservableList<MenuItem>)menuSetClass.getItems(), viewer, false);
        menuSetClass.setVisible(!menuSetClass.getItems().isEmpty());
    }

    private void updateSetAnnotationPathClassMenu(CirclePopupMenu menuSetClass, QuPathViewer viewer) {
        this.updateSetAnnotationPathClassMenu((ObservableList<MenuItem>)menuSetClass.getItems(), viewer, true);
    }

    private void updateSetAnnotationPathClassMenu(ObservableList<MenuItem> menuSetClassItems, QuPathViewer viewer, boolean useFancyIcons) {
        ObservableList<PathClass> availablePathClasses = this.qupath.getAvailablePathClasses();
        if (viewer == null || availablePathClasses.isEmpty() || viewer.getSelectedObject() == null || !viewer.getSelectedObject().isAnnotation() && !viewer.getSelectedObject().isTMACore()) {
            menuSetClassItems.clear();
            return;
        }
        int iconSize = 16;
        PathObject mainPathObject = viewer.getSelectedObject();
        PathClass currentClass = mainPathObject.getPathClass();
        ToggleGroup group = new ToggleGroup();
        ArrayList<RadioMenuItem> itemList = new ArrayList<RadioMenuItem>();
        RadioMenuItem selected = null;
        for (PathClass pathClass : availablePathClasses) {
            Rectangle shape;
            PathClass pathClassToSet = pathClass.getName() == null ? null : pathClass;
            String name = pathClass.getName() == null ? "None" : pathClass.toString();
            Action actionSetClass = new Action(name, e -> {
                ArrayList<PathObject> changed = new ArrayList<PathObject>();
                for (PathObject pathObject : viewer.getAllSelectedObjects()) {
                    if (pathObject.getPathClass() == pathClassToSet) continue;
                    pathObject.setPathClass(pathClassToSet);
                    changed.add(pathObject);
                }
                if (!changed.isEmpty()) {
                    viewer.getHierarchy().fireObjectClassificationsChangedEvent((Object)this, changed);
                }
            });
            if (useFancyIcons) {
                r = new Ellipse((double)iconSize / 2.0, (double)iconSize / 2.0, (double)iconSize, (double)iconSize);
                if ("None".equals(name)) {
                    r.setFill((Paint)Color.rgb((int)255, (int)255, (int)255, (double)0.75));
                } else {
                    r.setFill((Paint)ColorToolsFX.getCachedColor(pathClass.getColor()));
                }
                r.setOpacity(0.8);
                DropShadow effect = new DropShadow(6.0, -3.0, 3.0, Color.GRAY);
                r.setEffect((Effect)effect);
                shape = r;
            } else {
                r = new Rectangle(0.0, 0.0, 8.0, 8.0);
                r.setFill((Paint)("None".equals(name) ? Color.TRANSPARENT : ColorToolsFX.getCachedColor(pathClass.getColor())));
                shape = r;
            }
            RadioMenuItem item = ActionUtils.createRadioMenuItem((Action)actionSetClass);
            item.setMnemonicParsing(false);
            item.graphicProperty().unbind();
            item.setGraphic((Node)shape);
            item.setToggleGroup(group);
            itemList.add(item);
            if (pathClassToSet != currentClass) continue;
            selected = item;
        }
        group.selectToggle(selected);
        menuSetClassItems.setAll(itemList);
    }

    private static class ViewerPosition {
        private double x;
        private double y;
        private double downsample;
        private double rotation;
        private int z;
        private int t;

        private ViewerPosition() {
            this.reset();
        }

        private ViewerPosition(QuPathViewer viewer) {
            this.update(viewer);
        }

        private void update(QuPathViewer viewer) {
            if (viewer == null || viewer.getImageData() == null) {
                this.reset();
            } else {
                this.x = viewer.getCenterPixelX();
                this.y = viewer.getCenterPixelY();
                this.downsample = viewer.getDownsampleFactor();
                this.rotation = viewer.getRotation();
                this.z = viewer.getZPosition();
                this.t = viewer.getTPosition();
            }
        }

        private void reset() {
            this.x = Double.NaN;
            this.y = Double.NaN;
            this.downsample = Double.NaN;
            this.rotation = Double.NaN;
            this.z = -1;
            this.t = -1;
        }
    }

    class SplitPaneGrid {
        private SplitPane splitPaneMain = new SplitPane();
        private List<SplitPane> splitPaneRows = new ArrayList<SplitPane>();

        SplitPaneGrid(Node node) {
            this.splitPaneMain.setOrientation(Orientation.VERTICAL);
            SplitPane splitRow = new SplitPane();
            splitRow.setOrientation(Orientation.HORIZONTAL);
            splitRow.getItems().add((Object)node);
            this.splitPaneRows.add(splitRow);
            this.splitPaneMain.getItems().add((Object)splitRow);
        }

        SplitPane getMainSplitPane() {
            return this.splitPaneMain;
        }

        void addRow(int position) {
            SplitPane newRow = new SplitPane();
            newRow.setOrientation(Orientation.HORIZONTAL);
            newRow.getItems().clear();
            SplitPane firstRow = this.splitPaneRows.get(0);
            for (int i = 0; i < firstRow.getItems().size(); ++i) {
                newRow.getItems().add((Object)ViewerManager.this.createViewer().getView());
            }
            this.splitPaneRows.add(position, newRow);
            this.splitPaneMain.getItems().add(position, (Object)newRow);
            this.resetDividers(this.splitPaneMain);
            this.refreshDividerBindings();
        }

        boolean removeRow(int row) {
            if (row < 0 || row >= this.splitPaneRows.size() || this.splitPaneRows.size() == 1) {
                logger.error("Cannot remove row {} from grid with {} rows", (Object)row, (Object)this.splitPaneRows.size());
                return false;
            }
            SplitPane splitPane = this.splitPaneRows.remove(row);
            this.splitPaneMain.getItems().remove((Object)splitPane);
            this.refreshDividerBindings();
            return true;
        }

        public void resetGridSize() {
            this.resetDividers(this.splitPaneRows.get(0));
            this.resetDividers(this.splitPaneMain);
        }

        void resetDividers(SplitPane splitPane) {
            int n = splitPane.getItems().size();
            if (n <= 1) {
                return;
            }
            if (n == 2) {
                splitPane.setDividerPosition(0, 0.5);
                return;
            }
            double[] positions = new double[n - 1];
            for (int i = 0; i < positions.length; ++i) {
                positions[i] = ((double)i + 1.0) / (double)n;
            }
            splitPane.setDividerPositions(positions);
        }

        boolean removeColumn(int col) {
            if (col < 0 || col >= this.nCols() || this.nCols() == 1) {
                logger.error("Cannot remove column {} from grid with {} columns", (Object)col, (Object)this.nCols());
                return false;
            }
            for (SplitPane splitRow : this.splitPaneRows) {
                splitRow.getItems().remove(col);
            }
            this.refreshDividerBindings();
            return true;
        }

        int countOpenViewersForRow(int row) {
            int count = 0;
            for (QuPathViewer viewer : ViewerManager.this.getAllViewers()) {
                if (row != this.getRow((Node)viewer.getView()) || !viewer.hasServer()) continue;
                ++count;
            }
            return count;
        }

        int countOpenViewersForColumn(int col) {
            int count = 0;
            for (QuPathViewer viewer : ViewerManager.this.getAllViewers()) {
                if (col != this.getColumn((Node)viewer.getView()) || !viewer.hasServer()) continue;
                ++count;
            }
            return count;
        }

        void refreshDividerBindings() {
            SplitPane firstRow = this.splitPaneRows.get(0);
            for (int r = 1; r < this.splitPaneRows.size(); ++r) {
                SplitPane splitRow = this.splitPaneRows.get(r);
                for (int c = 0; c < splitRow.getDividers().size(); ++c) {
                    ((SplitPane.Divider)splitRow.getDividers().get(c)).positionProperty().bindBidirectional((Property)((SplitPane.Divider)firstRow.getDividers().get(c)).positionProperty());
                }
            }
        }

        void addColumn(int position) {
            for (SplitPane splitRow : this.splitPaneRows) {
                splitRow.getItems().add(position, (Object)ViewerManager.this.createViewer().getView());
            }
            this.resetDividers(this.splitPaneRows.get(0));
            this.refreshDividerBindings();
        }

        public int getRow(QuPathViewer viewer) {
            return this.getRow((Node)viewer.getView());
        }

        public int getRow(Node node) {
            int count = 0;
            for (SplitPane row : this.splitPaneRows) {
                int ind = row.getItems().indexOf((Object)node);
                if (ind >= 0) {
                    return count;
                }
                ++count;
            }
            return -1;
        }

        public int getColumn(QuPathViewer viewer) {
            return this.getColumn((Node)viewer.getView());
        }

        public int getColumn(Node node) {
            for (SplitPane row : this.splitPaneRows) {
                int ind = row.getItems().indexOf((Object)node);
                if (ind < 0) continue;
                return ind;
            }
            return -1;
        }

        public int nRows() {
            return this.splitPaneRows.size();
        }

        public int nCols() {
            return this.splitPaneRows.get(0).getDividers().size() + 1;
        }

        public boolean isDetached(QuPathViewer viewer) {
            return this.getRow(viewer) < 0;
        }

        public boolean attachViewer(QuPathViewer viewer) {
            QuPathViewer closedViewer = ViewerManager.this.getAllViewers().stream().filter(v -> !v.hasServer() && !this.isDetached((QuPathViewer)v)).sorted(Comparator.comparingInt(vv -> this.getRow((QuPathViewer)vv)).thenComparing(vv -> this.getColumn((QuPathViewer)vv))).findFirst().orElse(null);
            if (closedViewer == null) {
                Dialogs.showErrorMessage((String)"Attach viewer", (String)"Cannot attach viewer - please close an existing viewer in the grid first");
                return false;
            }
            double[] positions = this.splitPaneRows.get(0).getDividerPositions();
            int row = this.getRow(closedViewer);
            int col = this.getColumn(closedViewer);
            Window stage = FXUtils.getWindow((Node)viewer.getView());
            stage.hide();
            stage.getScene().setRoot((Parent)new BorderPane());
            stage.fireEvent((Event)new WindowEvent(stage, WindowEvent.WINDOW_CLOSE_REQUEST));
            this.splitPaneRows.get(row).getItems().set(col, (Object)viewer.getView());
            ViewerManager.this.refreshViewerList();
            this.refreshDividerBindings();
            ViewerManager.this.setActiveViewer(viewer);
            this.splitPaneRows.get(0).setDividerPositions(positions);
            return true;
        }

        public boolean detachViewer(QuPathViewer viewer) {
            int row = this.getRow((Node)viewer.getView());
            int col = this.getColumn((Node)viewer.getView());
            if (row >= 0 && col >= 0) {
                double[] positions = this.splitPaneRows.get(0).getDividerPositions();
                SplitPane splitRow = this.splitPaneRows.get(row);
                splitRow.getItems().set(col, (Object)ViewerManager.this.createViewer().getView());
                this.refreshDividerBindings();
                Stage stage = new Stage();
                FXUtils.addCloseWindowShortcuts((Stage)stage);
                BorderPane pane = new BorderPane((Node)viewer.getView());
                Scene scene = new Scene((Parent)pane);
                stage.setScene(scene);
                stage.initOwner((Window)ViewerManager.this.qupath.getStage());
                stage.titleProperty().bind((ObservableValue)this.createDetachedViewerTitleBinding(viewer));
                stage.addEventFilter(KeyEvent.ANY, this::keyEventFilter);
                stage.addEventFilter(MouseEvent.ANY, this::mouseEventFilter);
                stage.addEventHandler(KeyEvent.ANY, this::propagateKeyEventToMainWindow);
                stage.setOnCloseRequest(e -> {
                    if (FXUtils.getWindow((Node)viewer.getView()) == null) {
                        logger.debug("Closing stage after viewer has been removed");
                        return;
                    }
                    if (ViewerManager.this.viewers.size() == 1 && ViewerManager.this.viewers.contains((Object)viewer)) {
                        logger.error("The last viewer can't be closed!");
                        e.consume();
                        return;
                    }
                    if (ViewerManager.this.qupath.closeViewer(viewer)) {
                        ArrayList<QuPathViewer> allOtherViewers = new ArrayList<QuPathViewer>((Collection<QuPathViewer>)ViewerManager.this.getAllViewers());
                        allOtherViewers.remove(viewer);
                        if (!allOtherViewers.isEmpty()) {
                            ViewerManager.this.setActiveViewer(allOtherViewers.get(0));
                        }
                        stage.close();
                        pane.getChildren().clear();
                        ViewerManager.this.refreshViewerList();
                    }
                    e.consume();
                });
                stage.show();
                ViewerManager.this.refreshViewerList();
                this.splitPaneRows.get(0).setDividerPositions(positions);
                return true;
            }
            logger.warn("Viewer is already detached!");
            return false;
        }

        private StringBinding createDetachedViewerTitleBinding(QuPathViewer viewer) {
            return Bindings.createStringBinding(() -> ViewerManager.this.qupath.getDisplayedImageName(viewer.getImageData()), (Observable[])new Observable[]{viewer.imageDataProperty(), PathPrefs.maskImageNamesProperty(), ViewerManager.this.qupath.projectProperty(), ViewerManager.this.refreshTitleProperty});
        }

        private void keyEventFilter(KeyEvent e) {
            if (((Boolean)ViewerManager.this.qupath.uiBlocked().getValue()).booleanValue()) {
                e.consume();
            }
        }

        private void mouseEventFilter(MouseEvent e) {
            if (((Boolean)ViewerManager.this.qupath.uiBlocked().getValue()).booleanValue()) {
                e.consume();
            }
        }

        private void propagateKeyEventToMainWindow(KeyEvent e) {
            EventHandler handler;
            if (!e.isConsumed() && e.getEventType() == KeyEvent.KEY_RELEASED && (handler = ViewerManager.this.qupath.getStage().getScene().getOnKeyReleased()) != null) {
                handler.handle((Event)e);
            }
        }
    }
}

