/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer;

import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Separator;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import qupath.fx.utils.FXUtils;
import qupath.lib.common.GeneralTools;

class ViewerDimensionControls {
    private final IntegerProperty zPositionProperty = new SimpleIntegerProperty();
    private final IntegerProperty zMaxProperty = new SimpleIntegerProperty();
    private final IntegerProperty tPositionProperty = new SimpleIntegerProperty();
    private final IntegerProperty tMaxProperty = new SimpleIntegerProperty();
    private final DoubleProperty contentOpacityProperty = new SimpleDoubleProperty(1.0);
    private final Spinner<Integer> spinnerZ = this.createSpinner(this.zPositionProperty, this.zMaxProperty, "Z-slice");
    private final Spinner<Integer> spinnerT = this.createSpinner(this.tPositionProperty, this.tMaxProperty, "Time point");
    private final ProgressBar progressZ = this.createProgressBar(this.zPositionProperty, this.zMaxProperty);
    private final ProgressBar progressT = this.createProgressBar(this.tPositionProperty, this.tMaxProperty);
    private final Label labelZ = this.createLabel("Z: ", (Node)this.spinnerZ);
    private final Label labelT = this.createLabel("Time: ", (Node)this.spinnerT);
    private final GridPane pane = new GridPane();

    ViewerDimensionControls() {
        this.pane.getStyleClass().addAll((Object[])new String[]{"viewer-overlay", "viewer-dims"});
        this.pane.setOnMouseEntered(e -> this.contentOpacityProperty.set(1.0));
        this.pane.setOnMouseExited(e -> this.contentOpacityProperty.set(0.5));
        this.pane.setVgap(4.0);
        this.zMaxProperty.addListener(this::handleChange);
        this.tMaxProperty.addListener(this::handleChange);
        this.updateContents();
    }

    private ProgressBar createProgressBar(IntegerProperty property, IntegerProperty maxProperty) {
        ProgressBar progress = new ProgressBar();
        progress.setMaxWidth(Double.MAX_VALUE);
        progress.setPrefHeight(10.0);
        progress.progressProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> property.doubleValue() / (double)(maxProperty.get() - 1), (Observable[])new Observable[]{property, maxProperty}));
        progress.opacityProperty().bind((ObservableValue)this.contentOpacityProperty);
        progress.setOnMouseClicked(e -> this.updateFromProgress(progress, e.getX(), property, maxProperty));
        progress.setOnMouseDragged(e -> this.updateFromProgress(progress, e.getX(), property, maxProperty));
        return progress;
    }

    private void updateFromProgress(ProgressBar progress, double x, IntegerProperty prop, IntegerProperty max) {
        int val = (int)Math.round(x / progress.getWidth() * max.doubleValue());
        prop.setValue((Number)GeneralTools.clipValue((int)val, (int)0, (int)max.get()));
    }

    private Spinner<Integer> createSpinner(IntegerProperty property, IntegerProperty maxProperty, String name) {
        SpinnerValueFactory.IntegerSpinnerValueFactory factory = new SpinnerValueFactory.IntegerSpinnerValueFactory(0, 1);
        maxProperty.addListener((v, o, n) -> factory.setMax(Math.max(0, n.intValue() - 1)));
        Spinner spinner = new Spinner((SpinnerValueFactory)factory);
        factory.valueProperty().addListener((v, o, n) -> property.setValue((Number)n));
        property.addListener((v, o, n) -> factory.setValue((Object)((Integer)n)));
        spinner.setPrefWidth(70.0);
        spinner.setEditable(true);
        FXUtils.resetSpinnerNullToPrevious((Spinner)spinner);
        Tooltip tooltip = new Tooltip();
        tooltip.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> name + " (" + property.get() + "/" + maxProperty.get() + ")", (Observable[])new Observable[]{property, maxProperty}));
        spinner.setTooltip(tooltip);
        spinner.opacityProperty().bind((ObservableValue)this.contentOpacityProperty);
        return spinner;
    }

    private Label createLabel(String text, Node node) {
        Label label = new Label(text);
        label.setLabelFor(node);
        label.setContentDisplay(ContentDisplay.RIGHT);
        label.setAlignment(Pos.CENTER_RIGHT);
        label.setMaxWidth(Double.MAX_VALUE);
        label.opacityProperty().bind((ObservableValue)this.contentOpacityProperty);
        return label;
    }

    private void handleChange(ObservableValue<? extends Number> val, Number oldValue, Number newValue) {
        this.updateContents();
    }

    private void updateContents() {
        this.pane.getChildren().clear();
        int row = 0;
        if (this.tMaxProperty.get() > 1) {
            this.pane.addRow(row++, new Node[]{this.labelT, this.spinnerT});
            this.pane.add((Node)this.progressT, 0, row++, 2, 1);
        }
        if (this.zMaxProperty.get() > 1) {
            if (row > 0) {
                this.pane.add((Node)new Separator(), 0, row++, 2, 1);
            }
            this.pane.addRow(row++, new Node[]{this.labelZ, this.spinnerZ});
            this.pane.add((Node)this.progressZ, 0, row++, 2, 1);
        }
        this.pane.setVisible(!this.pane.getChildren().isEmpty());
    }

    IntegerProperty zMaxProperty() {
        return this.zMaxProperty;
    }

    IntegerProperty tMaxProperty() {
        return this.tMaxProperty;
    }

    IntegerProperty zPositionProperty() {
        return this.zPositionProperty;
    }

    IntegerProperty tPositionProperty() {
        return this.tPositionProperty;
    }

    Pane getPane() {
        return this.pane;
    }
}

