/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer;

import javafx.event.EventHandler;
import javafx.scene.input.ScrollEvent;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.gui.viewer.tools.PathTools;

class ScrollEventPanningFilter
implements EventHandler<ScrollEvent> {
    private QuPathViewer viewer;
    private boolean lastTouchEvent = false;
    private double deltaX = 0.0;
    private double deltaY = 0.0;
    private long lastTimestamp = 0L;

    ScrollEventPanningFilter(QuPathViewer viewer) {
        this.viewer = viewer;
    }

    public void handle(ScrollEvent e) {
        boolean wouldRatherDoSomethingElse;
        boolean bl = wouldRatherDoSomethingElse = e.getTouchCount() == 0 && (!PathPrefs.useScrollGesturesProperty().get() || e.isShiftDown() || e.isShortcutDown());
        if (wouldRatherDoSomethingElse) {
            return;
        }
        if (e.isInertia()) {
            e.consume();
            return;
        }
        boolean bl2 = this.lastTouchEvent = e.getTouchCount() != 0;
        if (!this.lastTouchEvent && !PathPrefs.useScrollGesturesProperty().get() || e.isShiftDown() || e.isShortcutDown()) {
            return;
        }
        if (this.lastTouchEvent && this.viewer.getActiveTool() != PathTools.MOVE) {
            e.consume();
            return;
        }
        if (!this.lastTouchEvent && e.getEventType() == ScrollEvent.SCROLL_FINISHED) {
            if (System.currentTimeMillis() - this.lastTimestamp < 100L) {
                this.viewer.requestStartMoving(this.deltaX, this.deltaY);
                this.viewer.requestDecelerate();
            }
            this.deltaX = 0.0;
            this.deltaY = 0.0;
            e.consume();
            return;
        }
        double dx = e.getDeltaX() * this.viewer.getDownsampleFactor();
        double dy = e.getDeltaY() * this.viewer.getDownsampleFactor();
        if (PathPrefs.invertScrollingProperty().get()) {
            dx = -dx;
            dy = -dy;
        }
        if (this.viewer.isRotated()) {
            double cosTheta = Math.cos(-this.viewer.getRotation());
            double sinTheta = Math.sin(-this.viewer.getRotation());
            double dx2 = cosTheta * dx - sinTheta * dy;
            double dy2 = sinTheta * dx + cosTheta * dy;
            dx = dx2;
            dy = dy2;
        }
        this.viewer.setCenterPixelLocation(this.viewer.getCenterPixelX() - dx, this.viewer.getCenterPixelY() - dy);
        this.deltaX = dx;
        this.deltaY = dy;
        this.lastTimestamp = System.currentTimeMillis();
        e.consume();
    }
}

