/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer;

import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.FontWeight;
import javafx.scene.text.TextAlignment;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tools.ColorToolsFX;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.gui.viewer.QuPathViewerListener;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.objects.PathObject;

class Scalebar
implements QuPathViewerListener {
    private QuPathViewer viewer;
    private double preferredLength;
    private double[] permittedScales = new double[]{0.1, 0.25, 0.5, 1.0, 2.0, 5.0, 10.0, 20.0, 50.0, 100.0, 200.0, 250.0, 400.0, 500.0, 800.0, 1000.0, 2000.0, 5000.0, 10000.0, 20000.0, 50000.0, 100000.0};
    protected static DecimalFormat df = new DecimalFormat("#.##");
    private double scaledLength = Double.NaN;
    private double scaledLengthPixels = Double.NaN;
    private double lastLineThickness = Double.NaN;
    private Label label = new Label();
    private Canvas canvas = new Canvas();
    private Color color = ColorToolsFX.TRANSLUCENT_BLACK_FX;
    private double lastDownsample = Double.NaN;

    public Scalebar(QuPathViewer viewer) {
        this(viewer, 100.0);
    }

    public Scalebar(QuPathViewer viewer, double preferredLength) {
        this.viewer = viewer;
        this.preferredLength = preferredLength;
        viewer.addViewerListener(this);
        this.label.setTextAlignment(TextAlignment.CENTER);
        StringBinding fontBinding = Bindings.createStringBinding(() -> {
            PathPrefs.FontSize fontSize = (PathPrefs.FontSize)((Object)((Object)PathPrefs.scalebarFontSizeProperty().get()));
            if (fontSize == null) {
                return null;
            }
            String style = "-fx-font-size: " + fontSize.getFontSize();
            FontWeight fontWeight = (FontWeight)PathPrefs.scalebarFontWeightProperty().get();
            if (fontWeight == null) {
                return style;
            }
            return style + "; -fx-font-weight: " + fontWeight.getWeight();
        }, (Observable[])new Observable[]{PathPrefs.scalebarFontSizeProperty(), PathPrefs.scalebarFontWeightProperty()});
        this.label.styleProperty().bind((ObservableValue)fontBinding);
        PathPrefs.scalebarLineWidthProperty().addListener((v, o, n) -> this.updateScalebar());
    }

    public void setVisible(boolean visible) {
        this.label.setVisible(visible);
    }

    public boolean isVisible() {
        return this.label.isVisible();
    }

    protected double getPermittedScale(double preferredLength) {
        double minDiff = Double.POSITIVE_INFINITY;
        double scaleValue = Double.NaN;
        for (double d : this.permittedScales) {
            double tempDiff = Math.abs(d - preferredLength);
            if (!(tempDiff < minDiff)) continue;
            scaleValue = d;
            minDiff = tempDiff;
        }
        return scaleValue;
    }

    public void updateScalebar() {
        if (this.viewer == null) {
            // empty if block
        }
        try {
            double lineThickness = PathPrefs.scalebarLineWidthProperty().get();
            double currentDownsample = this.viewer.getDownsampleFactor();
            if (this.lastDownsample == currentDownsample && this.lastLineThickness == lineThickness) {
                return;
            }
            ImageServer<BufferedImage> server = this.viewer.getServer();
            double scale = 1.0;
            String unit = "px";
            PixelCalibration cal = server.getPixelCalibration();
            if (cal.hasPixelSizeMicrons()) {
                scale = cal.getPixelWidthMicrons();
                unit = GeneralTools.micrometerSymbol();
            }
            double pxSize = scale * currentDownsample;
            this.scaledLength = this.getPermittedScale(pxSize * this.preferredLength);
            this.scaledLengthPixels = this.scaledLength / pxSize;
            String labelText = df.format(this.scaledLength) + " " + unit;
            if (this.scaledLength >= 1000.0 && GeneralTools.micrometerSymbol().equals(unit)) {
                labelText = df.format(this.scaledLength / 1000.0) + " mm";
            }
            double width = this.scaledLengthPixels;
            this.lastLineThickness = lineThickness;
            if (lineThickness > 0.0) {
                double totalThickness = lineThickness;
                this.canvas.setWidth(width + 2.0);
                this.canvas.setHeight(totalThickness);
                GraphicsContext gc = this.canvas.getGraphicsContext2D();
                gc.clearRect(0.0, 0.0, this.canvas.getWidth(), this.canvas.getHeight());
                gc.save();
                boolean x = true;
                gc.setStroke((Paint)this.color);
                gc.setLineWidth(lineThickness);
                gc.strokeLine((double)x, totalThickness / 2.0, (double)x + width, totalThickness / 2.0);
                gc.restore();
            } else {
                GraphicsContext gc = this.canvas.getGraphicsContext2D();
                gc.clearRect(0.0, 0.0, this.canvas.getWidth(), this.canvas.getHeight());
            }
            this.label.setText(labelText);
            this.lastDownsample = currentDownsample;
        }
        catch (NullPointerException e) {
            this.label.setText("");
        }
    }

    public void setTextColor(Color color) {
        if (this.color == color) {
            return;
        }
        this.color = color;
        this.label.setTextFill((Paint)color);
        this.lastDownsample = Double.NaN;
        this.updateScalebar();
    }

    @Override
    public void imageDataChanged(QuPathViewer viewer, ImageData<BufferedImage> imageDataOld, ImageData<BufferedImage> imageDataNew) {
        this.lastDownsample = Double.NaN;
        this.updateScalebar();
    }

    @Override
    public void visibleRegionChanged(QuPathViewer viewer, Shape shape) {
        this.updateScalebar();
    }

    public Node getNode() {
        this.label.setGraphic((Node)this.canvas);
        this.label.setTextAlignment(TextAlignment.CENTER);
        this.label.setContentDisplay(ContentDisplay.TOP);
        return this.label;
    }

    @Override
    public void selectedObjectChanged(QuPathViewer viewer, PathObject pathObjectSelected) {
    }

    @Override
    public void viewerClosed(QuPathViewer viewer) {
        this.viewer = null;
    }
}

