/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import qupath.lib.images.ImageData;
import qupath.lib.objects.PathAnnotationObject;
import qupath.lib.objects.PathObject;
import qupath.lib.regions.ImageRegion;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.interfaces.ROI;

public interface RegionFilter
extends BiPredicate<ImageData<?>, RegionRequest> {
    private static boolean overlapsObjects(Collection<? extends PathObject> pathObjects, ImageRegion region) {
        List<ROI> rois = pathObjects.stream().map(PathObject::getROI).filter(Objects::nonNull).sorted(Comparator.comparingInt(ROI::getNumPoints)).toList();
        for (ROI r : rois) {
            if (!r.intersects(region)) continue;
            return true;
        }
        return false;
    }

    public static enum StandardRegionFilters implements RegionFilter
    {
        EVERYWHERE,
        ANY_OBJECTS,
        ANY_ANNOTATIONS,
        ANY_OBJECTS_BOUNDS,
        ANY_ANNOTATIONS_BOUNDS,
        IMAGE;


        public String toString() {
            return switch (this.ordinal()) {
                case 0 -> "Everywhere";
                case 5 -> "Image (non-empty regions)";
                case 1 -> "Any object ROI";
                case 2 -> "Any annotation ROI";
                case 3 -> "Any object bounds (fast)";
                case 4 -> "Any annotation bounds (fast)";
                default -> "Unknown";
            };
        }

        @Override
        public boolean test(ImageData<?> imageData, RegionRequest region) {
            return switch (this.ordinal()) {
                case 2 -> {
                    Collection annotations = imageData.getHierarchy().getAnnotationsForRegion((ImageRegion)region, null);
                    yield RegionFilter.overlapsObjects(annotations, (ImageRegion)region);
                }
                case 1 -> {
                    Collection pathObjects = imageData.getHierarchy().getAllObjectsForRegion((ImageRegion)region, null);
                    yield RegionFilter.overlapsObjects(pathObjects, (ImageRegion)region);
                }
                case 5 -> {
                    if (!imageData.getServer().isEmptyRegion(region)) {
                        yield true;
                    }
                    yield false;
                }
                case 3 -> imageData.getHierarchy().hasObjectsForRegion(null, (ImageRegion)region);
                case 4 -> imageData.getHierarchy().hasObjectsForRegion(PathAnnotationObject.class, (ImageRegion)region);
                default -> true;
            };
        }
    }
}

