/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer;

import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.text.TextAlignment;
import qupath.lib.gui.images.stores.DefaultImageRegionStore;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tools.ColorToolsFX;
import qupath.lib.gui.tools.CommandFinderTools;
import qupath.lib.gui.viewer.ImageOverview;
import qupath.lib.gui.viewer.OverlayOptions;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.gui.viewer.Scalebar;
import qupath.lib.gui.viewer.ViewerDimensionControls;
import qupath.lib.gui.viewer.ViewerPlusDisplayOptions;
import qupath.lib.gui.viewer.ZProjectOverlayControls;
import qupath.lib.images.servers.ImageServer;

public class QuPathViewerPlus
extends QuPathViewer {
    private final ViewerDimensionControls dimensionControls;
    private final ViewerPlusDisplayOptions viewerDisplayOptions;
    private final ChangeListener<Boolean> locationListener = (v, o, n) -> this.setLocationVisible((boolean)n);
    private final ChangeListener<Boolean> overviewListener = (v, o, n) -> this.setOverviewVisible((boolean)n);
    private final ChangeListener<Boolean> scalebarListener = (v, o, n) -> this.setScalebarVisible((boolean)n);
    private final AnchorPane basePane = new AnchorPane();
    private final ImageOverview overview = new ImageOverview(this);
    private final Scalebar scalebar = new Scalebar(this);
    private final ZProjectOverlayControls zProjectOverlayControls;
    private final BorderPane panelLocation = new BorderPane();
    private final Label labelLocation = new Label(" ");
    private final BooleanProperty useCalibratedLocationString = PathPrefs.useCalibratedLocationStringProperty();
    private final int padding = 10;

    public QuPathViewerPlus(DefaultImageRegionStore regionStore, OverlayOptions overlayOptions, ViewerPlusDisplayOptions viewerDisplayOptions) {
        super(regionStore, overlayOptions);
        this.dimensionControls = new ViewerDimensionControls();
        this.dimensionControls.zPositionProperty().bindBidirectional((Property)this.zPositionProperty());
        this.dimensionControls.tPositionProperty().bindBidirectional((Property)this.tPositionProperty());
        this.useCalibratedLocationString.addListener(v -> this.updateLocationString());
        Pane view = super.getView();
        view.getChildren().add((Object)this.basePane);
        this.basePane.prefWidthProperty().bind((ObservableValue)view.widthProperty());
        this.basePane.prefHeightProperty().bind((ObservableValue)view.heightProperty());
        view.addEventFilter(MouseEvent.MOUSE_MOVED, e -> this.updateLocationString());
        Node overviewNode = this.overview.getNode();
        this.basePane.getChildren().add((Object)overviewNode);
        AnchorPane.setTopAnchor((Node)overviewNode, (Double)10.0);
        AnchorPane.setRightAnchor((Node)overviewNode, (Double)10.0);
        this.labelLocation.setTextAlignment(TextAlignment.CENTER);
        StringBinding fontBinding = Bindings.createStringBinding(() -> {
            PathPrefs.FontSize temp = (PathPrefs.FontSize)((Object)((Object)PathPrefs.locationFontSizeProperty().get()));
            return temp == null ? null : "-fx-font-size: " + temp.getFontSize();
        }, (Observable[])new Observable[]{PathPrefs.locationFontSizeProperty()});
        this.labelLocation.styleProperty().bind((ObservableValue)fontBinding);
        this.panelLocation.getStyleClass().add((Object)"viewer-overlay");
        this.panelLocation.setMinSize(140.0, 40.0);
        this.panelLocation.setCenter((Node)this.labelLocation);
        this.panelLocation.setPadding(new Insets(5.0));
        this.basePane.getChildren().add((Object)this.panelLocation);
        AnchorPane.setBottomAnchor((Node)this.panelLocation, (Double)10.0);
        AnchorPane.setRightAnchor((Node)this.panelLocation, (Double)10.0);
        Node scalebarNode = this.scalebar.getNode();
        this.basePane.getChildren().add((Object)scalebarNode);
        AnchorPane.setBottomAnchor((Node)scalebarNode, (Double)10.0);
        AnchorPane.setLeftAnchor((Node)scalebarNode, (Double)10.0);
        CommandFinderTools.CommandBarDisplay commandBarDisplay = (CommandFinderTools.CommandBarDisplay)((Object)CommandFinderTools.commandBarDisplayProperty().getValue());
        this.setSpinnersPosition(!commandBarDisplay.equals((Object)CommandFinderTools.CommandBarDisplay.NEVER));
        this.basePane.getChildren().addAll((Object[])new Node[]{this.dimensionControls.getPane()});
        this.updateSpinners();
        this.zPositionProperty().addListener(v -> this.updateLocationString());
        this.tPositionProperty().addListener(v -> this.updateLocationString());
        this.viewerDisplayOptions = viewerDisplayOptions;
        this.setLocationVisible(viewerDisplayOptions.getShowLocation());
        this.setOverviewVisible(viewerDisplayOptions.getShowOverview());
        this.setScalebarVisible(viewerDisplayOptions.getShowScalebar());
        viewerDisplayOptions.showLocationProperty().addListener(this.locationListener);
        viewerDisplayOptions.showOverviewProperty().addListener(this.overviewListener);
        viewerDisplayOptions.showScalebarProperty().addListener(this.scalebarListener);
        this.zProjectOverlayControls = new ZProjectOverlayControls(this, viewerDisplayOptions.showZProjectControlsProperty());
    }

    private void updateSpinners() {
        if (this.dimensionControls == null) {
            return;
        }
        ImageServer<BufferedImage> server = this.getServer();
        if (server != null) {
            this.dimensionControls.zMaxProperty().set(server.nZSlices());
            this.dimensionControls.zPositionProperty().set(server.nZSlices() / 2);
            this.dimensionControls.tMaxProperty().set(server.nTimepoints());
            this.dimensionControls.tPositionProperty().set(server.nTimepoints() / 2);
        } else {
            this.dimensionControls.zMaxProperty().set(0);
            this.dimensionControls.tMaxProperty().set(0);
        }
    }

    @Override
    public void initializeForServer(ImageServer<BufferedImage> server) {
        super.initializeForServer(server);
        this.updateSpinners();
    }

    private void setLocationVisible(boolean showLocation) {
        this.panelLocation.setVisible(showLocation);
    }

    public boolean isLocationVisible() {
        return this.panelLocation.isVisible();
    }

    private void setScalebarVisible(boolean scalebarVisible) {
        this.scalebar.setVisible(scalebarVisible);
    }

    public boolean isScalebarVisible() {
        return this.scalebar.isVisible();
    }

    private void setOverviewVisible(boolean overviewVisible) {
        this.overview.setVisible(overviewVisible);
    }

    public boolean isOverviewVisible() {
        return this.overview.isVisible();
    }

    public void setSpinnersPosition(boolean down) {
        double spinnersTopPadding = 10.0 + (double)(down ? 20 : 0);
        Pane pane = this.dimensionControls.getPane();
        AnchorPane.setTopAnchor((Node)pane, (Double)spinnersTopPadding);
        AnchorPane.setLeftAnchor((Node)pane, (Double)10.0);
    }

    @Override
    public void closeViewer() {
        super.closeViewer();
        this.viewerDisplayOptions.showLocationProperty().removeListener(this.locationListener);
        this.viewerDisplayOptions.showOverviewProperty().removeListener(this.overviewListener);
        this.viewerDisplayOptions.showScalebarProperty().removeListener(this.scalebarListener);
    }

    void updateLocationString() {
        String s = null;
        if (this.labelLocation != null && this.hasServer()) {
            s = this.getFullLocationString(this.useCalibratedLocationString());
        }
        if (s != null && !s.isEmpty()) {
            this.labelLocation.setText(s);
            this.panelLocation.setOpacity(1.0);
        } else {
            this.panelLocation.setOpacity(0.0);
        }
    }

    private boolean useCalibratedLocationString() {
        return this.useCalibratedLocationString.get();
    }

    @Override
    protected void updateAffineTransform() {
        super.updateAffineTransform();
        this.updateLocationString();
    }

    @Override
    void paintCanvas() {
        boolean imageWasUpdated = this.imageUpdated || this.locationUpdated;
        super.paintCanvas();
        if (this.scalebar == null) {
            return;
        }
        Bounds boundsFX = this.scalebar.getNode().getBoundsInParent();
        Rectangle2D.Double bounds = new Rectangle2D.Double(boundsFX.getMinX(), boundsFX.getMinY(), boundsFX.getMaxX(), boundsFX.getMaxY());
        if (imageWasUpdated) {
            if (this.getDisplayedClipShape(bounds).intersects(0.0, 0.0, this.getServerWidth(), this.getServerHeight())) {
                this.scalebar.setTextColor(this.getSuggestedOverlayColorFX());
            } else {
                this.scalebar.setTextColor(ColorToolsFX.TRANSLUCENT_WHITE_FX);
            }
        }
    }

    @Override
    public void repaintEntireImage() {
        super.repaintEntireImage();
        if (this.overview != null) {
            this.overview.repaint();
        }
    }
}

