/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.color.ICC_Profile;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ByteLookupTable;
import java.awt.image.ColorConvertOp;
import java.awt.image.LookupOp;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyLongProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Paint;
import javafx.scene.text.TextAlignment;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.awt.common.AwtTools;
import qupath.lib.color.ColorToolsAwt;
import qupath.lib.common.ColorTools;
import qupath.lib.common.GeneralTools;
import qupath.lib.display.DirectServerChannelInfo;
import qupath.lib.display.ImageDisplay;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.images.servers.PathHierarchyImageServer;
import qupath.lib.gui.images.stores.DefaultImageRegionStore;
import qupath.lib.gui.images.stores.ImageRegionStoreHelpers;
import qupath.lib.gui.images.stores.ImageRenderer;
import qupath.lib.gui.images.stores.TileListener;
import qupath.lib.gui.measure.ObservableMeasurementTableData;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tools.ColorToolsFX;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.viewer.OverlayOptions;
import qupath.lib.gui.viewer.PathObjectPainter;
import qupath.lib.gui.viewer.QuPathViewerListener;
import qupath.lib.gui.viewer.overlays.AbstractOverlay;
import qupath.lib.gui.viewer.overlays.GridOverlay;
import qupath.lib.gui.viewer.overlays.HierarchyOverlay;
import qupath.lib.gui.viewer.overlays.PathOverlay;
import qupath.lib.gui.viewer.overlays.PixelClassificationOverlay;
import qupath.lib.gui.viewer.overlays.TMAGridOverlay;
import qupath.lib.gui.viewer.tools.PathTool;
import qupath.lib.gui.viewer.tools.PathTools;
import qupath.lib.gui.viewer.tools.handlers.MoveToolEventHandler;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.objects.PathDetectionObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.objects.hierarchy.TMAGrid;
import qupath.lib.objects.hierarchy.events.PathObjectHierarchyEvent;
import qupath.lib.objects.hierarchy.events.PathObjectHierarchyListener;
import qupath.lib.objects.hierarchy.events.PathObjectSelectionListener;
import qupath.lib.regions.ImagePlane;
import qupath.lib.regions.ImageRegion;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.RectangleROI;
import qupath.lib.roi.RoiEditor;
import qupath.lib.roi.interfaces.ROI;

public class QuPathViewer
implements TileListener<BufferedImage>,
PathObjectHierarchyListener,
PathObjectSelectionListener {
    private static final Logger logger = LoggerFactory.getLogger(QuPathViewer.class);
    private static final double MIN_ROTATION = 0.0;
    private static final double MAX_ROTATION = Math.PI * 2;
    private final List<QuPathViewerListener> listeners = new ArrayList<QuPathViewerListener>();
    private final ObjectProperty<ImageData<BufferedImage>> imageDataProperty = new SimpleObjectProperty();
    private DefaultImageRegionStore regionStore;
    private OverlayOptions overlayOptions;
    private HierarchyOverlay hierarchyOverlay = null;
    private TMAGridOverlay tmaGridOverlay;
    private GridOverlay gridOverlay;
    private PathOverlay customPixelLayerOverlay = null;
    private final StringProperty placeholderText = new SimpleStringProperty();
    private final ObservableList<PathOverlay> customOverlayLayers = FXCollections.synchronizedObservableList((ObservableList)FXCollections.observableArrayList());
    private final ObservableList<PathOverlay> coreOverlayLayers = FXCollections.synchronizedObservableList((ObservableList)FXCollections.observableArrayList());
    private final ObservableList<PathOverlay> allOverlayLayers = FXCollections.synchronizedObservableList((ObservableList)FXCollections.observableArrayList());
    private BufferedImage imgBuffer = null;
    private BufferedImage imgThumbnailRGB;
    private boolean thumbnailIsFullImage = false;
    protected boolean imageUpdated = false;
    protected boolean locationUpdated = false;
    private BooleanProperty imageDataChanging = new SimpleBooleanProperty(false);
    private Tooltip tooltip = null;
    private double xCenter = 0.0;
    private double yCenter = 0.0;
    private DoubleProperty downsampleFactor = new SimpleDoubleProperty(1.0);
    private DoubleProperty rotationProperty = new SimpleDoubleProperty(0.0);
    private DoubleProperty gammaProperty = new SimpleDoubleProperty(1.0);
    private AffineTransform transform = new AffineTransform();
    private AffineTransform transformInverse = new AffineTransform();
    private boolean doFasterRepaint = false;
    private Color background = ColorToolsAwt.getCachedColor((Integer)PathPrefs.viewerBackgroundColorProperty().get());
    private boolean spaceDown = false;
    private Color colorOverlaySuggested = null;
    private Cursor requestedCursor = Cursor.DEFAULT;
    private Shape lastVisibleShape = null;
    private RoiEditor roiEditor = RoiEditor.createInstance();
    private ObjectProperty<PathTool> currentTool = new SimpleObjectProperty((Object)PathTools.MOVE);
    private ImageDisplay imageDisplay;
    private transient long lastDisplayChangeTimestamp = 0L;
    private LongProperty lastRepaintTimestamp = new SimpleLongProperty(0L);
    private boolean repaintRequested = false;
    private double mouseX;
    private double mouseY;
    private StackPane pane;
    private Canvas canvas;
    private BufferedImage imgCache;
    private WritableImage imgCacheFX;
    private double borderLineWidth = 6.0;
    private javafx.scene.paint.Color borderColor;
    private long lastPaint = 0L;
    private long minimumRepaintSpacingMillis = -1L;
    private InvalidationListener repainter = new InvalidationListener(){

        public void invalidated(Observable observable) {
            QuPathViewer.this.repaint();
        }
    };
    private InvalidationListener repainterEntire = new InvalidationListener(){

        public void invalidated(Observable observable) {
            Platform.runLater(() -> {
                QuPathViewer.this.background = ColorToolsAwt.getCachedColor((Integer)PathPrefs.viewerBackgroundColorProperty().get());
                QuPathViewer.this.repaintEntireImage();
            });
        }
    };
    private InvalidationListener repainterOverlay = new InvalidationListener(){

        public void invalidated(Observable observable) {
            QuPathViewer.this.forceOverlayUpdate();
            QuPathViewer.this.background = ColorToolsAwt.getCachedColor((Integer)PathPrefs.viewerBackgroundColorProperty().get());
            QuPathViewer.this.repaint();
        }
    };
    private ListenerManager manager = new ListenerManager();
    private ListenerManager overlayOptionsManager = new ListenerManager();
    private final IntegerProperty tPosition = new SimpleIntegerProperty(0);
    private final IntegerProperty zPosition = new SimpleIntegerProperty(0);
    private ObjectBinding<LookupOp> gammaOp = Bindings.createObjectBinding(() -> {
        double gamma = this.gammaProperty.get();
        if (gamma == 1.0 || gamma <= 0.0 || !Double.isFinite(gamma)) {
            return null;
        }
        return QuPathViewer.createGammaOp(gamma);
    }, (Observable[])new Observable[]{this.gammaProperty});
    private ColorConvertOp iccTransformOp = null;
    private boolean doICCTransform = false;
    private MoveToolEventHandler.ViewerMover mover = new MoveToolEventHandler.ViewerMover(this);

    public Pane getView() {
        if (this.canvas == null) {
            this.setupCanvas();
        }
        return this.pane;
    }

    private void setupCanvas() {
        this.canvas = new Canvas();
        this.addViewerListener(new QuPathViewerListener(){

            @Override
            public void imageDataChanged(QuPathViewer viewer, ImageData<BufferedImage> imageDataOld, ImageData<BufferedImage> imageDataNew) {
                QuPathViewer.this.paintCanvas();
            }

            @Override
            public void visibleRegionChanged(QuPathViewer viewer, Shape shape) {
            }

            @Override
            public void selectedObjectChanged(QuPathViewer viewer, PathObject pathObjectSelected) {
            }

            @Override
            public void viewerClosed(QuPathViewer viewer) {
                QuPathViewer.this.removeViewerListener(this);
                QuPathViewer.this.canvas = null;
            }
        });
        this.canvas.widthProperty().addListener((e, f, g) -> {
            this.updateAffineTransform();
            this.repaint();
        });
        this.canvas.heightProperty().addListener((e, f, g) -> {
            this.updateAffineTransform();
            this.repaint();
        });
        this.pane = new StackPane();
        this.pane.getChildren().add((Object)this.canvas);
        this.canvas.widthProperty().bind((ObservableValue)this.pane.widthProperty());
        this.canvas.heightProperty().bind((ObservableValue)this.pane.heightProperty());
        this.pane.setAlignment(Pos.CENTER);
        Label placeholder = this.createPlaceholder();
        this.pane.getChildren().add((Object)placeholder);
        this.pane.setMinWidth(1.0);
        this.pane.setMinHeight(1.0);
        this.pane.setMaxWidth(Double.MAX_VALUE);
        this.pane.setMaxHeight(Double.MAX_VALUE);
        this.pane.addEventFilter(MouseEvent.ANY, e -> {
            this.mouseX = e.getX();
            this.mouseY = e.getY();
            if (this.tooltip != null && this.tooltip.isShowing()) {
                this.updateTooltip(this.tooltip);
            }
        });
        this.pane.addEventFilter(KeyEvent.ANY, (EventHandler)new KeyEventFilter());
        this.pane.addEventHandler(KeyEvent.ANY, (EventHandler)new KeyEventHandler());
    }

    public StringProperty placeholderTextProperty() {
        return this.placeholderText;
    }

    private Label createPlaceholder() {
        Label placeholder = new Label(this.placeholderText.getValueSafe());
        placeholder.setWrapText(true);
        placeholder.setTextAlignment(TextAlignment.CENTER);
        placeholder.setPadding(new Insets(5.0));
        placeholder.textProperty().bind((ObservableValue)this.placeholderText);
        placeholder.styleProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            javafx.scene.paint.Color c;
            Integer rgb = PathPrefs.viewerBackgroundColorProperty().getValue();
            javafx.scene.paint.Color color = c = rgb == null ? javafx.scene.paint.Color.BLACK : ColorToolsFX.getCachedColor(rgb);
            if (c.getBrightness() > 0.5) {
                return "-fx-text-fill: black;";
            }
            return "-fx-text-fill: white";
        }, (Observable[])new Observable[]{PathPrefs.viewerBackgroundColorProperty()}));
        placeholder.setOpacity(0.7);
        placeholder.visibleProperty().bind((ObservableValue)this.imageDataProperty.isNull().and((ObservableBooleanValue)this.placeholderText.isNotEmpty()));
        return placeholder;
    }

    private synchronized void refreshAllOverlayLayers() {
        ArrayList<PathOverlay> temp = new ArrayList<PathOverlay>();
        temp.addAll((Collection<PathOverlay>)this.customOverlayLayers);
        temp.addAll((Collection<PathOverlay>)this.coreOverlayLayers);
        this.allOverlayLayers.setAll(temp);
    }

    public void setMinimumRepaintSpacingMillis(long repaintSpacingMillis) {
        this.minimumRepaintSpacingMillis = repaintSpacingMillis;
    }

    public void resetMinimumRepaintSpacingMillis() {
        this.minimumRepaintSpacingMillis = -1L;
        this.repaintRequested = false;
        this.repaint();
    }

    void paintCanvas() {
        long timeSinceRepaint;
        if (this.imageUpdated) {
            this.repaintRequested = true;
        }
        if (!this.repaintRequested || this.canvas == null || this.canvas.getWidth() <= 0.0 || this.canvas.getHeight() <= 0.0) {
            this.repaintRequested = false;
            return;
        }
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater(() -> this.paintCanvas());
            return;
        }
        if (this.minimumRepaintSpacingMillis > 0L && (timeSinceRepaint = System.currentTimeMillis() - this.lastPaint) < this.minimumRepaintSpacingMillis) {
            return;
        }
        if (this.imgCache == null || (double)this.imgCache.getWidth() < this.canvas.getWidth() || (double)this.imgCache.getHeight() < this.canvas.getHeight()) {
            int w = (int)(this.canvas.getWidth() + 1.0);
            int h = (int)(this.canvas.getHeight() + 1.0);
            this.imgCache = new BufferedImage(w, h, 3);
            this.imgCacheFX = new WritableImage(w, h);
        }
        this.repaintRequested = false;
        GraphicsContext context = this.canvas.getGraphicsContext2D();
        long startTime = System.currentTimeMillis();
        Graphics2D g = this.imgCache.createGraphics();
        this.paintViewer(g, this.getWidth(), this.getHeight());
        g.dispose();
        long endTime = System.currentTimeMillis();
        logger.trace("Viewer painting: {} ms", (Object)(endTime - startTime));
        this.imgCacheFX = SwingFXUtils.toFXImage((BufferedImage)this.imgCache, (WritableImage)this.imgCacheFX);
        context.drawImage((javafx.scene.image.Image)this.imgCacheFX, 0.0, 0.0);
        if (this.borderColor != null) {
            context.setStroke((Paint)this.borderColor);
            context.setLineWidth(this.borderLineWidth);
            context.strokeRect(0.0, 0.0, this.canvas.getWidth(), this.canvas.getHeight());
        }
        long time = System.currentTimeMillis();
        logger.trace("Time since last repaint: {} ms", (Object)(time - this.lastPaint));
        this.lastPaint = System.currentTimeMillis();
        this.imageDataChanging.set(false);
    }

    public void setBorderColor(javafx.scene.paint.Color color) {
        this.borderColor = color;
        if (Platform.isFxApplicationThread()) {
            this.repaintRequested = true;
            this.paintCanvas();
        } else {
            this.repaint();
        }
    }

    public javafx.scene.paint.Color getBorderColor() {
        return this.borderColor;
    }

    private int getWidth() {
        return (int)Math.ceil(this.getView().getWidth());
    }

    private int getHeight() {
        return (int)Math.ceil(this.getView().getHeight());
    }

    public void repaint() {
        if (this.repaintRequested && this.minimumRepaintSpacingMillis <= 0L) {
            return;
        }
        if (this.imageDisplay != null && this.lastDisplayChangeTimestamp != this.imageDisplay.getLastChangeTimestamp()) {
            this.repaintEntireImage();
            return;
        }
        logger.trace("Repaint requested!");
        this.repaintRequested = true;
        Platform.runLater(() -> this.paintCanvas());
    }

    public double getMinDownsample() {
        return 0.015625;
    }

    public double getMaxDownsample() {
        if (!this.hasServer()) {
            return 1.0;
        }
        return (double)Math.max(this.getServerWidth(), this.getServerHeight()) / 100.0;
    }

    public void zoomOut(int nSteps) {
        this.zoomIn(-nSteps);
    }

    public void zoomIn(int nSteps) {
        if (nSteps == 0) {
            return;
        }
        this.setDownsampleFactor(this.getDownsampleFactor() * Math.pow(this.getDefaultZoomFactor(), -nSteps), -1.0, -1.0);
    }

    public double getDefaultZoomFactor() {
        return 1.01;
    }

    public void zoomOut() {
        this.zoomOut(1);
    }

    public void zoomIn() {
        this.zoomIn(1);
    }

    public QuPathViewer(DefaultImageRegionStore regionStore, OverlayOptions overlayOptions) {
        this(regionStore, overlayOptions, new ImageDisplay());
    }

    private QuPathViewer(DefaultImageRegionStore regionStore, OverlayOptions overlayOptions, ImageDisplay imageDisplay) {
        this.regionStore = regionStore;
        this.setOverlayOptions(overlayOptions);
        this.manager.attachListener((Observable)PathPrefs.annotationStrokeThicknessProperty(), this.repainter);
        this.manager.attachListener((Observable)PathPrefs.newDetectionRenderingProperty(), this.repainter);
        this.gammaProperty.set(PathPrefs.viewerGammaProperty().get());
        this.gammaProperty.bind((ObservableValue)PathPrefs.viewerGammaProperty());
        this.manager.attachListener((Observable)this.gammaProperty, this.repainterEntire);
        this.manager.attachListener((Observable)PathPrefs.viewerInterpolateBilinearProperty(), this.repainterEntire);
        this.manager.attachListener((Observable)PathPrefs.viewerBackgroundColorProperty(), this.repainterEntire);
        this.manager.attachListener((Observable)PathPrefs.showPointHullsProperty(), this.repainter);
        this.manager.attachListener((Observable)PathPrefs.useSelectedColorProperty(), this.repainter);
        this.manager.attachListener((Observable)PathPrefs.colorDefaultObjectsProperty(), this.repainterOverlay);
        this.manager.attachListener((Observable)PathPrefs.colorSelectedObjectProperty(), this.repainter);
        this.manager.attachListener((Observable)PathPrefs.colorTileProperty(), this.repainter);
        this.manager.attachListener((Observable)PathPrefs.colorTMAProperty(), this.repainter);
        this.manager.attachListener((Observable)PathPrefs.opacityTMAMissingProperty(), this.repainter);
        this.manager.attachListener((Observable)PathPrefs.alwaysPaintSelectedObjectsProperty(), this.repainter);
        this.manager.attachListener((Observable)PathPrefs.locationFontSizeProperty(), this.repainter);
        this.manager.attachListener((Observable)PathPrefs.scalebarFontSizeProperty(), this.repainter);
        this.manager.attachListener((Observable)PathPrefs.scalebarFontWeightProperty(), this.repainter);
        this.manager.attachListener((Observable)PathPrefs.scalebarLineWidthProperty(), this.repainter);
        this.manager.attachListener((Observable)PathPrefs.gridSpacingXProperty(), this.repainter);
        this.manager.attachListener((Observable)PathPrefs.gridSpacingYProperty(), this.repainter);
        this.manager.attachListener((Observable)PathPrefs.gridStartXProperty(), this.repainter);
        this.manager.attachListener((Observable)PathPrefs.gridStartYProperty(), this.repainter);
        this.manager.attachListener((Observable)PathPrefs.gridScaleMicronsProperty(), this.repainter);
        this.manager.attachListener((Observable)PathPrefs.detectionStrokeThicknessProperty(), this.repainterOverlay);
        this.imageDisplay = imageDisplay;
        if (imageDisplay != null) {
            imageDisplay.eventCountProperty().addListener(this.repainterEntire);
        }
        this.customOverlayLayers.addListener(e -> this.refreshAllOverlayLayers());
        this.coreOverlayLayers.addListener(e -> this.refreshAllOverlayLayers());
        this.allOverlayLayers.addListener(e -> this.repaint());
        this.hierarchyOverlay = new HierarchyOverlay(this.regionStore, overlayOptions, null);
        this.tmaGridOverlay = new TMAGridOverlay(overlayOptions);
        this.gridOverlay = new GridOverlay(overlayOptions);
        this.coreOverlayLayers.setAll((Object[])new PathOverlay[]{this.tmaGridOverlay, this.hierarchyOverlay, this.gridOverlay});
        this.regionStore.addTileListener((TileListener)this);
        this.imageUpdated = true;
        if (this.tooltip != null) {
            this.tooltip.setTextAlignment(TextAlignment.CENTER);
            this.tooltip.activatedProperty().addListener((v, o, n) -> {
                if (n.booleanValue()) {
                    this.updateTooltip(this.tooltip);
                }
            });
            this.tooltip.setAutoHide(true);
            Tooltip.install((Node)this.getView(), (Tooltip)this.tooltip);
        }
        this.zPosition.addListener((v, o, n) -> {
            this.imageUpdated = true;
            this.updateThumbnail(false);
            this.repaint();
            this.fireVisibleRegionChangedEvent(this.getDisplayedRegionShape());
        });
        this.tPosition.addListener((v, o, n) -> {
            this.imageUpdated = true;
            this.updateThumbnail(false);
            this.repaint();
            this.fireVisibleRegionChangedEvent(this.getDisplayedRegionShape());
        });
        this.rotationProperty.addListener((v, o, n) -> {
            this.imageUpdated = true;
            this.updateAffineTransform();
            this.repaint();
        });
    }

    public ReadOnlyObjectProperty<ImageData<BufferedImage>> imageDataProperty() {
        return this.imageDataProperty;
    }

    public ImageData<BufferedImage> getImageData() {
        return (ImageData)this.imageDataProperty.get();
    }

    public OverlayOptions getOverlayOptions() {
        return this.overlayOptions;
    }

    public DefaultImageRegionStore getImageRegionStore() {
        return this.regionStore;
    }

    public void setDoFasterRepaint(boolean fasterRepaint) {
        if (this.doFasterRepaint == fasterRepaint) {
            return;
        }
        this.imageUpdated = true;
        this.doFasterRepaint = fasterRepaint;
        this.repaint();
    }

    public Point2D getMousePosition() {
        if (this.mouseX >= 0.0 && this.mouseX <= this.canvas.getWidth() && this.mouseY >= 0.0 && this.mouseY <= this.canvas.getHeight()) {
            return new Point2D.Double(this.mouseX, this.mouseY);
        }
        return null;
    }

    private void setOverlayOptions(OverlayOptions overlayOptions) {
        if (this.overlayOptions == overlayOptions) {
            return;
        }
        if (this.overlayOptions != null) {
            this.overlayOptionsManager.detachAll();
        }
        this.overlayOptions = overlayOptions;
        if (overlayOptions != null) {
            this.overlayOptionsManager.attachListener((Observable)overlayOptions.fillDetectionsProperty(), this.repainterOverlay);
            this.overlayOptionsManager.attachListener((Observable)overlayOptions.selectedClassesProperty(), this.repainterOverlay);
            this.overlayOptionsManager.attachListener((Observable)overlayOptions.selectedClassVisibilityModeProperty(), this.repainterOverlay);
            this.overlayOptionsManager.attachListener((Observable)overlayOptions.useExactSelectedClassesProperty(), this.repainterOverlay);
            this.overlayOptionsManager.attachListener((Observable)overlayOptions.measurementMapperProperty(), this.repainterOverlay);
            this.overlayOptionsManager.attachListener((Observable)overlayOptions.detectionDisplayModeProperty(), this.repainterOverlay);
            this.overlayOptionsManager.attachListener((Observable)overlayOptions.showConnectionsProperty(), this.repainterOverlay);
            this.overlayOptionsManager.attachListener((Observable)overlayOptions.showObjectPredicateProperty(), this.repainterOverlay);
            this.overlayOptionsManager.attachListener((Observable)overlayOptions.showAnnotationsProperty(), this.repainter);
            this.overlayOptionsManager.attachListener((Observable)overlayOptions.showNamesProperty(), this.repainter);
            this.overlayOptionsManager.attachListener((Observable)overlayOptions.fillAnnotationsProperty(), this.repainter);
            this.overlayOptionsManager.attachListener((Observable)overlayOptions.showDetectionsProperty(), this.repainter);
            this.overlayOptionsManager.attachListener((Observable)overlayOptions.showPixelClassificationProperty(), this.repainter);
            this.overlayOptionsManager.attachListener((Observable)overlayOptions.pixelClassificationFilterRegionProperty(), this.repainter);
            this.overlayOptionsManager.attachListener((Observable)overlayOptions.gridLinesProperty(), this.repainter);
            this.overlayOptionsManager.attachListener((Observable)overlayOptions.showTMACoreLabelsProperty(), this.repainter);
            this.overlayOptionsManager.attachListener((Observable)overlayOptions.showGridProperty(), this.repainter);
            this.overlayOptionsManager.attachListener((Observable)overlayOptions.showTMAGridProperty(), this.repainter);
            this.overlayOptionsManager.attachListener((Observable)overlayOptions.opacityProperty(), this.repainter);
            this.overlayOptionsManager.attachListener((Observable)overlayOptions.fontSizeProperty(), this.repainter);
        }
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public boolean isShowing() {
        return this.canvas != null && this.canvas.isVisible() && this.canvas.getScene() != null;
    }

    protected void initializeForServer(ImageServer<BufferedImage> server) {
        this.imageUpdated = true;
        if (server == null) {
            this.zPosition.set(0);
            this.tPosition.set(0);
            return;
        }
        this.updateICCTransform();
        this.zPosition.set(server.nZSlices() / 2);
        this.tPosition.set(0);
        this.updateThumbnail();
        this.colorOverlaySuggested = null;
    }

    public boolean isSpaceDown() {
        return this.spaceDown;
    }

    public void setSpaceDown(boolean spaceDown) {
        if (this.spaceDown == spaceDown) {
            return;
        }
        this.spaceDown = spaceDown;
        PathTool activeTool = (PathTool)this.currentTool.get();
        if (activeTool != PathTools.MOVE && activeTool != null) {
            if (spaceDown) {
                activeTool.deregisterTool(this);
                activeTool = PathTools.MOVE;
                activeTool.registerTool(this);
            } else {
                PathTools.MOVE.deregisterTool(this);
                activeTool.registerTool(this);
            }
        }
        logger.trace("Setting space down to {} - active tool {}", (Object)spaceDown, (Object)activeTool);
        this.updateCursor();
    }

    private static int getMeanBrightnessRGB(BufferedImage img, int x, int y, int w, int h) {
        if (img == null) {
            return 0;
        }
        double sum = 0.0;
        if (w < 0) {
            w = img.getWidth();
        }
        if (h < 0) {
            h = img.getHeight();
        }
        int[] pixels = new int[w * h];
        img.getRGB(x, y, w, h, pixels, 0, w);
        double scale = 1.0 / (3.0 * (double)w * (double)h);
        for (int c : pixels) {
            int r = (c & ColorTools.MASK_RED) >> 16;
            int g = (c & ColorTools.MASK_GREEN) >> 8;
            int b = c & ColorTools.MASK_BLUE;
            sum += (double)(r + g + b) * scale;
        }
        return (int)(sum + 0.5);
    }

    void updateSuggestedOverlayColorFromThumbnail() {
        this.colorOverlaySuggested = QuPathViewer.getMeanBrightnessRGB(this.imgThumbnailRGB, 0, 0, this.imgThumbnailRGB.getWidth(), this.imgThumbnailRGB.getHeight()) > 127 ? ColorToolsAwt.TRANSLUCENT_BLACK : ColorToolsAwt.TRANSLUCENT_WHITE;
    }

    Color getSuggestedOverlayColor() {
        if (this.colorOverlaySuggested == null) {
            this.updateSuggestedOverlayColorFromThumbnail();
        }
        return this.colorOverlaySuggested;
    }

    javafx.scene.paint.Color getSuggestedOverlayColorFX() {
        Color c = this.getSuggestedOverlayColor();
        if (c == ColorToolsAwt.TRANSLUCENT_BLACK) {
            return ColorToolsFX.TRANSLUCENT_BLACK_FX;
        }
        return ColorToolsFX.TRANSLUCENT_WHITE_FX;
    }

    public double getCenterPixelX() {
        return this.xCenter;
    }

    public double getCenterPixelY() {
        return this.yCenter;
    }

    public void setActiveTool(PathTool tool) {
        logger.trace("Setting tool {} for {}", (Object)tool, (Object)this);
        PathTool activeTool = (PathTool)this.currentTool.get();
        if (activeTool != null) {
            activeTool.deregisterTool(this);
        }
        this.currentTool.set((Object)tool);
        if (tool != null) {
            tool.registerTool(this);
        }
        this.updateCursor();
        this.updateRoiEditor();
    }

    public PathTool getActiveTool() {
        if (this.spaceDown) {
            return PathTools.MOVE;
        }
        return (PathTool)this.currentTool.get();
    }

    protected void updateCursor() {
        PathTool mode = this.getActiveTool();
        if (mode == PathTools.MOVE) {
            this.getView().setCursor(Cursor.HAND);
        } else {
            this.getView().setCursor(this.requestedCursor);
        }
    }

    public Cursor getCursor() {
        return this.getView().getCursor();
    }

    public void setCursor(Cursor cursor) {
        this.requestedCursor = cursor;
        this.updateCursor();
    }

    public PathObject getSelectedObject() {
        PathObjectHierarchy hierarchy = this.getHierarchy();
        if (hierarchy == null) {
            return null;
        }
        return hierarchy.getSelectionModel().getSelectedObject();
    }

    public Collection<PathObject> getAllSelectedObjects() {
        PathObjectHierarchy hierarchy = this.getHierarchy();
        if (hierarchy == null) {
            return Collections.emptyList();
        }
        return hierarchy.getSelectionModel().getSelectedObjects();
    }

    public void setCustomPixelLayerOverlay(PathOverlay pathOverlay) {
        ImageData<BufferedImage> imageData;
        if (this.customPixelLayerOverlay == pathOverlay) {
            return;
        }
        PathOverlay previousOverlay = this.getCurrentPixelLayerOverlay();
        int ind = this.coreOverlayLayers.indexOf((Object)previousOverlay);
        this.customPixelLayerOverlay = pathOverlay;
        if (this.customPixelLayerOverlay == null) {
            if (ind >= 0) {
                this.coreOverlayLayers.remove(ind);
            }
        } else if (ind < 0) {
            this.coreOverlayLayers.add(0, (Object)this.customPixelLayerOverlay);
        } else {
            this.coreOverlayLayers.set(ind, (Object)this.customPixelLayerOverlay);
        }
        if ((imageData = this.getImageData()) != null) {
            if (pathOverlay instanceof PixelClassificationOverlay) {
                ImageServer<BufferedImage> server = ((PixelClassificationOverlay)pathOverlay).getPixelClassificationServer(imageData);
                ObservableMeasurementTableData.setPixelLayer(imageData, server);
            } else {
                ObservableMeasurementTableData.setPixelLayer(imageData, null);
            }
        }
    }

    public void resetCustomPixelLayerOverlay() {
        this.setCustomPixelLayerOverlay(null);
    }

    private PathOverlay getCurrentPixelLayerOverlay() {
        return this.customPixelLayerOverlay;
    }

    public PathOverlay getCustomPixelLayerOverlay() {
        return this.customPixelLayerOverlay;
    }

    public ROI getCurrentROI() {
        PathObject selectedObject = this.getSelectedObject();
        return selectedObject == null ? null : selectedObject.getROI();
    }

    public void setSelectedObject(PathObject pathObject) {
        this.setSelectedObject(pathObject, false);
    }

    public void setSelectedObject(PathObject pathObject, boolean addToSelected) {
        PathObjectHierarchy hierarchy = this.getHierarchy();
        if (hierarchy == null) {
            return;
        }
        hierarchy.getSelectionModel().setSelectedObject(pathObject, addToSelected);
    }

    void updateThumbnail() {
        this.updateThumbnail(true);
    }

    void updateThumbnail(boolean updateOverlayColor) {
        ImageServer<BufferedImage> server = this.getServer();
        if (server == null) {
            return;
        }
        try {
            int z = GeneralTools.clipValue((int)this.getZPosition(), (int)0, (int)(server.nZSlices() - 1));
            int t = GeneralTools.clipValue((int)this.getTPosition(), (int)0, (int)(server.nTimepoints() - 1));
            BufferedImage imgThumbnail = (BufferedImage)this.regionStore.getThumbnail((ImageServer)server, z, t, true);
            this.imgThumbnailRGB = this.createThumbnailRGB(imgThumbnail);
            boolean bl = this.thumbnailIsFullImage = this.imgThumbnailRGB.getWidth() == server.getWidth() && this.imgThumbnailRGB.getHeight() == server.getHeight();
            if (updateOverlayColor) {
                this.colorOverlaySuggested = null;
            }
        }
        catch (IOException e) {
            this.imgThumbnailRGB = null;
            this.colorOverlaySuggested = null;
            logger.warn("Error requesting thumbnail {}", (Object)e.getLocalizedMessage());
        }
    }

    BufferedImage createThumbnailRGB(BufferedImage imgThumbnail) throws IOException {
        ImageRenderer renderer = this.getRenderer();
        if (renderer != null) {
            return renderer.applyTransforms(imgThumbnail, null);
        }
        return imgThumbnail;
    }

    protected ImageRenderer getRenderer() {
        return this.getImageDisplay();
    }

    public Shape getDisplayedRegionShape() {
        return this.getDisplayedClipShape(null);
    }

    protected Shape getDisplayedClipShape(Shape clip) {
        Shape clip2 = clip == null ? new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight()) : clip;
        if (clip2 instanceof Rectangle2D && this.getRotation() == 0.0) {
            Rectangle2D rect = (Rectangle2D)clip2;
            double[] coords = new double[]{rect.getMinX(), rect.getMinY(), rect.getMaxX(), rect.getMaxY()};
            this.transformInverse.transform(coords, 0, coords, 0, 2);
            if (rect == clip) {
                rect = new Rectangle2D.Double();
            }
            rect.setFrameFromDiagonal(coords[0], coords[1], coords[2], coords[3]);
            return rect;
        }
        return this.transformInverse.createTransformedShape(clip2);
    }

    public void zoomToFit() {
        if (this.getServer() == null) {
            return;
        }
        this.setDownsampleFactorImpl(this.getZoomToFitDownsampleFactor(), -1.0, -1.0);
        this.centerImage();
    }

    public ImageServer<BufferedImage> getServer() {
        ImageData temp = (ImageData)this.imageDataProperty.get();
        return temp == null ? null : temp.getServer();
    }

    public boolean hasServer() {
        return this.getServer() != null;
    }

    public void setZPosition(int zPos) {
        this.zPosition.set(zPos);
    }

    public int getTPosition() {
        return this.tPosition.get();
    }

    public void setTPosition(int tPosition) {
        this.tPosition.set(tPosition);
    }

    public int getZPosition() {
        return this.zPosition.get();
    }

    public ImagePlane getImagePlane() {
        return ImagePlane.getPlane((int)this.getZPosition(), (int)this.getTPosition());
    }

    public boolean isImageDataChanging() {
        return this.imageDataChanging.get();
    }

    public void setImageData(ImageData<BufferedImage> imageDataNew) throws IOException {
        if (this.imageDataProperty.get() == imageDataNew) {
            return;
        }
        this.hierarchyOverlay.resetImageData();
        this.imageDataChanging.set(true);
        ImageData imageDataOld = (ImageData)this.imageDataProperty.get();
        if (imageDataOld != null) {
            imageDataOld.getHierarchy().removeListener((PathObjectHierarchyListener)this);
            imageDataOld.getHierarchy().getSelectionModel().removePathObjectSelectionListener((PathObjectSelectionListener)this);
        }
        boolean sameServer = false;
        if (imageDataOld != null && imageDataNew != null && imageDataOld.getServerPath().equals(imageDataNew.getServerPath())) {
            sameServer = true;
        }
        this.imageDataProperty.set(imageDataNew);
        ImageServer server = imageDataNew == null ? null : imageDataNew.getServer();
        PathObjectHierarchy hierarchy = imageDataNew == null ? null : imageDataNew.getHierarchy();
        long startTime = System.currentTimeMillis();
        if (this.imageDisplay != null) {
            boolean keepDisplay = PathPrefs.keepDisplaySettingsProperty().get();
            boolean displaySet = false;
            if (imageDataNew != null && keepDisplay) {
                if (this.imageDisplay.getImageData() != null && QuPathViewer.serversCompatible((ImageServer<BufferedImage>)imageDataNew.getServer(), (ImageServer<BufferedImage>)this.imageDisplay.getImageData().getServer())) {
                    this.imageDisplay.setImageData(imageDataNew, keepDisplay);
                    displaySet = true;
                } else {
                    for (QuPathViewer viewer : QuPathGUI.getInstance().getAllViewers()) {
                        ImageServer currentServer;
                        ImageServer<BufferedImage> tempServer;
                        if (this == viewer || viewer.getImageData() == null || !QuPathViewer.serversCompatible(tempServer = viewer.getServer(), (ImageServer<BufferedImage>)(currentServer = imageDataNew.getServer()))) continue;
                        String json = viewer.getImageDisplay().toJSON(false);
                        imageDataNew.setProperty(ImageDisplay.class.getName(), (Object)json);
                        this.imageDisplay.setImageData(imageDataNew, false);
                        displaySet = true;
                        break;
                    }
                }
            }
            if (!displaySet) {
                try {
                    this.imageDisplay.setImageData(imageDataNew, keepDisplay);
                }
                catch (Exception | UnsatisfiedLinkError e2) {
                    logger.warn("Caught exception setting ImageData - will reset to null ({})", (Object)e2.getMessage());
                    this.setImageData(null);
                    throw e2;
                }
            }
            if (server != null && !server.isRGB()) {
                List<Integer> colors = this.imageDisplay.availableChannels().stream().filter(c -> c instanceof DirectServerChannelInfo).map(c -> c.getColor()).toList();
                if (server.nChannels() == colors.size()) {
                    QuPathViewer.updateServerChannels((ImageServer<BufferedImage>)server, colors);
                }
            }
        }
        long endTime = System.currentTimeMillis();
        logger.debug("Setting ImageData time: {} ms", (Object)(endTime - startTime));
        this.initializeForServer((ImageServer<BufferedImage>)server);
        if (!sameServer) {
            this.setDownsampleFactorImpl(this.getZoomToFitDownsampleFactor(), -1.0, -1.0);
            this.centerImage();
        }
        this.fireImageDataChanged((ImageData<BufferedImage>)imageDataOld, imageDataNew);
        if (imageDataNew != null) {
            hierarchy.addListener((PathObjectHierarchyListener)this);
            hierarchy.getSelectionModel().addPathObjectSelectionListener((PathObjectSelectionListener)this);
        }
        this.setSelectedObject(null);
        if (this.isShowing()) {
            this.repaint();
        }
        if (imageDataNew == null) {
            logger.info("Image data reset");
        } else {
            logger.info("Image data set to {}", imageDataNew);
        }
    }

    public void resetImageData() {
        try {
            this.setImageData(null);
        }
        catch (IOException e) {
            logger.error("Error resetting image data", (Throwable)e);
        }
    }

    private static boolean updateServerChannels(ImageServer<BufferedImage> server, List<Integer> colors) throws IllegalArgumentException {
        ArrayList<ImageChannel> channels = server.getMetadata().getChannels();
        if (channels.size() != colors.size()) {
            throw new IllegalArgumentException(String.format("Number of channels (%d) does not match the number of colors (%d)!", channels.size(), colors.size()));
        }
        List<Integer> serverChannelColors = channels.stream().map(c -> c.getColor()).toList();
        if (colors.equals(serverChannelColors)) {
            return false;
        }
        channels = new ArrayList<ImageChannel>(channels);
        int n = 0;
        for (int i = 0; i < channels.size(); ++i) {
            ImageChannel channel = (ImageChannel)channels.get(i);
            Integer color = colors.get(i);
            if (Objects.equals(channel.getColor(), color)) continue;
            channels.set(i, ImageChannel.getInstance((String)channel.getName(), (Integer)color));
            ++n;
        }
        if (n == 0) {
            return false;
        }
        ImageServerMetadata newMetadata = new ImageServerMetadata.Builder(server.getMetadata()).channels(channels).build();
        server.setMetadata(newMetadata);
        if (n == 1) {
            logger.info("Updating server metadata for 1 channel");
        } else {
            logger.info("Updating server metadata for {} channels", (Object)n);
        }
        return true;
    }

    private static boolean serversCompatible(ImageServer<BufferedImage> currentServer, ImageServer<BufferedImage> tempServer) {
        if (Objects.equals(currentServer, tempServer)) {
            return true;
        }
        if (currentServer == null || tempServer == null) {
            return false;
        }
        if (tempServer.nChannels() == currentServer.nChannels() && tempServer.getPixelType() == currentServer.getPixelType()) {
            List<String> tempNames = tempServer.getMetadata().getChannels().stream().map(c -> c.getName()).toList();
            List<String> currentNames = currentServer.getMetadata().getChannels().stream().map(c -> c.getName()).toList();
            return tempNames.equals(currentNames);
        }
        return false;
    }

    protected void fireImageDataChanged(ImageData<BufferedImage> imageDataPrevious, ImageData<BufferedImage> imageDataNew) {
        for (QuPathViewerListener listener : this.listeners.toArray(new QuPathViewerListener[0])) {
            listener.imageDataChanged(this, imageDataPrevious, imageDataNew);
        }
    }

    protected void fireVisibleRegionChangedEvent(Shape shape) {
        for (QuPathViewerListener listener : this.listeners.toArray(new QuPathViewerListener[0])) {
            listener.visibleRegionChanged(this, shape);
        }
    }

    private void repaintImageRegion(Rectangle2D region, boolean updateImage) {
        Rectangle clipBounds = this.transform.createTransformedShape(region).getBounds();
        if (clipBounds.intersects(0.0, 0.0, this.getWidth(), this.getHeight())) {
            if (updateImage) {
                this.imageUpdated = true;
            }
            this.repaint();
        }
    }

    public void repaintEntireImage() {
        this.imageUpdated = true;
        if (this.imageDisplay != null) {
            this.lastDisplayChangeTimestamp = this.imageDisplay.getLastChangeTimestamp();
        }
        this.updateThumbnail();
        this.repaint();
    }

    public double getMagnification() {
        if (!this.hasServer()) {
            return Double.NaN;
        }
        return this.getFullMagnification() / this.getDownsampleFactor();
    }

    public double getFullMagnification() {
        if (!this.hasServer()) {
            return 1.0;
        }
        double magnification = this.getServer().getMetadata().getMagnification();
        if (Double.isNaN(magnification)) {
            return 1.0;
        }
        return magnification;
    }

    public void setMagnification(double magnification) {
        if (this.hasServer()) {
            this.setDownsampleFactor(this.getFullMagnification() / magnification);
        }
    }

    public void closeViewer() {
        this.overlayOptionsManager.detachAll();
        this.overlayOptionsManager.clear();
        this.manager.detachAll();
        this.manager.clear();
        this.regionStore.removeTileListener((TileListener)this);
        for (QuPathViewerListener listener : this.listeners.toArray(new QuPathViewerListener[0])) {
            listener.viewerClosed(this);
        }
    }

    protected void paintComponent(Graphics g) {
        this.paintViewer(g, this.getWidth(), this.getHeight());
    }

    void updateRepaintTimestamp() {
        long timestamp = System.currentTimeMillis();
        this.lastRepaintTimestamp.set(timestamp);
    }

    protected void paintViewer(Graphics g, int w, int h) {
        boolean paintCompletely;
        boolean clipFull;
        ImageServer<BufferedImage> server = this.getServer();
        if (server == null) {
            g.setColor(this.background);
            g.fillRect(0, 0, w, h);
            this.updateRepaintTimestamp();
            return;
        }
        Rectangle clip = g.getClipBounds();
        if (clip == null) {
            clip = new Rectangle(0, 0, w, h);
            g.setClip(0, 0, w, h);
            clipFull = true;
        } else {
            boolean bl = clipFull = clip.x == 0 && clip.y == 0 && clip.width == w && clip.height == h;
        }
        if (this.imgBuffer == null || this.imgBuffer.getWidth() != w || this.imgBuffer.getHeight() != h) {
            this.imgBuffer = QuPathViewer.createBufferedImage(w, h);
            this.imgBuffer.setAccelerationPriority(1.0f);
            logger.trace("New buffered image created: {}", (Object)this.imgBuffer);
            this.imageUpdated = true;
            this.updateAffineTransform();
        }
        Shape shapeRegion = this.getDisplayedRegionShape();
        boolean shapeChanged = this.lastVisibleShape == null || !this.lastVisibleShape.equals(shapeRegion);
        long t1 = System.currentTimeMillis();
        if (this.imageUpdated || this.locationUpdated) {
            this.imageUpdated = false;
            this.locationUpdated = false;
            this.updateBufferedImage(this.imgBuffer, shapeRegion, w, h);
        }
        this.lastVisibleShape = shapeRegion;
        g.setColor(this.background);
        if (clipFull) {
            QuPathViewer.paintFinalImage(g, this.imgBuffer, this);
        } else {
            g.drawImage(this.imgBuffer, clip.x, clip.y, clip.x + clip.width, clip.y + clip.height, clip.x, clip.y, clip.x + clip.width, clip.y + clip.height, null);
        }
        if (logger.isTraceEnabled()) {
            long t2 = System.currentTimeMillis();
            logger.trace("Final image drawing time: {}", (Object)(t2 - t1));
        }
        if (!(g instanceof Graphics2D)) {
            this.imageUpdated = false;
            if (shapeChanged) {
                this.fireVisibleRegionChangedEvent(this.lastVisibleShape);
            }
            return;
        }
        double downsample = this.getDownsampleFactor();
        float opacity = this.overlayOptions.getOpacity();
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.transform(this.transform);
        Composite previousComposite = g2d.getComposite();
        boolean bl = paintCompletely = this.thumbnailIsFullImage || !this.doFasterRepaint;
        if (opacity > 0.0f || PathPrefs.alwaysPaintSelectedObjectsProperty().get()) {
            if (opacity < 1.0f) {
                AlphaComposite composite = AlphaComposite.getInstance(3, opacity);
                g2d.setComposite(composite);
            }
            Color color = this.getSuggestedOverlayColor();
            ImageData imageData = (ImageData)this.imageDataProperty.get();
            for (PathOverlay overlay : (PathOverlay[])this.allOverlayLayers.toArray(PathOverlay[]::new)) {
                logger.trace("Painting overlay: {}", (Object)overlay);
                if (overlay instanceof AbstractOverlay) {
                    ((AbstractOverlay)overlay).setPreferredOverlayColor(color);
                }
                overlay.paintOverlay(g2d, this.getServerBounds(), downsample, (ImageData<BufferedImage>)imageData, paintCompletely);
            }
        }
        PathObjectHierarchy hierarchy = this.getHierarchy();
        PathObject mainSelectedObject = this.getSelectedObject();
        Rectangle2D boundsRect = null;
        boolean useSelectedColor = PathPrefs.useSelectedColorProperty().get();
        boolean paintSelectedBounds = PathPrefs.paintSelectedBoundsProperty().get();
        for (PathObject selectedObject : hierarchy.getSelectionModel().getSelectedObjects().toArray(new PathObject[0])) {
            Color color;
            ROI pathROI;
            if (selectedObject == null || !selectedObject.hasROI() || selectedObject.getROI().getZ() != this.getZPosition() || selectedObject.getROI().getT() != this.getTPosition()) continue;
            if (!selectedObject.isDetection()) {
                if (previousComposite != null) {
                    g2d.setComposite(previousComposite);
                }
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            if (!((pathROI = selectedObject.getROI()) == null || !paintSelectedBounds && useSelectedColor || pathROI instanceof RectangleROI || pathROI.isEmpty())) {
                ROI hull;
                Shape boundsShape = null;
                if (pathROI.isPoint() && (hull = pathROI.getConvexHull()) != null) {
                    boundsShape = hull.getShape();
                }
                if (boundsShape == null) {
                    boundsRect = AwtTools.getBounds2D((ROI)pathROI, boundsRect);
                    boundsShape = boundsRect;
                }
                PathObjectPainter.paintShape(boundsShape, g2d, this.getSuggestedOverlayColor(), PathObjectPainter.getCachedStroke(Math.max(downsample, 1.0) * 2.0), null);
            }
            if (selectedObject.isDetection() && PathPrefs.useSelectedColorProperty().get() || !PathObjectTools.hierarchyContainsObject((PathObjectHierarchy)hierarchy, (PathObject)selectedObject)) {
                g2d.setClip(shapeRegion);
                PathObjectPainter.paintObject(selectedObject, g2d, this.overlayOptions, this.getHierarchy().getSelectionModel(), downsample);
            }
            if (selectedObject != mainSelectedObject || !this.roiEditor.hasROI()) continue;
            Stroke strokeThick = PathObjectPainter.getCachedStroke(PathPrefs.annotationStrokeThicknessProperty().get() * downsample);
            Color color2 = color = useSelectedColor ? ColorToolsAwt.getCachedColor((Integer)PathPrefs.colorSelectedObjectProperty().get()) : null;
            if (color == null) {
                color = ColorToolsAwt.getCachedColor((Integer)ColorToolsFX.getDisplayedColorARGB(selectedObject));
            }
            g2d.setStroke(strokeThick);
            double maxHandleSize = this.getMaxROIHandleSize();
            double minHandleSize = downsample;
            PathObjectPainter.paintHandles(this.roiEditor, g2d, minHandleSize, maxHandleSize, color, ColorToolsAwt.getTranslucentColor((Color)color));
        }
        if (shapeChanged) {
            this.fireVisibleRegionChangedEvent(this.lastVisibleShape);
        }
        this.updateRepaintTimestamp();
    }

    public double getMaxROIHandleSize() {
        return PathPrefs.annotationStrokeThicknessProperty().get() * this.getDownsampleFactor() * 4.0;
    }

    public ReadOnlyLongProperty repaintTimestamp() {
        return this.lastRepaintTimestamp;
    }

    static BufferedImage createBufferedImage(int w, int h) {
        return new BufferedImage(w, h, 3);
    }

    private void updateBufferedImage(BufferedImage imgBuffer, Shape shapeRegion, int w, int h) {
        LookupOp gammaOp;
        Graphics2D gBuffered = imgBuffer.createGraphics();
        this.updateBufferedImage(gBuffered, shapeRegion, w, h);
        gBuffered.dispose();
        if (this.iccTransformOp != null) {
            this.iccTransformOp.filter(this.imgBuffer.getRaster(), this.imgBuffer.getRaster());
        }
        if ((gammaOp = this.getGammaOp()) != null) {
            gammaOp.filter(this.imgBuffer.getRaster(), this.imgBuffer.getRaster());
        }
    }

    private void updateBufferedImage(Graphics2D gBuffered, Shape shapeRegion, int w, int h) {
        boolean overBoundary;
        Shape shapeToUpdate = shapeRegion;
        gBuffered.setColor(this.background);
        gBuffered.fillRect(0, 0, w, h);
        gBuffered.transform(this.transform);
        gBuffered.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        ImageServer<BufferedImage> server = this.getServer();
        int serverWidth = server.getWidth();
        int serverHeight = server.getHeight();
        BufferedImage imgThumbnail = (BufferedImage)this.regionStore.getThumbnail((ImageServer)server, this.getZPosition(), this.getTPosition(), true);
        double lowResolutionDownsample = 0.5 * ((double)serverWidth / (double)imgThumbnail.getWidth() + (double)serverHeight / (double)imgThumbnail.getHeight());
        boolean requiresTiling = !this.thumbnailIsFullImage && lowResolutionDownsample > Math.max(this.downsampleFactor.get(), 1.0);
        Rectangle shapeBounds = shapeToUpdate.getBounds();
        boolean bl = overBoundary = shapeBounds.x < 0 || shapeBounds.y < 0 || shapeBounds.x + shapeBounds.width >= serverWidth || shapeBounds.y + shapeBounds.height >= serverHeight;
        if (!this.doFasterRepaint && PathPrefs.viewerInterpolateBilinearProperty().get()) {
            gBuffered.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        } else {
            gBuffered.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        }
        if (requiresTiling) {
            double downsample = this.getDownsampleFactor();
            if (server.isRGB() && !overBoundary) {
                this.regionStore.paintRegion(server, gBuffered, shapeToUpdate, this.getZPosition(), this.getTPosition(), downsample, imgThumbnail, null, null);
                gBuffered.dispose();
                if (this.imageDisplay != null) {
                    this.imgBuffer = this.getRenderer().applyTransforms(this.imgBuffer, null);
                }
            } else {
                this.regionStore.paintRegion(server, gBuffered, shapeToUpdate, this.getZPosition(), this.getTPosition(), downsample, imgThumbnail, null, this.getRenderer());
            }
        } else {
            QuPathViewer.paintThumbnail(gBuffered, this.imgThumbnailRGB, serverWidth, serverHeight, this);
        }
    }

    public List<PathOverlay> getOverlayLayers() {
        return FXCollections.unmodifiableObservableList(this.allOverlayLayers);
    }

    public ObservableList<PathOverlay> getCustomOverlayLayers() {
        return this.customOverlayLayers;
    }

    static void paintThumbnail(Graphics g, Image img, int width, int height, QuPathViewer viewer) {
        g.drawImage(img, 0, 0, width, height, null);
    }

    static LookupOp createGammaOp(double gamma) {
        byte[] lut = new byte[256];
        for (int i = 0; i < 256; ++i) {
            double val = Math.pow((double)i / 255.0, gamma) * 255.0;
            lut[i] = (byte)ColorTools.do8BitRangeCheck((double)val);
        }
        return new LookupOp(new ByteLookupTable(0, lut), null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static ICC_Profile readICC(Object input) {
        try (ImageInputStream stream = ImageIO.createImageInputStream(input);){
            Iterator<ImageReader> readers = ImageIO.getImageReaders(stream);
            if (readers == null) {
                logger.debug("No readers found to extract ICC profile from {}", input);
                ICC_Profile iCC_Profile = null;
                return iCC_Profile;
            }
            Class<?> clsTiffDir = Class.forName("javax.imageio.plugins.tiff.TIFFDirectory");
            Class<?> clsTiffField = Class.forName("javax.imageio.plugins.tiff.TIFFField");
            Method mCreateFromMetadata = clsTiffDir.getMethod("createFromMetadata", IIOMetadata.class);
            Method mGetTiffField = clsTiffDir.getMethod("getTIFFField", Integer.TYPE);
            Method mGetAsBytes = clsTiffField.getMethod("getAsBytes", new Class[0]);
            if (!readers.hasNext()) return null;
            ImageReader reader = readers.next();
            stream.reset();
            reader.setInput(stream);
            Object tiffDir = mCreateFromMetadata.invoke(null, reader.getImageMetadata(0));
            Object tiffField = mGetTiffField.invoke(tiffDir, 34675);
            byte[] bytes = (byte[])mGetAsBytes.invoke(tiffField, new Object[0]);
            ICC_Profile iCC_Profile = ICC_Profile.getInstance(bytes);
            return iCC_Profile;
        }
        catch (Exception e) {
            logger.warn("Unable to read ICC profile: {}", (Object)e.getLocalizedMessage());
        }
        return null;
    }

    ColorConvertOp createICCConvertOp() {
        Collection uris;
        ImageServer<BufferedImage> server = this.getServer();
        Collection collection = uris = server == null ? null : server.getURIs();
        if (uris == null || uris.isEmpty()) {
            return null;
        }
        ICC_Profile iccSource = QuPathViewer.readICC(Paths.get((URI)uris.iterator().next()).toFile());
        if (iccSource == null) {
            return null;
        }
        return new ColorConvertOp(new ICC_Profile[]{iccSource, ICC_Profile.getInstance(1000)}, null);
    }

    public LookupOp getGammaOp() {
        return (LookupOp)this.gammaOp.get();
    }

    public double getGamma() {
        return this.gammaProperty.get();
    }

    public void setGamma(double gamma) {
        if (this.gammaProperty.isBound()) {
            logger.warn("Unable to set gamma for viewer - property is bound.");
            logger.warn("Call viewer.gammaProperty().unbind() first.");
            return;
        }
        this.gammaProperty.set(gamma);
    }

    public DoubleProperty gammaProperty() {
        return this.gammaProperty;
    }

    void updateICCTransform() {
        this.iccTransformOp = this.getDoICCTransform() ? this.createICCConvertOp() : null;
    }

    void setDoICCTransform(boolean doTransform) {
        this.doICCTransform = doTransform;
        this.updateICCTransform();
    }

    boolean getDoICCTransform() {
        return this.doICCTransform;
    }

    static void paintFinalImage(Graphics g, Image img, QuPathViewer viewer) {
        g.drawImage(img, 0, 0, null);
    }

    public RoiEditor getROIEditor() {
        return this.roiEditor;
    }

    private void updateTooltip(Tooltip tooltip) {
        String text = this.getTooltipText(this.mouseX, this.mouseY);
        tooltip.setText(text);
        if (text == null) {
            tooltip.setOpacity(0.0);
        } else {
            tooltip.setOpacity(1.0);
        }
    }

    private String getTooltipText(double x, double y) {
        Point2D p;
        TMACoreObject core;
        TMAGrid tmaGrid;
        PathObjectHierarchy hierarchy = this.getHierarchy();
        TMAGrid tMAGrid = tmaGrid = hierarchy == null ? null : hierarchy.getTMAGrid();
        if (tmaGrid != null && (core = PathObjectTools.getTMACoreForPixel((TMAGrid)tmaGrid, (double)(p = this.componentPointToImagePoint(x, y, null, false)).getX(), (double)p.getY())) != null) {
            if (core.isMissing()) {
                return String.format("TMA Core %s\n(missing)", core.getName());
            }
            return String.format("TMA Core %s", core.getName());
        }
        return null;
    }

    public ImageDisplay getImageDisplay() {
        return this.imageDisplay;
    }

    protected boolean componentContains(double x, double y) {
        return x >= 0.0 && x < this.getView().getWidth() && y >= 0.0 && y <= this.getView().getHeight();
    }

    public void setDownsampleFactor(double downsampleFactor) {
        if (this.componentContains(this.mouseX, this.mouseY)) {
            this.setDownsampleFactor(downsampleFactor, this.mouseX, this.mouseY);
        } else {
            this.setDownsampleFactor(downsampleFactor, -1.0, -1.0);
        }
    }

    public BufferedImage getThumbnail() {
        ImageServer<BufferedImage> server = this.getServer();
        return server == null ? null : (BufferedImage)this.regionStore.getThumbnail((ImageServer)server, this.getZPosition(), this.getTPosition(), true);
    }

    public List<BufferedImage> getAllThumbnails() {
        ImageServer<BufferedImage> server = this.getServer();
        if (server == null) {
            return Collections.emptyList();
        }
        int nImages = server.nTimepoints() * server.nZSlices();
        if (nImages == 1) {
            return Collections.singletonList((BufferedImage)this.regionStore.getThumbnail((ImageServer)server, 0, 0, true));
        }
        ArrayList<BufferedImage> thumbnails = new ArrayList<BufferedImage>(nImages);
        for (int t = 0; t < server.nTimepoints(); ++t) {
            for (int z = 0; z < server.nZSlices(); ++z) {
                thumbnails.add((BufferedImage)this.regionStore.getThumbnail((ImageServer)server, this.getZPosition(), this.getTPosition(), true));
            }
        }
        return thumbnails;
    }

    public BufferedImage getRGBThumbnail() {
        return this.imgThumbnailRGB;
    }

    public void setDownsampleFactor(double downsampleFactor, double cx, double cy) {
        this.setDownsampleFactor(downsampleFactor, cx, cy, false);
    }

    public void setDownsampleFactor(double downsampleFactor, double cx, double cy, boolean clipToMinMax) {
        if (clipToMinMax) {
            downsampleFactor = GeneralTools.clipValue((double)downsampleFactor, (double)this.getMinDownsample(), (double)this.getMaxDownsample());
        } else if (downsampleFactor <= 0.0 || !Double.isFinite(downsampleFactor)) {
            logger.warn("Invalid downsample factor {}, will use {} instead", (Object)downsampleFactor, (Object)this.getMinDownsample());
            downsampleFactor = this.getMinDownsample();
        }
        this.setDownsampleFactorImpl(downsampleFactor, cx, cy);
    }

    private void setDownsampleFactorImpl(double downsampleFactor, double cx, double cy) {
        double currentDownsample = this.getDownsampleFactor();
        if (currentDownsample == downsampleFactor) {
            return;
        }
        if (cx < 0.0) {
            cx = (double)this.getWidth() / 2.0;
        }
        if (cy < 0.0) {
            cy = (double)this.getHeight() / 2.0;
        }
        if (!this.isRotated()) {
            this.xCenter += (cx - (double)this.getWidth() / 2.0) * (currentDownsample - downsampleFactor);
            this.yCenter += (cy - (double)this.getHeight() / 2.0) * (currentDownsample - downsampleFactor);
        } else {
            Point2D p2 = this.componentPointToImagePoint(cx, cy, null, false);
            double dx = (p2.getX() - this.xCenter) / currentDownsample * downsampleFactor;
            double dy = (p2.getY() - this.yCenter) / currentDownsample * downsampleFactor;
            this.xCenter = p2.getX() - dx;
            this.yCenter = p2.getY() - dy;
        }
        if (!Double.isFinite(downsampleFactor)) {
            logger.debug("Setting non-finite downsample {} to 1.0", (Object)downsampleFactor);
            downsampleFactor = 1.0;
        }
        this.downsampleFactor.set(downsampleFactor);
        this.updateAffineTransform();
        this.imageUpdated = true;
        this.repaint();
    }

    protected double getZoomToFitDownsampleFactor() {
        if (!this.hasServer()) {
            return Double.NaN;
        }
        double fullWidth = this.getServerWidth();
        double fullHeight = this.getServerHeight();
        double maxDownsample = fullWidth / (double)this.getWidth();
        maxDownsample = Math.max(maxDownsample, fullHeight / (double)this.getHeight());
        return maxDownsample;
    }

    public int getServerWidth() {
        ImageServer<BufferedImage> server = this.getServer();
        return server == null ? 0 : server.getWidth();
    }

    public int getServerHeight() {
        ImageServer<BufferedImage> server = this.getServer();
        return server == null ? 0 : server.getHeight();
    }

    public ImageRegion getServerBounds() {
        ImageServer<BufferedImage> server = this.getServer();
        return server == null ? null : ImageRegion.createInstance((int)0, (int)0, (int)server.getWidth(), (int)server.getHeight(), (int)this.getZPosition(), (int)this.getTPosition());
    }

    public double getDownsampleFactor() {
        return this.downsampleFactor.get();
    }

    public Point2D componentPointToImagePoint(Point2D point, Point2D pointDest, boolean constrainToBounds) {
        return this.componentPointToImagePoint(point.getX(), point.getY(), pointDest, constrainToBounds);
    }

    public Point2D componentPointToImagePoint(double x, double y, Point2D pointDest, boolean constrainToBounds) {
        if (pointDest == null) {
            pointDest = new Point2D.Double(x, y);
        } else {
            pointDest.setLocation(x, y);
        }
        this.transformInverse.transform(pointDest, pointDest);
        ImageServer<BufferedImage> server = this.getServer();
        if (constrainToBounds && server != null) {
            pointDest.setLocation(Math.min(Math.max(pointDest.getX(), 0.0), (double)server.getWidth()), Math.min(Math.max(pointDest.getY(), 0.0), (double)server.getHeight()));
        }
        return pointDest;
    }

    public Point2D imagePointToComponentPoint(Point2D point, Point2D pointDest, boolean constrainToBounds) {
        return this.imagePointToComponentPoint(point.getX(), point.getY(), pointDest, constrainToBounds);
    }

    private Point2D imagePointToComponentPoint(double x, double y, Point2D pointDest, boolean constrainToBounds) {
        if (pointDest == null) {
            pointDest = new Point2D.Double(x, y);
        } else {
            pointDest.setLocation(x, y);
        }
        this.transform.transform(pointDest, pointDest);
        if (constrainToBounds) {
            pointDest.setLocation(Math.min(Math.max(pointDest.getX(), 0.0), (double)this.getWidth()), Math.min(Math.max(pointDest.getY(), 0.0), (double)this.getHeight()));
        }
        return pointDest;
    }

    public void centerImage() {
        ImageServer<BufferedImage> server = this.getServer();
        if (server == null) {
            return;
        }
        this.setCenterPixelLocation(0.5 * (double)server.getWidth(), 0.5 * (double)server.getHeight());
    }

    public String getObjectClassificationString(double x, double y) {
        PathObjectHierarchy hierarchy = this.getHierarchy();
        if (hierarchy == null) {
            return "";
        }
        Point2D p2 = this.componentPointToImagePoint(x, y, null, false);
        return this.getImageObjectClassificationString(p2.getX(), p2.getY());
    }

    public String getImageObjectClassificationString(double x, double y) {
        PathObjectHierarchy hierarchy = this.getHierarchy();
        if (hierarchy == null) {
            return "";
        }
        Collection pathObjects = PathObjectTools.getObjectsForLocation((PathObjectHierarchy)hierarchy, (double)x, (double)y, (int)this.getZPosition(), (int)this.getTPosition(), (double)0.0);
        if (!pathObjects.isEmpty()) {
            return pathObjects.stream().filter(pathObject -> pathObject.isDetection()).map(pathObject -> {
                PathClass pathClass = pathObject.getPathClass();
                return pathClass == null ? "Unclassified" : pathClass.toString();
            }).collect(Collectors.joining(", "));
        }
        return "";
    }

    private String getImageLocationString(double xx, double yy, boolean useCalibratedUnits) {
        Object dimensionString;
        TMACoreObject core;
        String units;
        ImageServer<BufferedImage> server = this.getServer();
        if (server == null) {
            return "";
        }
        if (xx < 0.0 || yy < 0.0 || xx > (double)server.getWidth() || yy > (double)server.getHeight()) {
            return "";
        }
        double xDisplay = xx;
        double yDisplay = yy;
        PixelCalibration cal = server.getPixelCalibration();
        if (useCalibratedUnits && cal.hasPixelSizeMicrons()) {
            units = GeneralTools.micrometerSymbol();
            xDisplay *= cal.getPixelWidthMicrons();
            yDisplay *= cal.getPixelHeightMicrons();
        } else {
            units = "px";
        }
        Object prefix = "";
        TMAGrid tmaGrid = this.getHierarchy().getTMAGrid();
        if (tmaGrid != null && (core = PathObjectTools.getTMACoreForPixel((TMAGrid)tmaGrid, (double)xx, (double)yy)) != null) {
            prefix = core.getName() != null ? "Core: " + core.getName() : "TMA core";
            PathClass pathClass = core.getPathClass();
            if (pathClass != null) {
                prefix = (String)prefix + " (" + String.valueOf(pathClass) + ")";
            }
            if (core.isMissing()) {
                prefix = (String)prefix + " (missing)";
            }
            prefix = (String)prefix + "\n";
        }
        String s = null;
        RegionRequest request = ImageRegionStoreHelpers.getTileRequest(server, xx, yy, this.downsampleFactor.get(), this.getZPosition(), this.getTPosition());
        if (request != null) {
            BufferedImage img = (BufferedImage)this.regionStore.getCachedTile((ImageServer)server, request);
            int xi = 0;
            int yi = 0;
            if (img == null) {
                BufferedImage imgThumbnail = (BufferedImage)this.regionStore.getCachedThumbnail((ImageServer)server, this.getZPosition(), this.getTPosition());
                if (imgThumbnail != null) {
                    img = imgThumbnail;
                    double downsample = (double)server.getWidth() / (double)imgThumbnail.getWidth();
                    xi = (int)(xx / downsample);
                    yi = (int)(yy / downsample);
                }
            } else {
                xi = (int)((xx - (double)request.getX()) / request.getDownsample());
                yi = (int)((yy - (double)request.getY()) / request.getDownsample());
            }
            if (img != null) {
                xi = Math.min(xi, img.getWidth() - 1);
                yi = Math.min(yi, img.getHeight() - 1);
                if (this.imageDisplay != null) {
                    s = this.imageDisplay.getTransformedValueAsString(img, xi, yi);
                }
            }
        }
        Object zString = null;
        if (server.nZSlices() > 1) {
            double zSpacing = server.getPixelCalibration().getZSpacingMicrons();
            zString = !useCalibratedUnits || Double.isNaN(zSpacing) ? "z = " + this.getZPosition() : String.format("z = %.2f %s", (double)this.getZPosition() * zSpacing, GeneralTools.micrometerSymbol());
        }
        String tString = null;
        if (server.nTimepoints() > 1) {
            tString = "t = " + this.getTPosition();
        }
        if (tString == null && zString == null) {
            dimensionString = "";
        } else {
            dimensionString = "\n";
            if (zString != null) {
                dimensionString = (String)dimensionString + (String)zString;
                if (tString != null) {
                    dimensionString = (String)dimensionString + ", " + tString;
                }
            } else {
                dimensionString = (String)dimensionString + tString;
            }
        }
        if (s != null) {
            return String.format("%s%.2f, %.2f %s\n%s%s", prefix, xDisplay, yDisplay, units, s, dimensionString);
        }
        return String.format("%s%.2f, %.2f %s%s", prefix, xDisplay, yDisplay, units, dimensionString);
    }

    protected String getFullLocationString(boolean useCalibratedUnits) {
        if (this.componentContains(this.mouseX, this.mouseY)) {
            double y;
            Point2D p = this.componentPointToImagePoint(this.mouseX, this.mouseY, null, false);
            double x = p.getX();
            String locationString = this.getImageLocationString(x, y = p.getY(), useCalibratedUnits);
            if (locationString == null || locationString.isBlank()) {
                return "";
            }
            int z = this.getZPosition();
            int t = this.getTPosition();
            Object classString = this.getImageObjectClassificationString(x, y).trim();
            Object overlayStrings = this.allOverlayLayers.stream().map(o -> o.getLocationString(this.getImageData(), x, y, z, t)).filter(s -> s != null).collect(Collectors.joining("\n"));
            classString = classString == null ? "\n" : (String)classString + "\n";
            if (!((String)overlayStrings).isBlank()) {
                overlayStrings = (String)overlayStrings + "\n";
            }
            return (String)overlayStrings + (String)classString + locationString;
        }
        return "";
    }

    public PathObjectHierarchy getHierarchy() {
        ImageData temp = (ImageData)this.imageDataProperty.get();
        return temp == null ? null : temp.getHierarchy();
    }

    public void addViewerListener(QuPathViewerListener listener) {
        this.listeners.add(listener);
    }

    public void removeViewerListener(QuPathViewerListener listener) {
        this.listeners.remove(listener);
    }

    public void setCenterPixelLocation(double x, double y) {
        if (this.xCenter == x && this.yCenter == y || Double.isNaN(x + y)) {
            return;
        }
        this.xCenter = x;
        this.yCenter = y;
        this.updateAffineTransform();
        this.locationUpdated = true;
        this.repaint();
    }

    public void centerROI(ROI roi) {
        if (roi == null) {
            return;
        }
        double x = roi.getCentroidX();
        double y = roi.getCentroidY();
        this.setZPosition(roi.getZ());
        this.setTPosition(roi.getT());
        this.setCenterPixelLocation(x, y);
    }

    protected void updateAffineTransform() {
        if (!this.hasServer()) {
            return;
        }
        this.transform.setToIdentity();
        this.transform.translate((double)this.getWidth() * 0.5, (double)this.getHeight() * 0.5);
        double downsample = this.getDownsampleFactor();
        this.transform.scale(1.0 / downsample, 1.0 / downsample);
        this.transform.translate(-this.xCenter, -this.yCenter);
        if (this.rotationProperty.get() != 0.0) {
            this.transform.rotate(this.rotationProperty.get(), this.xCenter, this.yCenter);
        }
        this.transformInverse.setTransform(this.transform);
        try {
            this.transformInverse.invert();
        }
        catch (NoninvertibleTransformException e) {
            logger.warn("Transform not invertible!", (Throwable)e);
        }
    }

    public void setRotation(double theta) {
        if (this.rotationProperty.get() == theta) {
            return;
        }
        while (theta < 0.0) {
            theta += Math.PI * 2;
        }
        theta = theta % (Math.PI * 2) + 0.0;
        this.rotationProperty.set(theta);
    }

    public boolean isRotated() {
        return this.getRotation() != 0.0;
    }

    public double getRotation() {
        return this.rotationProperty.get();
    }

    public DoubleProperty rotationProperty() {
        return this.rotationProperty;
    }

    @Override
    public void tileAvailable(String serverPath, ImageRegion region, BufferedImage tile) {
        if (!this.hasServer()) {
            return;
        }
        if (serverPath == null || serverPath.contains(this.getServerPath())) {
            this.repaintImageRegion(AwtTools.getBounds((ImageRegion)region), true);
        }
    }

    public void forceOverlayUpdate() {
        if (Platform.isFxApplicationThread()) {
            this.hierarchyOverlay.clearCachedOverlay();
        } else {
            Platform.runLater(() -> this.hierarchyOverlay.clearCachedOverlay());
        }
        this.repaint();
    }

    public void hierarchyChanged(PathObjectHierarchyEvent event) {
        if (event.isObjectMeasurementEvent()) {
            return;
        }
        if (Platform.isFxApplicationThread()) {
            this.handleHierarchyChange(event);
        } else {
            Platform.runLater(() -> this.handleHierarchyChange(event));
        }
    }

    private void handleHierarchyChange(PathObjectHierarchyEvent event) {
        if (event != null) {
            logger.trace(event.toString());
        }
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater(() -> this.handleHierarchyChange(event));
            return;
        }
        if (event == null || event.isStructureChangeEvent()) {
            this.hierarchyOverlay.clearCachedOverlay();
        } else {
            List pathObjects = event.getChangedObjects();
            List pathDetectionObjects = PathObjectTools.getObjectsOfClass((Collection)pathObjects, PathDetectionObject.class);
            if (pathDetectionObjects.size() <= 50) {
                for (PathObject temp : pathDetectionObjects) {
                    if (!temp.hasROI()) continue;
                    this.hierarchyOverlay.clearCachedOverlayForRegion(ImageRegion.createInstance((ROI)temp.getROI()));
                }
            } else {
                this.hierarchyOverlay.clearCachedOverlay();
            }
        }
        if (event != null && !event.isChanging()) {
            this.updateRoiEditor();
        }
        this.repaint();
    }

    public void selectedPathObjectChanged(PathObject pathObjectSelected, PathObject previousObject, Collection<PathObject> allSelected) {
        this.updateRoiEditor();
        for (QuPathViewerListener listener : new ArrayList<QuPathViewerListener>(this.listeners)) {
            listener.selectedObjectChanged(this, pathObjectSelected);
        }
        logger.trace("Selected path object changed from {} to {}", (Object)previousObject, (Object)pathObjectSelected);
        this.repaint();
    }

    private void updateRoiEditor() {
        ROI newROI;
        PathObject pathObjectSelected = this.getSelectedObject();
        ROI previousROI = this.roiEditor.getROI();
        ROI rOI = newROI = pathObjectSelected != null && pathObjectSelected.isEditable() ? pathObjectSelected.getROI() : null;
        if (previousROI == newROI) {
            this.roiEditor.ensureHandlesUpdated();
        } else {
            this.roiEditor.setROI(newROI);
        }
        this.repaint();
    }

    private synchronized String getServerPath() {
        ImageServer<BufferedImage> server = this.getServer();
        return server == null ? null : server.getPath();
    }

    @Override
    public synchronized boolean requiresTileRegion(String serverPath, ImageRegion region) {
        if (serverPath.startsWith(PathHierarchyImageServer.DEFAULT_PREFIX) || serverPath.equals(this.getServerPath())) {
            return Math.abs(region.getZ() - this.getZPosition()) <= 3 && region.getT() == this.getTPosition() && this.getDisplayedClipShape(null).intersects(AwtTools.getBounds((ImageRegion)region));
        }
        return false;
    }

    public String toString() {
        ImageData temp = (ImageData)this.imageDataProperty.get();
        if (temp != null) {
            return this.getClass().getSimpleName() + " - " + temp.getServerPath();
        }
        return this.getClass().getSimpleName() + " - no server";
    }

    public IntegerProperty zPositionProperty() {
        return this.zPosition;
    }

    public IntegerProperty tPositionProperty() {
        return this.tPosition;
    }

    public void requestStopMoving() {
        this.mover.stopMoving();
    }

    public void requestDecelerate() {
        this.mover.decelerate();
    }

    public void requestStartMoving(double dx, double dy) {
        this.mover.startMoving(dx, dy, true);
        this.setDoFasterRepaint(true);
    }

    public void requestCancelDirection(boolean xAxis) {
        this.mover.cancelDirection(xAxis);
    }

    class KeyEventFilter
    implements EventHandler<KeyEvent> {
        KeyEventFilter() {
        }

        public void handle(KeyEvent event) {
            KeyCode code = event.getCode();
            if (code == KeyCode.SPACE) {
                if (event.getEventType() == KeyEvent.KEY_PRESSED) {
                    QuPathViewer.this.setSpaceDown(true);
                } else if (event.getEventType() == KeyEvent.KEY_RELEASED) {
                    QuPathViewer.this.setSpaceDown(false);
                }
                return;
            }
        }
    }

    class KeyEventHandler
    implements EventHandler<KeyEvent> {
        private KeyCode lastPressed = null;
        private Set<KeyCode> keysPressed = new HashSet<KeyCode>();
        private long keyDownTime = Long.MIN_VALUE;
        private double scale = 1.0;

        KeyEventHandler() {
        }

        public void handle(KeyEvent event) {
            ArrayList cores;
            if (event.isConsumed()) {
                return;
            }
            KeyCode code = event.getCode();
            if (event.getEventType() == KeyEvent.KEY_PRESSED && (code == KeyCode.BACK_SPACE || code == KeyCode.DELETE)) {
                if (QuPathViewer.this.getROIEditor().hasActiveHandle() || QuPathViewer.this.getROIEditor().isTranslating()) {
                    logger.debug("Cannot delete object - ROI being edited");
                    return;
                }
                PathObjectHierarchy hierarchy = QuPathViewer.this.getHierarchy();
                if (hierarchy != null) {
                    if (hierarchy.getSelectionModel().singleSelection()) {
                        GuiTools.promptToRemoveSelectedObject(hierarchy.getSelectionModel().getSelectedObject(), hierarchy);
                    } else {
                        GuiTools.promptToClearAllSelectedObjects(QuPathViewer.this.getImageData());
                    }
                }
                event.consume();
                return;
            }
            PathObjectHierarchy hierarchy = QuPathViewer.this.getHierarchy();
            if (hierarchy == null) {
                return;
            }
            if (code != KeyCode.LEFT && code != KeyCode.UP && code != KeyCode.RIGHT && code != KeyCode.DOWN) {
                return;
            }
            boolean skipMissingTMACores = PathPrefs.getSkipMissingCoresProperty();
            TMAGrid tmaGrid = hierarchy.getTMAGrid();
            ArrayList arrayList = cores = tmaGrid == null ? Collections.emptyList() : new ArrayList(tmaGrid.getTMACoreList());
            if (!event.isShiftDown() && tmaGrid != null && tmaGrid.nCores() > 0) {
                int temp;
                PathObject selected;
                if (event.getEventType() != KeyEvent.KEY_PRESSED) {
                    return;
                }
                for (selected = hierarchy.getSelectionModel().getSelectedObject(); selected != null && !selected.isTMACore(); selected = selected.getParent()) {
                }
                int ind = tmaGrid.getTMACoreList().indexOf(selected);
                int w = tmaGrid.getGridWidth();
                int h = tmaGrid.getGridHeight();
                if (ind < 0) {
                    double minDisplacementSq = Double.POSITIVE_INFINITY;
                    int i = -1;
                    for (TMACoreObject core : cores) {
                        double dy;
                        ROI coreROI;
                        double dx;
                        double displacementSq;
                        ++i;
                        if (core.isMissing() && skipMissingTMACores || !((displacementSq = (dx = (coreROI = core.getROI()).getCentroidX() - QuPathViewer.this.getCenterPixelX()) * dx + (dy = coreROI.getCentroidY() - QuPathViewer.this.getCenterPixelY()) * dy) < minDisplacementSq)) continue;
                        ind = i;
                        minDisplacementSq = displacementSq;
                    }
                }
                switch (code) {
                    case LEFT: {
                        int n = temp = ind - 1 < 0 ? 0 : ind - 1;
                        while (skipMissingTMACores && ((TMACoreObject)cores.get(temp)).isMissing() && temp > 0) {
                            temp = temp - 1 < 0 ? 0 : temp - 1;
                        }
                        break;
                    }
                    case UP: {
                        int n = ind == 0 ? ind : (temp = ind - w < 0 ? w * h - (w - ind + 1) : ind - w);
                        while (skipMissingTMACores && ((TMACoreObject)cores.get(temp)).isMissing() && temp != 0) {
                            temp = ind == 0 ? ind : (temp - w <= 0 ? w * h - (w - temp + 1) : temp - w);
                        }
                        break;
                    }
                    case RIGHT: {
                        int n = temp = ind + 1 >= w * h ? w * h - 1 : ind + 1;
                        while (skipMissingTMACores && ((TMACoreObject)cores.get(temp)).isMissing() && temp < w * h - 1) {
                            temp = temp + 1 >= w * h ? w * h - 1 : temp + 1;
                        }
                        break;
                    }
                    case DOWN: {
                        int n = ind == w * h - 1 ? ind : (temp = ind + w >= w * h ? ind % w + 1 : ind + w);
                        while (skipMissingTMACores && ((TMACoreObject)cores.get(temp)).isMissing() && temp != w * h - 1) {
                            temp = temp + w >= w * h ? temp % w + 1 : temp + w;
                        }
                        break;
                    }
                    default: {
                        return;
                    }
                }
                int n = !skipMissingTMACores ? temp : (ind = ((TMACoreObject)cores.get(temp)).isMissing() ? ind : temp);
                if (ind >= 0 && ind < w * h) {
                    PathObject selectedObject = (PathObject)cores.get(ind);
                    hierarchy.getSelectionModel().setSelectedObject(selectedObject);
                    if (selectedObject != null && selectedObject.hasROI()) {
                        QuPathViewer.this.centerROI(selectedObject.getROI());
                    }
                }
                event.consume();
            } else if (event.getEventType() == KeyEvent.KEY_PRESSED) {
                if (this.keysPressed.isEmpty()) {
                    this.keysPressed.add(code);
                    this.lastPressed = code;
                } else if (!this.keysPressed.contains(code)) {
                    this.keysPressed.add(code);
                    if (this.keysPressed.size() == 3) {
                        this.keysPressed.remove(this.lastPressed);
                    }
                }
                if (event.isShiftDown()) {
                    switch (code) {
                        case UP: {
                            if (!event.isShortcutDown()) {
                                QuPathViewer.this.zoomIn(10);
                            }
                            event.consume();
                            return;
                        }
                        case DOWN: {
                            if (!event.isShortcutDown()) {
                                QuPathViewer.this.zoomOut(10);
                            }
                            event.consume();
                            return;
                        }
                    }
                }
                long currentTime = System.currentTimeMillis();
                if (this.keyDownTime == Long.MIN_VALUE) {
                    this.keyDownTime = currentTime;
                }
                if (PathPrefs.getNavigationAccelerationProperty()) {
                    this.scale *= 1.05;
                }
                double d = QuPathViewer.this.getDownsampleFactor() * this.scale * 20.0 * PathPrefs.getScaledNavigationSpeed();
                double dx = 0.0;
                double dy = 0.0;
                int nZSlices = QuPathViewer.this.hasServer() ? QuPathViewer.this.getServer().nZSlices() : 1;
                int nTimepoints = QuPathViewer.this.hasServer() ? QuPathViewer.this.getServer().nTimepoints() : 1;
                switch (code) {
                    case LEFT: {
                        if (nTimepoints > 1) {
                            QuPathViewer.this.setTPosition(Math.max(QuPathViewer.this.getTPosition() - 1, 0));
                            event.consume();
                            return;
                        }
                        dx = d;
                        if (this.lastPressed == code) break;
                        if (this.lastPressed == KeyCode.RIGHT) {
                            dx = 0.0;
                            break;
                        }
                        dy = this.lastPressed == KeyCode.UP ? d : -d;
                        break;
                    }
                    case UP: {
                        if (nZSlices > 1) {
                            int inc = PathPrefs.invertZSliderProperty().get() ? -1 : 1;
                            QuPathViewer.this.setZPosition(GeneralTools.clipValue((int)(QuPathViewer.this.getZPosition() + inc), (int)0, (int)(nZSlices - 1)));
                            event.consume();
                            return;
                        }
                        dy = d;
                        if (this.lastPressed == code) break;
                        if (this.lastPressed == KeyCode.DOWN) {
                            dy = 0.0;
                            break;
                        }
                        dx = this.lastPressed == KeyCode.LEFT ? d : -d;
                        break;
                    }
                    case RIGHT: {
                        if (nTimepoints > 1) {
                            QuPathViewer.this.setTPosition(Math.min(nTimepoints - 1, QuPathViewer.this.getTPosition() + 1));
                            event.consume();
                            return;
                        }
                        dx = -d;
                        if (this.lastPressed == code) break;
                        if (this.lastPressed == KeyCode.LEFT) {
                            dx = 0.0;
                            break;
                        }
                        dy = this.lastPressed == KeyCode.UP ? d : -d;
                        break;
                    }
                    case DOWN: {
                        if (nZSlices > 1) {
                            int inc = PathPrefs.invertZSliderProperty().get() ? 1 : -1;
                            QuPathViewer.this.setZPosition(GeneralTools.clipValue((int)(QuPathViewer.this.getZPosition() + inc), (int)0, (int)(nZSlices - 1)));
                            event.consume();
                            return;
                        }
                        dy = -d;
                        if (this.lastPressed == code) break;
                        if (this.lastPressed == KeyCode.UP) {
                            dy = 0.0;
                            break;
                        }
                        dx = this.lastPressed == KeyCode.LEFT ? d : -d;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                QuPathViewer.this.requestStartMoving(dx, dy);
                event.consume();
            } else if (event.getEventType() == KeyEvent.KEY_RELEASED) {
                this.keysPressed.remove(code);
                if (this.lastPressed == code) {
                    this.lastPressed = this.keysPressed.size() == 1 ? this.keysPressed.iterator().next() : null;
                }
                if (this.keysPressed.size() == 1) {
                    QuPathViewer.this.requestCancelDirection(code == KeyCode.LEFT || code == KeyCode.RIGHT);
                }
                switch (code) {
                    case LEFT: 
                    case UP: 
                    case RIGHT: 
                    case DOWN: {
                        if (this.lastPressed == null) {
                            if (!PathPrefs.getNavigationAccelerationProperty()) {
                                QuPathViewer.this.mover.stopMoving();
                            } else {
                                QuPathViewer.this.mover.decelerate();
                            }
                            QuPathViewer.this.setDoFasterRepaint(false);
                            this.keyDownTime = Long.MIN_VALUE;
                            this.scale = 1.0;
                        }
                        event.consume();
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
        }
    }

    static class ListenerManager {
        private List<ListenerHandler> handlers = new ArrayList<ListenerHandler>();

        ListenerManager() {
        }

        public ListenerHandler attachListener(Observable observable, InvalidationListener listener) {
            ObservableListenerHandler handler = new ObservableListenerHandler(observable, listener);
            handler.attach();
            this.handlers.add(handler);
            return handler;
        }

        public <T> ListenerHandler attachListener(ObservableValue<T> observable, ChangeListener<T> listener) {
            ObservableValueListenerHandler<T> handler = new ObservableValueListenerHandler<T>(observable, listener);
            this.handlers.add(handler);
            handler.attach();
            return handler;
        }

        public <T> ListenerHandler attachListener(ObservableList<T> observable, ListChangeListener<T> listener) {
            ObservableListListenerHandler<T> handler = new ObservableListListenerHandler<T>(observable, listener);
            this.handlers.add(handler);
            handler.attach();
            return handler;
        }

        public void detachAll() {
            this.handlers.stream().forEach(h -> h.detach());
        }

        public void clear() {
            this.handlers.clear();
        }
    }

    static interface ListenerHandler {
        public void attach();

        public void detach();
    }

    static class ObservableValueListenerHandler<T>
    implements ListenerHandler {
        private ObservableValue<T> observable;
        private ChangeListener<T> listener;

        private ObservableValueListenerHandler(ObservableValue<T> observable, ChangeListener<T> listener) {
            this.observable = observable;
            this.listener = listener;
        }

        @Override
        public void attach() {
            this.observable.addListener(this.listener);
        }

        @Override
        public void detach() {
            this.observable.removeListener(this.listener);
        }
    }

    static class ObservableListListenerHandler<T>
    implements ListenerHandler {
        private ObservableList<T> observable;
        private ListChangeListener<T> listener;

        private ObservableListListenerHandler(ObservableList<T> observable, ListChangeListener<T> listener) {
            this.observable = observable;
            this.listener = listener;
        }

        @Override
        public void attach() {
            this.observable.addListener(this.listener);
        }

        @Override
        public void detach() {
            this.observable.removeListener(this.listener);
        }
    }

    static class ObservableListenerHandler
    implements ListenerHandler {
        private Observable observable;
        private InvalidationListener listener;

        private ObservableListenerHandler(Observable observable, InvalidationListener listener) {
            this.observable = observable;
            this.listener = listener;
        }

        @Override
        public void attach() {
            this.observable.addListener(this.listener);
        }

        @Override
        public void detach() {
            this.observable.removeListener(this.listener);
        }
    }
}

