/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.analysis.DelaunayTools;
import qupath.lib.awt.common.AwtTools;
import qupath.lib.color.ColorToolsAwt;
import qupath.lib.common.LogTools;
import qupath.lib.geom.Point;
import qupath.lib.geom.Point2;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tools.ColorToolsFX;
import qupath.lib.gui.tools.MeasurementMapper;
import qupath.lib.gui.viewer.DownsampledShapeCache;
import qupath.lib.gui.viewer.OverlayOptions;
import qupath.lib.objects.PathCellObject;
import qupath.lib.objects.PathDetectionObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectConnectionGroup;
import qupath.lib.objects.PathObjectConnections;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.classes.PathClassTools;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.objects.hierarchy.TMAGrid;
import qupath.lib.objects.hierarchy.events.PathObjectSelectionModel;
import qupath.lib.plugins.ParallelTileObject;
import qupath.lib.regions.ImagePlane;
import qupath.lib.regions.ImageRegion;
import qupath.lib.roi.EllipseROI;
import qupath.lib.roi.LineROI;
import qupath.lib.roi.PointsROI;
import qupath.lib.roi.RectangleROI;
import qupath.lib.roi.RoiEditor;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;

public class PathObjectPainter {
    private static final Logger logger = LoggerFactory.getLogger(PathObjectPainter.class);
    private static final ShapeProvider shapeProvider = new ShapeProvider();
    private static final Map<Object, Double> doubleCache = new HashMap<Object, Double>();
    private static final Map<Number, Stroke> strokeMap = new HashMap<Number, Stroke>();
    private static final Map<Number, Stroke> dashedStrokeMap = new HashMap<Number, Stroke>();
    private static final ThreadLocal<Path2D> localPath2D = ThreadLocal.withInitial(Path2D.Double::new);
    private static final ThreadLocal<Rectangle2D> localRect2D = ThreadLocal.withInitial(Rectangle2D.Double::new);
    private static final ThreadLocal<Ellipse2D> localEllipse2D = ThreadLocal.withInitial(Ellipse2D.Double::new);

    private PathObjectPainter() {
    }

    public static void paintSpecifiedObjects(Graphics2D g2d, Collection<? extends PathObject> pathObjects, OverlayOptions overlayOptions, PathObjectSelectionModel selectionModel, double downsample) {
        if (pathObjects == null) {
            return;
        }
        for (PathObject pathObject : pathObjects) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            PathObjectPainter.paintObject(pathObject, g2d, overlayOptions, selectionModel, downsample);
        }
    }

    public static void paintTMAGrid(Graphics2D g2d, TMAGrid tmaGrid, OverlayOptions overlayOptions, PathObjectSelectionModel selectionModel, double downsample) {
        if (tmaGrid == null) {
            return;
        }
        if (!overlayOptions.getShowTMAGrid()) {
            return;
        }
        Stroke strokeThick = PathObjectPainter.getCachedStroke(PathPrefs.annotationStrokeThicknessProperty().get() * downsample);
        g2d.setStroke(strokeThick);
        Color colorGrid = ColorToolsAwt.getCachedColor((Integer)PathPrefs.colorTMAProperty().get());
        for (int gy = 0; gy < tmaGrid.getGridHeight(); ++gy) {
            for (int gx = 0; gx < tmaGrid.getGridWidth(); ++gx) {
                Rectangle2D boundsNext;
                g2d.setStroke(strokeThick);
                TMACoreObject core = tmaGrid.getTMACore(gy, gx);
                Rectangle2D bounds = AwtTools.getBounds2D((ROI)core.getROI());
                g2d.setColor(colorGrid);
                if (gx < tmaGrid.getGridWidth() - 1) {
                    boundsNext = AwtTools.getBounds2D((ROI)tmaGrid.getTMACore(gy, gx + 1).getROI());
                    g2d.drawLine((int)bounds.getMaxX(), (int)bounds.getCenterY(), (int)boundsNext.getMinX(), (int)boundsNext.getCenterY());
                }
                if (gy < tmaGrid.getGridHeight() - 1) {
                    boundsNext = AwtTools.getBounds2D((ROI)tmaGrid.getTMACore(gy + 1, gx).getROI());
                    g2d.drawLine((int)bounds.getCenterX(), (int)bounds.getMaxY(), (int)boundsNext.getCenterX(), (int)boundsNext.getMinY());
                }
                PathObjectPainter.paintObject((PathObject)core, g2d, overlayOptions, selectionModel, downsample);
            }
        }
        if (overlayOptions.getShowTMACoreLabels()) {
            int fitCount = 0;
            int totalCount = 0;
            FontMetrics fm = g2d.getFontMetrics();
            for (TMACoreObject core : tmaGrid.getTMACoreList()) {
                if (core.getName() == null) continue;
                int width = fm.stringWidth(core.getName());
                if ((double)width < core.getROI().getBoundsWidth() / downsample) {
                    ++fitCount;
                }
                ++totalCount;
            }
            if (fitCount == 0 || (double)fitCount / (double)totalCount < 0.8) {
                return;
            }
            AffineTransform transform = g2d.getTransform();
            g2d.setTransform(new AffineTransform());
            Point2D.Double pSource = new Point2D.Double();
            Point2D.Double pDest = new Point2D.Double();
            g2d.setFont(g2d.getFont().deriveFont(1));
            for (TMACoreObject core : tmaGrid.getTMACoreList()) {
                if (core.getName() == null) continue;
                int width = fm.stringWidth(core.getName());
                double x = core.getROI().getBoundsX() + core.getROI().getBoundsWidth() / 2.0;
                double y = core.getROI().getBoundsY() + core.getROI().getBoundsHeight() / 2.0;
                ((Point2D)pSource).setLocation(x, y);
                transform.transform(pSource, pDest);
                float xf = (float)(((Point2D)pDest).getX() - (double)width / 2.0);
                float yf = (float)(((Point2D)pDest).getY() + (double)fm.getDescent());
                Color colorPainted = ColorToolsAwt.getCachedColor((Integer)ColorToolsFX.getDisplayedColorARGB((PathObject)core));
                double mean = (double)(colorPainted.getRed() + colorPainted.getGreen() + colorPainted.getBlue()) / 765.0;
                if (mean > 0.5) {
                    g2d.setColor(ColorToolsAwt.TRANSLUCENT_BLACK);
                } else {
                    g2d.setColor(Color.WHITE);
                }
                g2d.drawString(core.getName(), xf, yf);
            }
        }
    }

    public static boolean paintObject(PathObject pathObject, Graphics2D g, OverlayOptions overlayOptions, PathObjectSelectionModel selectionModel, double downsample) {
        boolean paintSymbols;
        Stroke stroke;
        boolean isSelected;
        if (pathObject == null) {
            return false;
        }
        ROI roi = pathObject.getROI();
        if (roi == null) {
            return false;
        }
        if (!PathObjectPainter.roiIntersectsClipBounds(g, roi)) {
            return false;
        }
        boolean bl = isSelected = selectionModel != null && selectionModel.isSelected(pathObject);
        if (!isSelected && (overlayOptions.isHidden(pathObject) && !pathObject.isTMACore() || PathObjectPainter.isHiddenObjectType(pathObject, overlayOptions))) {
            return false;
        }
        Color color = PathObjectPainter.getBaseObjectColor(pathObject, overlayOptions, isSelected);
        if (pathObject.isDetection() && PathObjectPainter.isRoiTinyAfterDownsampling(roi, downsample)) {
            PathObjectPainter.fillRoiBounds(g, roi, color);
            return true;
        }
        Color colorFill = PathObjectPainter.updateFillColorFromBase(pathObject, color, overlayOptions);
        Color colorStroke = PathObjectPainter.updateStrokeColorFromBase(pathObject, color, overlayOptions);
        if (colorFill != null && colorFill.equals(colorStroke)) {
            colorStroke = ColorToolsAwt.darkenColor((Color)color);
        }
        Stroke stroke2 = stroke = colorStroke == null ? null : PathObjectPainter.calculateStroke(pathObject, downsample, isSelected);
        if (colorFill != null && pathObject.hasChildObjects()) {
            colorFill = ColorToolsAwt.getColorWithOpacity((Color)colorFill, (double)0.1);
        }
        if (stroke != null) {
            g.setStroke(stroke);
        }
        if (paintSymbols = PathObjectPainter.shouldPaintRoiAsSymbol(pathObject, overlayOptions)) {
            Shape shape = PathObjectPainter.getCentroidSymbol(pathObject);
            PathObjectPainter.paintShape(shape, g, colorStroke, stroke, colorFill);
        } else if (pathObject.isCell()) {
            ROI nucleus;
            PathCellObject cell = (PathCellObject)pathObject;
            if (overlayOptions.getShowCellBoundaries()) {
                PathObjectPainter.paintROI(roi, g, colorStroke, stroke, colorFill, downsample);
            }
            if (overlayOptions.getShowCellNuclei() && (nucleus = cell.getNucleusROI()) != null) {
                PathObjectPainter.paintROI(cell.getNucleusROI(), g, colorStroke, stroke, colorFill, downsample);
            }
        } else {
            PathObjectPainter.paintROI(roi, g, colorStroke, stroke, colorFill, downsample);
            String arrowhead = PathObjectPainter.getArrowheadStringOrNull(pathObject, roi);
            if (arrowhead != null) {
                PathObjectPainter.paintArrowheads(g, roi, arrowhead, colorStroke, null, downsample);
            }
        }
        return true;
    }

    private static String getArrowheadStringOrNull(PathObject pathObject, ROI roi) {
        if (pathObject.isAnnotation() && roi.isLine() && roi instanceof LineROI) {
            return pathObject.getMetadata().getOrDefault("arrowhead", null);
        }
        return null;
    }

    private static void paintArrowheads(Graphics2D g, ROI roi, String arrow, Color colorStroke, Stroke stroke, double downsample) {
        List points = roi.getAllPoints();
        ArrayList<Point2> pointsToDraw = new ArrayList<Point2>();
        ArrayList<Double> angles = new ArrayList<Double>();
        if (arrow.contains("<")) {
            pointsToDraw.add((Point2)points.get(0));
            if (points.size() > 1) {
                angles.add(Math.atan2(((Point2)points.get(0)).getY() - ((Point2)points.get(1)).getY(), ((Point2)points.get(0)).getX() - ((Point2)points.get(1)).getX()) + 1.5707963267948966);
            } else {
                angles.add(0.0);
            }
        }
        if (arrow.contains(">")) {
            pointsToDraw.add((Point2)points.get(points.size() - 1));
            if (points.size() > 1) {
                angles.add(Math.atan2(((Point2)points.get(1)).getY() - ((Point2)points.get(0)).getY(), ((Point2)points.get(1)).getX() - ((Point2)points.get(0)).getX()) + 1.5707963267948966);
            } else {
                angles.add(0.0);
            }
        }
        for (int i = 0; i < pointsToDraw.size(); ++i) {
            Point2 p = (Point2)pointsToDraw.get(i);
            double angle = (Double)angles.get(i);
            double width = (float)(PathPrefs.annotationStrokeThicknessProperty().get() * downsample * 6.0);
            double length = Math.min(width, roi.getLength() / 3.0);
            double x = p.getX();
            double y = p.getY();
            Path2D triangle = localPath2D.get();
            triangle.reset();
            triangle.moveTo(x, y);
            triangle.lineTo(x - width / 2.0, y + length);
            triangle.lineTo(x + width / 2.0, y + length);
            triangle.closePath();
            triangle.transform(AffineTransform.getRotateInstance(angle, p.getX(), p.getY()));
            PathObjectPainter.paintShape(triangle, g, colorStroke, stroke, colorStroke);
        }
    }

    private static Color getBaseObjectColor(PathObject pathObject, OverlayOptions overlayOptions, boolean isSelected) {
        MeasurementMapper mapper;
        Color color = null;
        if (isSelected) {
            color = PathObjectPainter.getSelectedObjectColorOrNull();
        }
        if (color != null) {
            return color;
        }
        MeasurementMapper measurementMapper = mapper = pathObject.isDetection() ? PathObjectPainter.getValidMeasurementMapperOrNull(overlayOptions) : null;
        if (mapper != null) {
            return PathObjectPainter.getColorFromMeasurementMapperOrNull(pathObject, mapper);
        }
        Integer rgb = ColorToolsFX.getDisplayedColorARGB(pathObject);
        return ColorToolsAwt.getCachedColor((Integer)rgb);
    }

    private static boolean useDetectionStrokeWidth(double downsample) {
        return downsample >= 1.0 || !PathPrefs.newDetectionRenderingProperty().get();
    }

    private static Stroke calculateStroke(PathObject pathObject, double downsample, boolean isSelected) {
        if (pathObject.isDetection() && PathObjectPainter.useDetectionStrokeWidth(downsample)) {
            if (pathObject.getParent() instanceof PathDetectionObject) {
                return PathObjectPainter.getCachedStroke(PathPrefs.detectionStrokeThicknessProperty().get() / 2.0);
            }
            return PathObjectPainter.getCachedStroke(PathPrefs.detectionStrokeThicknessProperty().get());
        }
        double thicknessScale = downsample * (isSelected && !PathPrefs.useSelectedColorProperty().get() ? 1.6 : 1.0);
        float thickness = (float)(PathPrefs.annotationStrokeThicknessProperty().get() * thicknessScale);
        if (isSelected && pathObject.getParent() == null && PathPrefs.selectionModeStatus().get()) {
            return PathObjectPainter.getCachedStrokeDashed(Float.valueOf(thickness));
        }
        return PathObjectPainter.getCachedStroke(thickness);
    }

    private static Color updateStrokeColorFromBase(PathObject pathObject, Color colorBase, OverlayOptions overlayOptions) {
        if (pathObject.isTile() && PathObjectPainter.getValidMeasurementMapperOrNull(overlayOptions) != null && overlayOptions != null && overlayOptions.getFillDetections()) {
            return null;
        }
        return colorBase;
    }

    private static Double tryToGetDouble(Object obj) {
        if (obj == null) {
            return null;
        }
        if (doubleCache.containsKey(obj)) {
            return doubleCache.getOrDefault(obj, null);
        }
        return doubleCache.computeIfAbsent(obj, PathObjectPainter::tryToParseDouble);
    }

    private static Double tryToParseDouble(Object obj) {
        try {
            if (obj instanceof String) {
                return Double.parseDouble((String)obj);
            }
            if (obj instanceof Number) {
                return ((Number)obj).doubleValue();
            }
        }
        catch (Exception e) {
            logger.warn("Unable to parse double from {}", obj);
        }
        return null;
    }

    private static Double getFillOpacityFromMetadataOrNull(PathObject pathObject) {
        return PathObjectPainter.tryToGetDouble(pathObject.getMetadata().getOrDefault("fillOpacity", null));
    }

    private static Color updateFillColorFromBase(PathObject pathObject, Color colorBase, OverlayOptions overlayOptions) {
        if (pathObject instanceof ParallelTileObject) {
            return ColorToolsAwt.getMoreTranslucentColor((Color)colorBase);
        }
        Double fillOpacity = PathObjectPainter.getFillOpacityFromMetadataOrNull(pathObject);
        if (fillOpacity != null) {
            return ColorToolsAwt.getColorWithOpacity((Color)colorBase, (double)fillOpacity);
        }
        if (pathObject.getPathClass() == PathClass.StandardPathClasses.REGION) {
            return null;
        }
        if (pathObject.isDetection()) {
            if (!overlayOptions.getFillDetections()) {
                return null;
            }
            if (pathObject.isCell() && overlayOptions.getShowCellBoundaries() && overlayOptions.getShowCellNuclei()) {
                return ColorToolsAwt.getMoreTranslucentColor((Color)colorBase);
            }
            if (pathObject.getParent() instanceof PathDetectionObject) {
                return ColorToolsAwt.getTranslucentColor((Color)colorBase);
            }
            if (pathObject.isTile() && pathObject.getPathClass() == null && overlayOptions.getMeasurementMapper() == null) {
                return ColorToolsAwt.getMoreTranslucentColor((Color)colorBase);
            }
            return colorBase;
        }
        if (pathObject.isTMACore()) {
            return null;
        }
        if (pathObject.isAnnotation()) {
            if (pathObject.getROI().isPoint() && overlayOptions.getFillDetections()) {
                return colorBase;
            }
            if (overlayOptions.getFillAnnotations()) {
                return ColorToolsAwt.getMoreTranslucentColor((Color)colorBase);
            }
            return null;
        }
        return null;
    }

    private static MeasurementMapper getValidMeasurementMapperOrNull(OverlayOptions overlayOptions) {
        MeasurementMapper mapper = overlayOptions.getMeasurementMapper();
        if (mapper == null || !mapper.isValid()) {
            return null;
        }
        return mapper;
    }

    private static Color getColorFromMeasurementMapperOrNull(PathObject pathObject, MeasurementMapper mapper) {
        if (!pathObject.hasMeasurements()) {
            return null;
        }
        Integer rgb = mapper.getColorForObject(pathObject);
        if (rgb == null) {
            return null;
        }
        return ColorToolsAwt.getCachedColor((Integer)rgb);
    }

    private static Color getSelectedObjectColorOrNull() {
        Integer rgb;
        if (PathPrefs.useSelectedColorProperty().get() && (rgb = PathPrefs.colorSelectedObjectProperty().getValue()) != null) {
            return ColorToolsAwt.getCachedColor((Integer)rgb);
        }
        return null;
    }

    private static boolean isHiddenObjectType(PathObject pathObject, OverlayOptions overlayOptions) {
        if (pathObject.isAnnotation()) {
            return !overlayOptions.getShowAnnotations();
        }
        if (pathObject.isDetection()) {
            return !overlayOptions.getShowDetections();
        }
        if (pathObject.isTMACore()) {
            return !overlayOptions.getShowTMAGrid();
        }
        return false;
    }

    private static void fillRoiBounds(Graphics2D g2d, ROI roi, Color color) {
        int x = (int)roi.getBoundsX();
        int y = (int)roi.getBoundsY();
        int w = (int)Math.ceil(roi.getBoundsWidth());
        int h = (int)Math.ceil(roi.getBoundsHeight());
        if (w > 0 && h > 0) {
            g2d.setColor(color);
            g2d.fillRect(x, y, w, h);
        }
    }

    private static boolean isRoiTinyAfterDownsampling(ROI roi, double downsample) {
        return downsample > 4.0 && roi.getBoundsWidth() / downsample < 3.0 && roi.getBoundsHeight() / downsample < 3.0;
    }

    private static boolean roiIntersectsClipBounds(Graphics2D g2d, ROI roi) {
        Rectangle bounds = g2d.getClipBounds();
        if (bounds == null) {
            return true;
        }
        return bounds.intersects(roi.getBoundsX(), roi.getBoundsY(), Math.max(1.0, roi.getBoundsWidth()), Math.max(1.0, roi.getBoundsHeight()));
    }

    private static int getNumSubclasses(PathClass pathClass) {
        if (pathClass == null) {
            return 0;
        }
        if (!pathClass.isDerivedClass()) {
            return 1;
        }
        return PathClassTools.splitNames((PathClass)pathClass).size();
    }

    private static Shape getCentroidSymbol(PathObject pathObject) {
        ROI roi = PathObjectTools.getROI((PathObject)pathObject, (boolean)true);
        double radius = PathPrefs.detectionStrokeThicknessProperty().get() * 2.0;
        for (PathObject parent = pathObject.getParent(); parent != null && parent.isDetection(); parent = parent.getParent()) {
            if (!((radius /= 2.0) < 1.0)) continue;
            radius = 1.0;
            break;
        }
        int nSubclasses = PathObjectPainter.getNumSubclasses(pathObject.getPathClass());
        return PathObjectPainter.getCentroidSymbol(roi, nSubclasses, radius);
    }

    private static Shape getCentroidSymbol(ROI roi, int nSubclasses, double radius) {
        double x = roi.getCentroidX();
        double y = roi.getCentroidY();
        switch (nSubclasses) {
            case 0: {
                Ellipse2D ellipse = localEllipse2D.get();
                ellipse.setFrame(x - radius, y - radius, radius * 2.0, radius * 2.0);
                return ellipse;
            }
            case 1: {
                Rectangle2D rect = localRect2D.get();
                rect.setFrame(x - radius, y - radius, radius * 2.0, radius * 2.0);
                return rect;
            }
            case 2: {
                Path2D triangle = localPath2D.get();
                double sqrt3 = Math.sqrt(3.0);
                triangle.reset();
                triangle.moveTo(x, y - radius * 2.0 / sqrt3);
                triangle.lineTo(x - radius, y + radius / sqrt3);
                triangle.lineTo(x + radius, y + radius / sqrt3);
                triangle.closePath();
                return triangle;
            }
            case 3: {
                Path2D plus = localPath2D.get();
                plus.reset();
                plus.moveTo(x, y - radius);
                plus.lineTo(x, y + radius);
                plus.moveTo(x - radius, y);
                plus.lineTo(x + radius, y);
                return plus;
            }
        }
        Path2D cross = localPath2D.get();
        cross.reset();
        cross.moveTo(x - (radius /= Math.sqrt(2.0)), y - radius);
        cross.lineTo(x + radius, y + radius);
        cross.moveTo(x + radius, y - radius);
        cross.lineTo(x - radius, y + radius);
        return cross;
    }

    private static boolean shouldPaintRoiAsSymbol(PathObject pathObject, OverlayOptions overlayOptions) {
        return overlayOptions.getDetectionDisplayMode() == OverlayOptions.DetectionDisplayMode.CENTROIDS && pathObject.isDetection() && !pathObject.isTile();
    }

    private static void paintROI(ROI roi, Graphics2D g, Color colorStroke, Stroke stroke, Color colorFill, double downsample) {
        if (colorStroke == null && colorFill == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        if (RoiTools.isShapeROI((ROI)roi)) {
            Shape shape = shapeProvider.getShape(roi, downsample, g.getClipBounds());
            if (roi.isArea()) {
                PathObjectPainter.paintShape(shape, g, colorStroke, stroke, colorFill);
            } else if (roi.isLine()) {
                PathObjectPainter.paintShape(shape, g, colorStroke, stroke, null);
            }
        } else if (roi.isPoint()) {
            PathObjectPainter.paintPoints(roi, g2d, PathPrefs.pointRadiusProperty().get(), colorStroke, stroke, colorFill, downsample);
        }
        g2d.dispose();
    }

    public static void paintShape(Shape shape, Graphics2D g2d, Color colorStroke, Stroke stroke, Color colorFill) {
        long startTime = System.currentTimeMillis();
        if (colorFill != null) {
            g2d.setColor(colorFill);
            g2d.fill(shape);
        }
        if (colorStroke != null) {
            if (stroke != null) {
                g2d.setStroke(stroke);
            }
            g2d.setColor(colorStroke);
            g2d.draw(shape);
        }
        long endTime = System.currentTimeMillis();
        if (logger.isTraceEnabled() && endTime - startTime > 1000L) {
            logger.trace("Painting time: {} for shape={}", (Object)(endTime - startTime), (Object)shape);
        }
    }

    private static void paintPoints(ROI pathPoints, Graphics2D g2d, double radius, Color colorStroke, Stroke stroke, Color colorFill, double downsample) {
        RectangularShape ellipse;
        ROI convexHull;
        PointsROI pathPointsROI;
        PointsROI pointsROI = pathPointsROI = pathPoints instanceof PointsROI ? (PointsROI)pathPoints : null;
        if (pathPointsROI != null && PathPrefs.showPointHullsProperty().get() && (convexHull = pathPointsROI.getConvexHull()) != null) {
            Color colorHull = colorFill != null ? colorFill : colorStroke;
            if ((colorHull = ColorToolsAwt.getColorWithOpacity((Color)colorHull, (double)0.1)) != null) {
                PathObjectPainter.paintShape(RoiTools.getShape((ROI)convexHull), g2d, null, null, colorHull);
            }
        }
        double scale = Math.max(1.0, downsample);
        radius = Math.max(1.0 / scale, radius);
        Rectangle bounds = g2d.getClipBounds();
        if (bounds != null) {
            ((Rectangle2D)bounds).setRect(((RectangularShape)bounds).getX() - radius, ((RectangularShape)bounds).getY() - radius, ((RectangularShape)bounds).getWidth() + radius * 2.0, ((RectangularShape)bounds).getHeight() + radius * 2.0);
        }
        Graphics2D g = g2d;
        if (radius / downsample < 0.5) {
            if (colorStroke == null) {
                colorStroke = colorFill;
            }
            colorFill = null;
            ellipse = new Rectangle2D.Double();
            int rule = 3;
            float alpha = (float)(radius / downsample);
            Composite composite = g.getComposite();
            if (composite instanceof AlphaComposite) {
                AlphaComposite temp = (AlphaComposite)composite;
                rule = temp.getRule();
                alpha = temp.getAlpha() * alpha;
            }
            if (alpha < 0.01f) {
                return;
            }
            composite = AlphaComposite.getInstance(rule, alpha);
            g = (Graphics2D)g2d.create();
            g.setComposite(composite);
        } else {
            ellipse = new Ellipse2D.Double();
        }
        g.setStroke(stroke);
        for (Point2 p : pathPoints.getAllPoints()) {
            if (bounds != null && !bounds.contains(p.getX(), p.getY())) continue;
            ellipse.setFrame(p.getX() - radius, p.getY() - radius, radius * 2.0, radius * 2.0);
            if (colorFill != null) {
                g.setColor(colorFill);
                g.fill(ellipse);
            }
            if (colorStroke == null) continue;
            g.setColor(colorStroke);
            g.draw(ellipse);
        }
        if (g != g2d) {
            g.dispose();
        }
    }

    static Stroke getCachedStrokeDashed(Number thickness) {
        Stroke stroke = dashedStrokeMap.get(thickness);
        if (stroke == null) {
            stroke = new BasicStroke(thickness.floatValue(), 0, 0, 10.0f, new float[]{thickness.floatValue() * 5.0f}, 0.0f);
            dashedStrokeMap.put(thickness, stroke);
        }
        return stroke;
    }

    static Stroke getCachedStroke(Number thickness) {
        Stroke stroke = strokeMap.get(thickness);
        if (stroke == null) {
            stroke = new BasicStroke(thickness.floatValue());
            strokeMap.put(thickness, stroke);
        }
        return stroke;
    }

    private static Stroke getCachedStroke(int thickness) {
        return PathObjectPainter.getCachedStroke((Number)thickness);
    }

    public static Stroke getCachedStroke(double thickness) {
        if (thickness == Math.rint(thickness)) {
            return PathObjectPainter.getCachedStroke((int)thickness);
        }
        return PathObjectPainter.getCachedStroke(Float.valueOf((float)thickness));
    }

    public static void paintHandles(RoiEditor roiEditor, Graphics2D g2d, double minHandleSize, double maxHandleSize, Color colorStroke, Color colorFill) {
        if (!(roiEditor.getROI() instanceof PointsROI)) {
            PathObjectPainter.paintHandles(roiEditor.getHandles(), g2d, minHandleSize, maxHandleSize, colorStroke, colorFill);
        }
    }

    public static void paintHandles(List<Point2> handles, Graphics2D g2d, double minHandleSize, double maxHandleSize, Color colorStroke, Color colorFill) {
        Rectangle2D.Double handleShape = new Rectangle2D.Double();
        int n = handles.size();
        if (minHandleSize == maxHandleSize) {
            for (Point2 p : handles) {
                double handleSize = minHandleSize;
                ((RectangularShape)handleShape).setFrame(p.getX() - handleSize / 2.0, p.getY() - handleSize / 2.0, handleSize, handleSize);
                if (colorFill != null) {
                    g2d.setColor(colorFill);
                    g2d.fill(handleShape);
                }
                if (colorStroke == null) continue;
                g2d.setColor(colorStroke);
                g2d.draw(handleShape);
            }
            return;
        }
        for (int i = 0; i < handles.size(); ++i) {
            Point2 current = handles.get(i);
            Point2 before = handles.get((i + n - 1) % n);
            Point2 after = handles.get((i + 1) % n);
            double distance = Math.sqrt(Math.min(current.distanceSq((Point)before), current.distanceSq((Point)after))) * 0.5;
            double size = Math.max(minHandleSize, Math.min(distance, maxHandleSize));
            Point2 p = current;
            ((RectangularShape)handleShape).setFrame(p.getX() - size / 2.0, p.getY() - size / 2.0, size, size);
            if (colorFill != null) {
                g2d.setColor(colorFill);
                g2d.fill(handleShape);
            }
            if (colorStroke == null) continue;
            g2d.setColor(colorStroke);
            g2d.draw(handleShape);
        }
    }

    private static double getConnectionStrokeThickness(double downsample) {
        double thickness = PathPrefs.detectionStrokeThicknessProperty().get();
        if (thickness / downsample <= 0.25) {
            return 0.0;
        }
        if (PathObjectPainter.useDetectionStrokeWidth(downsample)) {
            return thickness;
        }
        return thickness * Math.min(1.0, downsample);
    }

    private static float getConnectionAlpha(double downsample) {
        float alpha = (float)(1.0 - downsample / 5.0);
        return Math.min(alpha, 0.4f);
    }

    @Deprecated
    public static void paintConnections(PathObjectConnections connections, PathObjectHierarchy hierarchy, Graphics2D g2d, Color color, double downsampleFactor, ImagePlane plane) {
        if (hierarchy == null || connections == null || connections.isEmpty()) {
            return;
        }
        LogTools.warnOnce((Logger)logger, (String)"Legacy 'Delaunay cluster features 2D' connections are being shown in the viewer - this command is deprecated, and support will be removed in a future version");
        float alpha = PathObjectPainter.getConnectionAlpha(downsampleFactor);
        double thickness = PathObjectPainter.getConnectionStrokeThickness(downsampleFactor);
        if (alpha < 0.1f || thickness <= 0.0) {
            return;
        }
        g2d = (Graphics2D)g2d.create();
        g2d.setStroke(PathObjectPainter.getCachedStroke(thickness));
        g2d.setColor(ColorToolsAwt.getColorWithOpacity((Integer)color.getRGB(), (double)alpha));
        Rectangle bounds = g2d.getClipBounds();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        ImageRegion imageRegion = AwtTools.getImageRegion((Rectangle)bounds, (int)plane.getZ(), (int)plane.getT());
        HashSet<PathObject> vistedObjects = new HashSet<PathObject>();
        Line2D.Double line = new Line2D.Double();
        int nDrawn = 0;
        int nSkipped = 0;
        long startTime = System.currentTimeMillis();
        for (PathObjectConnectionGroup dt : connections.getConnectionGroups()) {
            vistedObjects.clear();
            for (PathObject pathObject : dt.getPathObjectsForRegion(imageRegion)) {
                vistedObjects.add(pathObject);
                ROI roi = PathObjectTools.getROI((PathObject)pathObject, (boolean)true);
                double x1 = roi.getCentroidX();
                double y1 = roi.getCentroidY();
                for (PathObject siblingObject : dt.getConnectedObjects(pathObject)) {
                    double y2;
                    if (vistedObjects.contains(siblingObject)) continue;
                    ROI roi2 = PathObjectTools.getROI((PathObject)siblingObject, (boolean)true);
                    double x2 = roi2.getCentroidX();
                    if (bounds.intersectsLine(x1, y1, x2, y2 = roi2.getCentroidY())) {
                        ((Line2D)line).setLine(x1, y1, x2, y2);
                        g2d.draw(line);
                        ++nDrawn;
                        continue;
                    }
                    ++nSkipped;
                }
            }
        }
        long endTime = System.currentTimeMillis();
        logger.trace("Drawn {} connections in {} ms ({} skipped)", new Object[]{nDrawn, endTime - startTime, nSkipped});
        g2d.dispose();
    }

    public static void paintConnections(DelaunayTools.Subdivision subdivision, PathObjectHierarchy hierarchy, Graphics2D g2d, Color color, double downsampleFactor, ImagePlane plane) {
        if (hierarchy == null || subdivision.size() <= 1) {
            return;
        }
        float alpha = PathObjectPainter.getConnectionAlpha(downsampleFactor);
        double thickness = PathObjectPainter.getConnectionStrokeThickness(downsampleFactor);
        if (alpha < 0.1f || thickness <= 0.0) {
            return;
        }
        g2d = (Graphics2D)g2d.create();
        g2d.setStroke(PathObjectPainter.getCachedStroke(thickness));
        g2d.setColor(ColorToolsAwt.getColorWithOpacity((Integer)color.getRGB(), (double)alpha));
        Rectangle bounds = g2d.getClipBounds();
        ImageRegion region = ImageRegion.createInstance((int)bounds.x, (int)bounds.y, (int)bounds.width, (int)bounds.height, (int)plane.getZ(), (int)plane.getT());
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        HashSet<PathObject> vistedObjects = new HashSet<PathObject>();
        Line2D.Double line = new Line2D.Double();
        int nDrawn = 0;
        int nSkipped = 0;
        long startTime = System.currentTimeMillis();
        for (PathObject pathObject : subdivision.getObjectsForRegion(region)) {
            vistedObjects.add(pathObject);
            ROI roi = PathObjectTools.getROI((PathObject)pathObject, (boolean)true);
            double x1 = roi.getCentroidX();
            double y1 = roi.getCentroidY();
            for (PathObject neighbor : subdivision.getNeighbors(pathObject)) {
                double y2;
                if (vistedObjects.contains(neighbor)) continue;
                ROI roi2 = PathObjectTools.getROI((PathObject)neighbor, (boolean)true);
                double x2 = roi2.getCentroidX();
                if (bounds.intersectsLine(x1, y1, x2, y2 = roi2.getCentroidY())) {
                    ((Line2D)line).setLine(x1, y1, x2, y2);
                    g2d.draw(line);
                    ++nDrawn;
                    continue;
                }
                ++nSkipped;
            }
        }
        long endTime = System.currentTimeMillis();
        logger.trace("Drawn {} connections in {} ms ({} skipped)", new Object[]{nDrawn, endTime - startTime, nSkipped});
        g2d.dispose();
    }

    static class ShapeProvider {
        static final int MIN_SIMPLIFY_VERTICES = 250;
        private final RectanglePool rectanglePool = new RectanglePool();
        private final EllipsePool ellipsePool = new EllipsePool();
        private final LinePool linePool = new LinePool();
        private final Map<Area, GriddedArea> areaMap = Collections.synchronizedMap(new WeakHashMap());

        ShapeProvider() {
        }

        public Shape getShape(ROI roi, double downsample, Rectangle clip) {
            Shape shape = this.getShape(roi, downsample);
            if (shape instanceof Area) {
                Area area = (Area)shape;
                if (clip != null) {
                    GriddedArea griddedArea = this.areaMap.computeIfAbsent(area, GriddedArea::new);
                    shape = griddedArea.getArea(clip);
                }
            }
            return shape;
        }

        private Shape getShape(ROI roi, double downsample) {
            if (roi instanceof RectangleROI) {
                Rectangle2D rectangle = (Rectangle2D)this.rectanglePool.getShape();
                rectangle.setFrame(roi.getBoundsX(), roi.getBoundsY(), roi.getBoundsWidth(), roi.getBoundsHeight());
                return rectangle;
            }
            if (roi instanceof EllipseROI) {
                Ellipse2D ellipse = (Ellipse2D)this.ellipsePool.getShape();
                ellipse.setFrame(roi.getBoundsX(), roi.getBoundsY(), roi.getBoundsWidth(), roi.getBoundsHeight());
                return ellipse;
            }
            if (roi instanceof LineROI) {
                LineROI l = (LineROI)roi;
                Line2D line = (Line2D)this.linePool.getShape();
                line.setLine(l.getX1(), l.getY1(), l.getX2(), l.getY2());
                return line;
            }
            return DownsampledShapeCache.getShapeForDownsample(roi, downsample);
        }
    }

    private static class GriddedArea {
        private static int minSegments = 10000;
        private static final Area EMPTY = new Area();
        private final Area mainArea;
        private final int nSegments;
        private final Rectangle mainClip;
        private final double mainClipArea;
        private Map<Rectangle, Area> cache;

        private GriddedArea(Area area) {
            this.mainArea = area;
            this.mainClip = area.getBounds();
            this.mainClipArea = GriddedArea.boundsArea(this.mainClip);
            this.nSegments = GriddedArea.countSegments(area);
        }

        private static int countSegments(Area area) {
            PathIterator iterator = area.getPathIterator(null);
            int nSegments = 0;
            while (!iterator.isDone()) {
                iterator.next();
                ++nSegments;
            }
            return nSegments;
        }

        private void ensureCacheExists() {
            if (this.cache == null) {
                this.cache = Collections.synchronizedMap(new LinkedHashMap<Rectangle, Area>(){

                    @Override
                    protected boolean removeEldestEntry(Map.Entry<Rectangle, Area> eldest) {
                        return this.size() > 200;
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Area getArea(Rectangle clip) {
            if (clip.isEmpty()) {
                return EMPTY;
            }
            if (this.nSegments < minSegments || clip == null || clip.contains(this.mainClip) || GriddedArea.boundsArea(clip) > this.mainClipArea * 0.5) {
                return this.mainArea;
            }
            this.ensureCacheExists();
            if (!this.cache.isEmpty()) {
                Map<Rectangle, Area> map = this.cache;
                synchronized (map) {
                    for (Map.Entry<Rectangle, Area> entry : this.cache.entrySet()) {
                        if (!entry.getKey().contains(clip)) continue;
                        return entry.getValue();
                    }
                }
            }
            Rectangle padded = GriddedArea.createPaddedRectangle(clip, clip.width + 1, clip.height + 1);
            Area cropped = this.crop(padded);
            this.cache.put(padded, cropped);
            return cropped;
        }

        private static double boundsArea(Rectangle rectangle) {
            return rectangle.getWidth() * rectangle.getHeight();
        }

        private static Rectangle createPaddedRectangle(Rectangle clip, int padX, int padY) {
            return new Rectangle((int)(clip.getX() - (double)padX), (int)(clip.getY() - (double)padY), (int)(clip.getWidth() + (double)(padX * 2)), (int)(clip.getHeight() + (double)(padY * 2)));
        }

        private Area crop(Rectangle clip) {
            if (clip.contains(this.mainClip)) {
                return this.mainArea;
            }
            Area croppedArea = new Area(clip);
            croppedArea.intersect(this.mainArea);
            return croppedArea;
        }
    }

    static class LinePool
    extends ShapePool<Line2D> {
        LinePool() {
        }

        @Override
        protected Line2D createShape() {
            return new Line2D.Double();
        }
    }

    static class EllipsePool
    extends ShapePool<Ellipse2D> {
        EllipsePool() {
        }

        @Override
        protected Ellipse2D createShape() {
            return new Ellipse2D.Double();
        }
    }

    static class RectanglePool
    extends ShapePool<Rectangle2D> {
        RectanglePool() {
        }

        @Override
        protected Rectangle2D createShape() {
            return new Rectangle2D.Double();
        }
    }

    static abstract class ShapePool<T extends Shape> {
        private Map<Thread, T> map = new WeakHashMap<Thread, T>();

        ShapePool() {
        }

        protected abstract T createShape();

        public T getShape() {
            Thread thread = Thread.currentThread();
            Shape shape = (Shape)this.map.get(thread);
            if (shape == null) {
                shape = this.createShape();
                this.map.put(thread, shape);
            }
            return (T)shape;
        }
    }
}

