/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer;

import java.util.Arrays;
import java.util.Set;
import java.util.function.Predicate;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyLongProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleFloatProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tools.MeasurementMapper;
import qupath.lib.gui.viewer.GridLines;
import qupath.lib.gui.viewer.RegionFilter;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.classes.PathClass;

public class OverlayOptions {
    private final ObjectProperty<MeasurementMapper> measurementMapper = new SimpleObjectProperty();
    private final BooleanProperty showAnnotations = new SimpleBooleanProperty(null, "showAnnotations", true);
    private final BooleanProperty showNames = new SimpleBooleanProperty(null, "showAnnotationNames", true);
    private final BooleanProperty showTMAGrid = new SimpleBooleanProperty(null, "showTMAGrid", true);
    private final BooleanProperty showDetections = new SimpleBooleanProperty(null, "showDetections", true);
    private final BooleanProperty showConnections = new SimpleBooleanProperty(null, "showConnections", false);
    private final BooleanProperty fillDetections = new SimpleBooleanProperty(null, "fillDetections", false);
    private final BooleanProperty fillAnnotations = new SimpleBooleanProperty(null, "fillAnnotations", false);
    private final BooleanProperty showTMACoreLabels = new SimpleBooleanProperty(null, "showTMACoreLabels", false);
    private final BooleanProperty showGrid = new SimpleBooleanProperty(null, "showGrid", false);
    private final ObjectProperty<GridLines> gridLines = new SimpleObjectProperty(null, "showGridLines", (Object)new GridLines());
    private final BooleanProperty showPixelClassification = new SimpleBooleanProperty(null, "showPixelClassification", true);
    private final ObjectProperty<RegionFilter> pixelClassificationFilter = new SimpleObjectProperty(null, "pixelClassificationFilter", (Object)RegionFilter.StandardRegionFilters.EVERYWHERE);
    private final FloatProperty fontSize = new SimpleFloatProperty();
    private final ObservableSet<PathClass> selectedClasses = FXCollections.observableSet((Object[])new PathClass[0]);
    private final ObjectProperty<ClassVisibilityMode> selectedClassVisibilityMode = new SimpleObjectProperty((Object)ClassVisibilityMode.HIDE_SELECTED);
    private final BooleanProperty useExactSelectedClasses = new SimpleBooleanProperty(null, "useExactSelectedClasses", false);
    private final ObjectProperty<DetectionDisplayMode> cellDisplayMode = new SimpleObjectProperty(null, "cellDisplayMode", (Object)DetectionDisplayMode.NUCLEI_AND_BOUNDARIES);
    private final ObjectProperty<Predicate<PathObject>> showObjectPredicate = new SimpleObjectProperty(null, "showObjectPredicate");
    private final FloatProperty opacity = new SimpleFloatProperty(1.0f);
    private final LongProperty timestamp = new SimpleLongProperty(System.nanoTime());
    private static final OverlayOptions SHARED_INSTANCE = OverlayOptions.createSharedInstance();

    private static OverlayOptions createSharedInstance() {
        OverlayOptions options = new OverlayOptions();
        for (BooleanProperty prop : Arrays.asList(options.showNames, options.showConnections, options.fillDetections, options.fillAnnotations, options.showTMACoreLabels, options.showGrid, options.showAnnotations, options.showDetections, options.showPixelClassification, options.showTMAGrid, options.useExactSelectedClasses)) {
            prop.bindBidirectional((Property)PathPrefs.createPersistentPreference("overlayOptions_" + prop.getName(), prop.get()));
        }
        options.selectedClassVisibilityMode.bindBidirectional(PathPrefs.createPersistentPreference("overlayOptions_selectedClassVisibilityMode", (ClassVisibilityMode)((Object)options.selectedClassVisibilityMode.get()), ClassVisibilityMode.class));
        options.cellDisplayMode.bindBidirectional(PathPrefs.createPersistentPreference("overlayOptions_cellDisplayMode", (DetectionDisplayMode)((Object)options.cellDisplayMode.get()), DetectionDisplayMode.class));
        options.fontSize.bindBidirectional((Property)PathPrefs.createPersistentPreference("overlayOptions_fontSize", options.fontSize.get()));
        return options;
    }

    public static OverlayOptions getSharedInstance() {
        return SHARED_INSTANCE;
    }

    public OverlayOptions() {
        InvalidationListener timestamper = e -> this.updateTimestamp();
        this.showAnnotations.addListener(timestamper);
        this.showNames.addListener(timestamper);
        this.showTMAGrid.addListener(timestamper);
        this.showPixelClassification.addListener(timestamper);
        this.showDetections.addListener(timestamper);
        this.showConnections.addListener(timestamper);
        this.fillDetections.addListener(timestamper);
        this.fillAnnotations.addListener(timestamper);
        this.showTMACoreLabels.addListener(timestamper);
        this.showGrid.addListener(timestamper);
        this.gridLines.addListener(timestamper);
        this.selectedClasses.addListener(timestamper);
        this.cellDisplayMode.addListener(timestamper);
        this.opacity.addListener(timestamper);
        this.fontSize.addListener(timestamper);
        this.useExactSelectedClasses.addListener(timestamper);
        this.selectedClassVisibilityMode.addListener(timestamper);
    }

    public OverlayOptions(OverlayOptions options) {
        this();
        this.cellDisplayMode.set((Object)((DetectionDisplayMode)((Object)options.cellDisplayMode.get())));
        this.fillAnnotations.set(options.fillAnnotations.get());
        this.fillDetections.set(options.fillDetections.get());
        this.gridLines.set((Object)((GridLines)options.gridLines.get()));
        this.selectedClasses.addAll(options.selectedClasses);
        this.showObjectPredicateProperty().set((Object)((Predicate)options.showObjectPredicateProperty().get()));
        this.selectedClassVisibilityMode.set((Object)((ClassVisibilityMode)((Object)options.selectedClassVisibilityModeProperty().get())));
        this.useExactSelectedClasses.set(options.useExactSelectedClasses.get());
        this.measurementMapper.set((Object)((MeasurementMapper)options.measurementMapper.get()));
        this.opacity.set(options.opacity.get());
        this.showAnnotations.set(options.showAnnotations.get());
        this.showNames.set(options.showNames.get());
        this.showConnections.set(options.showConnections.get());
        this.showDetections.set(options.showDetections.get());
        this.showGrid.set(options.showGrid.get());
        this.showPixelClassification.set(options.showPixelClassification.get());
        this.showTMACoreLabels.set(options.showTMACoreLabels.get());
        this.showTMAGrid.set(options.showTMAGrid.get());
        this.pixelClassificationFilter.set((Object)((RegionFilter)options.pixelClassificationFilter.get()));
        this.fontSize.set(options.fontSize.get());
        this.timestamp.set(options.timestamp.get());
    }

    private void updateTimestamp() {
        this.timestamp.set(System.nanoTime());
    }

    public ReadOnlyLongProperty lastChangeTimestamp() {
        return this.timestamp;
    }

    public void setOpacity(float opacity) {
        opacity = opacity < 0.0f ? 0.0f : (opacity > 1.0f ? 1.0f : opacity);
        this.opacity.set(opacity);
    }

    public float getOpacity() {
        return this.opacity.get();
    }

    public FloatProperty opacityProperty() {
        return this.opacity;
    }

    public DetectionDisplayMode getDetectionDisplayMode() {
        return (DetectionDisplayMode)((Object)this.cellDisplayMode.get());
    }

    public boolean getShowCellNuclei() {
        return this.cellDisplayMode.get() == DetectionDisplayMode.NUCLEI_AND_BOUNDARIES || this.cellDisplayMode.get() == DetectionDisplayMode.NUCLEI_ONLY;
    }

    public boolean getShowCellBoundaries() {
        return this.cellDisplayMode.get() == DetectionDisplayMode.NUCLEI_AND_BOUNDARIES || this.cellDisplayMode.get() == DetectionDisplayMode.BOUNDARIES_ONLY;
    }

    public void setDetectionDisplayMode(DetectionDisplayMode mode) {
        this.cellDisplayMode.set((Object)mode);
    }

    public ObjectProperty<DetectionDisplayMode> detectionDisplayModeProperty() {
        return this.cellDisplayMode;
    }

    public float getThickStrokeWidth(double downsample) {
        return (float)(PathPrefs.annotationStrokeThicknessProperty().get() * Math.max(1.0, downsample));
    }

    public void setShowTMAGrid(boolean show) {
        this.showTMAGrid.set(show);
    }

    public void setShowAnnotations(boolean show) {
        this.showAnnotations.set(show);
    }

    public void setShowNames(boolean show) {
        this.showNames.set(show);
    }

    public void setFontSize(float size) {
        this.fontSize.set(size);
    }

    public void setShowDetections(boolean show) {
        this.showDetections.set(show);
    }

    public void setShowPixelClassification(boolean show) {
        this.showPixelClassification.set(show);
    }

    public void setFillDetections(boolean fill) {
        this.fillDetections.set(fill);
    }

    public void setFillAnnotations(boolean fill) {
        this.fillAnnotations.set(fill);
    }

    public void setShowConnections(boolean show) {
        this.showConnections.set(show);
    }

    public void setShowTMACoreLabels(boolean showTMALabels) {
        this.showTMACoreLabels.set(showTMALabels);
    }

    public boolean getShowTMACoreLabels() {
        return this.showTMACoreLabels.get();
    }

    public BooleanProperty showTMACoreLabelsProperty() {
        return this.showTMACoreLabels;
    }

    public BooleanProperty showConnectionsProperty() {
        return this.showConnections;
    }

    public boolean getShowPixelClassification() {
        return this.showPixelClassification.get();
    }

    public boolean getShowAnnotations() {
        return this.showAnnotations.get();
    }

    public boolean getShowNames() {
        return this.showNames.get();
    }

    public float getFontSize() {
        return this.fontSize.get();
    }

    public boolean getShowTMAGrid() {
        return this.showTMAGrid.get();
    }

    public boolean getShowDetections() {
        return this.showDetections.get();
    }

    public boolean getShowConnections() {
        return this.showConnections.get();
    }

    public boolean getFillDetections() {
        return this.fillDetections.get();
    }

    public boolean getFillAnnotations() {
        return this.fillAnnotations.get();
    }

    public void setShowGrid(boolean showGrid) {
        this.showGrid.set(showGrid);
    }

    public boolean getShowGrid() {
        return this.showGrid.get();
    }

    public GridLines getGridLines() {
        return (GridLines)this.gridLines.get();
    }

    public void setGridLines(GridLines gridLines) {
        this.gridLines.set((Object)gridLines);
    }

    public ObjectProperty<GridLines> gridLinesProperty() {
        return this.gridLines;
    }

    public void setMeasurementMapper(MeasurementMapper mapper) {
        this.measurementMapper.set((Object)mapper);
    }

    public MeasurementMapper getMeasurementMapper() {
        return (MeasurementMapper)this.measurementMapper.get();
    }

    public ObjectProperty<MeasurementMapper> measurementMapperProperty() {
        return this.measurementMapper;
    }

    public void resetMeasurementMapper() {
        this.setMeasurementMapper(null);
    }

    public boolean getAllPathClassesVisible() {
        return this.selectedClasses.isEmpty();
    }

    public boolean isHidden(PathObject pathObject) {
        return this.isHiddenByType(pathObject) || this.isHiddenByPredicate(pathObject) || this.isPathClassHidden(pathObject.getPathClass());
    }

    public ObjectProperty<Predicate<PathObject>> showObjectPredicateProperty() {
        return this.showObjectPredicate;
    }

    public void resetShowObjectPredicate() {
        this.setShowObjectPredicate(null);
    }

    public void setShowObjectPredicate(Predicate<PathObject> pathObjectPredicate) {
        this.showObjectPredicate.set(pathObjectPredicate);
    }

    public Predicate<PathObject> getShowObjectPredicate() {
        return (Predicate)this.showObjectPredicate.get();
    }

    private boolean isHiddenByType(PathObject pathObject) {
        if (pathObject.isDetection()) {
            return !this.getShowDetections();
        }
        if (pathObject.isAnnotation()) {
            return !this.getShowAnnotations();
        }
        if (pathObject.isTMACore()) {
            return !this.getShowTMAGrid();
        }
        return false;
    }

    private boolean isHiddenByPredicate(PathObject pathObject) {
        Predicate<PathObject> predicate = this.getShowObjectPredicate();
        return predicate != null && !predicate.test(pathObject);
    }

    public boolean isPathClassHidden(PathClass pathClass) {
        boolean checkContains;
        ClassVisibilityMode mode = this.getSelectedClassVisibilityMode();
        boolean showByDefault = mode == ClassVisibilityMode.HIDE_SELECTED;
        boolean bl = checkContains = !this.getUseExactSelectedClasses();
        if (this.isSelectedClass(pathClass) || checkContains && this.containsSelectedClass(pathClass)) {
            return showByDefault;
        }
        return !showByDefault;
    }

    private boolean isSelectedClass(PathClass pathClass) {
        if (this.selectedClasses.isEmpty()) {
            return false;
        }
        if (pathClass == null || pathClass == PathClass.NULL_CLASS) {
            return this.selectedClasses.contains(null) || this.selectedClasses.contains((Object)PathClass.NULL_CLASS);
        }
        return this.selectedClasses.contains((Object)pathClass);
    }

    private boolean containsSelectedClass(PathClass pathClass) {
        if (this.selectedClasses.isEmpty()) {
            return false;
        }
        if (pathClass == null || pathClass == PathClass.NULL_CLASS) {
            return false;
        }
        Set set = pathClass.toSet();
        for (PathClass selected : this.selectedClasses) {
            if (selected == null || selected == PathClass.NULL_CLASS || !pathClass.isDerivedClass() && !selected.isDerivedClass() || !set.containsAll(selected.toSet())) continue;
            return true;
        }
        return false;
    }

    public void setPathClassHidden(PathClass pathClass, boolean hidden) {
        if (hidden) {
            this.selectedClasses.add((Object)pathClass);
        } else {
            this.selectedClasses.remove((Object)pathClass);
        }
    }

    public ObservableSet<PathClass> selectedClassesProperty() {
        return this.selectedClasses;
    }

    public BooleanProperty useExactSelectedClassesProperty() {
        return this.useExactSelectedClasses;
    }

    public void setUseExactSelectedClasses(boolean useExact) {
        this.useExactSelectedClasses.set(useExact);
    }

    public boolean getUseExactSelectedClasses() {
        return this.useExactSelectedClasses.get();
    }

    public ObjectProperty<ClassVisibilityMode> selectedClassVisibilityModeProperty() {
        return this.selectedClassVisibilityMode;
    }

    public ClassVisibilityMode getSelectedClassVisibilityMode() {
        return (ClassVisibilityMode)((Object)this.selectedClassVisibilityMode.get());
    }

    public void setSelectedClassVisibilityMode(ClassVisibilityMode value) {
        this.selectedClassVisibilityMode.set((Object)value);
    }

    public BooleanProperty showAnnotationsProperty() {
        return this.showAnnotations;
    }

    public BooleanProperty showNamesProperty() {
        return this.showNames;
    }

    public FloatProperty fontSizeProperty() {
        return this.fontSize;
    }

    public BooleanProperty showTMAGridProperty() {
        return this.showTMAGrid;
    }

    public BooleanProperty showPixelClassificationProperty() {
        return this.showPixelClassification;
    }

    public ObjectProperty<RegionFilter> pixelClassificationFilterRegionProperty() {
        return this.pixelClassificationFilter;
    }

    public void setPixelClassificationRegionFilter(RegionFilter region) {
        this.pixelClassificationFilter.set((Object)region);
    }

    public RegionFilter getPixelClassificationRegionFilter() {
        return (RegionFilter)this.pixelClassificationFilter.get();
    }

    public BooleanProperty showDetectionsProperty() {
        return this.showDetections;
    }

    public BooleanProperty fillDetectionsProperty() {
        return this.fillDetections;
    }

    public BooleanProperty fillAnnotationsProperty() {
        return this.fillAnnotations;
    }

    public BooleanProperty showGridProperty() {
        return this.showGrid;
    }

    public static enum ClassVisibilityMode {
        HIDE_SELECTED,
        SHOW_SELECTED;

    }

    public static enum DetectionDisplayMode {
        BOUNDARIES_ONLY,
        NUCLEI_ONLY,
        NUCLEI_AND_BOUNDARIES,
        CENTROIDS;

    }
}

