/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.gui.viewer.QuPathViewerListener;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.objects.PathObject;

class ImageOverview
implements QuPathViewerListener {
    private static final Logger logger = LoggerFactory.getLogger(ImageOverview.class);
    private QuPathViewer viewer;
    private Canvas canvas = new Canvas();
    private boolean repaintRequested = false;
    private BufferedImage imgLastThumbnail;
    private WritableImage imgPreview;
    private int preferredWidth = 150;
    private Shape shapeVisible = null;
    private AffineTransform transform;
    private static Color color = Color.rgb((int)200, (int)0, (int)0, (double)0.8);
    private static Color colorBorder = Color.rgb((int)64, (int)64, (int)64);

    protected void mouseViewerToLocation(double x, double y) {
        ImageServer<BufferedImage> server = this.viewer.getServer();
        if (server == null) {
            return;
        }
        double cx = x / this.getWidth() * (double)server.getWidth();
        double cy = y / this.getHeight() * (double)server.getHeight();
        this.viewer.setCenterPixelLocation(cx, cy);
    }

    public ImageOverview(QuPathViewer viewer) {
        this.viewer = viewer;
        this.setImage(viewer.getRGBThumbnail());
        this.canvas.setOnMouseClicked(e -> this.mouseViewerToLocation(e.getX(), e.getY()));
        this.canvas.setOnMouseDragged(e -> {
            this.mouseViewerToLocation(e.getX(), e.getY());
            e.consume();
        });
        viewer.zPositionProperty().addListener(v -> this.repaint());
        viewer.tPositionProperty().addListener(v -> this.repaint());
        viewer.addViewerListener(this);
    }

    private void updateTransform() {
        if (this.imgPreview != null && this.viewer != null && this.viewer.getServer() != null) {
            double scale = this.imgPreview.getWidth() / (double)this.viewer.getServer().getWidth();
            if (scale > 0.0) {
                if (this.transform == null) {
                    this.transform = AffineTransform.getScaleInstance(scale, scale);
                } else {
                    this.transform.setToScale(scale, scale);
                }
            } else {
                this.transform = null;
            }
        }
    }

    void paintCanvas() {
        GraphicsContext g = this.canvas.getGraphicsContext2D();
        double w = this.getWidth();
        double h = this.getHeight();
        g.clearRect(0.0, 0.0, w, h);
        if (this.viewer == null || !this.viewer.hasServer()) {
            return;
        }
        this.setImage(this.viewer.getRGBThumbnail());
        g.drawImage((Image)this.imgPreview, 0.0, 0.0);
        if (this.shapeVisible != null) {
            g.setStroke((Paint)color);
            g.setLineWidth(1.0);
            PathIterator iterator = this.shapeVisible.getPathIterator(null);
            double[] coords = new double[6];
            g.beginPath();
            while (!iterator.isDone()) {
                int type = iterator.currentSegment(coords);
                if (type == 0) {
                    g.moveTo(coords[0], coords[1]);
                } else if (type == 1) {
                    g.lineTo(coords[0], coords[1]);
                } else if (type == 4) {
                    g.closePath();
                    g.stroke();
                } else {
                    logger.debug("Unknown PathIterator type: {}", (Object)type);
                }
                iterator.next();
            }
        }
        g.setLineWidth(2.0);
        g.setStroke((Paint)colorBorder);
        g.strokeRect(0.0, 0.0, w, h);
        this.repaintRequested = false;
    }

    public boolean isVisible() {
        return this.canvas.isVisible();
    }

    public void setVisible(boolean visible) {
        this.canvas.setVisible(visible);
    }

    private double getWidth() {
        return this.canvas.getWidth();
    }

    private double getHeight() {
        return this.canvas.getHeight();
    }

    private void setImage(BufferedImage img) {
        if (img == this.imgLastThumbnail) {
            return;
        }
        if (img == null) {
            this.imgLastThumbnail = null;
        } else {
            int preferredHeight = (int)((double)img.getHeight() * ((double)this.preferredWidth / (double)img.getWidth()));
            this.imgPreview = GuiTools.getScaledRGBInstance(img, this.preferredWidth, preferredHeight);
            this.canvas.setWidth(this.imgPreview.getWidth());
            this.canvas.setHeight(this.imgPreview.getHeight());
            this.imgLastThumbnail = img;
        }
        this.updateTransform();
    }

    @Override
    public void imageDataChanged(QuPathViewer viewer, ImageData<BufferedImage> imageDataOld, ImageData<BufferedImage> imageDataNew) {
        this.setImage(viewer.getRGBThumbnail());
        this.repaint();
    }

    @Override
    public void visibleRegionChanged(QuPathViewer viewer, Shape shape) {
        if (shape != null) {
            if (this.transform == null) {
                this.updateTransform();
            }
            this.shapeVisible = this.transform != null ? this.transform.createTransformedShape(shape) : shape;
        } else {
            this.shapeVisible = null;
        }
        this.repaint();
    }

    void repaint() {
        if (Platform.isFxApplicationThread()) {
            this.repaintRequested = true;
            this.paintCanvas();
            return;
        }
        if (this.repaintRequested) {
            return;
        }
        logger.trace("Overview repaint requested!");
        this.repaintRequested = true;
        Platform.runLater(() -> this.repaint());
    }

    public Node getNode() {
        return this.canvas;
    }

    @Override
    public void selectedObjectChanged(QuPathViewer viewer, PathObject pathObjectSelected) {
    }

    @Override
    public void viewerClosed(QuPathViewer viewer) {
        this.viewer = null;
    }
}

