/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer;

import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import qupath.lib.common.GeneralTools;
import qupath.lib.geom.Point2;
import qupath.lib.roi.interfaces.ROI;

public class DownsampledShapeCache {
    private static final int pointCountThreshold = 1000;
    private static final double minDownsample = 4.0;
    private final double downsampleStep;
    private final DownsampledShape shape;
    private final boolean canSimplify;
    private final List<DownsampledShape> downsampledShapes;
    private static final Map<ROI, DownsampledShapeCache> shapeCache = Collections.synchronizedMap(new WeakHashMap());

    private static DownsampledShapeCache getInstance(ROI roi) {
        return shapeCache.computeIfAbsent(roi, DownsampledShapeCache::new);
    }

    public static Shape getShapeForDownsample(ROI roi, double downsample) {
        if (roi.isArea() && roi.getNumPoints() > 1000) {
            return DownsampledShapeCache.getInstance(roi).getForDownsample(downsample);
        }
        return roi.getShape();
    }

    private DownsampledShapeCache(ROI roi) {
        int nPoints = roi.getNumPoints();
        this.shape = new DownsampledShape(roi.getShape(), 1.0, nPoints);
        boolean bl = this.canSimplify = nPoints > 1000 && roi.isArea();
        if (this.canSimplify) {
            this.downsampleStep = nPoints < 5000000 ? 1.25 : (nPoints < 10000000 ? 1.5 : 2.0);
            this.downsampledShapes = new ArrayList<DownsampledShape>();
        } else {
            this.downsampleStep = 2.0;
            this.downsampledShapes = Collections.emptyList();
        }
    }

    private Shape getForDownsample(double downsample) {
        if (!this.canSimplify || downsample <= 4.0) {
            return this.shape.shape();
        }
        DownsampledShape lastShape = this.shape;
        double lastDownsample = 4.0;
        int ind = 0;
        while (lastShape.nPoints() >= 1000 && !(lastDownsample > downsample)) {
            DownsampledShape currentShape;
            if (ind >= this.downsampledShapes.size()) {
                currentShape = DownsampledShapeCache.downsampleShape(lastShape.shape(), ind == 0 ? 4.0 : lastDownsample * this.downsampleStep);
                this.downsampledShapes.add(currentShape);
            } else {
                currentShape = this.downsampledShapes.get(ind);
            }
            lastShape = currentShape;
            lastDownsample = currentShape.downsample();
            ++ind;
        }
        return lastShape.shape();
    }

    private static DownsampledShape downsampleShape(Shape shape, double downsample) {
        ArrayList<Point2> points = new ArrayList<Point2>();
        Path2D path = shape instanceof Path2D ? (Path2D)shape : new Path2D.Float(shape);
        Rectangle2D bounds = shape.getBounds2D();
        PathIterator iter = path.getPathIterator(null, downsample / 2.0);
        Path2D.Float pathNew = new Path2D.Float();
        Rectangle2D.Double segmentBounds = new Rectangle2D.Double();
        int n = 0;
        while (!iter.isDone()) {
            points.clear();
            DownsampledShapeCache.getNextClosedSegment(iter, points, downsample, bounds);
            if (points.isEmpty()) break;
            if (points.size() < 3) continue;
            DownsampledShapeCache.getBounds(points, segmentBounds);
            if (((RectangularShape)segmentBounds).getWidth() < downsample || ((RectangularShape)segmentBounds).getHeight() < downsample) continue;
            boolean firstPoint = true;
            for (Point2 p : points) {
                double xx = p.getX();
                double yy = p.getY();
                if (firstPoint) {
                    firstPoint = false;
                    ((Path2D)pathNew).moveTo(xx, yy);
                    continue;
                }
                ((Path2D)pathNew).lineTo(xx, yy);
            }
            pathNew.closePath();
            n += points.size();
        }
        if (n == 0) {
            return new DownsampledShape(bounds, downsample, 4);
        }
        return new DownsampledShape(pathNew, downsample, n);
    }

    private static Rectangle2D getBounds(List<Point2> points, Rectangle2D bounds) {
        if (bounds == null) {
            bounds = new Rectangle2D.Double();
        }
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (Point2 p : points) {
            minX = Math.min(minX, p.getX());
            minY = Math.min(minY, p.getY());
            maxX = Math.max(maxX, p.getX());
            maxY = Math.max(maxY, p.getY());
        }
        bounds.setFrame(minX, minY, maxX - minX, maxY - minY);
        return bounds;
    }

    private static void getNextClosedSegment(PathIterator iter, List<Point2> points, double downsample, Rectangle2D bounds) {
        double[] seg = new double[6];
        Point2 point = null;
        double minX = bounds.getMinX();
        double maxX = bounds.getMaxX();
        double minY = bounds.getMinY();
        double maxY = bounds.getMaxY();
        double eps = 0.001;
        while (!iter.isDone()) {
            switch (iter.currentSegment(seg)) {
                case 0: 
                case 1: {
                    double x = seg[0];
                    double y = seg[1];
                    if (!GeneralTools.almostTheSame((double)x, (double)minX, (double)eps) && !GeneralTools.almostTheSame((double)x, (double)maxX, (double)eps)) {
                        x = GeneralTools.clipValue((double)(minX + DownsampledShapeCache.roundToDownsample(x - minX, downsample)), (double)minX, (double)maxX);
                    }
                    if (!GeneralTools.almostTheSame((double)y, (double)minY, (double)eps) && !GeneralTools.almostTheSame((double)y, (double)maxY, (double)eps)) {
                        y = GeneralTools.clipValue((double)(minY + DownsampledShapeCache.roundToDownsample(y - minY, downsample)), (double)minY, (double)maxY);
                    }
                    if (point != null && point.getX() == x && point.getY() == y) break;
                    point = new Point2(x, y);
                    points.add(point);
                    break;
                }
                case 4: {
                    iter.next();
                    return;
                }
                default: {
                    throw new RuntimeException("Invalid path iterator " + String.valueOf(iter) + " - only line connections are allowed");
                }
            }
            iter.next();
        }
    }

    private static double roundToDownsample(double value, double downsample) {
        return (double)Math.round(value / downsample) * downsample;
    }

    private record DownsampledShape(Shape shape, double downsample, int nPoints) {
    }
}

