/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.tools;

import java.net.URL;
import javafx.application.ColorScheme;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import qupath.lib.gui.prefs.QuPathStyleManager;

public class WebViews {
    private static final StringProperty userStylesheet = new SimpleStringProperty();

    public static WebView create(boolean bindStylesheetToStyle) {
        WebView webview = new WebView();
        if (bindStylesheetToStyle) {
            WebViews.bindUserStylesheetToStyle(webview.getEngine());
        }
        return webview;
    }

    public static void bindUserStylesheetToStyle(WebEngine engine) {
        engine.userStyleSheetLocationProperty().unbind();
        engine.userStyleSheetLocationProperty().bind((ObservableValue)userStylesheet);
    }

    public static ReadOnlyStringProperty getStyleSheet() {
        return userStylesheet;
    }

    private static void updateStylesheet() {
        Object cssName = "/css/web-";
        switch ((QuPathStyleManager.Fonts)((Object)QuPathStyleManager.fontProperty().get())) {
            case SERIF: {
                cssName = (String)cssName + "serif-";
                break;
            }
            default: {
                cssName = (String)cssName + "sans-serif-";
            }
        }
        ColorScheme scheme = QuPathStyleManager.getStyleColorScheme();
        cssName = scheme != null && scheme == ColorScheme.DARK ? (String)cssName + "dark" : (String)cssName + "light";
        cssName = (String)cssName + ".css";
        URL url = WebViews.class.getResource((String)cssName);
        if (url == null) {
            userStylesheet.set(null);
        } else {
            userStylesheet.set((Object)url.toExternalForm());
        }
    }

    static {
        QuPathStyleManager.fontProperty().addListener((v, o, n) -> WebViews.updateStylesheet());
        QuPathStyleManager.selectedStyleProperty().addListener((v, o, n) -> WebViews.updateStylesheet());
        Platform.getPreferences().colorSchemeProperty().addListener((v, o, n) -> WebViews.updateStylesheet());
        WebViews.updateStylesheet();
    }
}

