/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.tools;

import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Function;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeCell;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.TilePane;
import org.kordamp.ikonli.javafx.StackedFontIcon;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.actions.CommonActions;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tools.IconFactory;
import qupath.lib.objects.PathAnnotationObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.TMACoreObject;

public class PathObjectLabels {
    public static PathObjectMiniPane createPane() {
        return PathObjectLabels.createPane(PathObject::toString);
    }

    public static PathObjectMiniPane createPane(Function<PathObject, String> stringExtractor) {
        PathObjectMiniPane pane = new PathObjectMiniPane(stringExtractor);
        pane.pane.setPadding(new Insets(5.0));
        BorderPane borderPane = pane.pane;
        Objects.requireNonNull(pane);
        borderPane.setPrefHeight((double)(16 + 16));
        return pane;
    }

    public static ListCell<PathObject> createListCell() {
        return PathObjectLabels.createListCell(PathObject::toString);
    }

    public static ListCell<PathObject> createListCell(Function<PathObject, String> stringExtractor) {
        return new PathObjectListCell(stringExtractor);
    }

    public static TreeCell<PathObject> createTreeCell() {
        return PathObjectLabels.createTreeCell(PathObject::toString);
    }

    public static TreeCell<PathObject> createTreeCell(Function<PathObject, String> stringExtractor) {
        return new PathObjectTreeCell(stringExtractor);
    }

    public static class PathObjectMiniPane {
        private final Tooltip tooltip = new Tooltip();
        private Function<PathObject, String> fun;
        private final int w = 16;
        private final int h = 16;
        private final Node lockIcon;
        private final Node unlockIcon;
        private final Node descriptionIcon;
        private final Pane iconPane;
        private final Tooltip descriptionTooltip = new Tooltip();
        private final Label label;
        private final BorderPane pane;
        private static boolean showUnlocked = false;

        public PathObjectMiniPane(Function<PathObject, String> stringExtractor) {
            CommonActions actions;
            this.fun = stringExtractor;
            if (this.fun == null) {
                this.fun = PathObject::toString;
            }
            this.pane = new BorderPane();
            this.label = new Label();
            this.label.setTextOverrun(OverrunStyle.ELLIPSIS);
            StackPane sp = new StackPane(new Node[]{this.label});
            sp.setPrefWidth(1.0);
            sp.setMinHeight(0.0);
            StackPane.setAlignment((Node)this.label, (Pos)Pos.CENTER_LEFT);
            this.pane.setCenter((Node)sp);
            this.lockIcon = PathObjectMiniPane.createLockIcon();
            this.unlockIcon = PathObjectMiniPane.createUnlockIcon();
            this.descriptionIcon = PathObjectMiniPane.createDescriptionIcon();
            QuPathGUI qupath = QuPathGUI.getInstance();
            CommonActions commonActions = actions = qupath == null ? null : qupath.getCommonActions();
            if (actions != null) {
                this.descriptionIcon.setOnMouseClicked(e -> {
                    if (e.getClickCount() == 2) {
                        actions.SHOW_OBJECT_DESCRIPTIONS.handle(new ActionEvent());
                        e.consume();
                    }
                });
            }
            Tooltip.install((Node)this.descriptionIcon, (Tooltip)this.descriptionTooltip);
            this.iconPane = new TilePane();
            Tooltip lockedTooltip = new Tooltip("ROI locked");
            Tooltip.install((Node)this.lockIcon, (Tooltip)lockedTooltip);
            BorderPane.setAlignment((Node)this.label, (Pos)Pos.CENTER_LEFT);
            BorderPane.setAlignment((Node)this.iconPane, (Pos)Pos.CENTER_RIGHT);
        }

        private static Node createDescriptionIcon() {
            StackedFontIcon descriptionIcon = new StackedFontIcon();
            descriptionIcon.setIconCodeLiterals(new String[]{"ion4-md-list"});
            descriptionIcon.setStyle("-fx-background-color: -fx-background; -fx-icon-color: -fx-text-background-color;");
            descriptionIcon.setOpacity(0.6);
            return descriptionIcon;
        }

        private static Node createLockIcon() {
            StackedFontIcon lockIcon = new StackedFontIcon();
            lockIcon.setIconCodeLiterals(new String[]{"ion4-md-lock"});
            lockIcon.setStyle("-fx-background-color: -fx-background; -fx-icon-color: -fx-text-background-color;");
            lockIcon.setOpacity(0.6);
            return lockIcon;
        }

        private static Node createUnlockIcon() {
            StackedFontIcon unlockIcon = new StackedFontIcon();
            unlockIcon.setIconCodeLiterals(new String[]{"ion4-md-unlock"});
            unlockIcon.setStyle("-fx-background-color: -fx-background; -fx-icon-color: -fx-text-background-color;");
            unlockIcon.opacityProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> unlockIcon.isHover() ? 0.4 : 0.1, (Observable[])new Observable[]{unlockIcon.hoverProperty()}));
            return unlockIcon;
        }

        public void setPathObject(PathObject value) {
            boolean hasDescription;
            if (value == null) {
                this.label.setText(null);
                this.label.setGraphic(null);
                this.pane.setRight(null);
                return;
            }
            this.label.setText(this.fun.apply(value));
            String description = this.getDescription(value);
            this.updateTooltips(value, description);
            if (this.showRoiIcon(value)) {
                Node icon = IconFactory.createPathObjectIcon(value, 16, 16);
                this.label.setGraphic(icon);
            } else {
                this.label.setGraphic(null);
            }
            boolean bl = hasDescription = description != null && !description.isBlank();
            if (hasDescription) {
                this.descriptionTooltip.setText(description);
            } else {
                this.descriptionTooltip.setText("No description");
            }
            boolean isLocked = value.isLocked();
            ArrayList<Node> icons = new ArrayList<Node>();
            if (hasDescription) {
                icons.add(this.descriptionIcon);
            }
            if (isLocked) {
                icons.add(this.lockIcon);
            } else if (showUnlocked) {
                icons.add(this.unlockIcon);
            }
            if (icons.isEmpty()) {
                this.pane.setRight(null);
            } else {
                this.iconPane.getChildren().setAll(icons);
                this.pane.setRight((Node)this.iconPane);
            }
        }

        private String getDescription(PathObject pathObject) {
            if (pathObject instanceof PathAnnotationObject) {
                return ((PathAnnotationObject)pathObject).getDescription();
            }
            if (pathObject instanceof TMACoreObject) {
                TMACoreObject core = (TMACoreObject)pathObject;
                return core.getMetadata().getOrDefault("Note", null);
            }
            return null;
        }

        private boolean showRoiIcon(PathObject pathObject) {
            if (pathObject == null || !pathObject.hasROI()) {
                return false;
            }
            return !pathObject.isDetection() || PathPrefs.detectionTreeDisplayModeProperty().get() == PathPrefs.DetectionTreeDisplayModes.WITH_ICONS;
        }

        public Pane getNode() {
            return this.pane;
        }

        private void updateTooltips(PathObject pathObject, String description) {
            if (pathObject == null) {
                this.label.setTooltip(null);
                return;
            }
            this.tooltip.setText(this.label.getText());
            this.label.setTooltip(this.tooltip);
            if (description == null) {
                this.descriptionTooltip.setText("No description");
            } else {
                this.descriptionTooltip.setText(description);
            }
        }
    }

    private static class PathObjectListCell
    extends ListCell<PathObject> {
        private final PathObjectMiniPane miniPane;

        PathObjectListCell(Function<PathObject, String> stringExtractor) {
            this.miniPane = new PathObjectMiniPane(stringExtractor);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        }

        protected void updateItem(PathObject value, boolean empty) {
            super.updateItem((Object)value, empty);
            this.miniPane.setPathObject(empty ? null : value);
            if (value == null || empty) {
                this.setText(null);
                this.setGraphic(null);
                return;
            }
            this.setGraphic((Node)this.miniPane.getNode());
        }
    }

    private static class PathObjectTreeCell
    extends TreeCell<PathObject> {
        private final PathObjectMiniPane miniPane;

        PathObjectTreeCell(Function<PathObject, String> stringExtractor) {
            this.miniPane = new PathObjectMiniPane(stringExtractor);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        }

        protected void updateItem(PathObject value, boolean empty) {
            super.updateItem((Object)value, empty);
            this.miniPane.setPathObject(empty ? null : value);
            if (value == null || empty) {
                this.setText(null);
                this.setGraphic(null);
                return;
            }
            this.setGraphic((Node)this.miniPane.getNode());
        }
    }
}

