/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.tools;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TableCell;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.text.TextAlignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.gui.images.stores.DefaultImageRegionStore;
import qupath.lib.gui.images.stores.ImageRenderer;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.viewer.OverlayOptions;
import qupath.lib.gui.viewer.PathObjectPainter;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.objects.PathObject;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.interfaces.ROI;

public class PathObjectImageViewers {
    private static ExecutorService sharedPool;

    private static synchronized ExecutorService getSharedPool() {
        if (sharedPool == null) {
            sharedPool = Executors.newThreadPerTaskExecutor(Thread.ofVirtual().name("pathobject-view", 0L).factory());
        }
        return sharedPool;
    }

    public static <S, T extends PathObject> TableCell<S, T> createTableCell(QuPathViewer viewer, ImageServer<BufferedImage> server, boolean paintObject, double padding) {
        PathObjectCanvasManager painter = new PathObjectCanvasManager(new Canvas(), viewer, server, paintObject, PathObjectImageViewers.getSharedPool());
        return new PathObjectTableCell(painter, padding);
    }

    public static ItemViewer<PathObject, Canvas> createCanvasViewer(QuPathViewer viewer, ImageServer<BufferedImage> server, boolean paintObject) {
        return new PathObjectCanvasManager(new Canvas(), viewer, server, paintObject, PathObjectImageViewers.getSharedPool());
    }

    public static ItemViewer<PathObject, ImageView> createImageViewer(QuPathViewer viewer, ImageServer<BufferedImage> server, boolean paintObject) {
        return new PathObjectImageViewManager(new ImageView(), viewer, server, paintObject, PathObjectImageViewers.getSharedPool());
    }

    private static void clearCanvas(Canvas canvas) {
        canvas.getGraphicsContext2D().clearRect(0.0, 0.0, canvas.getWidth(), canvas.getHeight());
    }

    private static class PathObjectCanvasManager
    extends AbstractPathObjectViewer<Canvas> {
        PathObjectCanvasManager(Canvas canvas, QuPathViewer viewer, ImageServer<BufferedImage> server, boolean paintObject, ExecutorService pool) {
            super(canvas, viewer, server, paintObject, canvas.widthProperty(), canvas.heightProperty(), pool);
        }

        @Override
        protected void updateNode(Image image) {
            Canvas canvas = (Canvas)this.getNode();
            if (image == null) {
                PathObjectImageViewers.clearCanvas(canvas);
            } else {
                GuiTools.paintImage(canvas, image);
            }
        }
    }

    private static class PathObjectTableCell<S, T extends PathObject>
    extends TableCell<S, T> {
        private static final Logger logger = LoggerFactory.getLogger(PathObjectTableCell.class);
        private final PathObjectCanvasManager painter;
        private Canvas canvas = new Canvas();
        private double preferredSize = 100.0;

        private PathObjectTableCell(PathObjectCanvasManager painter, double padding) {
            logger.trace("Creating new cell ({})", (Object)System.identityHashCode((Object)this));
            this.setContentDisplay(ContentDisplay.CENTER);
            this.setAlignment(Pos.CENTER);
            this.setTextAlignment(TextAlignment.CENTER);
            this.painter = painter;
            this.canvas = (Canvas)painter.getNode();
            this.canvas.setWidth(this.preferredSize);
            this.canvas.setHeight(this.preferredSize);
            this.canvas.setStyle("-fx-effect: dropshadow(three-pass-box, rgba(0,0,0,0.5), 4, 0, 1, 1);");
            this.canvas.heightProperty().bind((ObservableValue)this.canvas.widthProperty());
            this.tableColumnProperty().addListener((v, o, n) -> {
                this.canvas.widthProperty().unbind();
                if (n != null) {
                    this.canvas.widthProperty().bind((ObservableValue)n.widthProperty().subtract(padding * 2.0));
                }
            });
            this.canvas.widthProperty().addListener((v, o, n) -> painter.updateImage(false));
        }

        protected void updateItem(T pathObject, boolean empty) {
            super.updateItem(pathObject, empty);
            this.setText(null);
            if (empty || pathObject == null || pathObject.getROI() == null) {
                this.setGraphic(null);
                return;
            }
            this.setGraphic((Node)this.canvas);
            this.painter.setItem((PathObject)pathObject);
        }
    }

    private static class PathObjectImageViewManager
    extends AbstractPathObjectViewer<ImageView> {
        PathObjectImageViewManager(ImageView imageView, QuPathViewer viewer, ImageServer<BufferedImage> server, boolean paintObject, ExecutorService pool) {
            super(imageView, viewer, server, paintObject, imageView.fitWidthProperty(), imageView.fitHeightProperty(), pool);
        }

        @Override
        protected void updateNode(Image image) {
            ImageView imageView = (ImageView)this.getNode();
            imageView.setImage(image);
        }
    }

    private static class PathObjectThumbnailTask
    extends Task<Image> {
        private static final Logger logger = LoggerFactory.getLogger(PathObjectThumbnailTask.class);
        private final DefaultImageRegionStore store;
        private final ImageRenderer renderer;
        private final OverlayOptions options;
        private final ImageServer<BufferedImage> server;
        private final PathObject pathObject;
        private final int width;
        private final int height;
        private final boolean paintObject;

        PathObjectThumbnailTask(ImageServer<BufferedImage> server, PathObject pathObject, boolean paintObject, int width, int height) {
            this(server, pathObject, paintObject, width, height, null, null, null);
        }

        PathObjectThumbnailTask(ImageServer<BufferedImage> server, PathObject pathObject, boolean paintObject, int width, int height, QuPathViewer viewer) {
            this(server, pathObject, paintObject, width, height, viewer.getImageRegionStore(), viewer.getImageDisplay(), viewer.getOverlayOptions());
        }

        PathObjectThumbnailTask(ImageServer<BufferedImage> server, PathObject pathObject, boolean paintObject, int width, int height, DefaultImageRegionStore store, ImageRenderer renderer, OverlayOptions options) {
            this.store = store;
            this.renderer = renderer;
            this.options = options;
            this.server = server;
            this.pathObject = pathObject;
            this.paintObject = paintObject;
            this.width = width;
            this.height = height;
        }

        public PathObject getPathObject() {
            return this.pathObject;
        }

        public Image call() {
            if (Thread.interrupted() || this.pathObject == null || !this.pathObject.hasROI()) {
                return null;
            }
            ROI roi = this.pathObject.getROI();
            double scaleFactor = 1.2;
            double downsample = Math.max(roi.getBoundsWidth() * scaleFactor / (double)this.width, roi.getBoundsHeight() * scaleFactor / (double)this.height);
            if (downsample < 1.0) {
                downsample = 1.0;
            }
            try {
                BufferedImage img;
                if (this.store != null) {
                    img = new BufferedImage(this.width, this.height, 1);
                    Graphics2D g2d = img.createGraphics();
                    g2d.setClip(0, 0, img.getWidth(), img.getHeight());
                    g2d.scale(1.0 / downsample, 1.0 / downsample);
                    double x = roi.getCentroidX() - (double)img.getWidth() / 2.0 * downsample;
                    double y = roi.getCentroidY() - (double)img.getHeight() / 2.0 * downsample;
                    g2d.translate(-x, -y);
                    this.store.paintRegionCompletely(this.server, g2d, g2d.getClipBounds(), roi.getZ(), roi.getT(), downsample, null, this.renderer, 500L);
                    if (this.paintObject && this.options != null) {
                        PathObjectPainter.paintObject(this.pathObject, g2d, this.options, null, downsample);
                    }
                    g2d.dispose();
                } else {
                    RegionRequest request = RegionRequest.createInstance((String)this.server.getPath(), (double)downsample, (ROI)roi);
                    img = (BufferedImage)this.server.readRegion(request);
                }
                return SwingFXUtils.toFXImage((BufferedImage)img, null);
            }
            catch (Exception e) {
                logger.error("Unable to draw image for {}", (Object)this.pathObject, (Object)e);
                return null;
            }
        }
    }

    private static abstract class AbstractPathObjectViewer<T extends Node>
    implements ItemViewer<PathObject, T> {
        private static final Logger logger = LoggerFactory.getLogger(AbstractPathObjectViewer.class);
        private final QuPathViewer viewer;
        private final boolean paintObject;
        private final ImageServer<BufferedImage> server;
        private PathObject pathObject;
        private final T node;
        private final DoubleProperty widthProperty;
        private final DoubleProperty heightProperty;
        private PathObjectThumbnailTask task;
        private final WorkerHandler handler = new WorkerHandler();
        private int maxCacheSize = 100;
        private final ExecutorService pool;
        private WeakChangeListener<Number> numberListenerFalse = new WeakChangeListener((v, o, n) -> this.updateImage(false));
        private WeakChangeListener<Number> numberListenerTrue = new WeakChangeListener((v, o, n) -> this.updateImage(true));
        private final Map<PathObject, Image> cache = Collections.synchronizedMap(new LinkedHashMap<PathObject, Image>(){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<PathObject, Image> eldest) {
                return this.size() > maxCacheSize;
            }
        });

        AbstractPathObjectViewer(T node, QuPathViewer viewer, ImageServer<BufferedImage> server, boolean paintObject, DoubleProperty widthProperty, DoubleProperty heightProperty, ExecutorService pool) {
            logger.trace("Creating new cell ({})", (Object)System.identityHashCode(this));
            this.server = server;
            this.viewer = viewer;
            this.paintObject = paintObject;
            ExecutorService executorService = this.pool = pool == null ? ForkJoinPool.commonPool() : pool;
            if (paintObject && viewer != null) {
                OverlayOptions options = viewer.getOverlayOptions();
                options.lastChangeTimestamp().addListener(this.numberListenerFalse);
                viewer.getImageDisplay().eventCountProperty().addListener(this.numberListenerFalse);
            }
            this.node = node;
            this.widthProperty = widthProperty;
            this.heightProperty = heightProperty;
            widthProperty.addListener(this.numberListenerTrue);
            heightProperty.addListener(this.numberListenerTrue);
            node.visibleProperty().addListener((ChangeListener)new WeakChangeListener((v, o, n) -> this.updateImage(true)));
        }

        @Override
        public void setItem(PathObject pathObject) {
            if (this.pathObject == pathObject) {
                return;
            }
            if (this.task != null) {
                this.task.cancel(true);
                this.task = null;
            }
            this.pathObject = pathObject;
            this.updateImage(false);
        }

        public PathObject getPathObject() {
            return this.pathObject;
        }

        @Override
        public T getNode() {
            return this.node;
        }

        public void resetCache() {
            this.cache.clear();
        }

        public int getMaxCacheSize() {
            return this.maxCacheSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setMaxCacheSize(int maxSize) {
            this.maxCacheSize = maxSize;
            if (this.cache.size() > this.maxCacheSize) {
                Map<PathObject, Image> map = this.cache;
                synchronized (map) {
                    Iterator<Map.Entry<PathObject, Image>> iterator = this.cache.entrySet().iterator();
                    while (iterator.hasNext() && this.cache.size() > this.maxCacheSize) {
                        iterator.next();
                        iterator.remove();
                    }
                }
            }
        }

        public void updateImage(boolean useCache) {
            ROI roi;
            ROI rOI = roi = this.pathObject == null ? null : this.pathObject.getROI();
            if (roi == null || !this.node.isVisible()) {
                return;
            }
            try {
                int width = (int)Math.round(this.widthProperty.get());
                int height = (int)Math.round(this.heightProperty.get());
                Image image = null;
                if (useCache && this.task != null && this.task.isDone()) {
                    image = this.cache.get(this.pathObject);
                    if (image == null && this.task != null && this.task.isDone()) {
                        image = (Image)this.task.getValue();
                    }
                    if (image != null && image.getWidth() == (double)width && image.getHeight() == (double)height) {
                        this.updateNode(image);
                        return;
                    }
                    if (image != null) {
                        // empty if block
                    }
                }
                if (this.isTooSmall(width, height)) {
                    this.updateNode(null);
                    return;
                }
                if (this.task != null) {
                    this.task.cancel(true);
                }
                this.task = this.viewer != null ? new PathObjectThumbnailTask(this.server, this.pathObject, this.paintObject, width, height, this.viewer) : new PathObjectThumbnailTask(this.server, this.pathObject, this.paintObject, width, height);
                this.task.setOnSucceeded(this.handler);
                this.task.setOnFailed(this.handler);
                this.pool.submit((Runnable)((Object)this.task));
            }
            catch (Exception e) {
                logger.error("Problem reading thumbnail for {}", (Object)this.pathObject, (Object)e);
            }
        }

        protected boolean isTooSmall(int width, int height) {
            return width <= 2 || height <= 2;
        }

        protected abstract void updateNode(Image var1);

        private class WorkerHandler
        implements EventHandler<WorkerStateEvent> {
            private WorkerHandler() {
            }

            public void handle(WorkerStateEvent event) {
                if (event.getEventType() == WorkerStateEvent.WORKER_STATE_SUCCEEDED) {
                    try {
                        Image image = (Image)AbstractPathObjectViewer.this.task.getValue();
                        if (image != null) {
                            AbstractPathObjectViewer.this.cache.put(AbstractPathObjectViewer.this.task.getPathObject(), image);
                            AbstractPathObjectViewer.this.updateNode(image);
                        }
                        event.consume();
                        return;
                    }
                    catch (Exception e) {
                        logger.debug(e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                AbstractPathObjectViewer.this.updateNode(null);
                event.consume();
            }
        }
    }

    public static interface ItemViewer<S, T extends Node> {
        public void setItem(S var1);

        public T getNode();
    }
}

