/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.tools;

import java.util.Objects;
import java.util.function.Function;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import qupath.lib.gui.tools.ColorToolsFX;
import qupath.lib.objects.classes.PathClass;

public class PathClassListCell
extends ListCell<PathClass> {
    private final Function<PathClass, String> stringFunction;
    private final Rectangle rectangle = new Rectangle(10.0, 10.0);

    public PathClassListCell(Function<PathClass, String> stringFunction) {
        Objects.requireNonNull(stringFunction);
        this.stringFunction = stringFunction;
    }

    public PathClassListCell() {
        this(PathClassListCell::defaultStringFunction);
    }

    protected void updateItem(PathClass value, boolean empty) {
        super.updateItem((Object)value, empty);
        if (value == null || empty) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            if (value == PathClass.NULL_CLASS) {
                this.rectangle.setFill((Paint)Color.TRANSPARENT);
            } else {
                this.rectangle.setFill((Paint)ColorToolsFX.getPathClassColor(value));
            }
            this.setText(this.stringFunction.apply(value));
            this.setGraphic((Node)this.rectangle);
        }
    }

    public static String defaultStringFunction(PathClass pathClass) {
        if (pathClass == null || pathClass == PathClass.NULL_CLASS) {
            return "None";
        }
        return pathClass.toString();
    }
}

