/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Control;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.utils.FXUtils;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.common.LogTools;

@Deprecated
public class PaneTools {
    private static final Logger logger = LoggerFactory.getLogger(PaneTools.class);

    private static void logDeprecatedForGridPaneUtils() {
        PaneTools.logDeprecatedForOther(GridPaneUtils.class);
    }

    private static void logDeprecatedForOther(Class<?> cls) {
        LogTools.warnOnce((Logger)logger, (String)(PaneTools.class.getName() + " is deprecated and will be removed in the next QuPath release - please use " + cls.getName() + " instead"));
    }

    public static void addGridRow(GridPane pane, int row, int col, String tooltipText, Node ... nodes) {
        PaneTools.logDeprecatedForGridPaneUtils();
        Node lastNode = null;
        Tooltip tooltip = tooltipText == null ? null : new Tooltip(tooltipText);
        for (Node n : nodes) {
            if (n == null) {
                ++col;
                continue;
            }
            if (lastNode == n) {
                Integer span = GridPane.getColumnSpan((Node)n);
                if (span == null) {
                    GridPane.setColumnSpan((Node)n, (Integer)2);
                } else {
                    GridPane.setColumnSpan((Node)n, (Integer)(span + 1));
                }
            } else {
                pane.add(n, col, row);
                GridPane.setColumnSpan((Node)n, (Integer)1);
                if (tooltip != null) {
                    PaneTools.installTooltipRecursive(tooltip, n, false);
                }
            }
            lastNode = n;
            ++col;
        }
    }

    static void installTooltipRecursive(Tooltip tooltip, Node node, boolean overrideExisting) {
        if (node instanceof Control) {
            Control control = (Control)node;
            if (overrideExisting || control.getTooltip() == null) {
                control.setTooltip(tooltip);
            }
        } else {
            Tooltip.install((Node)node, (Tooltip)tooltip);
            if (node instanceof Region) {
                for (Node child : ((Region)node).getChildrenUnmodifiable()) {
                    PaneTools.installTooltipRecursive(tooltip, child, overrideExisting);
                }
            }
        }
    }

    public static void setHGrowPriority(Priority priority, Node ... nodes) {
        PaneTools.logDeprecatedForGridPaneUtils();
        for (Node n : nodes) {
            GridPane.setHgrow((Node)n, (Priority)priority);
        }
    }

    public static void setVGrowPriority(Priority priority, Node ... nodes) {
        PaneTools.logDeprecatedForGridPaneUtils();
        for (Node n : nodes) {
            GridPane.setVgrow((Node)n, (Priority)priority);
        }
    }

    public static void setMaxWidth(double width, Region ... regions) {
        PaneTools.logDeprecatedForGridPaneUtils();
        for (Region r : regions) {
            r.setMaxWidth(width);
        }
    }

    public static void setMaxHeight(double height, Region ... regions) {
        PaneTools.logDeprecatedForGridPaneUtils();
        for (Region r : regions) {
            r.setMaxHeight(height);
        }
    }

    public static void setMinWidth(double width, Region ... regions) {
        PaneTools.logDeprecatedForGridPaneUtils();
        for (Region r : regions) {
            r.setMinWidth(width);
        }
    }

    public static void setMinHeight(double height, Region ... regions) {
        PaneTools.logDeprecatedForGridPaneUtils();
        for (Region r : regions) {
            r.setMinHeight(height);
        }
    }

    public static void setFillWidth(Boolean doFill, Node ... nodes) {
        PaneTools.logDeprecatedForGridPaneUtils();
        for (Node n : nodes) {
            GridPane.setFillWidth((Node)n, (Boolean)doFill);
        }
    }

    public static void setToExpandGridPaneWidth(Node ... nodes) {
        PaneTools.setFillWidth(Boolean.TRUE, nodes);
        PaneTools.setHGrowPriority(Priority.ALWAYS, nodes);
        PaneTools.setMaxWidth(Double.MAX_VALUE, (Region[])Arrays.stream(nodes).filter(n -> n instanceof Region).map(n -> (Region)n).toArray(Region[]::new));
    }

    public static void setToExpandGridPaneHeight(Node ... nodes) {
        PaneTools.setFillHeight(Boolean.TRUE, nodes);
        PaneTools.setVGrowPriority(Priority.ALWAYS, nodes);
        PaneTools.setMaxHeight(Double.MAX_VALUE, (Region[])Arrays.stream(nodes).filter(n -> n instanceof Region).map(n -> (Region)n).toArray(Region[]::new));
    }

    public static void setFillHeight(Boolean doFill, Node ... nodes) {
        PaneTools.logDeprecatedForGridPaneUtils();
        for (Node n : nodes) {
            GridPane.setFillHeight((Node)n, (Boolean)doFill);
        }
    }

    public static GridPane createRowGrid(Node ... nodes) {
        PaneTools.logDeprecatedForGridPaneUtils();
        GridPane pane = new GridPane();
        int n = nodes.length;
        for (int i = 0; i < n; ++i) {
            RowConstraints row = new RowConstraints();
            row.setPercentHeight(100.0 / (double)n);
            pane.getRowConstraints().add((Object)row);
            pane.add(nodes[i], 0, i);
        }
        ColumnConstraints col = new ColumnConstraints();
        col.setPercentWidth(100.0);
        pane.getColumnConstraints().add((Object)col);
        return pane;
    }

    public static GridPane createRowGridControls(Node ... nodes) {
        PaneTools.logDeprecatedForGridPaneUtils();
        GridPane pane = new GridPane();
        int n = nodes.length;
        for (int i = 0; i < n; ++i) {
            RowConstraints row = new RowConstraints();
            row.setPercentHeight(100.0 / (double)n);
            pane.getRowConstraints().add((Object)row);
            Node node = nodes[i];
            pane.add(node, 0, i);
            if (!(node instanceof Control)) continue;
            ((Control)node).prefWidthProperty().bind((ObservableValue)pane.widthProperty());
        }
        ColumnConstraints col = new ColumnConstraints();
        col.setPercentWidth(100.0);
        pane.getColumnConstraints().add((Object)col);
        return pane;
    }

    public static GridPane createColumnGridControls(Node ... nodes) {
        PaneTools.logDeprecatedForGridPaneUtils();
        GridPane pane = new GridPane();
        int n = nodes.length;
        double maxMinWidth = 0.0;
        for (int i = 0; i < n; ++i) {
            ColumnConstraints col = new ColumnConstraints();
            col.setPercentWidth(100.0 / (double)n);
            pane.getColumnConstraints().add((Object)col);
            Node node = nodes[i];
            pane.add(node, i, 0);
            if (!(node instanceof Control)) continue;
            maxMinWidth = Math.max(maxMinWidth, ((Control)node).getPrefWidth());
            ((Control)node).prefWidthProperty().bind((ObservableValue)pane.widthProperty().divide(n));
        }
        RowConstraints row = new RowConstraints();
        row.setPercentHeight(100.0);
        pane.getRowConstraints().add((Object)row);
        pane.setMinWidth(maxMinWidth * (double)n);
        pane.setPrefWidth(maxMinWidth * (double)n);
        return pane;
    }

    public static GridPane createColumnGrid(Node ... nodes) {
        PaneTools.logDeprecatedForGridPaneUtils();
        GridPane pane = new GridPane();
        int n = nodes.length;
        for (int i = 0; i < n; ++i) {
            ColumnConstraints col = new ColumnConstraints();
            col.setPercentWidth(100.0 / (double)n);
            pane.getColumnConstraints().add((Object)col);
            pane.add(nodes[i], i, 0);
        }
        RowConstraints row = new RowConstraints();
        row.setPercentHeight(100.0);
        pane.getRowConstraints().add((Object)row);
        return pane;
    }

    public static GridPane createColumnGrid(int nCols) {
        PaneTools.logDeprecatedForGridPaneUtils();
        GridPane pane = new GridPane();
        for (int i = 0; i < nCols; ++i) {
            ColumnConstraints col = new ColumnConstraints();
            col.setPercentWidth(100.0 / (double)nCols);
            pane.getColumnConstraints().add((Object)col);
        }
        RowConstraints row = new RowConstraints();
        row.setPercentHeight(100.0);
        pane.getRowConstraints().add((Object)row);
        return pane;
    }

    public static Collection<Node> getContents(Parent parent, Collection<Node> collection, boolean doRecursive) {
        ObservableList children;
        PaneTools.logDeprecatedForOther(FXUtils.class);
        if (collection == null) {
            collection = new ArrayList<Node>();
        }
        if ((children = parent.getChildrenUnmodifiable()).isEmpty() && parent instanceof SplitPane) {
            children = ((SplitPane)parent).getItems();
        }
        for (Node child : children) {
            collection.add(child);
            if (!doRecursive || !(child instanceof Parent)) continue;
            PaneTools.getContents((Parent)child, collection, doRecursive);
        }
        return collection;
    }

    public static <T extends Node> Collection<T> getContentsOfType(Parent parent, Class<T> cls, boolean doRecursive) {
        PaneTools.logDeprecatedForOther(FXUtils.class);
        return PaneTools.getContents(parent, new ArrayList<Node>(), doRecursive).stream().filter(p -> cls.isInstance(p)).map(p -> (Node)cls.cast(p)).collect(Collectors.toList());
    }

    public static void simplifyTitledPane(TitledPane pane, boolean boldTitle) {
        PaneTools.logDeprecatedForOther(FXUtils.class);
        String css = PaneTools.class.getClassLoader().getResource("css/titled_plain.css").toExternalForm();
        pane.getStylesheets().add((Object)css);
        if (boldTitle) {
            String css2 = PaneTools.class.getClassLoader().getResource("css/titled_bold.css").toExternalForm();
            pane.getStylesheets().add((Object)css2);
        }
    }
}

