/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javafx.collections.ObservableList;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import org.controlsfx.control.action.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.gui.actions.ActionTools;
import qupath.lib.gui.localization.QuPathResources;

public class MenuTools {
    private static final Logger logger = LoggerFactory.getLogger(MenuTools.class);

    public static Menu createMenu(String name, Object ... items) {
        Menu menu = new Menu();
        if (QuPathResources.hasString(name)) {
            QuPathResources.getLocalizedResourceManager().registerProperty(menu.textProperty(), name);
        } else {
            menu.setText(name);
        }
        if (items.length > 0) {
            MenuTools.addMenuItems(menu, items);
        }
        return menu;
    }

    public static Menu addMenuItems(Menu menu, Object ... items) {
        MenuTools.addMenuItems((List<MenuItem>)menu.getItems(), items);
        return menu;
    }

    public static List<MenuItem> addMenuItems(List<MenuItem> menuItems, Object ... items) {
        if (menuItems == null) {
            menuItems = new ArrayList<MenuItem>();
        }
        boolean lastIsSeparator = !menuItems.isEmpty() && menuItems.getLast() instanceof SeparatorMenuItem;
        ArrayList<Object> newItems = new ArrayList<Object>();
        for (Object item : items) {
            if (item == null) {
                if (!lastIsSeparator) {
                    newItems.add(new SeparatorMenuItem());
                }
                lastIsSeparator = true;
                continue;
            }
            if (item instanceof MenuItem) {
                MenuItem menuItem = (MenuItem)item;
                newItems.add(menuItem);
                lastIsSeparator = false;
                continue;
            }
            if (item instanceof Action) {
                Action action = (Action)item;
                newItems.add(ActionTools.createMenuItem(action));
                lastIsSeparator = false;
                continue;
            }
            logger.warn("Could not add menu item {}", item);
        }
        if (!newItems.isEmpty()) {
            menuItems.addAll(newItems);
        }
        return menuItems;
    }

    public static Menu getMenu(List<Menu> menus, String name, boolean createMenu) {
        Menu menuCurrent = null;
        for (String namePart : name.split(">")) {
            String text;
            boolean isResourceString = QuPathResources.hasString(namePart = namePart.trim());
            String string = text = isResourceString ? QuPathResources.getString(namePart) : namePart;
            if (menuCurrent == null) {
                menuCurrent = MenuTools.findMenuByNameNonRecursive(menus, text);
                if (menuCurrent != null) continue;
                if (createMenu) {
                    menuCurrent = MenuTools.createMenu(namePart);
                    if (MenuTools.lastMenuIsHelp(menus)) {
                        menus.add(menus.size() - 1, menuCurrent);
                        continue;
                    }
                    menus.add(menuCurrent);
                    continue;
                }
                return null;
            }
            ObservableList menuItems = menuCurrent.getItems();
            if ((menuCurrent = MenuTools.findMenuByNameNonRecursive((List<? extends MenuItem>)menuItems, text)) != null) continue;
            if (createMenu) {
                menuCurrent = MenuTools.createMenu(namePart);
                menuItems.add(menuCurrent);
                continue;
            }
            return null;
        }
        return menuCurrent;
    }

    private static Menu findMenuByNameNonRecursive(List<? extends MenuItem> menuItems, String name) {
        for (MenuItem menuItem : menuItems) {
            if (!(menuItem instanceof Menu) || !Objects.equals(name, menuItem.getText())) continue;
            return (Menu)menuItem;
        }
        return null;
    }

    private static boolean lastMenuIsHelp(List<Menu> menus) {
        return !menus.isEmpty() && QuPathResources.getString("Menu.Help").equals(menus.get(menus.size() - 1).getText());
    }

    private static Menu createMenu(String keyOrName) {
        Menu menu = new Menu();
        if (QuPathResources.hasString(keyOrName)) {
            QuPathResources.getLocalizedResourceManager().registerProperty(menu.textProperty(), keyOrName);
        } else {
            menu.setText(keyOrName);
        }
        return menu;
    }

    public static List<MenuItem> getFlattenedMenuItems(List<? extends MenuItem> menuItems, boolean excludeMenusAndSeparators) {
        return MenuTools.getFlattenedMenuItems(excludeMenusAndSeparators, (MenuItem[])menuItems.toArray(MenuItem[]::new));
    }

    public static List<MenuItem> getFlattenedMenuItems(boolean excludeMenusAndSeparators, MenuItem ... items) {
        ArrayList<MenuItem> result = new ArrayList<MenuItem>();
        for (MenuItem temp : items) {
            MenuTools.addMenuItemsRecursive(temp, result, excludeMenusAndSeparators);
        }
        return result;
    }

    private static void addMenuItemsRecursive(MenuItem item, List<MenuItem> existingItems, boolean excludeMenusAndSeparators) {
        if (item instanceof Menu) {
            if (!excludeMenusAndSeparators) {
                existingItems.add(item);
            }
            for (MenuItem item2 : ((Menu)item).getItems()) {
                MenuTools.addMenuItemsRecursive(item2, existingItems, excludeMenusAndSeparators);
            }
        } else if (!excludeMenusAndSeparators || !(existingItems instanceof SeparatorMenuItem)) {
            existingItems.add(item);
        }
    }
}

