/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.tools;

import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.color.ColorMaps;
import qupath.lib.gui.tools.ColorToolsFX;
import qupath.lib.objects.PathDetectionObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathTileObject;

public class MeasurementMapper {
    private static final Logger logger = LoggerFactory.getLogger(MeasurementMapper.class);
    private ColorMaps.ColorMap colorMapper;
    private double minValueData = 0.0;
    private double maxValueData = 1.0;
    private double minValue = 0.0;
    private double maxValue = 1.0;
    private String measurement;
    private boolean isClassProbability = false;
    private boolean valid = false;
    private boolean excludeOutsideRange;

    public MeasurementMapper(ColorMaps.ColorMap mapper, String measurement, Collection<? extends PathObject> pathObjects) {
        this.colorMapper = mapper;
        this.measurement = measurement;
        this.isClassProbability = measurement.toLowerCase().trim().equals("class probability");
        this.minValueData = Double.POSITIVE_INFINITY;
        this.maxValueData = Double.NEGATIVE_INFINITY;
        for (PathObject pathObject : pathObjects) {
            double value = this.getUsefulValue(pathObject, Double.NaN);
            if (Double.isNaN(value) || Double.isInfinite(value)) continue;
            if (value > this.maxValueData) {
                this.maxValueData = value;
            }
            if (value < this.minValueData) {
                this.minValueData = value;
            }
            this.valid = true;
        }
        this.minValue = this.minValueData;
        this.maxValue = this.maxValueData;
        logger.debug("Measurement mapper limits for " + measurement + ": " + this.minValueData + ", " + this.maxValueData);
    }

    public void setColorMapper(ColorMaps.ColorMap mapper) {
        this.colorMapper = mapper;
    }

    public boolean getExcludeOutsideRange() {
        return this.excludeOutsideRange;
    }

    public void setExcludeOutsideRange(boolean excludeOutsideRange) {
        this.excludeOutsideRange = excludeOutsideRange;
    }

    public boolean isValid() {
        return this.valid;
    }

    public Integer getColorForObject(PathObject pathObject) {
        if (!(pathObject instanceof PathDetectionObject) && !(pathObject instanceof PathTileObject)) {
            return ColorToolsFX.getDisplayedColorARGB(pathObject);
        }
        double value = this.getUsefulValue(pathObject, Double.NaN);
        if (this.excludeOutsideRange && (value < this.minValue || value > this.maxValue)) {
            return null;
        }
        if (Double.isNaN(value)) {
            return null;
        }
        return this.colorMapper.getColor(value, this.minValue, this.maxValue);
    }

    protected double getUsefulValue(PathObject pathObject, double nanValue) {
        double value = this.isClassProbability ? pathObject.getClassProbability() : pathObject.getMeasurementList().get(this.measurement);
        if (Double.isNaN(value)) {
            value = nanValue;
        } else if (Double.isInfinite(value)) {
            if (value > 0.0) {
                return this.maxValueData;
            }
            return this.minValueData;
        }
        return value;
    }

    public ColorMaps.ColorMap getColorMapper() {
        return this.colorMapper;
    }

    public double getDataMinValue() {
        return this.minValueData;
    }

    public double getDataMaxValue() {
        return this.maxValueData;
    }

    public void setDisplayMinValue(double minValue) {
        this.minValue = minValue;
    }

    public void setDisplayMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public double getDisplayMinValue() {
        return this.minValue;
    }

    public double getDisplayMaxValue() {
        return this.maxValue;
    }
}

