/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.tools;

import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.DoubleConsumer;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.gui.measure.ObservableMeasurementTableData;
import qupath.lib.gui.measure.PathTableData;
import qupath.lib.images.ImageData;
import qupath.lib.objects.PathAnnotationObject;
import qupath.lib.objects.PathCellObject;
import qupath.lib.objects.PathDetectionObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathRootObject;
import qupath.lib.objects.PathTileObject;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.projects.ProjectImageEntry;

public class MeasurementExporter {
    private static final Logger logger = LoggerFactory.getLogger(MeasurementExporter.class);
    public static final int DECIMAL_PLACES_DEFAULT = Integer.MIN_VALUE;
    private static final String DEFAULT_SEPARATOR = "\t";
    private static final DoubleConsumer NULL_PROGRESS_MONITOR = d -> {};
    private List<String> includeOnlyColumns = new ArrayList<String>();
    private List<String> excludeColumns = new ArrayList<String>();
    private Predicate<PathObject> filter;
    private int nDecimalPlaces = Integer.MIN_VALUE;
    private Class<? extends PathObject> type = PathRootObject.class;
    private String separator;
    private List<ProjectImageEntry<BufferedImage>> imageList;
    private DoubleConsumer progressMonitor = NULL_PROGRESS_MONITOR;

    public MeasurementExporter decimalPlaces(int decimalPlaces) {
        this.nDecimalPlaces = decimalPlaces;
        return this;
    }

    public MeasurementExporter exportType(Class<? extends PathObject> type) {
        this.type = type;
        return this;
    }

    public MeasurementExporter annotations() {
        return this.exportType(PathAnnotationObject.class);
    }

    public MeasurementExporter allDetections() {
        return this.exportType(PathDetectionObject.class);
    }

    public MeasurementExporter image() {
        return this.exportType(PathRootObject.class);
    }

    public MeasurementExporter cells() {
        return this.exportType(PathCellObject.class);
    }

    public MeasurementExporter tiles() {
        return this.exportType(PathTileObject.class);
    }

    public MeasurementExporter tmaCores() {
        return this.exportType(TMACoreObject.class);
    }

    public MeasurementExporter includeOnlyColumns(String ... includeOnlyColumns) {
        this.includeOnlyColumns = Arrays.asList(includeOnlyColumns);
        return this;
    }

    public MeasurementExporter excludeColumns(String ... excludeColumns) {
        this.excludeColumns = Arrays.asList(excludeColumns);
        return this;
    }

    public MeasurementExporter separator(String sep) {
        this.separator = sep;
        return this;
    }

    public MeasurementExporter imageList(List<ProjectImageEntry<BufferedImage>> imageList) {
        this.imageList = List.copyOf(imageList);
        return this;
    }

    public MeasurementExporter progressMonitor(DoubleConsumer monitor) {
        this.progressMonitor = monitor == null ? NULL_PROGRESS_MONITOR : monitor;
        return this;
    }

    public MeasurementExporter filter(Predicate<PathObject> filter) {
        this.filter = filter;
        return this;
    }

    public List<ProjectImageEntry<BufferedImage>> getImageList() {
        return this.imageList;
    }

    public List<String> getExcludeColumns() {
        return this.excludeColumns;
    }

    public List<String> getIncludeColumns() {
        return this.includeOnlyColumns;
    }

    public String getSeparator() {
        return this.separator;
    }

    public Class<? extends PathObject> getType() {
        return this.type;
    }

    public void exportMeasurements(File file) throws IOException, InterruptedException {
        try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(file), 4096);){
            this.doExport(fos, this.getSeparatorToUse(file.getName()));
        }
    }

    private Predicate<String> createColumnPredicate() {
        if (!this.includeOnlyColumns.isEmpty()) {
            Set<String> set = Set.copyOf(this.includeOnlyColumns);
            return set::contains;
        }
        if (!this.excludeColumns.isEmpty()) {
            Set<String> set = Set.copyOf(this.excludeColumns);
            return s -> !set.contains(s);
        }
        return s -> true;
    }

    private MeasurementTable createMeasurementTable(ProgressMonitor monitor) throws IOException, InterruptedException {
        MeasurementTable table = new MeasurementTable();
        Predicate<String> columnPredicate = this.createColumnPredicate();
        ObservableMeasurementTableData model = new ObservableMeasurementTableData();
        for (ProjectImageEntry<BufferedImage> entry : this.imageList) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            try (ImageData imageData = entry.readImageData();){
                List<Object> pathObjects;
                Collection<Object> collection = pathObjects = imageData == null ? Collections.emptyList() : imageData.getHierarchy().getObjects(null, this.type);
                if (this.filter != null) {
                    pathObjects = pathObjects.stream().filter(this.filter).toList();
                }
                model.setImageData(imageData, pathObjects);
                List<String> columns = model.getAllNames().stream().filter(columnPredicate).toList();
                table.addRows(columns, model, this.nDecimalPlaces);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            monitor.incrementProgress();
        }
        return table;
    }

    private String getSeparatorToUse(String filename) {
        if (this.separator != null) {
            return this.separator;
        }
        if (filename != null) {
            String lower = filename.toLowerCase();
            if (lower.endsWith(".csv")) {
                return ",";
            }
            if (lower.endsWith(".tsv")) {
                return DEFAULT_SEPARATOR;
            }
        }
        return DEFAULT_SEPARATOR;
    }

    public void exportMeasurements(OutputStream stream) throws IOException, InterruptedException {
        this.doExport(stream, this.getSeparatorToUse(null));
    }

    private void doExport(OutputStream stream, String separator) throws IOException, InterruptedException {
        if (this.imageList == null || this.imageList.isEmpty()) {
            logger.warn("No images selected for export!");
            return;
        }
        long startTime = System.currentTimeMillis();
        int n = this.imageList.size();
        ProgressMonitor monitor = new ProgressMonitor(n + 1, this.progressMonitor);
        MeasurementTable table = this.createMeasurementTable(monitor);
        boolean warningLogged = false;
        try (PrintWriter writer = new PrintWriter(new OutputStreamWriter(stream, StandardCharsets.UTF_8));){
            List<String> header = table.getHeader();
            this.writeRow(writer, header, separator);
            ArrayList<String> rowValues = new ArrayList<String>();
            for (int row = 0; row < table.size(); ++row) {
                rowValues.clear();
                for (String h : header) {
                    String val = table.getString(row, h, null);
                    if (val == null) {
                        rowValues.add("");
                        continue;
                    }
                    if (val.contains(separator)) {
                        if (!warningLogged) {
                            logger.warn("Separator '{}' found in cell - this may cause the table to be misaligned in some software", (Object)separator);
                            warningLogged = true;
                        }
                        rowValues.add("\"" + val + "\"");
                        continue;
                    }
                    rowValues.add(val);
                }
                this.writeRow(writer, rowValues, separator);
            }
        }
        monitor.complete();
        long endTime = System.currentTimeMillis();
        long timeMillis = endTime - startTime;
        String time = timeMillis > 60000L ? String.format("Total processing time: %.2f minutes", (double)timeMillis / 60000.0) : (timeMillis > 1000L ? String.format("Total processing time: %.2f seconds", (double)timeMillis / 1000.0) : String.format("Total processing time: %d ms", timeMillis));
        logger.info("Processed {} images", (Object)this.imageList.size());
        logger.info(time);
    }

    private void writeRow(PrintWriter writer, List<String> strings, String delim) {
        int n = strings.size();
        for (int i = 0; i < n; ++i) {
            String val = strings.get(i);
            if (val != null) {
                writer.write(val);
            }
            if (i >= n - 1) continue;
            writer.write(delim);
        }
        writer.write(System.lineSeparator());
    }

    private static class MeasurementTable {
        private final Set<String> header = new LinkedHashSet<String>();
        private final List<String[]> data = new ArrayList<String[]>();
        private List<String> headerList;
        private Map<String, Integer> columnIndices = new HashMap<String, Integer>();

        private MeasurementTable() {
        }

        public <T> void addRows(Collection<String> headerColumns, PathTableData<T> table, int nDecimalPlaces) {
            Set<String> currentHeaderColumns = Set.copyOf(headerColumns);
            this.header.addAll(headerColumns);
            boolean sameColumns = this.header.size() == currentHeaderColumns.size();
            String[] columns = (String[])this.header.toArray(String[]::new);
            int n = columns.length;
            for (T item : table.getItems()) {
                String[] row = new String[columns.length];
                for (int i = 0; i < n; ++i) {
                    String col = columns[i];
                    if (!sameColumns && !currentHeaderColumns.contains(col)) continue;
                    row[i] = table.getStringValue(item, columns[i], nDecimalPlaces);
                }
                this.data.add(row);
            }
        }

        public synchronized List<String> getHeader() {
            if (this.headerList == null || this.headerList.size() != this.header.size()) {
                this.headerList = List.copyOf(this.header);
            }
            return this.headerList;
        }

        private synchronized Map<String, Integer> getColumnIndices() {
            List<String> list = this.getHeader();
            if (this.columnIndices.size() != list.size()) {
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                for (int i = 0; i < list.size(); ++i) {
                    map.put(list.get(i), i);
                }
                this.columnIndices = map;
            }
            return this.columnIndices;
        }

        public String getString(int row, String column, String defaultValue) {
            String[] dataRow = this.data.get(row);
            int ind = this.getColumnIndices().getOrDefault(column, -1);
            if (ind >= 0 && ind < dataRow.length) {
                return dataRow[ind];
            }
            return defaultValue;
        }

        public int size() {
            return this.data.size();
        }
    }

    private static class ProgressMonitor {
        private final int n;
        private final DoubleConsumer monitor;
        private final AtomicInteger counter = new AtomicInteger();

        private ProgressMonitor(int n, DoubleConsumer monitor) {
            this.n = n;
            this.monitor = monitor;
        }

        void incrementProgress() {
            double val = (double)this.counter.incrementAndGet() / (double)this.n;
            this.monitor.accept(val);
        }

        void complete() {
            this.counter.set(this.n);
            this.monitor.accept(1.0);
        }
    }
}

