/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.tools;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableIntegerValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.Ellipse;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.QuadCurve;
import javafx.scene.shape.QuadCurveTo;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextBoundsType;
import javafx.scene.transform.Transform;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.glyphfont.Glyph;
import org.controlsfx.glyphfont.GlyphFont;
import org.controlsfx.glyphfont.GlyphFontRegistry;
import org.controlsfx.tools.Duplicatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.geom.Point2;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tools.ColorToolsFX;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.viewer.DownsampledShapeCache;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.roi.EllipseROI;
import qupath.lib.roi.LineROI;
import qupath.lib.roi.RectangleROI;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;

public class IconFactory {
    private static final Logger logger = LoggerFactory.getLogger(IconFactory.class);
    private static final Color DETECTION_COLOR = Color.rgb((int)20, (int)180, (int)120, (double)0.9);
    private static ObservableList<Double> strokeDashArray;
    private static final Map<ROI, Path> roiIconCache;

    private static Node createLineOrArrowIcon(int size, String cap) {
        return new DuplicatableNode(() -> IconFactory.drawLineOrArrowIcon(size, size, cap));
    }

    private static Node drawLineOrArrowIcon(int width, int height, String cap) {
        double pad = 2.0;
        Path path = new Path();
        path.getElements().setAll((Object[])new PathElement[]{new MoveTo(pad, (double)height - pad), new LineTo((double)width - pad, pad)});
        IconFactory.bindShapeColorToObjectColor((javafx.scene.shape.Shape)path);
        path.fillProperty().bind((ObservableValue)path.strokeProperty());
        double length = (double)Math.min(width, height) / 3.0;
        if (cap.contains(">") && cap.contains("<")) {
            path.setClip((Node)new Rectangle(pad, pad, (double)width - pad * 2.0, (double)height - pad * 2.0));
        }
        if (cap.contains(">")) {
            path.getElements().addAll((Object[])new PathElement[]{new MoveTo((double)width - pad, pad), new LineTo((double)width - pad - length, pad), new LineTo((double)width - pad, pad + length), new ClosePath()});
            if (path.getClip() == null) {
                path.setClip((Node)new Rectangle(0.0, pad, (double)width - pad, (double)height - pad));
            }
        }
        if (cap.contains("<")) {
            path.getElements().addAll((Object[])new PathElement[]{new MoveTo(pad, (double)height - pad), new LineTo(pad, (double)height - pad - length), new LineTo(pad + length, (double)height - pad), new ClosePath()});
            if (path.getClip() == null) {
                path.setClip((Node)new Rectangle(pad, 0.0, (double)width - pad, (double)height - pad));
            }
        }
        if (path.getClip() == null) {
            path.setClip((Node)new Rectangle(0.0, 0.0, (double)width, (double)height));
        }
        IconFactory.bindStrokeToSelectionMode((ObservableList<Double>)path.getStrokeDashArray());
        return IconFactory.wrapInGroup((double)width, height, new Node[]{path});
    }

    private static Node drawRectangleIcon(int size) {
        double padX = 2.0;
        double padY = (double)size / 5.0;
        Rectangle shape = new Rectangle(padX, padY, (double)size - padX * 2.0, (double)size - padY * 2.0);
        shape.setStrokeWidth(1.0);
        IconFactory.bindShapeColorToObjectColor((javafx.scene.shape.Shape)shape);
        IconFactory.bindStrokeToSelectionMode((ObservableList<Double>)shape.getStrokeDashArray());
        shape.setFill((Paint)Color.TRANSPARENT);
        return IconFactory.wrapInGroup((double)size, new Node[]{shape});
    }

    private static void bindStrokeToSelectionMode(ObservableList<Double> dashArray) {
        Bindings.bindContent(dashArray, IconFactory.getStrokeDashArray());
    }

    private static ObservableList<Double> getStrokeDashArray() {
        if (strokeDashArray == null) {
            strokeDashArray = FXCollections.observableArrayList();
            PathPrefs.selectionModeStatus().addListener((v, o, n) -> {
                if (n.booleanValue()) {
                    strokeDashArray.setAll((Object[])new Double[]{3.0, 3.0});
                } else {
                    strokeDashArray.clear();
                }
            });
        }
        return strokeDashArray;
    }

    private static Group wrapInGroup(double size, Node ... nodes) {
        return IconFactory.wrapInGroup(size, size, nodes);
    }

    private static Group wrapInGroup(double width, double height, Node ... nodes) {
        Rectangle rect = new Rectangle(0.0, 0.0, width, height);
        rect.setFill((Paint)Color.TRANSPARENT);
        Group group = new Group(nodes);
        group.getChildren().addFirst((Object)rect);
        return group;
    }

    private static Node drawPointsIcon(int sizeOrig) {
        return IconFactory.drawPointsIcon(sizeOrig, null);
    }

    private static Node drawPointsIcon(int sizeOrig, Color color) {
        double pad = 1.0;
        double size = (double)sizeOrig - pad * 2.0;
        double radius = size / 5.0;
        Circle c1 = new Circle(pad + size / 2.0, pad + radius, radius, (Paint)Color.TRANSPARENT);
        Circle c2 = new Circle(pad + radius, pad + size - radius, radius, (Paint)Color.TRANSPARENT);
        Circle c3 = new Circle(pad + size - radius, pad + size - radius, radius, (Paint)Color.TRANSPARENT);
        if (color != null) {
            c1.setStroke((Paint)color);
            c2.setStroke((Paint)color);
            c3.setStroke((Paint)color);
        } else {
            IconFactory.bindShapeColorToObjectColor((javafx.scene.shape.Shape)c1);
            IconFactory.bindShapeColorToObjectColor((javafx.scene.shape.Shape)c2);
            IconFactory.bindShapeColorToObjectColor((javafx.scene.shape.Shape)c3);
        }
        return IconFactory.wrapInGroup((double)sizeOrig, new Node[]{c1, c2, c3});
    }

    private static Node drawPolygonIcon(int size) {
        double padX = 2.0;
        double padY = 3.0;
        Path path = new Path();
        path.getElements().setAll((Object[])new PathElement[]{new MoveTo((double)size - padX, padY), new LineTo((double)size / 3.0, padY), new LineTo(padX, (double)size / 2.0), new LineTo(padX, (double)size - padY), new LineTo((double)size - padX, (double)size - padY), new LineTo((double)size / 2.0 + padX, (double)size / 2.0), new ClosePath()});
        IconFactory.addNodesToPath(path, Math.max(3.0, (double)size / 10.0));
        IconFactory.bindShapeColorToObjectColor((javafx.scene.shape.Shape)path);
        IconFactory.bindStrokeToSelectionMode((ObservableList<Double>)path.getStrokeDashArray());
        return IconFactory.wrapInGroup((double)size, new Node[]{IconFactory.addNodesToPath(path, Math.max(2.0, (double)size / 10.0))});
    }

    private static Node drawBrushIcon(int size) {
        Path path = new Path();
        path.getElements().setAll((Object[])new PathElement[]{new MoveTo((double)size / 2.0, 0.0), new QuadCurveTo((double)size / 8.0, 0.0, (double)size / 3.0, (double)size / 2.0), new QuadCurveTo(0.0, (double)size, (double)size / 2.0, (double)size), new QuadCurveTo((double)size, (double)size, (double)(size * 2) / 3.0, (double)size / 2.0), new QuadCurveTo((double)size - (double)size / 8.0, 0.0, (double)size / 2.0, 0.0), new ClosePath()});
        path.setRotate(30.0);
        IconFactory.bindStrokeToSelectionMode((ObservableList<Double>)path.getStrokeDashArray());
        IconFactory.bindShapeColorToObjectColor((javafx.scene.shape.Shape)path);
        return IconFactory.wrapInGroup((double)size, new Node[]{path});
    }

    private static Node drawPolylineIcon(int size) {
        double padX = 2.0;
        double padY = 2.0;
        Path path = new Path();
        path.getElements().setAll((Object[])new PathElement[]{new MoveTo((double)size - padX, (double)size / 3.0), new LineTo((double)size / 3.0, padY), new LineTo(padX, (double)size - padY), new LineTo((double)size - padX, (double)size - padY)});
        IconFactory.bindShapeColorToObjectColor((javafx.scene.shape.Shape)path);
        IconFactory.bindStrokeToSelectionMode((ObservableList<Double>)path.getStrokeDashArray());
        return IconFactory.wrapInGroup((double)size, new Node[]{IconFactory.addNodesToPath(path, Math.max(2.0, (double)size / 10.0))});
    }

    private static Group addNodesToPath(Path path, double nodeSize) {
        Group group = new Group(new Node[]{path});
        for (PathElement pe : path.getElements()) {
            double y;
            double x;
            if (pe instanceof MoveTo) {
                x = ((MoveTo)pe).getX();
                y = ((MoveTo)pe).getY();
            } else {
                if (!(pe instanceof LineTo)) continue;
                x = ((LineTo)pe).getX();
                y = ((LineTo)pe).getY();
            }
            Rectangle rect = new Rectangle(x - nodeSize / 2.0, y - nodeSize / 2.0, nodeSize, nodeSize);
            rect.fillProperty().bind((ObservableValue)path.strokeProperty());
            rect.setStrokeWidth(0.0);
            group.getChildren().add((Object)rect);
        }
        return group;
    }

    private static Node drawConnectionsIcon(int size) {
        double padX = 2.0;
        double padY = 2.0;
        Point2 ptl = new Point2(padX, padY);
        Point2 ptr = new Point2((double)size - padX, padY);
        Point2 pbl = new Point2(padX, (double)size - padY);
        Point2 pbr = new Point2((double)size - padX, (double)size - padY);
        Point2 pc = new Point2((double)size / 2.0, (double)size / 2.0);
        Path path = new Path();
        path.getElements().setAll((Object[])new PathElement[]{IconFactory.move(ptl), IconFactory.line(ptr), IconFactory.line(pbr), IconFactory.line(pbl), IconFactory.line(ptl), IconFactory.line(pc), IconFactory.line(ptr), IconFactory.move(pc), IconFactory.line(pbl), IconFactory.move(pc), IconFactory.line(pbr)});
        path.setStyle("-fx-stroke: -fx-text-fill; -fx-opacity: 0.4;");
        Group group = new Group((Node[])Stream.of(ptl, ptr, pbl, pbr, pc).map(p -> {
            Circle circle = new Circle(p.getX(), p.getY(), 2.0, (Paint)DETECTION_COLOR);
            Color fillColor = ColorToolsFX.getColorWithOpacity(DETECTION_COLOR, 0.75);
            circle.setFill((Paint)fillColor);
            return circle;
        }).toArray(Node[]::new));
        return IconFactory.wrapInGroup((double)size, new Node[]{path, group});
    }

    private static MoveTo move(Point2 p) {
        return new MoveTo(p.getX(), p.getY());
    }

    private static LineTo line(Point2 p) {
        return new LineTo(p.getX(), p.getY());
    }

    private static Node drawEllipseIcon(int size) {
        double padX = 2.0;
        double padY = (double)size / 6.0;
        Ellipse shape = new Ellipse((double)size / 2.0, (double)size / 2.0, (double)size / 2.0 - padX, (double)size / 2.0 - padY);
        shape.setStrokeWidth(1.0);
        IconFactory.bindShapeColorToObjectColor((javafx.scene.shape.Shape)shape);
        shape.setFill((Paint)Color.TRANSPARENT);
        IconFactory.bindStrokeToSelectionMode((ObservableList<Double>)shape.getStrokeDashArray());
        return IconFactory.wrapInGroup((double)size, new Node[]{shape});
    }

    private static Node drawShowNamesIcon(int size) {
        Text text = new Text("N");
        text.setTextAlignment(TextAlignment.CENTER);
        IconFactory.bindColorPropertyToRGB((ObjectProperty<Paint>)text.fillProperty(), (ObservableIntegerValue)PathPrefs.colorDefaultObjectsProperty());
        return text;
    }

    private static Node drawPixelClassificationIcon(int size) {
        Label label = new Label("C");
        label.getStyleClass().add((Object)"qupath-icon");
        return label;
    }

    private static Node drawGridIcon(int size, int n) {
        ArrayList<Line> lines = new ArrayList<Line>();
        double offset = (double)size / (double)n;
        double k = offset / 2.0;
        for (int i = 0; i < n; ++i) {
            Line line1 = new Line(0.0, k, (double)size, k);
            IconFactory.styleIconShape((javafx.scene.shape.Shape)line1);
            lines.add(line1);
            Line line2 = new Line(k, 0.0, k, (double)size);
            IconFactory.styleIconShape((javafx.scene.shape.Shape)line2);
            lines.add(line2);
            k += offset;
        }
        Group group = IconFactory.wrapInGroup((double)size, (Node[])lines.toArray(Node[]::new));
        group.getStyleClass().add((Object)"qupath-icon");
        return group;
    }

    private static Node drawViewerGridIcon(int size, int rows, int cols) {
        Line line;
        double pad = 2.0;
        ArrayList<Object> nodes = new ArrayList<Object>();
        double h = ((double)size - pad * 2.0) / (double)rows;
        double w = ((double)size - pad * 2.0) / (double)cols;
        Rectangle rect = new Rectangle(pad, pad, (double)size - pad * 2.0, (double)size - pad * 2.0);
        double arcSize = (double)size / 6.0;
        rect.setArcHeight(arcSize);
        rect.setArcWidth(arcSize);
        IconFactory.styleIconShape((javafx.scene.shape.Shape)rect);
        nodes.add(rect);
        for (int r = 1; r < rows; ++r) {
            double y = pad + (double)r * h;
            line = new Line(pad, y, (double)size - pad, y);
            IconFactory.styleIconShape((javafx.scene.shape.Shape)line);
            nodes.add(line);
        }
        for (int c = 1; c < cols; ++c) {
            double x = pad + (double)c * w;
            line = new Line(x, pad, x, (double)size - pad);
            IconFactory.styleIconShape((javafx.scene.shape.Shape)line);
            nodes.add(line);
        }
        Group group = IconFactory.wrapInGroup((double)size, (Node[])nodes.toArray(Node[]::new));
        group.getStyleClass().add((Object)"qupath-icon");
        return group;
    }

    private static void styleIconShape(javafx.scene.shape.Shape shape) {
        shape.setFill((Paint)Color.TRANSPARENT);
        shape.setStrokeWidth(1.0);
        shape.setSmooth(true);
        shape.setStyle("-fx-stroke: -fx-text-fill;");
    }

    private static Node drawSelectionModeIcon(int size) {
        Text text = new Text("S");
        text.setTextAlignment(TextAlignment.CENTER);
        IconFactory.bindColorPropertyToRGB((ObjectProperty<Paint>)text.fillProperty(), (ObservableIntegerValue)PathPrefs.colorDefaultObjectsProperty());
        Circle circle = new Circle((double)size / 2.0, (double)size / 2.0, (double)size / 2.0, (Paint)Color.TRANSPARENT);
        IconFactory.bindColorPropertyToRGB((ObjectProperty<Paint>)circle.strokeProperty(), (ObservableIntegerValue)PathPrefs.colorDefaultObjectsProperty());
        circle.getStrokeDashArray().setAll((Object[])new Double[]{3.0, 3.0});
        circle.setOpacity(0.5);
        StackPane stack = new StackPane(new Node[]{circle, text});
        text.setBoundsType(TextBoundsType.VISUAL);
        return IconFactory.wrapInGroup((double)size, new Node[]{stack});
    }

    private static Node drawDashedS(int size) {
        int pad = 2;
        Path path = new Path();
        double unit = (double)(size - pad) / 6.0;
        path.getElements().setAll((Object[])new PathElement[]{new MoveTo(-unit * 1.5, unit * 2.0), new CubicCurveTo(unit, unit * 2.5, unit * 3.0, unit, 0.0, 0.0), new CubicCurveTo(-unit * 3.0, -unit, -unit, -unit * 2.5, unit * 1.0, -unit * 2.0)});
        path.setTranslateX((double)size / 2.0);
        path.setTranslateY((double)size / 2.0);
        path.getStrokeDashArray().setAll((Object[])new Double[]{2.0, 2.0});
        path.setFill((Paint)Color.TRANSPARENT);
        IconFactory.bindColorPropertyToRGB((ObjectProperty<Paint>)path.strokeProperty(), (ObservableIntegerValue)PathPrefs.colorDefaultObjectsProperty());
        return IconFactory.wrapInGroup((double)size, new Node[]{path});
    }

    private static Node drawLassoNode(int size) {
        int pad = 2;
        Ellipse ellipse = new Ellipse((double)size / 2.0 + (double)pad, (double)(pad * 2), (double)size / 2.0, (double)size / 4.0);
        ellipse.getStrokeDashArray().setAll((Object[])new Double[]{3.0, 3.0});
        ellipse.setFill((Paint)Color.TRANSPARENT);
        Circle circle = new Circle(ellipse.getCenterX(), ellipse.getCenterY() + ellipse.getRadiusY(), (double)size / 20.0);
        QuadCurve arc = new QuadCurve(circle.getCenterX(), circle.getCenterY(), (double)(size - pad), (double)(size - pad), (double)pad, (double)(size - pad));
        arc.setFill((Paint)Color.TRANSPARENT);
        arc.setStrokeDashOffset(1.0);
        arc.getStrokeDashArray().setAll((Object[])new Double[]{3.0, 3.0});
        IconFactory.bindColorPropertyToRGB((ObjectProperty<Paint>)ellipse.strokeProperty(), (ObservableIntegerValue)PathPrefs.colorDefaultObjectsProperty());
        IconFactory.bindColorPropertyToRGB((ObjectProperty<Paint>)circle.strokeProperty(), (ObservableIntegerValue)PathPrefs.colorDefaultObjectsProperty());
        IconFactory.bindColorPropertyToRGB((ObjectProperty<Paint>)circle.fillProperty(), (ObservableIntegerValue)PathPrefs.colorDefaultObjectsProperty());
        IconFactory.bindColorPropertyToRGB((ObjectProperty<Paint>)arc.strokeProperty(), (ObservableIntegerValue)PathPrefs.colorDefaultObjectsProperty());
        return IconFactory.wrapInGroup((double)size, new Node[]{ellipse, circle, arc});
    }

    private static void bindShapeColorToObjectColor(javafx.scene.shape.Shape shape) {
        IconFactory.bindShapeColor(shape, (ObservableIntegerValue)PathPrefs.colorDefaultObjectsProperty());
    }

    private static void bindShapeColor(javafx.scene.shape.Shape shape, ObservableIntegerValue color) {
        IconFactory.bindColorPropertyToRGB((ObjectProperty<Paint>)shape.strokeProperty(), color);
    }

    private static void bindColorPropertyToRGB(ObjectProperty<Paint> colorProperty, ObservableIntegerValue color) {
        colorProperty.bind((ObservableValue)Bindings.createObjectBinding(() -> ColorToolsFX.getCachedColor(color.get()), (Observable[])new Observable[]{color}));
    }

    public static Node createPathObjectIcon(PathObject pathObject, int width, int height) {
        Color color = ColorToolsFX.getDisplayedColor(pathObject);
        ROI roi = pathObject.getROI();
        ROI roiNucleus = PathObjectTools.getNucleusROI((PathObject)pathObject);
        if (roi == null) {
            roi = roiNucleus;
        }
        if (roi == null) {
            return null;
        }
        if (roi != roiNucleus && roiNucleus != null) {
            Shape shapeOuter = RoiTools.getShape((ROI)roi);
            Shape shapeNucleus = RoiTools.getShape((ROI)roiNucleus);
            AffineTransform transform = new AffineTransform();
            double scale = Math.min((double)width / roi.getBoundsWidth(), (double)height / roi.getBoundsHeight());
            transform.translate(-roi.getBoundsX(), -roi.getBoundsY());
            transform.scale(scale, scale);
            Path2D.Double shapeCombined = new Path2D.Double(shapeOuter);
            shapeCombined.append(shapeNucleus, false);
            PathIterator iterator = shapeCombined.getPathIterator(transform, Math.max(0.5, 1.0 / scale));
            return IconFactory.createShapeIcon(iterator, color);
        }
        return IconFactory.createROIIcon(roi, width, height, color);
    }

    public static Node createROIIcon(ROI roi, int width, int height, Color color) {
        double scale = Math.min((double)width / roi.getBoundsWidth(), (double)height / roi.getBoundsHeight());
        if (roi instanceof RectangleROI) {
            Rectangle rect = new Rectangle(0.0, 0.0, roi.getBoundsWidth() * scale, roi.getBoundsHeight() * scale);
            rect.setStroke((Paint)color);
            rect.setFill(null);
            return rect;
        }
        if (roi instanceof EllipseROI) {
            double w = roi.getBoundsWidth() * scale;
            double h = roi.getBoundsHeight() * scale;
            Ellipse ellipse = new Ellipse(w / 2.0, h / 2.0, w / 2.0, h / 2.0);
            ellipse.setStroke((Paint)color);
            ellipse.setFill(null);
            return ellipse;
        }
        if (roi instanceof LineROI) {
            LineROI l = (LineROI)roi;
            double xMin = Math.min(l.getX1(), l.getX2());
            double yMin = Math.min(l.getY1(), l.getY2());
            Line line = new Line((l.getX1() - xMin) * scale, (l.getY1() - yMin) * scale, (l.getX2() - xMin) * scale, (l.getY2() - yMin) * scale);
            line.setStroke((Paint)color);
            line.setFill(null);
            return line;
        }
        if (roi.isPoint()) {
            return IconFactory.drawPointsIcon(Math.min(width, height), color);
        }
        Path path = roiIconCache.computeIfAbsent(roi, r -> IconFactory.createPath(r, scale, color));
        if (path != null) {
            path = new Path((Collection)path.getElements());
            path.setStroke((Paint)color);
            return path;
        }
        logger.warn("Unable to create icon for ROI: {}", (Object)roi);
        return null;
    }

    private static Path createPath(ROI roi, double scale, Color color) {
        Shape shape;
        double downsample = 1.0 / (scale * 2.0);
        Shape shape2 = shape = roi.isArea() && roi.getNumPoints() > 100 ? DownsampledShapeCache.getShapeForDownsample(roi, downsample) : RoiTools.getShape((ROI)roi);
        if (shape == null) {
            return null;
        }
        AffineTransform transform = new AffineTransform();
        transform.translate(-roi.getBoundsX(), -roi.getBoundsY());
        transform.scale(scale, scale);
        PathIterator iterator = shape.getPathIterator(transform, Math.max(0.5, 1.0 / scale));
        return IconFactory.createShapeIcon(iterator, color);
    }

    private static Path createShapeIcon(PathIterator iterator, Color color) {
        Path path = new Path();
        double[] coords = new double[6];
        double lastX = Double.NaN;
        double lastY = Double.NaN;
        int n = 0;
        int skipped = 0;
        block5: while (!iterator.isDone()) {
            int type = iterator.currentSegment(coords);
            double x = coords[0];
            double y = coords[1];
            ++n;
            if (type == 1 && Math.round(lastX) == Math.round(x) && Math.round(lastY) == Math.round(y)) {
                ++skipped;
                iterator.next();
                continue;
            }
            lastX = x;
            lastY = y;
            switch (type) {
                case 0: {
                    path.getElements().add((Object)new MoveTo(x, y));
                    break;
                }
                case 1: {
                    path.getElements().add((Object)new LineTo(x, y));
                    break;
                }
                case 4: {
                    path.getElements().add((Object)new ClosePath());
                    break;
                }
                default: {
                    continue block5;
                }
            }
            iterator.next();
        }
        path.setStroke((Paint)color);
        path.setFill(null);
        logger.trace("Skipped {}/{}", (Object)skipped, (Object)n);
        return path;
    }

    public static Node createNode(int width, int height, PathIcons type) {
        try {
            return type.createGlyph(Math.min(width, height));
        }
        catch (Exception e) {
            logger.error("Unable to load icon {}", (Object)type, (Object)e);
            return null;
        }
    }

    public static Node createNode(FontAwesome.Glyph glyph, int size) {
        return new DuplicatableNode(() -> IconSuppliers.fontAwesome(glyph).apply(size));
    }

    public static Node createNode(FontAwesome.Glyph glyph) {
        return new DuplicatableNode(() -> IconSuppliers.fontAwesome(glyph).apply(16));
    }

    public static Node createFontAwesome(char character) {
        return new DuplicatableNode(() -> IconSuppliers.fontAwesome(character).apply(16));
    }

    public static Node createFontAwesome(char character, int size) {
        return new DuplicatableNode(() -> IconSuppliers.fontAwesome(character).apply(size));
    }

    public static Image createIconImage(PathIcons icon, int size) {
        Node glyph = icon.createGlyph(16);
        glyph.setStyle("-fx-background-color: transparent;");
        return IconFactory.createIconImage((Region)glyph, size);
    }

    private static Image createIconImage(Region glyph, int size) {
        Scene scene = glyph.getScene();
        if (scene == null) {
            scene = new Scene((Parent)glyph);
            scene.setFill((Paint)Color.TRANSPARENT);
        }
        WritableImage image = new WritableImage(size, size);
        scene.snapshot(image);
        double maxDim = Math.max(scene.getWidth(), scene.getHeight());
        double padX = (maxDim - scene.getWidth()) / 2.0;
        double padY = (maxDim - scene.getHeight()) / 2.0;
        glyph.setPadding(new Insets(padY, padX, padY, padX));
        double scale = (double)size / maxDim;
        SnapshotParameters params = new SnapshotParameters();
        params.setTransform((Transform)Transform.scale((double)scale, (double)scale));
        params.setFill((Paint)Color.TRANSPARENT);
        return glyph.snapshot(params, image);
    }

    static {
        roiIconCache = new WeakHashMap<ROI, Path>();
    }

    private static class DuplicatableNode
    extends Label
    implements Duplicatable<Node> {
        private final Supplier<Node> supplier;

        DuplicatableNode(Supplier<Node> supplier) {
            this.supplier = supplier;
            this.setGraphic(supplier.get());
        }

        public Node duplicate() {
            return this.supplier.get();
        }
    }

    public static enum PathIcons {
        ACTIVE_SERVER(IconSuppliers.icoMoon('\ue915', ColorToolsFX.getCachedColor(0, 200, 0))),
        ANNOTATIONS(IconSuppliers.icoMoon('\ue901', (ObservableIntegerValue)PathPrefs.colorDefaultObjectsProperty())),
        ANNOTATIONS_FILL(IconSuppliers.fillAnnotationsIcon()),
        ARROW_START_TOOL(IconSuppliers.arrowToolIcon("<")),
        ARROW_END_TOOL(IconSuppliers.arrowToolIcon(">")),
        ARROW_DOUBLE_TOOL(IconSuppliers.arrowToolIcon("<>")),
        BRUSH_TOOL(IconSuppliers.brushToolIcon()),
        CELL_NUCLEI_BOTH(IconSuppliers.icoMoon('\ue903')),
        CELL_ONLY(IconSuppliers.icoMoon('\ue904')),
        CENTROIDS_ONLY(IconSuppliers.icoMoon('\ue913')),
        COG(IconSuppliers.fontAwesome(FontAwesome.Glyph.COG)),
        COMMAND_LIST(IconSuppliers.fontAwesome(FontAwesome.Glyph.LIST_UL)),
        CONTRAST(IconSuppliers.icoMoon('\ue906')),
        DETECTIONS(IconSuppliers.icoMoon('\ue908', DETECTION_COLOR)),
        DETECTIONS_FILL(IconSuppliers.fillDetectionsIcon()),
        DOWNLOAD(IconSuppliers.fontAwesome(FontAwesome.Glyph.DOWNLOAD)),
        ELLIPSE_TOOL(IconSuppliers.ellipseToolIcon()),
        EXTRACT_REGION(IconSuppliers.icoMoon('\ue90a')),
        GRID(IconSuppliers.createGridIcon()),
        GRID_SPACING(IconSuppliers.createGridSpacingIcon()),
        GITHUB(IconSuppliers.fontAwesome(FontAwesome.Glyph.GITHUB)),
        HELP(IconSuppliers.fontAwesome(FontAwesome.Glyph.QUESTION_CIRCLE)),
        INFO(IconSuppliers.fontAwesome(FontAwesome.Glyph.INFO)),
        INACTIVE_SERVER(IconSuppliers.icoMoon('\ue915', ColorToolsFX.getCachedColor(200, 0, 0))),
        KEYBOARD(IconSuppliers.fontAwesome(FontAwesome.Glyph.KEYBOARD_ALT)),
        LOG_VIEWER(IconSuppliers.fontAwesome(FontAwesome.Glyph.LIST_ALT)),
        LINE_TOOL(IconSuppliers.lineToolIcon()),
        LOCATION(IconSuppliers.icoMoon('\ue90d')),
        MEASURE(IconSuppliers.icoMoon('\ue90e')),
        MEMORY_MONITOR(IconSuppliers.fontAwesome(FontAwesome.Glyph.AREA_CHART)),
        MINUS(IconSuppliers.fontAwesome(FontAwesome.Glyph.MINUS)),
        MOVE_TOOL(IconSuppliers.icoMoon('\ue90f')),
        NUCLEI_ONLY(IconSuppliers.icoMoon('\ue910')),
        OVERVIEW(IconSuppliers.icoMoon('\ue911')),
        PIXEL_CLASSIFICATION(IconSuppliers.pixelClassifierOverlayIcon()),
        PLAYBACK_PLAY(IconSuppliers.icoMoon('\ue912')),
        POINTS_TOOL(IconSuppliers.pointsToolIcon()),
        POLYGON_TOOL(IconSuppliers.polygonToolIcon()),
        POLYLINE_TOOL(IconSuppliers.polylineToolIcon()),
        RECENT_COMMANDS(IconSuppliers.fontAwesome(FontAwesome.Glyph.LIST_OL)),
        RECTANGLE_TOOL(IconSuppliers.rectangleToolIcon()),
        REFRESH(IconSuppliers.fontAwesome(FontAwesome.Glyph.REFRESH)),
        SELECTION_MODE(IconSuppliers.selectionModeIcon()),
        SCRIPT_EDITOR(IconSuppliers.fontAwesome(FontAwesome.Glyph.CODE)),
        SHOW_NAMES(IconSuppliers.showNamesIcon()),
        SHOW_SCALEBAR(IconSuppliers.icoMoon('\ue917')),
        SHOW_CONNECTIONS(IconSuppliers.drawConnectionsIcon()),
        SCREENSHOT(IconSuppliers.icoMoon('\ue918')),
        TRACKING_REWIND(IconSuppliers.fontAwesome(FontAwesome.Glyph.BACKWARD)),
        TRACKING_RECORD(IconSuppliers.icoMoon('\ue915', ColorToolsFX.getCachedColor(200, 0, 0))),
        TRACKING_STOP(IconSuppliers.icoMoon('\ue919')),
        TABLE(IconSuppliers.icoMoon('\ue91a')),
        TMA_GRID(IconSuppliers.icoMoon('\ue91b', (ObservableIntegerValue)PathPrefs.colorTMAProperty())),
        UNDO(IconSuppliers.fontAwesome(FontAwesome.Glyph.UNDO)),
        VIEWER_GRID_1x1(IconSuppliers.createViewerGridIcon(1, 1)),
        VIEWER_GRID_1x2(IconSuppliers.createViewerGridIcon(1, 2)),
        VIEWER_GRID_2x1(IconSuppliers.createViewerGridIcon(2, 1)),
        VIEWER_GRID_2x2(IconSuppliers.createViewerGridIcon(2, 2)),
        VIEWER_GRID_3x3(IconSuppliers.createViewerGridIcon(3, 3)),
        WAND_TOOL(IconSuppliers.icoMoon('\ue91c', (ObservableIntegerValue)PathPrefs.colorDefaultObjectsProperty())),
        WARNING(IconSuppliers.fontAwesome(FontAwesome.Glyph.WARNING)),
        Z_PROJECT(IconSuppliers.fontAwesome(FontAwesome.Glyph.CUBE)),
        ZOOM_IN(IconSuppliers.icoMoon('\ue91d')),
        ZOOM_OUT(IconSuppliers.icoMoon('\ue91e')),
        ZOOM_TO_FIT(IconSuppliers.icoMoon('\ue91f'));

        private final IntFunction<Node> fun;

        private PathIcons(IntFunction<Node> fun) {
            this.fun = fun;
        }

        private Node createGlyph(int size) {
            return this.fun.apply(size);
        }
    }

    static class IconSuppliers {
        private static final GlyphFont icoMoon;
        private static final GlyphFont fontAwesome;

        IconSuppliers() {
        }

        static IntFunction<Node> fontAwesome(FontAwesome.Glyph glyph, ObservableIntegerValue color) {
            return new FontIconSupplier(fontAwesome, glyph.getChar(), color);
        }

        static IntFunction<Node> fontAwesome(FontAwesome.Glyph glyph, Color color) {
            return new FontIconSupplier(fontAwesome, glyph.getChar(), color);
        }

        static IntFunction<Node> fontAwesome(FontAwesome.Glyph glyph) {
            return IconSuppliers.fontAwesome(glyph.getChar());
        }

        static IntFunction<Node> fontAwesome(char c) {
            return new FontIconSupplier(fontAwesome, c);
        }

        static IntFunction<Node> icoMoon(char c) {
            return new FontIconSupplier(icoMoon, c);
        }

        static IntFunction<Node> icoMoon(char c, ObservableIntegerValue color) {
            return new FontIconSupplier(icoMoon, c, color);
        }

        static IntFunction<Node> icoMoon(char c, Color color) {
            return new FontIconSupplier(icoMoon, c, color);
        }

        static IntFunction<Node> lineToolIcon() {
            return i -> IconFactory.createLineOrArrowIcon(i, "");
        }

        static IntFunction<Node> fillAnnotationsIcon() {
            return i -> new DuplicatableNode(() -> IconSuppliers.createFillAnnotationsIcon(i));
        }

        private static Node createFillAnnotationsIcon(int size) {
            Node fill = IconSuppliers.icoMoon('\ue900', (ObservableIntegerValue)PathPrefs.colorDefaultObjectsProperty()).apply(size);
            fill.setOpacity(0.5);
            Node outline = IconSuppliers.icoMoon('\ue901', (ObservableIntegerValue)PathPrefs.colorDefaultObjectsProperty()).apply(size);
            return new Group(new Node[]{fill, outline});
        }

        static IntFunction<Node> fillDetectionsIcon() {
            return i -> new DuplicatableNode(() -> IconSuppliers.createFillDetectionIcon(i));
        }

        private static Node createFillDetectionIcon(int size) {
            Node fill = IconSuppliers.icoMoon('\ue907', DETECTION_COLOR).apply(size);
            fill.setOpacity(0.75);
            Node outline = IconSuppliers.icoMoon('\ue908', DETECTION_COLOR).apply(size);
            return new Group(new Node[]{fill, outline});
        }

        static IntFunction<Node> arrowToolIcon(String cap) {
            return i -> IconFactory.createLineOrArrowIcon(i, cap);
        }

        static IntFunction<Node> rectangleToolIcon() {
            return i -> new DuplicatableNode(() -> IconFactory.drawRectangleIcon(i));
        }

        static IntFunction<Node> ellipseToolIcon() {
            return i -> new DuplicatableNode(() -> IconFactory.drawEllipseIcon(i));
        }

        static IntFunction<Node> polygonToolIcon() {
            return i -> new DuplicatableNode(() -> IconFactory.drawPolygonIcon(i));
        }

        static IntFunction<Node> polylineToolIcon() {
            return i -> new DuplicatableNode(() -> IconFactory.drawPolylineIcon(i));
        }

        static IntFunction<Node> pointsToolIcon() {
            return i -> new DuplicatableNode(() -> IconFactory.drawPointsIcon(i));
        }

        static IntFunction<Node> brushToolIcon() {
            return i -> new DuplicatableNode(() -> IconFactory.drawBrushIcon(i));
        }

        static IntFunction<Node> selectionModeIcon() {
            return i -> new DuplicatableNode(() -> IconFactory.drawSelectionModeIcon(i));
        }

        static IntFunction<Node> pixelClassifierOverlayIcon() {
            return i -> new DuplicatableNode(() -> IconFactory.drawPixelClassificationIcon(i));
        }

        static IntFunction<Node> drawConnectionsIcon() {
            return i -> new DuplicatableNode(() -> IconFactory.drawConnectionsIcon(i));
        }

        static IntFunction<Node> showNamesIcon() {
            return i -> new DuplicatableNode(() -> IconFactory.drawShowNamesIcon(i));
        }

        static IntFunction<Node> createViewerGridIcon(int rows, int cols) {
            return i -> new DuplicatableNode(() -> IconFactory.drawViewerGridIcon(i, rows, cols));
        }

        static IntFunction<Node> createGridIcon() {
            return i -> new DuplicatableNode(() -> IconFactory.drawGridIcon(i, 4));
        }

        static IntFunction<Node> createGridSpacingIcon() {
            return i -> new DuplicatableNode(() -> IconFactory.drawGridIcon(i, 2));
        }

        static {
            GlyphFontRegistry.register((String)"icomoon", (InputStream)IconFactory.class.getClassLoader().getResourceAsStream("fonts/icomoon.ttf"), (int)12);
            icoMoon = GlyphFontRegistry.font((String)"icomoon");
            fontAwesome = GlyphFontRegistry.font((String)"FontAwesome");
        }

        static class FontIconSupplier
        implements IntFunction<Node> {
            private final GlyphFont font;
            private final char code;
            private Color color;
            private ObservableIntegerValue observableColor;

            FontIconSupplier(GlyphFont font, char code) {
                this.font = font;
                this.code = code;
            }

            FontIconSupplier(GlyphFont font, char code, Color color) {
                this.font = font;
                this.code = code;
                this.color = color;
            }

            FontIconSupplier(GlyphFont font, char code, ObservableIntegerValue observableColor) {
                this.font = font;
                this.code = code;
                this.observableColor = observableColor;
            }

            private char getCode() {
                return this.code;
            }

            @Override
            public Node apply(int size) {
                char code = this.getCode();
                Glyph g = this.font.create(code).size((double)size);
                g.setAlignment(Pos.CENTER);
                g.setContentDisplay(ContentDisplay.CENTER);
                g.setTextAlignment(TextAlignment.CENTER);
                g.setIcon((Object)Character.valueOf(code));
                g.getStyleClass().add((Object)"qupath-icon");
                boolean useFill = false;
                if (this.observableColor == null || this.observableColor.getValue() == null) {
                    if (this.color != null) {
                        g.color(this.color);
                        useFill = true;
                    }
                } else {
                    g = GuiTools.ensureDuplicatableGlyph(g, false);
                    g.textFillProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> ColorToolsFX.getCachedColor(this.observableColor.get()), (Observable[])new Observable[]{this.observableColor}));
                    useFill = true;
                }
                if (!useFill) {
                    g.getStyleClass().add((Object)"use-text-fill");
                }
                return GuiTools.ensureDuplicatableGlyph(g, useFill);
            }
        }
    }
}

