/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.tools;

import java.awt.AWTException;
import java.awt.Desktop;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.StyleOrigin;
import javafx.css.StyleableObjectProperty;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Slider;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.robot.Robot;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.swing.SwingUtilities;
import org.controlsfx.control.ListSelectionView;
import org.controlsfx.control.action.Action;
import org.controlsfx.glyphfont.Glyph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.utils.FXUtils;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.awt.common.BufferedImageTools;
import qupath.lib.color.ColorDeconvolutionHelper;
import qupath.lib.color.ColorDeconvolutionStains;
import qupath.lib.color.StainVector;
import qupath.lib.common.ColorTools;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.actions.ActionTools;
import qupath.lib.gui.commands.Commands;
import qupath.lib.gui.dialogs.ParameterPanelFX;
import qupath.lib.gui.localization.QuPathResources;
import qupath.lib.gui.tools.ColorToolsFX;
import qupath.lib.gui.tools.MenuTools;
import qupath.lib.gui.tools.PathClassListCell;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.objects.PathAnnotationObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.PathRootObject;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.plugins.objects.SplitAnnotationsPlugin;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.plugins.workflow.DefaultScriptableWorkflowStep;
import qupath.lib.plugins.workflow.WorkflowStep;
import qupath.lib.roi.PointsROI;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;

public class GuiTools {
    private static final String MORE_ELLIPSIS = "\u22ee";
    public static final String STYLE_PLACEHOLDER_TEXT = "text-placeholder";
    private static final Logger logger = LoggerFactory.getLogger(GuiTools.class);
    private static final PathClass PATH_CLASS_UNCHANGED = PathClass.fromString((String)UUID.randomUUID().toString(), (Integer)ColorTools.packARGB((int)0, (int)255, (int)255, (int)255));
    private static final String KEY_REGIONS = "processRegions";

    public static Button createMoreButton(ContextMenu menu, Side side) {
        Button btnMore = new Button(MORE_ELLIPSIS);
        btnMore.setTooltip(new Tooltip("More options"));
        btnMore.setOnAction(e -> menu.show((Node)btnMore, side, 0.0, 0.0));
        return btnMore;
    }

    public static boolean showParameterDialog(String title, ParameterList params) {
        return Dialogs.showConfirmDialog((String)title, (Node)new ParameterPanelFX(params).getPane());
    }

    public static void showNoImageError(String title) {
        Dialogs.showErrorMessage((String)title, (String)QuPathResources.getString("Dialogs.noImage"));
    }

    public static void showNoProjectError(String title) {
        Dialogs.showErrorMessage((String)title, (String)QuPathResources.getString("Dialogs.noProject"));
    }

    public static Text createPlaceholderText(String text) {
        Text textNode = new Text(text);
        textNode.getStyleClass().add((Object)STYLE_PLACEHOLDER_TEXT);
        return textNode;
    }

    public static boolean browseDirectory(File file) {
        if (file == null || !file.exists()) {
            Dialogs.showErrorMessage((String)"Open", (String)("File " + String.valueOf(file) + " does not exist!"));
            return false;
        }
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                if (file.isFile() && desktop.isSupported(Desktop.Action.BROWSE_FILE_DIR)) {
                    SwingUtilities.invokeLater(() -> desktop.browseFileDirectory(file));
                    return true;
                }
                if (desktop.isSupported(Desktop.Action.OPEN)) {
                    File directoryToOpen = file.isDirectory() ? file : file.getParentFile();
                    SwingUtilities.invokeLater(() -> {
                        try {
                            desktop.open(directoryToOpen);
                        }
                        catch (IOException e) {
                            logger.error(e.getLocalizedMessage(), (Throwable)e);
                            logger.error("Unable to open {}", (Object)directoryToOpen.getAbsolutePath());
                        }
                    });
                    return true;
                }
                if (Dialogs.showConfirmDialog((String)"Browse directory", (String)"Directory browsing not supported on this platform!\nCopy directory path to clipboard instead?")) {
                    ClipboardContent content = new ClipboardContent();
                    content.putString(file.getAbsolutePath());
                    Clipboard.getSystemClipboard().setContent((Map)content);
                }
                return true;
            }
            catch (Exception e1) {
                if (desktop.isSupported(Desktop.Action.BROWSE_FILE_DIR)) {
                    SwingUtilities.invokeLater(() -> desktop.browseFileDirectory(file));
                }
                Dialogs.showErrorNotification((String)"Browse directory", (Throwable)e1);
                logger.error(e1.getMessage(), (Throwable)e1);
            }
        }
        return false;
    }

    public static <T> ListSelectionView<T> createListSelectionView() {
        ListSelectionView listSelectionView = new ListSelectionView();
        for (Action action : listSelectionView.getActions()) {
            Node graphic = action.getGraphic();
            if (!(graphic instanceof Glyph)) continue;
            action.graphicProperty().unbind();
            action.setGraphic((Node)GuiTools.ensureDuplicatableGlyph((Glyph)graphic));
        }
        return listSelectionView;
    }

    public static Glyph ensureDuplicatableGlyph(Glyph glyph) {
        return GuiTools.ensureDuplicatableGlyph(glyph, true);
    }

    public static Glyph ensureDuplicatableGlyph(Glyph glyph, boolean useFill) {
        if (glyph instanceof DuplicatableGlyph && ((DuplicatableGlyph)glyph).useFill == useFill) {
            return glyph;
        }
        return new DuplicatableGlyph(glyph, useFill);
    }

    public static boolean browseURI(URI uri) {
        return QuPathGUI.openInBrowser(uri.toString());
    }

    public static ImageData.ImageType estimateImageType(ImageServer<BufferedImage> server, BufferedImage imgThumbnail) {
        if (!server.isRGB()) {
            return ImageData.ImageType.FLUORESCENCE;
        }
        BufferedImage img = imgThumbnail;
        int w = img.getWidth();
        int h = img.getHeight();
        int[] rgb = img.getRGB(0, 0, w, h, null, 0, w);
        long rSum = 0L;
        long gSum = 0L;
        long bSum = 0L;
        int nDark = 0;
        int nLight = 0;
        int n = 0;
        int darkThreshold = 25;
        int lightThreshold = 220;
        for (int v : rgb) {
            int r = ColorTools.red((int)v);
            int g = ColorTools.green((int)v);
            int b = ColorTools.blue((int)v);
            if (r < darkThreshold & g < darkThreshold && b < darkThreshold) {
                ++nDark;
                continue;
            }
            if (r > lightThreshold & g > lightThreshold && b > lightThreshold) {
                ++nLight;
                continue;
            }
            ++n;
            rSum += (long)r;
            gSum += (long)g;
            bSum += (long)b;
        }
        if (nDark == 0 && nLight == 0) {
            return ImageData.ImageType.OTHER;
        }
        if (nDark >= nLight) {
            return ImageData.ImageType.FLUORESCENCE;
        }
        if (n == 0) {
            logger.warn("Unable to estimate brightfield stains (no stained pixels found)");
            return ImageData.ImageType.BRIGHTFIELD_OTHER;
        }
        ColorDeconvolutionStains stainsH_E = ColorDeconvolutionStains.makeDefaultColorDeconvolutionStains((ColorDeconvolutionStains.DefaultColorDeconvolutionStains)ColorDeconvolutionStains.DefaultColorDeconvolutionStains.H_E);
        double rOD = ColorDeconvolutionHelper.makeOD((double)((double)rSum / (double)n), (double)stainsH_E.getMaxRed());
        double gOD = ColorDeconvolutionHelper.makeOD((double)((double)gSum / (double)n), (double)stainsH_E.getMaxGreen());
        double bOD = ColorDeconvolutionHelper.makeOD((double)((double)bSum / (double)n), (double)stainsH_E.getMaxBlue());
        StainVector stainMean = StainVector.createStainVector((String)"Mean Stain", (double)rOD, (double)gOD, (double)bOD);
        double angleH = StainVector.computeAngle((StainVector)stainMean, (StainVector)stainsH_E.getStain(1));
        double angleE = StainVector.computeAngle((StainVector)stainMean, (StainVector)stainsH_E.getStain(2));
        ColorDeconvolutionStains stainsH_DAB = ColorDeconvolutionStains.makeDefaultColorDeconvolutionStains((ColorDeconvolutionStains.DefaultColorDeconvolutionStains)ColorDeconvolutionStains.DefaultColorDeconvolutionStains.H_DAB);
        double angleDAB = StainVector.computeAngle((StainVector)stainMean, (StainVector)stainsH_DAB.getStain(2));
        logger.debug("Angle hematoxylin: " + angleH);
        logger.debug("Angle eosin: " + angleE);
        logger.debug("Angle DAB: " + angleDAB);
        if (angleDAB < angleE || angleH < angleE) {
            logger.info("Estimating H-DAB staining");
            return ImageData.ImageType.BRIGHTFIELD_H_DAB;
        }
        logger.info("Estimating H & E staining");
        return ImageData.ImageType.BRIGHTFIELD_H_E;
    }

    public static WritableImage makeSnapshotFX(QuPathGUI qupath, SnapshotType type) {
        return GuiTools.makeSnapshotFX(qupath, qupath.getViewer(), type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WritableImage makeSnapshotFX(QuPathGUI qupath, QuPathViewer viewer, SnapshotType type) {
        if (!Platform.isFxApplicationThread()) {
            QuPathViewer temp = viewer;
            return (WritableImage)FXUtils.callOnApplicationThread(() -> GuiTools.makeSnapshotFX(qupath, temp, type));
        }
        Stage stage = qupath.getStage();
        Scene scene = stage.getScene();
        switch (type.ordinal()) {
            case 0: {
                if (viewer == null) {
                    viewer = qupath.getViewer();
                }
                Color borderColor = viewer.getBorderColor();
                try {
                    qupath.getViewer().setBorderColor(null);
                    WritableImage writableImage = viewer.getView().snapshot(null, null);
                    return writableImage;
                }
                finally {
                    viewer.setBorderColor(borderColor);
                }
            }
            case 1: {
                return scene.snapshot(null);
            }
            case 2: {
                double x = scene.getX() + stage.getX();
                double y = scene.getY() + stage.getY();
                double width = scene.getWidth();
                double height = scene.getHeight();
                try {
                    return GuiTools.createScreenCapture(x, y, width, height, GeneralTools.isMac());
                }
                catch (Exception e) {
                    logger.error("Unable to make main window screenshot, will resort to trying to crop a full screenshot instead", (Throwable)e);
                    WritableImage img2 = GuiTools.makeSnapshotFX(qupath, viewer, SnapshotType.FULL_SCREENSHOT);
                    return new WritableImage(img2.getPixelReader(), (int)x, (int)y, (int)width, (int)height);
                }
            }
            case 3: {
                Screen screen = FXUtils.getScreenOrPrimary((Window)stage);
                Rectangle2D bounds = screen.getBounds();
                return GuiTools.createScreenCapture(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight(), GeneralTools.isMac());
            }
        }
        throw new IllegalArgumentException("Unknown snapshot type " + String.valueOf((Object)type));
    }

    private static WritableImage createScreenCapture(double x, double y, double width, double height, boolean preferAwt) {
        if (preferAwt) {
            try {
                logger.debug("Attempting screen capture with AWT");
                BufferedImage img = new java.awt.Robot().createScreenCapture(new Rectangle2D.Double(x, y, width, height).getBounds());
                return SwingFXUtils.toFXImage((BufferedImage)img, null);
            }
            catch (AWTException e) {
                logger.warn("Exception attempting AWT screen capture");
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        return new Robot().getScreenCapture(null, x, y, width, height);
    }

    public static BufferedImage makeSnapshot(QuPathGUI qupath, SnapshotType type) {
        return GuiTools.makeSnapshot(qupath, qupath.getViewer(), type);
    }

    public static BufferedImage makeSnapshot(QuPathGUI qupath, QuPathViewer viewer, SnapshotType type) {
        WritableImage image = GuiTools.makeSnapshotFX(qupath, viewer, type);
        BufferedImage img = SwingFXUtils.fromFXImage((Image)image, null);
        return BufferedImageTools.ensureBufferedImageType((BufferedImage)img, (int)2);
    }

    public static BufferedImage makeViewerSnapshot(QuPathViewer viewer) {
        return SwingFXUtils.fromFXImage((Image)GuiTools.makeSnapshotFX(QuPathGUI.getInstance(), viewer, SnapshotType.VIEWER), null);
    }

    public static BufferedImage makeSnapshot() {
        return GuiTools.makeSnapshot(QuPathGUI.getInstance(), SnapshotType.MAIN_SCENE);
    }

    public static BufferedImage makeViewerSnapshot() {
        QuPathGUI qupath = QuPathGUI.getInstance();
        return GuiTools.makeSnapshot(qupath, qupath.getViewer(), SnapshotType.VIEWER);
    }

    public static BufferedImage makeFullScreenshot() {
        return GuiTools.makeSnapshot(QuPathGUI.getInstance(), SnapshotType.FULL_SCREENSHOT);
    }

    public static String getMagnificationString(QuPathViewer viewer) {
        if (viewer == null || !viewer.hasServer()) {
            return "";
        }
        return String.format("%.2fx", viewer.getMagnification());
    }

    public static boolean promptToClearAllSelectedObjects(ImageData<?> imageData) {
        PathObjectHierarchy hierarchy = imageData.getHierarchy();
        Set selectedRaw = hierarchy.getSelectionModel().getSelectedObjects();
        List<PathObject> selected = selectedRaw.stream().filter(p -> !(p instanceof TMACoreObject)).toList();
        if (selected.isEmpty()) {
            if (selectedRaw.size() > selected.size()) {
                Dialogs.showErrorMessage((String)"Delete selected objects", (String)"No valid objects selected! \n\nNote: Individual TMA cores cannot be deleted with this method.");
            } else {
                Dialogs.showErrorMessage((String)"Delete selected objects", (String)"No objects selected!");
            }
            return false;
        }
        int n = selected.size();
        Object message = n == 1 ? "Delete selected object?" : "Delete " + n + " selected objects?";
        if (Dialogs.showYesNoDialog((String)"Delete objects", (String)message)) {
            ArrayList children = new ArrayList();
            for (PathObject temp : selected) {
                children.addAll(temp.getChildObjects());
            }
            children.removeAll(selected);
            boolean keepChildren = true;
            if (!children.isEmpty()) {
                ButtonType response = Dialogs.showYesNoCancelDialog((String)"Delete objects", (String)"Keep descendant objects?");
                if (response == ButtonType.CANCEL) {
                    return false;
                }
                keepChildren = response == ButtonType.YES;
            }
            hierarchy.removeObjects(selected, keepChildren);
            hierarchy.getSelectionModel().clearSelection();
            if (keepChildren) {
                imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Delete selected objects", "removeSelectedObjects()"));
                logger.info("{} object(s) deleted", (Object)selected.size());
            } else {
                imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Delete selected objects and descendants", "removeSelectedObjectsAndDescendants()"));
                logger.info("{} object(s) deleted with descendants", (Object)selected.size());
            }
            return true;
        }
        return false;
    }

    public static boolean promptToRemoveSelectedObject(PathObject pathObjectSelected, PathObjectHierarchy hierarchy) {
        if (pathObjectSelected == null || pathObjectSelected instanceof TMACoreObject) {
            return false;
        }
        hierarchy.getSelectionModel().deselectObject(pathObjectSelected);
        if (pathObjectSelected.hasChildObjects()) {
            int nDescendants = PathObjectTools.countDescendants((PathObject)pathObjectSelected);
            String message = nDescendants == 1 ? "Keep descendant object?" : String.format("Keep %d descendant objects?", nDescendants);
            ButtonType confirm = Dialogs.showYesNoCancelDialog((String)"Delete object", (String)message);
            if (confirm == ButtonType.CANCEL) {
                return false;
            }
            if (confirm == ButtonType.YES) {
                hierarchy.removeObject(pathObjectSelected, true);
            } else {
                hierarchy.removeObject(pathObjectSelected, false);
            }
        } else if (PathObjectTools.hasPointROI((PathObject)pathObjectSelected)) {
            int nPoints = ((PointsROI)pathObjectSelected.getROI()).getNumPoints();
            if (nPoints > 1) {
                if (!Dialogs.showYesNoDialog((String)"Delete object", (String)String.format("Delete %d points?", nPoints))) {
                    return false;
                }
                hierarchy.removeObject(pathObjectSelected, false);
            } else {
                hierarchy.removeObject(pathObjectSelected, false);
            }
        } else if (pathObjectSelected.isDetection()) {
            if (!Dialogs.showYesNoDialog((String)"Delete object", (String)"Are you sure you want to delete this detection object?")) {
                return false;
            }
            hierarchy.removeObject(pathObjectSelected, false);
        } else {
            hierarchy.removeObject(pathObjectSelected, false);
        }
        return true;
    }

    public static boolean openFile(File file) {
        if (file == null || !file.exists()) {
            Dialogs.showErrorMessage((String)"Open", (String)("File " + String.valueOf(file) + " does not exist!"));
            return false;
        }
        if (file.isDirectory()) {
            return GuiTools.browseDirectory(file);
        }
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop desktop = Desktop.getDesktop();
                if (desktop.isSupported(Desktop.Action.OPEN)) {
                    SwingUtilities.invokeLater(() -> {
                        try {
                            desktop.open(file);
                        }
                        catch (IOException e) {
                            logger.error(e.getLocalizedMessage(), (Throwable)e);
                            logger.error("Unable to open {}", (Object)file.getAbsolutePath());
                        }
                    });
                } else if (Dialogs.showConfirmDialog((String)"Open file", (String)"Opening files not supported on this platform!\nCopy directory path to clipboard instead?")) {
                    ClipboardContent content = new ClipboardContent();
                    content.putString(file.getAbsolutePath());
                    Clipboard.getSystemClipboard().setContent((Map)content);
                }
                return true;
            }
            catch (Exception e1) {
                Dialogs.showErrorNotification((String)"Open file", (Throwable)e1);
                logger.error(e1.getMessage(), (Throwable)e1);
            }
        }
        return false;
    }

    public static void paintImage(Canvas canvas, Image image) {
        GuiTools.paintImage(canvas, image, -1.0);
    }

    public static void paintImage(Canvas canvas, Image image, double scale) {
        GraphicsContext gc = canvas.getGraphicsContext2D();
        double w = canvas.getWidth();
        double h = canvas.getHeight();
        gc.setFill((Paint)Color.TRANSPARENT);
        gc.clearRect(0.0, 0.0, w, h);
        if (image == null) {
            return;
        }
        if (scale <= 0.0) {
            scale = Math.min(w / image.getWidth(), h / image.getHeight());
        }
        double sw = image.getWidth() * scale;
        double sh = image.getHeight() * scale;
        double sx = (w - sw) / 2.0;
        double sy = (h - sh) / 2.0;
        gc.drawImage(image, sx, sy, sw, sh);
    }

    public static <T> void refreshList(ListView<T> listView) {
        if (Platform.isFxApplicationThread()) {
            listView.refresh();
        } else {
            Platform.runLater(() -> GuiTools.refreshList(listView));
        }
    }

    public static boolean promptToSetActiveAnnotationProperties(PathObjectHierarchy hierarchy) {
        PathObject currentObject = hierarchy.getSelectionModel().getSelectedObject();
        if (currentObject == null || !currentObject.isAnnotation()) {
            return false;
        }
        ROI roi = currentObject.getROI();
        if (roi == null) {
            return false;
        }
        List<PathAnnotationObject> otherAnnotations = hierarchy.getSelectionModel().getSelectedObjects().stream().filter(p -> p.isAnnotation() && p != currentObject).map(p -> (PathAnnotationObject)p).toList();
        if (GuiTools.promptToSetAnnotationProperties((PathAnnotationObject)currentObject, otherAnnotations)) {
            ArrayList<Object> changedObjects = new ArrayList<Object>();
            changedObjects.add(currentObject);
            changedObjects.addAll(otherAnnotations);
            hierarchy.fireObjectsChangedEvent(null, changedObjects);
            hierarchy.getSelectionModel().setSelectedObjects(changedObjects, currentObject);
            return true;
        }
        return false;
    }

    private static String pathClassStringFun(PathClass pathClass) {
        if (pathClass == PATH_CLASS_UNCHANGED) {
            return "[Don't change]";
        }
        return PathClassListCell.defaultStringFunction(pathClass);
    }

    private static boolean promptToSetAnnotationProperties(PathAnnotationObject annotation, Collection<PathAnnotationObject> otherAnnotations) {
        GridPane panel = new GridPane();
        panel.setVgap(5.0);
        panel.setHgap(5.0);
        TextField textField = new TextField();
        if (annotation.getName() != null) {
            textField.setText(annotation.getName());
        }
        textField.setPrefColumnCount(20);
        Platform.runLater(() -> ((TextField)textField).requestFocus());
        int row = 0;
        panel.addRow(row++, new Node[]{new Label("Name "), textField});
        boolean promptForColor = true;
        ComboBox comboClasses = new ComboBox();
        ArrayList<PathClass> availableClasses = new ArrayList<PathClass>((Collection<PathClass>)QuPathGUI.getInstance().getAvailablePathClasses());
        PathClass currentClass = annotation.getPathClass();
        if (currentClass == null) {
            currentClass = PathClass.NULL_CLASS;
        }
        if (!availableClasses.contains(currentClass)) {
            availableClasses.add(currentClass);
        }
        comboClasses.getItems().setAll(availableClasses);
        comboClasses.setCellFactory(c -> new PathClassListCell(GuiTools::pathClassStringFun));
        comboClasses.setButtonCell((ListCell)new PathClassListCell(GuiTools::pathClassStringFun));
        if (otherAnnotations != null && otherAnnotations.stream().anyMatch(p -> p.getPathClass() != annotation.getPathClass())) {
            comboClasses.getItems().addFirst((Object)PATH_CLASS_UNCHANGED);
            comboClasses.getSelectionModel().select((Object)PATH_CLASS_UNCHANGED);
        } else {
            comboClasses.setValue((Object)currentClass);
        }
        panel.addRow(row++, new Node[]{new Label("Class "), comboClasses});
        Color originalColor = ColorToolsFX.getDisplayedColor((PathObject)annotation);
        SimpleBooleanProperty colorChanged = new SimpleBooleanProperty(false);
        ColorPicker colorPicker = new ColorPicker(originalColor);
        if (promptForColor) {
            colorPicker.valueProperty().addListener((v, o, n) -> colorChanged.set(true));
            panel.addRow(row++, new Node[]{new Label("Color "), colorPicker});
            colorPicker.prefWidthProperty().bind((ObservableValue)textField.widthProperty());
        }
        Label labDescription = new Label("Description");
        TextArea textAreaDescription = new TextArea(annotation.getDescription());
        textAreaDescription.setPrefRowCount(8);
        textAreaDescription.setPrefColumnCount(40);
        labDescription.setLabelFor((Node)textAreaDescription);
        textAreaDescription.setStyle("-fx-font-family: monospaced;");
        textAreaDescription.setWrapText(true);
        panel.addRow(row++, new Node[]{labDescription, textAreaDescription});
        CheckBox cbLocked = new CheckBox("");
        cbLocked.setSelected(annotation.isLocked());
        Label labelLocked = new Label("Locked");
        labelLocked.setLabelFor((Node)cbLocked);
        panel.addRow(row++, new Node[]{labelLocked, cbLocked});
        CheckBox cbAll = new CheckBox("");
        boolean hasOthers = otherAnnotations != null && !otherAnnotations.isEmpty();
        cbAll.setSelected(hasOthers);
        if (hasOthers) {
            Label labelApplyToAll = new Label("Apply to all");
            cbAll.setTooltip(new Tooltip("Apply properties to all " + (otherAnnotations.size() + 1) + " selected annotations"));
            labelApplyToAll.setLabelFor((Node)cbAll);
            panel.addRow(row++, new Node[]{labelApplyToAll, cbAll});
        }
        GridPaneUtils.setToExpandGridPaneWidth((Node[])new Node[]{textField, colorPicker, comboClasses, textAreaDescription, cbLocked, cbAll});
        GridPaneUtils.setHGrowPriority((Priority)Priority.ALWAYS, (Node[])new Node[]{colorPicker, comboClasses, textAreaDescription, cbLocked, cbAll});
        GridPaneUtils.setVGrowPriority((Priority)Priority.NEVER, (Node[])new Node[]{colorPicker});
        GridPaneUtils.setToExpandGridPaneHeight((Node[])new Node[]{textAreaDescription});
        panel.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{new ColumnConstraints(-1.0), new ColumnConstraints(0.0, 400.0, Double.MAX_VALUE)});
        Dialog dialog = Dialogs.builder().title("Set annotation properties").content((Node)panel).modality(Modality.APPLICATION_MODAL).buttons(new ButtonType[]{ButtonType.APPLY, ButtonType.CANCEL}).resizable().build();
        Optional response = dialog.showAndWait();
        if (!Objects.equals(ButtonType.APPLY, response.orElse(ButtonType.CANCEL))) {
            return false;
        }
        ArrayList<PathAnnotationObject> toChange = new ArrayList<PathAnnotationObject>();
        toChange.add(annotation);
        if (cbAll.isSelected()) {
            toChange.addAll(otherAnnotations);
        }
        String name = textField.getText().trim();
        PathClass pathClass = (PathClass)comboClasses.getValue();
        if (pathClass == PathClass.NULL_CLASS) {
            pathClass = null;
        }
        for (PathAnnotationObject temp : toChange) {
            String description;
            if (!name.isEmpty()) {
                temp.setName(name);
            } else {
                temp.setName(null);
            }
            if (promptForColor && colorChanged.get()) {
                temp.setColor(Integer.valueOf(ColorToolsFX.getARGB((Color)colorPicker.getValue())));
            }
            if (pathClass != PATH_CLASS_UNCHANGED && pathClass != temp.getPathClass()) {
                temp.setPathClass(pathClass);
            }
            if ((description = textAreaDescription.getText()) == null || description.isEmpty()) {
                temp.setDescription(null);
            } else {
                temp.setDescription(description);
            }
            temp.setLocked(cbLocked.isSelected());
        }
        return true;
    }

    public static Menu populateAnnotationsMenu(QuPathGUI qupath, Menu menu) {
        GuiTools.createAnnotationsMenuImpl(qupath, menu);
        return menu;
    }

    public static ContextMenu populateAnnotationsMenu(QuPathGUI qupath, ContextMenu menu) {
        GuiTools.createAnnotationsMenuImpl(qupath, menu);
        return menu;
    }

    private static void createAnnotationsMenuImpl(QuPathGUI qupath, Object menu) {
        ObservableList items;
        CheckMenuItem miLockAnnotations = new CheckMenuItem("Lock");
        CheckMenuItem miUnlockAnnotations = new CheckMenuItem("Unlock");
        miLockAnnotations.setOnAction(e -> GuiTools.setSelectedAnnotationsLocked(qupath.getImageData(), true));
        miUnlockAnnotations.setOnAction(e -> GuiTools.setSelectedAnnotationsLocked(qupath.getImageData(), false));
        MenuItem miSetProperties = new MenuItem("Set properties");
        miSetProperties.setOnAction(e -> {
            PathObjectHierarchy hierarchy = qupath.getViewer().getHierarchy();
            if (hierarchy != null) {
                GuiTools.promptToSetActiveAnnotationProperties(hierarchy);
            }
        });
        Action actionInsertInHierarchy = qupath.createImageDataAction(imageData -> Commands.insertSelectedObjectsInHierarchy(imageData));
        actionInsertInHierarchy.setText("Insert in hierarchy");
        MenuItem miInsertHierarchy = ActionTools.createMenuItem(actionInsertInHierarchy);
        Action actionMerge = qupath.createImageDataAction(imageData -> Commands.mergeSelectedAnnotations(imageData));
        actionMerge.setText("Merge selected");
        Action actionSubtract = qupath.createImageDataAction(imageData -> Commands.combineSelectedAnnotations(imageData, RoiTools.CombineOp.SUBTRACT));
        actionSubtract.setText("Subtract selected");
        Action actionIntersect = qupath.createImageDataAction(imageData -> Commands.combineSelectedAnnotations(imageData, RoiTools.CombineOp.INTERSECT));
        actionIntersect.setText("Intersect selected");
        Action actionInverse = qupath.createImageDataAction(imageData -> Commands.makeInverseAnnotation(imageData));
        actionInverse.setText("Make inverse");
        Menu menuCombine = MenuTools.createMenu("Edit multiple annotations", actionMerge, actionSubtract, actionIntersect);
        Menu menuEdit = MenuTools.createMenu("Edit 1 annotation", actionInverse, qupath.createPluginAction("Split", SplitAnnotationsPlugin.class, null));
        SeparatorMenuItem separator = new SeparatorMenuItem();
        Runnable validator = () -> GuiTools.lambda$createAnnotationsMenuImpl$21(qupath, miLockAnnotations, miUnlockAnnotations, miSetProperties, miInsertHierarchy, menuEdit, menuCombine, (MenuItem)separator);
        if (menu instanceof Menu) {
            Menu m = (Menu)menu;
            items = m.getItems();
            m.setOnMenuValidation(e -> validator.run());
        } else if (menu instanceof ContextMenu) {
            ContextMenu m = (ContextMenu)menu;
            items = m.getItems();
            m.setOnShowing(e -> validator.run());
        } else {
            throw new IllegalArgumentException("Menu must be either a standard Menu or a ContextMenu!");
        }
        MenuTools.addMenuItems((List<MenuItem>)items, miLockAnnotations, miUnlockAnnotations, miSetProperties, miInsertHierarchy, separator, menuEdit, menuCombine);
    }

    private static void setSelectedAnnotationsLocked(ImageData<?> imageData, boolean setToLocked) {
        if (imageData == null) {
            return;
        }
        List<PathObject> selectedAnnotations = imageData.getHierarchy().getSelectionModel().getSelectedObjects().stream().filter(p -> p.isAnnotation()).toList();
        if (setToLocked) {
            PathObjectTools.lockObjects((PathObjectHierarchy)imageData.getHierarchy(), selectedAnnotations);
        } else {
            PathObjectTools.unlockObjects((PathObjectHierarchy)imageData.getHierarchy(), selectedAnnotations);
        }
    }

    public static void installRangePrompt(Slider slider) {
        slider.setOnMouseClicked(e -> {
            if (e.getClickCount() == 2) {
                GuiTools.promptForSliderRange(slider);
            }
        });
    }

    public static boolean promptForSliderRange(Slider slider) {
        ParameterList params = new ParameterList().addEmptyParameter("Specify the min/max values supported by the slider").addDoubleParameter("minValue", "Slider minimum", slider.getMin()).addDoubleParameter("maxValue", "Slider maximum", slider.getMax());
        if (!GuiTools.showParameterDialog("Slider range", params)) {
            return false;
        }
        slider.setMin(params.getDoubleParameterValue("minValue").doubleValue());
        slider.setMax(params.getDoubleParameterValue("maxValue").doubleValue());
        return true;
    }

    public static WritableImage getScaledRGBInstance(BufferedImage img, int targetWidth, int targetHeight) {
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage imgResult = img;
        int w = img.getWidth();
        int h = img.getHeight();
        while (w > targetWidth || h > targetHeight) {
            w = Math.max(w / 2, targetWidth);
            h = Math.max(h / 2, targetHeight);
            BufferedImage imgTemp = new BufferedImage(w, h, type);
            Graphics2D g2 = imgTemp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.drawImage(imgResult, 0, 0, w, h, null);
            g2.dispose();
            imgResult = imgTemp;
        }
        return SwingFXUtils.toFXImage((BufferedImage)imgResult, null);
    }

    private static String getNameFromURI(URI uri) {
        if (uri == null) {
            return "No URI";
        }
        String[] path = uri.getPath().split("/");
        if (path.length == 0) {
            return "";
        }
        String name = path[path.length - 1];
        if (path.length == 1) {
            return name;
        }
        return path[path.length - 2] + "/" + name;
    }

    public static Menu createRecentItemsMenu(String menuTitle, ObservableList<URI> recentItems, Consumer<URI> consumer) {
        Menu menuRecent = MenuTools.createMenu(menuTitle, new Object[0]);
        GuiTools.configureRecentItemsMenu(menuRecent, recentItems, consumer);
        return menuRecent;
    }

    public static void configureRecentItemsMenu(Menu menuRecent, ObservableList<URI> recentItems, Consumer<URI> consumer) {
        EventHandler validationHandler = e -> {
            ArrayList<MenuItem> items = new ArrayList<MenuItem>();
            for (URI uri : recentItems) {
                if (uri == null) continue;
                Object name = GuiTools.getNameFromURI(uri);
                name = ".../" + (String)name;
                MenuItem item = new MenuItem((String)name);
                item.setOnAction(event -> consumer.accept(uri));
                items.add(item);
            }
            menuRecent.getItems().setAll(items);
        };
        menuRecent.parentMenuProperty().addListener((v, o, n) -> {
            if (o != null && o.getOnMenuValidation() == validationHandler) {
                o.setOnMenuValidation(null);
            }
            if (n != null) {
                n.setOnMenuValidation(validationHandler);
            }
        });
        if (menuRecent.getParentMenu() != null) {
            menuRecent.getParentMenu().setOnMenuValidation(validationHandler);
        }
    }

    public static boolean promptForParentObjects(String name, ImageData<?> imageData, boolean includeSelected, Collection<Class<? extends PathObject>> supportedParents) {
        PathObjectHierarchy hierarchy;
        PathObjectHierarchy pathObjectHierarchy = hierarchy = imageData == null ? null : imageData.getHierarchy();
        if (hierarchy == null) {
            return false;
        }
        Collection possibleParents = null;
        int nParents = 0;
        ArrayList<Object> availableTypes = new ArrayList<Object>();
        for (Class<? extends PathObject> cls : supportedParents) {
            if (cls.equals(PathRootObject.class)) continue;
            if ((possibleParents = hierarchy.getObjects(possibleParents, (Class)cls)).size() > nParents) {
                availableTypes.add(cls);
            }
            nParents = possibleParents.size();
        }
        LinkedHashMap<String, Class<PathRootObject>> choices = new LinkedHashMap<String, Class<PathRootObject>>();
        for (Class clazz : availableTypes) {
            choices.put(PathObjectTools.getSuitableName((Class)clazz, (boolean)true), clazz);
        }
        if (supportedParents.contains(PathRootObject.class)) {
            choices.put("Entire image", PathRootObject.class);
        }
        ArrayList choiceList = new ArrayList(choices.keySet());
        if (includeSelected) {
            choiceList.add(0, "Selected objects");
        }
        PathObject pathObject = hierarchy.getSelectionModel().getSelectedObject();
        if (!includeSelected && pathObject != null && !pathObject.isRootObject() && supportedParents.contains(pathObject.getClass())) {
            return true;
        }
        if (!includeSelected && availableTypes.isEmpty()) {
            if (supportedParents.contains(PathRootObject.class)) {
                return true;
            }
            String message = name + " requires parent objects of one of the following types:";
            for (Class<? extends PathObject> cls : supportedParents) {
                message = message + "\n" + PathObjectTools.getSuitableName(cls, (boolean)false);
            }
            Dialogs.showErrorMessage((String)(name + " error"), (String)message);
            return false;
        }
        ParameterList paramsParents = new ParameterList();
        paramsParents.addChoiceParameter(KEY_REGIONS, "Process all", (Object)((String)choiceList.get(0)), choiceList);
        if (!GuiTools.showParameterDialog("Process regions", paramsParents)) {
            return false;
        }
        String choiceString = (String)paramsParents.getChoiceParameterValue(KEY_REGIONS);
        if (!"Selected objects".equals(choiceString)) {
            Commands.selectObjectsByClass(imageData, (Class)choices.get(choiceString));
        }
        return !hierarchy.getSelectionModel().noSelection();
    }

    public static void showWithScreenSizeConstraints(Stage stage, double proportion) {
        Screen screen = FXUtils.getScreen((Window)stage);
        if (screen == null && stage.getOwner() != null) {
            screen = FXUtils.getScreen((Window)stage.getOwner());
        }
        if (screen == null) {
            screen = Screen.getPrimary();
        }
        GuiTools.showWithSizeConstraints(stage, screen.getVisualBounds().getWidth() * proportion, screen.getVisualBounds().getHeight() * proportion);
    }

    public static void showWithSizeConstraints(Stage stage, double maxWidth, double maxHeight) {
        double previousMaxWidth = stage.getMaxWidth();
        double previousMaxHeight = stage.getMaxHeight();
        stage.setMaxWidth(Math.min(previousMaxWidth, maxWidth));
        stage.setMaxHeight(Math.min(previousMaxHeight, maxHeight));
        stage.show();
        stage.setMaxWidth(previousMaxWidth);
        stage.setMaxHeight(previousMaxHeight);
    }

    public static TitledPane createLeftRightTitledPane(String name, Node ... rightNodes) {
        Label label = new Label(name);
        label.setMaxWidth(Double.MAX_VALUE);
        label.setMaxHeight(Double.MAX_VALUE);
        label.setAlignment(Pos.CENTER_LEFT);
        label.setPadding(new Insets(0.0, 2.0, 0.0, 0.0));
        HBox right = rightNodes.length == 1 ? rightNodes[0] : new HBox(rightNodes);
        TitledPane pane = GuiTools.createLeftRightTitledPane((Node)label, (Node)right);
        pane.textProperty().bindBidirectional((Property)label.textProperty());
        return pane;
    }

    public static TitledPane createLeftRightTitledPane(Node left, Node right) {
        BorderPane pane = new BorderPane();
        pane.getStyleClass().add((Object)"titled-button-pane");
        pane.setLeft(left);
        pane.setRight(right);
        pane.setMaxWidth(Double.MAX_VALUE);
        pane.setPadding(Insets.EMPTY);
        TitledPane titled = new TitledPane();
        titled.setGraphic((Node)pane);
        titled.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        titled.setAlignment(Pos.CENTER);
        titled.setMaxWidth(Double.MAX_VALUE);
        titled.setMaxHeight(Double.MAX_VALUE);
        titled.setCollapsible(false);
        pane.paddingProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> {
            if (titled.isCollapsible()) {
                return new Insets(0.0, 5.0, 0.0, 25.0);
            }
            return new Insets(0.0, 5.0, 0.0, 5.0);
        }, (Observable[])new Observable[]{titled.collapsibleProperty()}));
        pane.minWidthProperty().bind((ObservableValue)titled.widthProperty());
        return titled;
    }

    private static /* synthetic */ void lambda$createAnnotationsMenuImpl$21(QuPathGUI qupath, CheckMenuItem miLockAnnotations, CheckMenuItem miUnlockAnnotations, MenuItem miSetProperties, MenuItem miInsertHierarchy, Menu menuEdit, Menu menuCombine, MenuItem separator) {
        ImageData<BufferedImage> imageData = qupath.getImageData();
        PathObject selected = null;
        List allSelected = Collections.emptyList();
        boolean allSelectedAnnotations = false;
        boolean hasSelectedAnnotation = false;
        if (imageData != null) {
            selected = imageData.getHierarchy().getSelectionModel().getSelectedObject();
            allSelected = new ArrayList(imageData.getHierarchy().getSelectionModel().getSelectedObjects());
            hasSelectedAnnotation = selected != null && selected.isAnnotation();
            allSelectedAnnotations = allSelected.stream().allMatch(PathObject::isAnnotation);
        }
        miLockAnnotations.setDisable(!hasSelectedAnnotation);
        miUnlockAnnotations.setDisable(!hasSelectedAnnotation);
        if (hasSelectedAnnotation) {
            boolean isLocked = selected.isLocked();
            miLockAnnotations.setSelected(isLocked);
            miUnlockAnnotations.setSelected(!isLocked);
        }
        miSetProperties.setDisable(!hasSelectedAnnotation);
        miInsertHierarchy.setVisible(selected != null);
        menuEdit.setVisible(hasSelectedAnnotation);
        menuCombine.setVisible(allSelectedAnnotations && allSelected.size() > 1);
        separator.setVisible(menuEdit.isVisible() || menuCombine.isVisible());
    }

    private static class DuplicatableGlyph
    extends Glyph {
        private boolean useFill;

        DuplicatableGlyph(Glyph glyph, boolean useFill) {
            this.useFill = useFill;
            this.setText(glyph.getText());
            this.setFontFamily(glyph.getFontFamily());
            this.setIcon(glyph.getIcon());
            this.setFontSize(glyph.getFontSize());
            this.getStyleClass().setAll((Collection)glyph.getStyleClass());
            this.setStyle(glyph.getStyle());
            if (useFill) {
                ObjectProperty textFill = glyph.textFillProperty();
                if (textFill.isBound()) {
                    this.textFillProperty().bind((ObservableValue)glyph.textFillProperty());
                } else if (textFill instanceof StyleableObjectProperty && ((StyleableObjectProperty)textFill).getStyleOrigin() == StyleOrigin.USER) {
                    this.setTextFill((Paint)textFill.get());
                }
            }
        }

        public Glyph duplicate() {
            return new DuplicatableGlyph(this, this.useFill);
        }
    }

    public static enum SnapshotType {
        VIEWER,
        MAIN_SCENE,
        MAIN_WINDOW_SCREENSHOT,
        FULL_SCREENSHOT;

    }
}

