/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.tools;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javafx.application.Platform;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.Image;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.tools.CommandFinderTools;
import qupath.lib.gui.tools.IconFactory;

@CommandLine.Command(name="DocGenerator", subcommands={CommandLine.HelpCommand.class})
public class DocGenerator
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(DocGenerator.class);
    @CommandLine.Parameters(index="0", description={"Output directory"}, defaultValue=".")
    private Path outputDir;
    @CommandLine.Option(names={"--icon-dir"}, description={"Name of directory to export icons to"}, defaultValue="icons")
    private String iconDirName = "icons";
    @CommandLine.Option(names={"--markdown-file"}, description={"Name of markdown file to export"}, defaultValue="commands.md")
    private String markdownFileName = "commands.md";
    @CommandLine.Option(names={"-s", "--icon-size"}, description={"Size of icons to export"}, defaultValue="128")
    private int iconSize = 128;
    @CommandLine.Option(names={"-i", "--icons"}, description={"Export icons"})
    private boolean doIcons = false;
    @CommandLine.Option(names={"-m", "--markdown"}, description={"Export markdown file with command descriptions"})
    private boolean doMarkdown = false;
    @CommandLine.Option(names={"-a", "--all"}, description={"Export all supported documentation files"})
    private boolean doAll = false;

    @Override
    public void run() {
        if (Platform.isFxApplicationThread()) {
            this.doExports();
        } else {
            Platform.startup(() -> {
                this.doExports();
                Platform.runLater(() -> {
                    Platform.exit();
                    System.exit(0);
                });
            });
        }
    }

    private void doExports() {
        if (!(this.doAll || this.doIcons || this.doMarkdown)) {
            logger.info("Nothing selected to export!");
            return;
        }
        if (this.outputDir == null || !Files.isDirectory(this.outputDir, new LinkOption[0])) {
            logger.error("Please specify a valid output directory (that exists)");
            return;
        }
        if (this.doAll || this.doIcons) {
            try {
                Path dirIcons = this.outputDir.resolve(this.iconDirName);
                System.out.println(dirIcons);
                System.out.println(logger);
                logger.info("Exporting icons to {}", (Object)dirIcons);
                if (!Files.exists(dirIcons, new LinkOption[0])) {
                    Files.createDirectory(dirIcons, new FileAttribute[0]);
                }
                this.exportIcons(dirIcons);
            }
            catch (IOException e) {
                logger.error("Failed to export icons", (Throwable)e);
            }
        }
        if (this.doAll || this.doMarkdown) {
            try {
                Path pathMarkdown = this.outputDir.resolve(this.markdownFileName);
                logger.info("Exporting markdown to {}", (Object)pathMarkdown);
                this.exportMarkdown(pathMarkdown);
            }
            catch (IOException e) {
                logger.error("Failed to export markdown", (Throwable)e);
            }
        }
    }

    private void exportIcons(Path outputDir) throws IOException {
        for (IconFactory.PathIcons icon : IconFactory.PathIcons.values()) {
            Image image = IconFactory.createIconImage(icon, this.iconSize);
            BufferedImage img = SwingFXUtils.fromFXImage((Image)image, null);
            ImageIO.write((RenderedImage)img, "PNG", outputDir.resolve(String.valueOf((Object)icon) + ".png").toFile());
        }
    }

    private void exportMarkdown(Path outputFile) throws IOException {
        QuPathGUI qupath = QuPathGUI.getInstance();
        String customPrefNode = null;
        if (qupath == null) {
            customPrefNode = "io.github.qupath/" + String.valueOf(UUID.randomUUID());
            logger.info("Creating custom pref node: {}", (Object)customPrefNode);
            System.setProperty("qupath.prefs.name", customPrefNode);
            logger.debug("Creating new QuPath instance");
            qupath = QuPathGUI.createHiddenInstance();
        }
        logger.info("Writing markdown to {}", (Object)outputFile);
        try (BufferedWriter writer = Files.newBufferedWriter(outputFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            CommandFinderTools.menusToMarkdown(qupath, writer);
        }
        if (customPrefNode != null) {
            try {
                logger.info("Resetting custom pref node: {}", (Object)customPrefNode);
                Preferences.userRoot().node(customPrefNode).removeNode();
            }
            catch (BackingStoreException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void main(String[] args) {
        new CommandLine((Object)new DocGenerator()).execute(args);
    }
}

