/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.tools;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.skin.TableColumnHeader;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.BorderPane;
import javafx.scene.text.TextAlignment;
import javafx.stage.Popup;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import javafx.util.Duration;
import org.controlsfx.control.HiddenSidesPane;
import org.controlsfx.control.action.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.utils.FXUtils;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.actions.ActionTools;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.gui.viewer.QuPathViewerPlus;

public class CommandFinderTools {
    private static BooleanProperty autoCloseCommandListProperty = PathPrefs.createPersistentPreference("autoCloseCommandList", true);
    private static ObjectProperty<CommandBarDisplay> commandBarDisplay = PathPrefs.createPersistentPreference("commandFinderDisplayMode", CommandBarDisplay.NEVER, CommandBarDisplay.class);

    public static ObjectProperty<CommandBarDisplay> commandBarDisplayProperty() {
        return commandBarDisplay;
    }

    public static HiddenSidesPane createCommandFinderPane(QuPathGUI qupath, Node node, ObjectProperty<CommandBarDisplay> displayMode) {
        MenuManager menuManager = MenuManager.getInstance(qupath.getMenuBar());
        FilteredList commands = new FilteredList(menuManager.getCommands());
        TableView<CommandEntry> table = CommandFinderTools.createCommandTable((ObservableList<CommandEntry>)commands);
        TextField textField = CommandFinderTools.createTextField(table, (FilteredList<CommandEntry>)commands, true, null, null);
        BorderPane paneCommands = new BorderPane();
        paneCommands.setPadding(new Insets(5.0, 10.0, 5.0, 10.0));
        paneCommands.setCenter((Node)textField);
        Popup popup = new Popup();
        textField.textProperty().addListener((v, o, n) -> {
            if (o.isEmpty() && !n.isEmpty()) {
                menuManager.refresh(true);
            }
            if (n.trim().isEmpty()) {
                popup.hide();
            } else {
                Bounds bounds = textField.localToScreen(textField.getBoundsInLocal());
                popup.show((Node)textField, bounds.getMinX(), bounds.getMaxY());
            }
        });
        textField.focusedProperty().addListener((v, o, n) -> {
            if (!n.booleanValue()) {
                popup.hide();
            }
        });
        table.setOnMouseClicked(e -> {
            if (!e.isConsumed() && e.getClickCount() > 1 && CommandFinderTools.runSelectedCommand((CommandEntry)table.getSelectionModel().getSelectedItem())) {
                textField.clear();
            }
        });
        table.prefWidthProperty().bind((ObservableValue)textField.widthProperty());
        popup.getContent().add(table);
        table.getStylesheets().add((Object)CommandFinderTools.class.getClassLoader().getResource("css/table_without_header.css").toExternalForm());
        DoubleBinding opacityBinding = Bindings.createDoubleBinding(() -> {
            if (textField.isFocused()) {
                return 0.9;
            }
            return 0.75;
        }, (Observable[])new Observable[]{textField.focusedProperty()});
        textField.opacityProperty().bind((ObservableValue)opacityBinding);
        HiddenSidesPane paneViewer = new HiddenSidesPane();
        paneViewer.pinnedSideProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> {
            switch (((CommandBarDisplay)((Object)((Object)displayMode.get()))).ordinal()) {
                case 0: {
                    return Side.TOP;
                }
                case 1: {
                    return null;
                }
            }
            return textField.isFocused() ? Side.TOP : null;
        }, (Observable[])new Observable[]{textField.focusedProperty(), displayMode}));
        displayMode.addListener((v, o, n) -> {
            if (n == CommandBarDisplay.NEVER) {
                paneViewer.setTop(null);
            } else {
                paneViewer.setTop((Node)paneCommands);
            }
        });
        if (displayMode.get() != CommandBarDisplay.NEVER) {
            paneViewer.setTop((Node)paneCommands);
        }
        paneViewer.setContent(node);
        commandBarDisplay.addListener((v, o, n) -> {
            ObservableList<QuPathViewer> viewers = qupath.getAllViewers();
            for (QuPathViewer viewer : viewers) {
                if (!(viewer instanceof QuPathViewerPlus)) continue;
                ((QuPathViewerPlus)viewer).setSpinnersPosition(!n.equals((Object)CommandBarDisplay.NEVER));
            }
        });
        return paneViewer;
    }

    public static Stage createCommandFinderDialog(QuPathGUI qupath) {
        return CommandFinderTools.createCommandFinderDialog(qupath.getMenuBar(), (Window)qupath.getStage());
    }

    public static Stage createRecentCommandsDialog(QuPathGUI qupath) {
        return CommandFinderTools.createRecentCommandDialog(qupath.getMenuBar(), (Window)qupath.getStage());
    }

    private static Stage createRecentCommandDialog(MenuBar menubar, Window owner) {
        MenuManager menuManager = MenuManager.getInstance(menubar);
        menuManager.refresh(true);
        Stage stage = new Stage();
        stage.initOwner(owner);
        stage.setTitle("Recent Commands");
        FilteredList commands = new FilteredList(menuManager.getRecentCommands());
        TableView<CommandEntry> table = CommandFinderTools.createCommandTable((ObservableList<CommandEntry>)commands);
        for (TableColumn col : table.getColumns()) {
            col.setSortable(false);
        }
        TextField textField = CommandFinderTools.createTextField(table, (FilteredList<CommandEntry>)commands, false, stage, null);
        textField.setPromptText("Search recent commands");
        stage.focusedProperty().addListener((v, o, n) -> {
            if (n.booleanValue()) {
                table.requestFocus();
                if (!table.getItems().isEmpty() && textField.textProperty().isEmpty().get()) {
                    table.getSelectionModel().selectLast();
                }
            }
        });
        commands.addListener(c -> {
            if (table.isVisible() && !table.getItems().isEmpty() && textField.textProperty().isEmpty().get()) {
                table.scrollTo(table.getItems().size() - 1);
                table.getSelectionModel().selectLast();
            }
        });
        stage.setOnShown(e -> textField.selectAll());
        BorderPane pane = new BorderPane();
        pane.setCenter(table);
        pane.setBottom((Node)textField);
        stage.setScene(new Scene((Parent)pane, 600.0, 400.0));
        FXUtils.addCloseWindowShortcuts((Stage)stage);
        textField.textProperty().addListener((v, o, n) -> {
            if (o.isEmpty() && !n.isEmpty()) {
                menuManager.refresh(true);
            }
        });
        table.setOnMouseClicked(e -> {
            if (e.getClickCount() > 1 && !(e.getTarget() instanceof TableColumnHeader)) {
                CommandFinderTools.runSelectedCommand((CommandEntry)table.getSelectionModel().getSelectedItem());
            }
        });
        return stage;
    }

    private static Stage createCommandFinderDialog(MenuBar menubar, Window owner) {
        MenuManager menuManager = MenuManager.getInstance(menubar);
        menuManager.refresh(true);
        Stage stage = new Stage();
        stage.initOwner(owner);
        stage.setTitle("Command List");
        CheckBox cbAutoClose = new CheckBox("Auto close");
        cbAutoClose.selectedProperty().bindBidirectional((Property)autoCloseCommandListProperty);
        cbAutoClose.setPadding(new Insets(2.0, 2.0, 2.0, 2.0));
        FilteredList commands = new FilteredList(menuManager.getCommands());
        TableView<CommandEntry> table = CommandFinderTools.createCommandTable((ObservableList<CommandEntry>)commands);
        TextField textField = CommandFinderTools.createTextField(table, (FilteredList<CommandEntry>)commands, false, stage, (ObservableBooleanValue)cbAutoClose.selectedProperty());
        textField.setPromptText("Search all commands");
        stage.focusedProperty().addListener((v, o, n) -> {
            if (n.booleanValue()) {
                textField.requestFocus();
            }
        });
        stage.setOnShown(e -> textField.selectAll());
        BorderPane panelSearch = new BorderPane();
        panelSearch.setCenter((Node)textField);
        panelSearch.setRight((Node)cbAutoClose);
        BorderPane pane = new BorderPane();
        pane.setCenter(table);
        pane.setBottom((Node)panelSearch);
        stage.setScene(new Scene((Parent)pane, 600.0, 400.0));
        FXUtils.addCloseWindowShortcuts((Stage)stage);
        textField.textProperty().addListener((v, o, n) -> {
            if (o.isEmpty() && !n.isEmpty()) {
                menuManager.refresh(true);
            }
        });
        table.setOnMouseClicked(e -> {
            CommandEntry selected;
            if (e.getClickCount() > 1 && !(e.getTarget() instanceof TableColumnHeader) && CommandFinderTools.runSelectedCommand(selected = (CommandEntry)table.getSelectionModel().getSelectedItem()) && cbAutoClose.isSelected()) {
                stage.hide();
            }
        });
        return stage;
    }

    public static String menusToMarkdown() throws IOException {
        QuPathGUI qupath = QuPathGUI.getInstance();
        Objects.requireNonNull(qupath, "No QuPath instance!");
        StringWriter writer = new StringWriter();
        CommandFinderTools.menusToMarkdown(qupath, writer);
        return writer.toString();
    }

    public static void menusToMarkdown(QuPathGUI qupath, Writer writer) throws IOException {
        MenuManager menuManager = MenuManager.getInstance(qupath.getMenuBar());
        menuManager.refresh(false);
        PrintWriter printWriter = CommandFinderTools.toPrintWriter(writer);
        String lastMenu = null;
        for (CommandEntry item : menuManager.getCommands()) {
            String menu;
            String menuPath = item.getMenuPath();
            if (menuPath != null && !Objects.equals(menu = menuPath.split("\u2192")[0].strip(), lastMenu)) {
                printWriter.println("## " + menu);
                lastMenu = menu;
            }
            CommandFinderTools.toMarkdown(item, printWriter);
        }
        printWriter.flush();
    }

    private static PrintWriter toPrintWriter(Writer writer) {
        return writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    private static void toMarkdown(CommandEntry entry, PrintWriter writer) {
        String title = "### " + entry.getText();
        writer.println(title);
        String subtitle = entry.getCommandPath();
        writer.print("{menuselection}`" + subtitle.replaceAll("\u2192", "-->") + "`");
        String accelerator = entry.getAcceleratorText();
        if (CommandFinderTools.worthwhile(accelerator)) {
            String a = entry.getMenuItem().getAccelerator().toString();
            writer.print(String.format("  - {kbd}`%s`", CommandFinderTools.cleanAccelerator(a)));
        }
        writer.println();
        writer.println();
        String description = entry.getLongText();
        if (CommandFinderTools.worthwhile(description)) {
            writer.println(description);
        }
        writer.println();
    }

    private static boolean worthwhile(String s) {
        return s != null && !s.isBlank();
    }

    private static String cleanAccelerator(String accelerator) {
        return accelerator.replace("shortcut", "Ctrl").replace("Shortcut", "Ctrl").replace("shift", "Shift").replace("alt", "Alt");
    }

    private static TextField createTextField(TableView<CommandEntry> table, FilteredList<CommandEntry> commands, boolean clearTextOnRun, Stage dialog, ObservableBooleanValue hideDialogOnRun) {
        TextField textField = new TextField();
        textField.setTooltip(new Tooltip("Start typing to search through available commands, then select any you want to run"));
        textField.textProperty().addListener((v, o, n) -> CommandFinderTools.updateTableFilter(n.toLowerCase(), commands));
        textField.setOnKeyReleased(e -> {
            if (e.getCode() == KeyCode.ENTER) {
                if (!CommandFinderTools.runSelectedCommand((CommandEntry)table.getSelectionModel().getSelectedItem())) {
                    return;
                }
                if (clearTextOnRun) {
                    textField.clear();
                }
                if (hideDialogOnRun != null && hideDialogOnRun.get() && dialog != null) {
                    dialog.hide();
                }
                e.consume();
            } else if (e.getCode() == KeyCode.DOWN) {
                if (table.getItems().size() == 1) {
                    table.getSelectionModel().select(0);
                } else {
                    int row = table.getSelectionModel().getSelectedIndex() + 1;
                    if (row < table.getItems().size()) {
                        table.getSelectionModel().select(row);
                    }
                }
                e.consume();
            } else if (e.getCode() == KeyCode.UP) {
                if (table.getItems().size() == 1) {
                    table.getSelectionModel().select(0);
                } else {
                    int row = table.getSelectionModel().getSelectedIndex() - 1;
                    if (row >= 0) {
                        table.getSelectionModel().select(row);
                    }
                }
                e.consume();
            }
        });
        return textField;
    }

    static void addMenuComponents(Menu menu, String menuPath, List<CommandEntry> commands) {
        for (MenuItem item : menu.getItems()) {
            if (!item.isVisible()) continue;
            if (item instanceof Menu) {
                CommandFinderTools.addMenuComponents((Menu)item, menuPath + " \u2192 " + ((Menu)item).getText(), commands);
                continue;
            }
            if (item instanceof SeparatorMenuItem || item.getText() == null) continue;
            commands.add(CommandEntry.getInstance(item, menuPath));
        }
    }

    static TableView<CommandEntry> createCommandTable(ObservableList<CommandEntry> commands) {
        TableView table = new TableView();
        SortedList items = new SortedList(commands);
        items.comparatorProperty().bind((ObservableValue)table.comparatorProperty());
        table.setItems((ObservableList)items);
        TableColumn col1 = new TableColumn("Command");
        col1.setCellValueFactory((Callback)new PropertyValueFactory("text"));
        TableColumn col2 = new TableColumn("Menu Path");
        col2.setCellValueFactory((Callback)new PropertyValueFactory("menuPath"));
        TableColumn col3 = new TableColumn("Keys");
        col3.setCellValueFactory((Callback)new PropertyValueFactory("acceleratorText"));
        TableColumn col4 = new TableColumn("Help");
        col4.setCellValueFactory((Callback)new PropertyValueFactory("longText"));
        Function<CommandEntry, String> tipExtractor = entry -> entry == null ? null : entry.getLongText();
        col1.setCellFactory(v -> new TooltipCellFactory(tipExtractor));
        col2.setCellFactory(v -> new TooltipCellFactory(tipExtractor));
        col3.setCellFactory(v -> new TooltipCellFactory(tipExtractor));
        col4.setCellFactory(v -> new HelpCellFactory());
        table.setRowFactory(e -> new CommandTableRow());
        table.setOnKeyPressed(e -> {
            CommandEntry selected;
            if (e.isConsumed()) {
                return;
            }
            if (e.getCode() == KeyCode.ENTER && (selected = (CommandEntry)table.getSelectionModel().getSelectedItem()) != null) {
                CommandFinderTools.runSelectedCommand(selected);
            }
        });
        col1.prefWidthProperty().bind((ObservableValue)table.widthProperty().multiply(0.4).subtract(6));
        col2.prefWidthProperty().bind((ObservableValue)table.widthProperty().multiply(0.4).subtract(6));
        col3.prefWidthProperty().bind((ObservableValue)table.widthProperty().multiply(0.1).subtract(6));
        col4.prefWidthProperty().bind((ObservableValue)table.widthProperty().multiply(0.1).subtract(6));
        table.getColumns().add((Object)col1);
        table.getColumns().add((Object)col2);
        table.getColumns().add((Object)col3);
        table.getColumns().add((Object)col4);
        table.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        table.setFocusTraversable(false);
        return table;
    }

    static void updateTableFilter(final String text, FilteredList<CommandEntry> commands) {
        commands.setPredicate((Predicate)new Predicate<CommandEntry>(){

            @Override
            public boolean test(CommandEntry entry) {
                return entry.getCommandPath().toLowerCase().contains(text);
            }
        });
    }

    private static void copyStringToClipboard(String text) {
        if (Platform.isFxApplicationThread()) {
            ClipboardContent content = new ClipboardContent();
            content.putString(text);
            Clipboard.getSystemClipboard().setContent((Map)content);
        } else {
            Platform.runLater(() -> CommandFinderTools.copyStringToClipboard(text));
        }
    }

    static boolean runSelectedCommand(CommandEntry entry) {
        if (entry != null) {
            MenuItem item = entry.getMenuItem();
            return MenuManager.fireMenuItem(item);
        }
        return false;
    }

    private static class MenuManager {
        private static Logger logger = LoggerFactory.getLogger(MenuManager.class);
        private MenuBar menubar;
        private ObservableList<CommandEntry> commandsBase = FXCollections.observableArrayList();
        private ObservableList<CommandEntry> recentCommands = FXCollections.observableArrayList();
        private static Map<MenuBar, MenuManager> managerMap = new WeakHashMap<MenuBar, MenuManager>();

        public static MenuManager getInstance(MenuBar menubar) {
            return managerMap.computeIfAbsent(menubar, m -> new MenuManager((MenuBar)m));
        }

        private MenuManager(MenuBar menubar) {
            this.menubar = menubar;
        }

        private void refresh(boolean doSort) {
            for (CommandEntry c : this.commandsBase) {
                c.setRecentCommandList(null);
            }
            ArrayList<CommandEntry> commandsTemp = new ArrayList<CommandEntry>();
            for (Menu menu : this.menubar.getMenus()) {
                CommandFinderTools.addMenuComponents(menu, menu.getText(), commandsTemp);
            }
            if (doSort) {
                commandsTemp.sort(Comparator.comparing(CommandEntry::getText));
            }
            this.commandsBase.setAll(commandsTemp);
            for (CommandEntry c : this.commandsBase) {
                c.setRecentCommandList(this.recentCommands);
            }
        }

        public ObservableList<CommandEntry> getCommands() {
            return this.commandsBase;
        }

        public ObservableList<CommandEntry> getRecentCommands() {
            return this.recentCommands;
        }

        static boolean fireMenuItem(MenuItem menuItem) {
            if (menuItem.isDisable()) {
                logger.error("'{}' command is not currently available!", (Object)menuItem.getText());
                return false;
            }
            if (menuItem instanceof CheckMenuItem) {
                MenuManager.fireMenuItem((CheckMenuItem)menuItem);
            } else if (menuItem instanceof RadioMenuItem) {
                MenuManager.fireMenuItem((RadioMenuItem)menuItem);
            } else {
                Platform.runLater(() -> ((MenuItem)menuItem).fire());
            }
            return true;
        }

        static void fireMenuItem(CheckMenuItem menuItem) {
            menuItem.setSelected(!menuItem.isSelected());
        }

        static void fireMenuItem(RadioMenuItem menuItem) {
            menuItem.setSelected(!menuItem.isSelected());
        }
    }

    public static enum CommandBarDisplay {
        ALWAYS,
        NEVER,
        HOVER;


        public String toString() {
            switch (this.ordinal()) {
                case 0: {
                    return "Always";
                }
                case 2: {
                    return "When cursor near";
                }
                case 1: {
                    return "Never";
                }
            }
            return super.toString();
        }
    }

    public static class CommandEntry {
        private StringProperty menuPath = new SimpleStringProperty();
        private ObjectProperty<MenuItem> item = new SimpleObjectProperty();
        private StringProperty text = new SimpleStringProperty();
        private StringProperty acceleratorText = new SimpleStringProperty();
        private StringProperty longText = new SimpleStringProperty();
        private CommandListener listener = new CommandListener();
        private ObservableList<CommandEntry> recent;
        private static Map<MenuItem, CommandEntry> map = new WeakHashMap<MenuItem, CommandEntry>();

        static synchronized CommandEntry getInstance(MenuItem item, String menuPath) {
            CommandEntry cached = map.getOrDefault(item, null);
            if (cached == null || !Objects.equals(cached.getMenuPath(), menuPath)) {
                cached = new CommandEntry(item, menuPath);
                map.put(item, cached);
            }
            return cached;
        }

        private CommandEntry(MenuItem item, String menuPath) {
            Action action;
            this.item.set((Object)item);
            this.menuPath.set((Object)menuPath);
            this.text.bind((ObservableValue)Bindings.createStringBinding(() -> {
                MenuItem temp = (MenuItem)this.item.get();
                return temp == null ? "" : temp.getText();
            }, (Observable[])new Observable[]{this.item}));
            ObjectBinding accelerator = Bindings.createObjectBinding(() -> {
                MenuItem temp = (MenuItem)this.item.get();
                return temp == null ? null : temp.getAccelerator();
            }, (Observable[])new Observable[]{this.item});
            Action action2 = action = item == null ? null : ActionTools.getActionProperty(item);
            if (action != null) {
                this.longText = action.longTextProperty();
            }
            this.acceleratorText.bind((ObservableValue)Bindings.createStringBinding(() -> CommandEntry.lambda$new$2((ObservableObjectValue)accelerator), (Observable[])new Observable[]{accelerator}));
        }

        private void addToRecent() {
            if (this.recent == null) {
                return;
            }
            if (this.recent.isEmpty() || ((CommandEntry)this.recent.get(this.recent.size() - 1)).getMenuItem() != this.getMenuItem()) {
                this.recent.add((Object)this);
            }
        }

        public MenuItem getMenuItem() {
            return (MenuItem)this.item.get();
        }

        public String getCommandPath() {
            return this.getMenuPath() + " \u2192 " + this.getText();
        }

        public String getText() {
            return (String)this.text.get();
        }

        public String getLongText() {
            return (String)this.longTextProperty().get();
        }

        public String getAcceleratorText() {
            return (String)this.acceleratorTextProperty().get();
        }

        public String getMenuPath() {
            return (String)this.menuPath.get();
        }

        public ReadOnlyStringProperty acceleratorTextProperty() {
            return this.acceleratorText;
        }

        public ReadOnlyStringProperty textProperty() {
            return this.text;
        }

        public ReadOnlyStringProperty longTextProperty() {
            return this.longText;
        }

        public ReadOnlyStringProperty menuPathProperty() {
            return this.menuPath;
        }

        private void setRecentCommandList(ObservableList<CommandEntry> recent) {
            if (Objects.equals(recent, this.recent)) {
                return;
            }
            this.recent = recent;
            MenuItem item = this.getMenuItem();
            if (recent == null) {
                if (item instanceof CheckMenuItem) {
                    ((CheckMenuItem)item).selectedProperty().removeListener((ChangeListener)this.listener);
                } else if (item instanceof RadioMenuItem) {
                    ((RadioMenuItem)item).selectedProperty().removeListener((ChangeListener)this.listener);
                } else {
                    item.removeEventHandler(ActionEvent.ACTION, (EventHandler)this.listener);
                }
            } else if (item instanceof CheckMenuItem) {
                ((CheckMenuItem)item).selectedProperty().addListener((ChangeListener)this.listener);
            } else if (item instanceof RadioMenuItem) {
                ((RadioMenuItem)item).selectedProperty().addListener((ChangeListener)this.listener);
            } else {
                item.addEventHandler(ActionEvent.ACTION, (EventHandler)this.listener);
            }
        }

        private static /* synthetic */ String lambda$new$2(ObservableObjectValue accelerator) throws Exception {
            KeyCombination temp = (KeyCombination)accelerator.get();
            return temp == null ? null : temp.getDisplayText();
        }

        class CommandListener
        implements ChangeListener<Boolean>,
        EventHandler<ActionEvent> {
            CommandListener() {
            }

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                CommandEntry.this.addToRecent();
            }

            public void handle(ActionEvent event) {
                CommandEntry.this.addToRecent();
            }
        }
    }

    private static class CommandTableRow
    extends TableRow<CommandEntry> {
        private ContextMenu popup = new ContextMenu();

        private CommandTableRow() {
            MenuItem miCopyPath = new MenuItem("Copy to clipboard");
            miCopyPath.setOnAction(e -> {
                CommandEntry item = (CommandEntry)this.getItem();
                if (item != null) {
                    CommandFinderTools.copyStringToClipboard(item.getCommandPath());
                }
            });
            this.popup.getItems().add((Object)miCopyPath);
            this.setContextMenu(this.popup);
        }

        public void updateItem(CommandEntry entry, boolean empty) {
            super.updateItem((Object)entry, empty);
            if (entry == null || empty || !((MenuItem)entry.item.get()).isDisable()) {
                this.setStyle("-fx-opacity: 1.0;");
            } else {
                this.setStyle("-fx-opacity: 0.5;");
            }
        }
    }

    static class HelpCellFactory<S>
    extends TableCell<S, String> {
        private Tooltip tooltip = new Tooltip();

        public HelpCellFactory() {
            this.setAlignment(Pos.CENTER);
            this.tooltip.setWrapText(true);
            this.tooltip.setMaxWidth(240.0);
            this.tooltip.setTextAlignment(TextAlignment.CENTER);
            this.tooltip.setShowDelay(Duration.millis((double)200.0));
            this.tooltip.setShowDuration(Duration.INDEFINITE);
        }

        public void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            this.setGraphic(null);
            if (!empty && item != null && !item.isEmpty()) {
                this.setText("?");
                this.tooltip.setText(item);
                this.setTooltip(this.tooltip);
            } else {
                this.setText("");
                this.tooltip.setText(item);
                this.setTooltip(null);
            }
        }
    }

    private static class TooltipCellFactory<S, T>
    extends TableCell<S, T> {
        private Function<S, String> funTip;
        private Tooltip tooltip = new Tooltip();

        public TooltipCellFactory(Function<S, String> funTip) {
            this.funTip = funTip;
        }

        public void updateItem(T item, boolean empty) {
            String text;
            super.updateItem(item, empty);
            this.setGraphic(null);
            if (item == null || empty || this.funTip == null) {
                this.setText(null);
                this.setTooltip(null);
                return;
            }
            this.setText(item.toString());
            TableRow row = this.getTableRow();
            String string = text = row == null ? null : this.funTip.apply(row.getItem());
            if (text == null || text.isEmpty()) {
                this.setTooltip(null);
            } else {
                this.tooltip.setText(text);
                this.setTooltip(this.tooltip);
            }
        }
    }
}

